/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.shaded.org.jgroups.EmptyMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RELAY;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RelayHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteMaster;

public class Topology {
    protected final RELAY relay;
    protected final Map<String, View> cache = new ConcurrentHashMap<String, View>();
    protected BiConsumer<String, View> view_handler;
    @Property(description="When true, members joining or leaving any site in the network are triggering the view handler callback")
    protected boolean global_views = true;

    public Topology(RELAY relay) {
        this.relay = Objects.requireNonNull(relay);
    }

    public Map<String, View> cache() {
        return this.cache;
    }

    public boolean globalViews() {
        return this.global_views;
    }

    public Topology globalViews(boolean b) {
        this.global_views = b;
        return this;
    }

    public Topology setViewHandler(BiConsumer<String, View> c) {
        this.view_handler = c;
        return this;
    }

    @ManagedOperation(description="Fetches information (site, address, IP address) from all members")
    public Topology refresh() {
        return this.refresh(null);
    }

    @ManagedOperation(description="Fetches information (site, address, IP address) from all members of a given site")
    public Topology refresh(String site) {
        return this.refresh(site, false);
    }

    @ManagedOperation(description="Fetches the topology information for a given site")
    public Topology refresh(String site, boolean return_entire_cache) {
        SiteMaster dest = new SiteMaster(site);
        RelayHeader hdr = new RelayHeader(6).setFinalDestination(dest).setOriginalSender(this.relay.getAddress()).returnEntireCache(return_entire_cache);
        Message topo_req = new EmptyMessage(dest).putHeader(this.relay.getId(), hdr);
        this.relay.down(topo_req);
        return this;
    }

    @ManagedOperation(description="Prints the cache information about all members")
    public String print() {
        return this.print(null);
    }

    @ManagedOperation(description="Prints the cache information about all members")
    public String print(String site) {
        if (site != null) {
            return this.dumpSite(site);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, View> e : this.cache.entrySet()) {
            sb.append(this.dumpSite(e.getKey())).append("\n");
        }
        return sb.toString();
    }

    public Topology removeAll(Collection<String> sites) {
        if (sites == null) {
            this.cache.keySet().clear();
        } else {
            this.cache.keySet().removeAll(sites);
        }
        return this;
    }

    public String toString() {
        return String.format("%d sites", this.cache.size());
    }

    protected String dumpSite(String site) {
        View view = this.cache.get(site);
        if (view == null) {
            return String.format("%s: no view found for site %s", this.relay.getAddress(), site);
        }
        return String.format("%s: %s", site, view);
    }

    protected void put(String site, View v) {
        View existing = this.cache.get(site);
        if (!Objects.equals(existing, v)) {
            this.cache.put(site, v);
            if (this.view_handler != null) {
                this.view_handler.accept(site, v);
            }
        }
    }
}

