/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.logging;

import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.simple.SimpleLogger;

public class Log4J2LogImpl
implements Log {
    protected final Logger logger;
    protected static final Level[] levels = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL};

    public Log4J2LogImpl(String category) {
        this.logger = LogManager.getFormatterLogger((String)category);
    }

    public Log4J2LogImpl(Class<?> category) {
        this.logger = LogManager.getFormatterLogger(category);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isFatalEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(Object msg) {
        this.logger.trace(msg);
    }

    @Override
    public void trace(String msg) {
        this.logger.trace(msg);
    }

    @Override
    public void trace(String format, Object ... args) {
        this.logger.trace(format, args);
    }

    @Override
    public void trace(String msg, Throwable throwable) {
        this.logger.trace(msg, throwable);
    }

    @Override
    public void debug(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void debug(String format, Object ... args) {
        this.logger.debug(format, args);
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        this.logger.debug(msg, throwable);
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void info(String format, Object ... args) {
        this.logger.info(format, args);
    }

    @Override
    public void warn(String msg) {
        this.logger.warn(msg);
    }

    @Override
    public void warn(String format, Object ... args) {
        this.logger.warn(format, args);
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        this.logger.warn(msg, throwable);
    }

    @Override
    public void error(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void error(String format, Object ... args) {
        this.logger.error(format, args);
    }

    @Override
    public void error(String msg, Throwable throwable) {
        this.logger.error(msg, throwable);
    }

    @Override
    public void fatal(String msg) {
        this.logger.fatal(msg);
    }

    @Override
    public void fatal(String format, Object ... args) {
        this.logger.fatal(format, args);
    }

    @Override
    public void fatal(String msg, Throwable throwable) {
        this.logger.fatal(msg, throwable);
    }

    @Override
    public String getLevel() {
        for (Level level : levels) {
            if (!this.logger.isEnabled(level)) continue;
            return level.toString();
        }
        return "n/a";
    }

    @Override
    public void setLevel(String level) {
        Level new_level = Log4J2LogImpl.strToLevel(level);
        if (new_level == null) {
            return;
        }
        if (this.logger instanceof org.apache.logging.log4j.core.Logger) {
            ((org.apache.logging.log4j.core.Logger)this.logger).setLevel(new_level);
        } else if (this.logger instanceof SimpleLogger) {
            ((SimpleLogger)this.logger).setLevel(new_level);
        }
    }

    private static Level strToLevel(String level) {
        if (level == null) {
            return null;
        }
        if ((level = level.toLowerCase().trim()).equals("fatal")) {
            return Level.FATAL;
        }
        if (level.equals("error")) {
            return Level.ERROR;
        }
        if (level.equals("warn")) {
            return Level.WARN;
        }
        if (level.equals("warning")) {
            return Level.WARN;
        }
        if (level.equals("info")) {
            return Level.INFO;
        }
        if (level.equals("debug")) {
            return Level.DEBUG;
        }
        if (level.equals("trace")) {
            return Level.TRACE;
        }
        return null;
    }
}

