/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.util.AverageMinMax;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class MsgStats {
    @Property(description="Whether metrics should be logged")
    protected boolean enabled = true;
    @ManagedAttribute(description="Number of unicast messages sent", type=AttributeType.SCALAR)
    protected final LongAdder num_ucasts_sent = new LongAdder();
    @ManagedAttribute(description="Number of unicast messages received", type=AttributeType.SCALAR)
    protected final LongAdder num_ucasts_received = new LongAdder();
    @ManagedAttribute(description="Number of multicast messages sent", type=AttributeType.SCALAR)
    protected final LongAdder num_mcasts_sent = new LongAdder();
    @ManagedAttribute(description="Total number of multicast messages received", type=AttributeType.SCALAR)
    protected final LongAdder num_mcasts_received = new LongAdder();
    @ManagedAttribute(description="Number of single messages sent (by the bundler)", type=AttributeType.SCALAR)
    protected final LongAdder num_single_msgs_sent = new LongAdder();
    @ManagedAttribute(description="Number of single messages received (by the transport)", type=AttributeType.SCALAR)
    protected final LongAdder num_single_msgs_received = new LongAdder();
    @ManagedAttribute(description="Number of batches sent (by the bundler)", type=AttributeType.SCALAR)
    protected final LongAdder num_batches_sent = new LongAdder();
    @ManagedAttribute(description="Number of batches received (by the transport)", type=AttributeType.SCALAR)
    protected final LongAdder num_batches_received = new LongAdder();
    @ManagedAttribute(description="Returns the average batch size of received batches")
    protected final AverageMinMax avg_batch_size = new AverageMinMax();
    @ManagedAttribute(description="Number of multicast bytes sent", type=AttributeType.BYTES)
    protected final LongAdder num_mcast_bytes_sent = new LongAdder();
    @ManagedAttribute(description="Number of multicast bytes received", type=AttributeType.BYTES)
    protected final LongAdder num_mcast_bytes_received = new LongAdder();
    @ManagedAttribute(description="Number of unicast bytes sent", type=AttributeType.BYTES)
    protected final LongAdder num_ucast_bytes_sent = new LongAdder();
    @ManagedAttribute(description="Number of unicast bytes received", type=AttributeType.BYTES)
    protected final LongAdder num_ucast_bytes_received = new LongAdder();

    public boolean enabled() {
        return this.enabled;
    }

    public MsgStats enable(boolean b) {
        this.enabled = b;
        return this;
    }

    @ManagedAttribute(description="Number of messages sent (mcasts and ucasts sent)", type=AttributeType.SCALAR)
    public long getNumMsgsSent() {
        return this.num_mcasts_sent.sum() + this.num_ucasts_sent.sum();
    }

    @ManagedAttribute(description="Number of messages received (mcasts and ucasts received)", type=AttributeType.SCALAR)
    public long getNumMsgsReceived() {
        return this.num_mcasts_received.sum() + this.num_ucasts_received.sum();
    }

    public AverageMinMax getAvgBatchSize() {
        return this.avg_batch_size;
    }

    @ManagedAttribute(description="Total number of bytes sent (unicast + multicast bytes)", type=AttributeType.BYTES)
    public long getNumBytesSent() {
        return this.num_mcast_bytes_sent.sum() + this.num_ucast_bytes_sent.sum();
    }

    @ManagedAttribute(description="Total number of bytes received (unicast + multicast)", type=AttributeType.BYTES)
    public long getNumBytesReceived() {
        return this.num_mcast_bytes_received.sum() + this.num_ucast_bytes_received.sum();
    }

    public long getNumUcastsSent() {
        return this.num_ucasts_sent.sum();
    }

    public long getNumMcastsSent() {
        return this.num_mcasts_sent.sum();
    }

    public long getNumUcastsReceived() {
        return this.num_ucasts_received.sum();
    }

    public long getNumMcastsReceived() {
        return this.num_mcasts_received.sum();
    }

    public long getNumSingleMsgsSent() {
        return this.num_single_msgs_sent.sum();
    }

    public MsgStats incrNumSingleMsgsSent() {
        if (this.enabled) {
            this.num_single_msgs_sent.increment();
        }
        return this;
    }

    public long getNumBatchesSent() {
        return this.num_batches_sent.sum();
    }

    public MsgStats incrNumBatchesSent() {
        if (this.enabled) {
            this.num_batches_sent.increment();
        }
        return this;
    }

    public MsgStats incrNumBatchesSent(int n) {
        if (this.enabled) {
            this.num_batches_sent.add(n);
        }
        return this;
    }

    public long getNumBatchesReceived() {
        return this.num_batches_received.sum();
    }

    public long getNumUcastBytesSent() {
        return this.num_ucast_bytes_sent.sum();
    }

    public long getNumMcastBytesSent() {
        return this.num_mcast_bytes_sent.sum();
    }

    public long getNumUcastBytesReceived() {
        return this.num_ucast_bytes_received.sum();
    }

    public long getNumMcastBytesReceived() {
        return this.num_mcast_bytes_received.sum();
    }

    public MsgStats sent(Address dest, int length) {
        if (!this.enabled) {
            return this;
        }
        if (dest == null) {
            return this.add(this.num_mcasts_sent, 1, this.num_mcast_bytes_sent, length);
        }
        return this.add(this.num_ucasts_sent, 1, this.num_ucast_bytes_sent, length);
    }

    public MsgStats sent(Message msg) {
        return msg == null || !this.enabled ? this : this.sent(msg.dest(), msg.getLength());
    }

    public MsgStats received(Address dest, int length) {
        if (!this.enabled) {
            return this;
        }
        if (dest == null) {
            return this.add(this.num_mcasts_received, 1, this.num_mcast_bytes_received, length);
        }
        return this.add(this.num_ucasts_received, 1, this.num_ucast_bytes_received, length);
    }

    public MsgStats received(Message msg) {
        if (msg == null || !this.enabled) {
            return this;
        }
        this.num_single_msgs_received.increment();
        return this.received(msg.dest(), msg.getLength());
    }

    public MsgStats received(MessageBatch batch) {
        if (batch == null || !this.enabled) {
            return this;
        }
        this.num_batches_received.increment();
        int num_msgs = batch.size();
        int length = batch.length();
        this.avg_batch_size.add(num_msgs);
        if (batch.dest() == null) {
            return this.add(this.num_mcasts_received, num_msgs, this.num_mcast_bytes_received, length);
        }
        return this.add(this.num_ucasts_received, num_msgs, this.num_ucast_bytes_received, length);
    }

    public MsgStats reset() {
        Stream.of(this.num_ucasts_sent, this.num_ucasts_received, this.num_mcasts_sent, this.num_mcasts_received, this.num_single_msgs_sent, this.num_single_msgs_received, this.num_batches_sent, this.num_batches_received, this.num_mcast_bytes_sent, this.num_mcast_bytes_received, this.num_ucast_bytes_sent, this.num_ucast_bytes_received).forEach(LongAdder::reset);
        this.avg_batch_size.clear();
        return this;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean details) {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        if (!details) {
            sb.append(String.format("%,d sent (%s) %,d received (%s)", this.getNumMsgsSent(), Util.printBytes(this.getNumBytesSent()), this.getNumMsgsReceived(), Util.printBytes(this.getNumBytesReceived())));
            return sb.toString();
        }
        for (Field field : fields = MsgStats.class.getDeclaredFields()) {
            try {
                Object val = Util.getField(field, this);
                sb.append(field.getName()).append(": ").append(val).append("\n");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    protected MsgStats add(LongAdder msgs, int num_msgs, LongAdder bytes, int length) {
        msgs.add(num_msgs);
        if (length > 0) {
            bytes.add(length);
        }
        return this;
    }
}

