/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.activemq.artemis.shaded.org.jgroups.client.StompConnection;
import org.apache.activemq.artemis.shaded.org.jgroups.demos.DrawCommand;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class StompDraw
implements StompConnection.Listener,
ActionListener {
    private int num_servers = 1;
    private int num_clients = 0;
    private JFrame mainFrame = null;
    private JPanel sub_panel = null;
    private DrawPanel panel = null;
    private JButton clear_button;
    private JButton leave_button;
    private final Random random = new Random(System.currentTimeMillis());
    private final Font default_font = new Font("Helvetica", 0, 12);
    private final Color draw_color = this.selectColor();
    private static final Color background_color = Color.white;
    private final List<String> servers = new ArrayList<String>();
    private final Set<String> clients = new HashSet<String>();
    protected StompConnection stomp_client;
    protected static final String draw_dest = "/topics/draw-demo";
    protected static final String clients_dest = "/topics/clients";

    public StompDraw(String host, String port) throws Exception {
        this.stomp_client = new StompConnection(host + ":" + port);
        this.stomp_client.addListener(this);
    }

    public static void main(String[] args) {
        StompDraw draw = null;
        String host = "localhost";
        String port = "8787";
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                StompDraw.help();
                return;
            }
            if ("-h".equals(args[i])) {
                host = args[++i];
                continue;
            }
            if ("-p".equals(args[i])) {
                port = args[++i];
                continue;
            }
            StompDraw.help();
            return;
        }
        try {
            draw = new StompDraw(host, port);
            draw.go();
        }
        catch (Throwable e) {
            System.err.println("fatal error: " + e.getLocalizedMessage() + ", cause: ");
            Throwable t = e.getCause();
            if (t != null) {
                t.printStackTrace(System.err);
            }
            System.exit(0);
        }
    }

    static void help() {
        System.out.println("\nDraw [-help] [-no_channel] [-h host] [-port port]");
    }

    private Color selectColor() {
        int red = Math.abs(this.random.nextInt() % 255);
        int green = Math.abs(this.random.nextInt() % 255);
        int blue = Math.abs(this.random.nextInt() % 255);
        return new Color(red, green, blue);
    }

    private void sendToAll(byte[] buf) throws Exception {
        if (buf != null) {
            this.stomp_client.send(draw_dest, buf, 0, buf.length);
        }
    }

    public void go() throws Exception {
        this.stomp_client.connect();
        this.stomp_client.subscribe(draw_dest);
        this.stomp_client.subscribe(clients_dest);
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(3);
        this.panel = new DrawPanel(false);
        this.panel.setBackground(background_color);
        this.sub_panel = new JPanel();
        this.mainFrame.getContentPane().add("Center", this.panel);
        this.clear_button = new JButton("Clear");
        this.clear_button.setFont(this.default_font);
        this.clear_button.addActionListener(this);
        this.leave_button = new JButton("Leave");
        this.leave_button.setFont(this.default_font);
        this.leave_button.addActionListener(this);
        this.sub_panel.add("South", this.clear_button);
        this.sub_panel.add("South", this.leave_button);
        this.mainFrame.getContentPane().add("South", this.sub_panel);
        this.mainFrame.setBackground(background_color);
        this.clear_button.setForeground(Color.blue);
        this.leave_button.setForeground(Color.blue);
        this.mainFrame.pack();
        this.mainFrame.setLocation(15, 25);
        this.mainFrame.setBounds(new Rectangle(250, 250));
        this.mainFrame.setVisible(true);
        this.setTitle();
        String session_id = this.stomp_client.getSessionId();
        if (session_id != null) {
            this.stomp_client.send(clients_dest, null, 0, 0, "client-joined", session_id);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    void setTitle() {
        if (this.mainFrame != null) {
            this.mainFrame.setTitle(this.num_servers + " server(s), " + this.num_clients + " client(s)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfClients() {
        Set<String> set = this.clients;
        synchronized (set) {
            return this.clients.size();
        }
    }

    String getAllClients() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String client : this.clients) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(client);
        }
        return sb.toString();
    }

    @Override
    public void onInfo(Map<String, String> information) {
        String view = information.get("view");
        if (view != null) {
            List<String> list = Util.parseCommaDelimitedStrings(view);
            if (list != null) {
                this.num_servers = list.size();
                if (this.mainFrame != null) {
                    this.setTitle();
                }
                this.servers.clear();
                this.servers.addAll(list);
            } else {
                String targets = information.get("endpoints");
                if (targets != null && (list = Util.parseCommaDelimitedStrings(targets)) != null) {
                    this.num_servers = list.size();
                    if (this.mainFrame != null) {
                        this.setTitle();
                    }
                    this.servers.clear();
                    this.servers.addAll(list);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Map<String, String> headers, byte[] buf, int offset, int length) {
        if (buf == null) {
            return;
        }
        String destination = headers.get("destination");
        if (Objects.equals(destination, clients_dest)) {
            List<String> list;
            String all_clients;
            String left_client;
            String new_client = headers.get("client-joined");
            if (new_client != null) {
                Set<String> set = this.clients;
                synchronized (set) {
                    if (this.clients.add(new_client)) {
                        this.num_clients = this.clients.size();
                        this.setTitle();
                    }
                }
                this.stomp_client.send(clients_dest, null, 0, 0, "clients", this.getAllClients());
            }
            if ((left_client = headers.get("client-left")) != null) {
                Set<String> set = this.clients;
                synchronized (set) {
                    if (this.clients.remove(left_client)) {
                        this.num_clients = this.clients.size();
                        this.setTitle();
                    }
                }
            }
            if ((all_clients = headers.get("clients")) != null && (list = Util.parseCommaDelimitedStrings(all_clients)) != null) {
                Set<String> set = this.clients;
                synchronized (set) {
                    if (this.clients.addAll(list)) {
                        this.num_clients = this.clients.size();
                        this.setTitle();
                    }
                }
            }
            return;
        }
        try {
            DrawCommand comm = Util.streamableFromByteBuffer(DrawCommand::new, buf, offset, length);
            switch (comm.mode) {
                case 1: {
                    if (this.panel != null) {
                        this.panel.drawPoint(comm);
                    }
                    break;
                }
                case 2: {
                    this.clearPanel();
                    break;
                }
                default: {
                    System.err.println("***** received invalid draw command " + comm.mode);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearPanel() {
        if (this.panel != null) {
            this.panel.clear();
        }
    }

    public void sendClearPanelMsg() {
        DrawCommand comm = new DrawCommand(2);
        try {
            byte[] buf = Util.streamableToByteBuffer(comm);
            this.sendToAll(buf);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Clear".equals(command)) {
            this.sendClearPanelMsg();
        } else if ("Leave".equals(command)) {
            this.stop();
            this.mainFrame.setVisible(false);
            this.mainFrame.dispose();
        } else {
            System.out.println("Unknown action");
        }
    }

    public void stop() {
        if (!this.stomp_client.isConnected()) {
            return;
        }
        String session_id = this.stomp_client.getSessionId();
        if (session_id != null) {
            this.stomp_client.send(clients_dest, null, 0, 0, "client-left", session_id);
        }
        this.stomp_client.disconnect();
    }

    private class DrawPanel
    extends JPanel
    implements MouseMotionListener {
        final Dimension preferred_size = new Dimension(235, 170);
        Image img = null;
        Dimension d;
        Dimension imgsize = null;
        Graphics gr = null;
        final Map<Point, Color> state;

        public DrawPanel(boolean use_state) {
            this.state = use_state ? new LinkedHashMap<Point, Color>() : null;
            this.createOffscreenImage(false);
            this.addMouseMotionListener(this);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (DrawPanel.this.getWidth() <= 0 || DrawPanel.this.getHeight() <= 0) {
                        return;
                    }
                    DrawPanel.this.createOffscreenImage(false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeState(OutputStream outstream) throws IOException {
            if (this.state == null) {
                return;
            }
            Map<Point, Color> map = this.state;
            synchronized (map) {
                DataOutputStream dos = new DataOutputStream(outstream);
                dos.writeInt(this.state.size());
                for (Map.Entry<Point, Color> entry : this.state.entrySet()) {
                    Point point = entry.getKey();
                    Color col = entry.getValue();
                    dos.writeInt(point.x);
                    dos.writeInt(point.y);
                    dos.writeInt(col.getRGB());
                }
                dos.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readState(InputStream instream) throws IOException {
            DataInputStream in = new DataInputStream(instream);
            HashMap<Point, Color> new_state = new HashMap<Point, Color>();
            int num = in.readInt();
            for (int i = 0; i < num; ++i) {
                Point point = new Point(in.readInt(), in.readInt());
                Color col = new Color(in.readInt());
                new_state.put(point, col);
            }
            Map<Point, Color> map = this.state;
            synchronized (map) {
                this.state.clear();
                this.state.putAll(new_state);
                System.out.println("read state: " + this.state.size() + " entries");
                this.createOffscreenImage(true);
            }
        }

        final void createOffscreenImage(boolean discard_image) {
            this.d = this.getSize();
            if (discard_image) {
                this.img = null;
                this.imgsize = null;
            }
            if (this.img == null || this.imgsize == null || this.imgsize.width != this.d.width || this.imgsize.height != this.d.height) {
                this.img = this.createImage(this.d.width, this.d.height);
                if (this.img != null) {
                    this.gr = this.img.getGraphics();
                    if (this.gr != null && this.state != null) {
                        this.drawState();
                    }
                }
                this.imgsize = this.d;
            }
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            DrawCommand comm = new DrawCommand(1, x, y, StompDraw.this.draw_color.getRGB());
            try {
                byte[] buf = Util.streamableToByteBuffer(comm);
                StompDraw.this.sendToAll(buf);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawPoint(DrawCommand c) {
            if (c == null || this.gr == null) {
                return;
            }
            Color col = new Color(c.rgb);
            this.gr.setColor(col);
            this.gr.fillOval(c.x, c.y, 10, 10);
            this.repaint();
            if (this.state != null) {
                Map<Point, Color> map = this.state;
                synchronized (map) {
                    this.state.put(new Point(c.x, c.y), col);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (this.gr == null) {
                return;
            }
            this.gr.clearRect(0, 0, this.getSize().width, this.getSize().height);
            this.repaint();
            if (this.state != null) {
                Map<Point, Color> map = this.state;
                synchronized (map) {
                    this.state.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawState() {
            Map<Point, Color> map = this.state;
            synchronized (map) {
                for (Map.Entry<Point, Color> entry : this.state.entrySet()) {
                    Point pt = entry.getKey();
                    Color col = entry.getValue();
                    this.gr.setColor(col);
                    this.gr.fillOval(pt.x, pt.y, 10, 10);
                }
            }
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferred_size;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img != null) {
                g.drawImage(this.img, 0, 0, null);
            }
        }
    }
}

