/*
 * Decompiled with CFR 0.152.
 */
package org.apache.artemis.client.cdi.extension;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.artemis.client.cdi.configuration.ArtemisClientConfiguration;
import org.apache.artemis.client.cdi.extension.ArtemisClientConfigBean;
import org.apache.artemis.client.cdi.extension.ArtemisEmbeddedServerConfigBean;
import org.apache.artemis.client.cdi.logger.ActiveMQCDILogger;

public class ArtemisExtension
implements Extension {
    private boolean foundEmbeddedConfig = false;
    private boolean foundConfiguration = false;

    void foundClientConfig(@Observes ProcessBean<?> processBean) {
        if (processBean.getBean().getTypes().contains(ArtemisClientConfiguration.class)) {
            ActiveMQCDILogger.LOGGER.discoveredConfiguration(processBean);
            this.foundConfiguration = true;
        }
    }

    void foundEmbeddedConfig(@Observes ProcessBean<?> processBean) {
        if (processBean.getBean().getTypes().contains(Configuration.class)) {
            ActiveMQCDILogger.LOGGER.discoveredClientConfiguration(processBean);
            this.foundEmbeddedConfig = true;
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        if (!this.foundConfiguration) {
            afterBeanDiscovery.addBean((Bean)new ArtemisClientConfigBean());
        } else {
            ActiveMQCDILogger.LOGGER.notUsingDefaultConfiguration();
        }
        if (!this.foundEmbeddedConfig) {
            afterBeanDiscovery.addBean((Bean)new ArtemisEmbeddedServerConfigBean());
        } else {
            ActiveMQCDILogger.LOGGER.notUsingDefaultClientConfiguration();
        }
    }
}

