/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq;

import java.util.List;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.apache.activemq.artemis.core.protocol.hornetq.HQPropertiesConversionInterceptor;
import org.apache.activemq.artemis.core.protocol.hornetq.HornetQProtocolManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;

public class HornetQProtocolManagerFactory
extends CoreProtocolManagerFactory {
    public static final String HORNETQ_PROTOCOL_NAME = "HORNETQ";
    private static final String MODULE_NAME = "artemis-hornetq-protocol";
    private static String[] SUPPORTED_PROTOCOLS = new String[]{"HORNETQ"};

    public ProtocolManager createProtocolManager(ActiveMQServer server, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors) {
        HQPropertiesConversionInterceptor propertyConversionInterceptor = new HQPropertiesConversionInterceptor();
        incomingInterceptors.add(propertyConversionInterceptor);
        outgoingInterceptors.add(propertyConversionInterceptor);
        return new HornetQProtocolManager(this, server, incomingInterceptors, outgoingInterceptors);
    }

    public String[] getProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

