/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.integration;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.dto.ServerDTO;
import org.apache.activemq.artemis.integration.Broker;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.apache.activemq.artemis.jms.server.config.JMSQueueConfiguration;
import org.apache.activemq.artemis.jms.server.config.TopicConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;

public class FileBroker
implements Broker {
    private final String configurationUrl;
    private boolean started;
    private final ActiveMQSecurityManager securityManager;
    private Map<String, ActiveMQComponent> components;

    public FileBroker(ServerDTO broker, ActiveMQSecurityManager security) {
        this.securityManager = security;
        this.configurationUrl = broker.configuration;
    }

    public synchronized void start() throws Exception {
        List coreAddressConfigurations;
        if (this.started) {
            return;
        }
        FileConfiguration configuration = new FileConfiguration();
        FileJMSConfiguration jmsConfiguration = new FileJMSConfiguration();
        FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(this.configurationUrl);
        fileDeploymentManager.addDeployable((Deployable)configuration).addDeployable((Deployable)jmsConfiguration);
        fileDeploymentManager.readConfiguration();
        this.createDirectories(configuration);
        for (JMSQueueConfiguration jmsQueueConfig : jmsConfiguration.getQueueConfigurations()) {
            coreAddressConfigurations = configuration.getAddressConfigurations();
            coreAddressConfigurations.add(new CoreAddressConfiguration().setName(jmsQueueConfig.getName()).addRoutingType(RoutingType.ANYCAST).addQueueConfiguration(new CoreQueueConfiguration().setAddress(jmsQueueConfig.getName()).setName(jmsQueueConfig.getName()).setFilterString(jmsQueueConfig.getSelector()).setRoutingType(RoutingType.ANYCAST)));
        }
        for (TopicConfiguration topicConfig : jmsConfiguration.getTopicConfigurations()) {
            coreAddressConfigurations = configuration.getAddressConfigurations();
            coreAddressConfigurations.add(new CoreAddressConfiguration().setName(topicConfig.getName()).addRoutingType(RoutingType.MULTICAST));
        }
        this.components = fileDeploymentManager.buildService(this.securityManager, ManagementFactory.getPlatformMBeanServer());
        ArrayList<ActiveMQComponent> componentsByStartOrder = this.getComponentsByStartOrder(this.components);
        ActiveMQBootstrapLogger.LOGGER.serverStarting();
        for (ActiveMQComponent component : componentsByStartOrder) {
            component.start();
        }
        this.started = true;
    }

    private void createDirectories(FileConfiguration fileConfiguration) {
        fileConfiguration.getPagingLocation().mkdirs();
        fileConfiguration.getJournalLocation().mkdirs();
        fileConfiguration.getBindingsLocation().mkdirs();
        fileConfiguration.getLargeMessagesLocation().mkdirs();
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean isShutdown) throws Exception {
        if (!this.started) {
            return;
        }
        ActiveMQComponent[] mqComponents = new ActiveMQComponent[this.components.size()];
        this.components.values().toArray(mqComponents);
        for (int i = mqComponents.length - 1; i >= 0; --i) {
            if (mqComponents[i] instanceof ServiceComponent) {
                ((ServiceComponent)mqComponents[i]).stop(isShutdown);
                continue;
            }
            mqComponents[i].stop();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Map<String, ActiveMQComponent> getComponents() {
        return this.components;
    }

    private ArrayList<ActiveMQComponent> getComponentsByStartOrder(Map<String, ActiveMQComponent> components) {
        ArrayList<ActiveMQComponent> activeMQComponents = new ArrayList<ActiveMQComponent>();
        ActiveMQComponent jmsComponent = components.get("jms");
        if (jmsComponent != null) {
            activeMQComponents.add(jmsComponent);
        }
        activeMQComponents.add(components.get("core"));
        return activeMQComponents;
    }

    @Override
    public ActiveMQServer getServer() {
        return (ActiveMQServer)this.components.get("core");
    }
}

