/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Arguments;
import io.airlift.airline.Help;
import io.airlift.airline.Option;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import java.io.File;
import javax.inject.Inject;
import org.apache.activemq.artemis.cli.commands.ActionAbstract;
import org.apache.activemq.artemis.cli.factory.BrokerFactory;
import org.apache.activemq.artemis.cli.factory.jmx.ManagementFactory;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.dto.BrokerDTO;
import org.apache.activemq.artemis.dto.ManagementContextDTO;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;

public abstract class Configurable
extends ActionAbstract {
    @Arguments(description="Broker Configuration URI, default 'xml:${ARTEMIS_INSTANCE}/etc/bootstrap.xml'")
    String configuration;
    @Option(name={"--broker"}, description="This would override the broker configuration from the bootstrap")
    String brokerConfig;
    @Inject
    public GlobalMetadata global;
    private BrokerDTO brokerDTO = null;
    private FileConfiguration fileConfiguration;

    protected void treatError(Exception e, String group, String command) {
        ActiveMQBootstrapLogger.LOGGER.debug(e.getMessage(), e);
        System.err.println();
        System.err.println("Error:" + e.getMessage());
        System.err.println();
        this.helpGroup(group, command);
    }

    protected void helpGroup(String groupName, String commandName) {
        for (CommandGroupMetadata group : this.global.getCommandGroups()) {
            if (!group.getName().equals(groupName)) continue;
            for (CommandMetadata command : group.getCommands()) {
                if (!command.getName().equals(commandName)) continue;
                Help.help((CommandMetadata)command);
            }
        }
    }

    protected FileConfiguration getFileConfiguration() throws Exception {
        if (this.fileConfiguration == null) {
            if (this.getBrokerInstance() == null) {
                String defaultLocation = "./data";
                this.fileConfiguration = new FileConfiguration();
                this.fileConfiguration.setBindingsDirectory("./data/bindings");
                this.fileConfiguration.setJournalDirectory("./data/journal");
                this.fileConfiguration.setLargeMessagesDirectory("./data/largemessages");
                this.fileConfiguration.setPagingDirectory("./data/paging");
                this.fileConfiguration.setBrokerInstance(new File("."));
            } else {
                this.fileConfiguration = new FileConfiguration();
                FileJMSConfiguration jmsConfiguration = new FileJMSConfiguration();
                String serverConfiguration = this.getBrokerDTO().server.getConfigurationURI().toASCIIString();
                FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(serverConfiguration);
                fileDeploymentManager.addDeployable((Deployable)this.fileConfiguration).addDeployable((Deployable)jmsConfiguration);
                fileDeploymentManager.readConfiguration();
                this.fileConfiguration.setBrokerInstance(new File(this.getBrokerInstance()));
            }
        }
        return this.fileConfiguration;
    }

    protected BrokerDTO getBrokerDTO() throws Exception {
        if (this.brokerDTO == null) {
            this.getConfiguration();
            this.brokerDTO = BrokerFactory.createBrokerConfiguration(this.configuration, this.getBrokerHome(), this.getBrokerInstance(), this.getBrokerURIInstance());
            if (this.brokerConfig != null) {
                if (!this.brokerConfig.startsWith("file:")) {
                    this.brokerConfig = "file:" + this.brokerConfig;
                }
                this.brokerDTO.server.configuration = this.brokerConfig;
            }
        }
        return this.brokerDTO;
    }

    protected ManagementContextDTO getManagementDTO() throws Exception {
        String configuration = this.getManagementConfiguration();
        return ManagementFactory.createJmxAclConfiguration(configuration, this.getBrokerHome(), this.getBrokerInstance(), this.getBrokerURIInstance());
    }

    protected String getConfiguration() {
        if (this.configuration == null) {
            File xmlFile = new File(new File(new File(this.getBrokerInstance()), "etc"), "bootstrap.xml");
            this.configuration = "xml:" + xmlFile.toURI().toString().substring("file:".length());
            this.configuration = this.configuration.replace("\\", "/");
            ActiveMQBootstrapLogger.LOGGER.usingBrokerConfig(this.configuration);
        }
        return this.configuration;
    }

    protected String getManagementConfiguration() {
        File xmlFile = new File(new File(new File(this.getBrokerInstance()), "etc"), "management.xml");
        String configuration = "xml:" + xmlFile.toURI().toString().substring("file:".length());
        configuration = configuration.replace("\\", "/");
        return configuration;
    }
}

