/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.utils.Base64;

@Command(name="encode", description="Encode a set of journal files into an internal encoded data format")
public class EncodeJournal
extends LockAbstract {
    @Option(name={"--directory"}, description="The journal folder (default the journal folder from broker.xml)")
    public String directory;
    @Option(name={"--prefix"}, description="The journal prefix (default activemq-data)")
    public String prefix = "activemq-data";
    @Option(name={"--suffix"}, description="The journal suffix (default amq)")
    public String suffix = "amq";
    @Option(name={"--file-size"}, description="The journal size (default 10485760)")
    public int size = 0xA00000;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        try {
            if (this.directory == null) {
                this.directory = this.getFileConfiguration().getJournalDirectory();
            }
            EncodeJournal.exportJournal(this.directory, this.prefix, this.suffix, 2, this.size);
        }
        catch (Exception e) {
            this.treatError(e, "data", "encode");
        }
        return null;
    }

    public static void exportJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize) throws Exception {
        EncodeJournal.exportJournal(directory, journalPrefix, journalSuffix, minFiles, fileSize, System.out);
    }

    public static void exportJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, String fileName) throws Exception {
        try (FileOutputStream fileOutputStream = new FileOutputStream(fileName);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             PrintStream out = new PrintStream(bufferedOutputStream);){
            EncodeJournal.exportJournal(directory, journalPrefix, journalSuffix, minFiles, fileSize, out);
        }
    }

    public static void exportJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, PrintStream out) throws Exception {
        NIOSequentialFileFactory nio = new NIOSequentialFileFactory(new File(directory), null, 1);
        JournalImpl journal = new JournalImpl(fileSize, minFiles, minFiles, 0, 0, (SequentialFileFactory)nio, journalPrefix, journalSuffix, 1);
        List files = journal.orderFiles();
        for (JournalFile file : files) {
            out.println("#File," + file);
            EncodeJournal.exportJournalFile(out, (SequentialFileFactory)nio, file);
        }
    }

    public static void exportJournalFile(final PrintStream out, SequentialFileFactory fileFactory, JournalFile file) throws Exception {
        JournalImpl.readJournalFile((SequentialFileFactory)fileFactory, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback(){

            public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                out.println("operation@UpdateTX,txID@" + transactionID + "," + EncodeJournal.describeRecord(recordInfo));
            }

            public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
                out.println("operation@Update," + EncodeJournal.describeRecord(recordInfo));
            }

            public void onReadRollbackRecord(long transactionID) throws Exception {
                out.println("operation@Rollback,txID@" + transactionID);
            }

            public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                out.println("operation@Prepare,txID@" + transactionID + ",numberOfRecords@" + numberOfRecords + ",extraData@" + EncodeJournal.encode(extraData));
            }

            public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                out.println("operation@DeleteRecordTX,txID@" + transactionID + "," + EncodeJournal.describeRecord(recordInfo));
            }

            public void onReadDeleteRecord(long recordID) throws Exception {
                out.println("operation@DeleteRecord,id@" + recordID);
            }

            public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                out.println("operation@Commit,txID@" + transactionID + ",numberOfRecords@" + numberOfRecords);
            }

            public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                out.println("operation@AddRecordTX,txID@" + transactionID + "," + EncodeJournal.describeRecord(recordInfo));
            }

            public void onReadAddRecord(RecordInfo recordInfo) throws Exception {
                out.println("operation@AddRecord," + EncodeJournal.describeRecord(recordInfo));
            }

            public void markAsDataFile(JournalFile file) {
            }
        });
    }

    private static String describeRecord(RecordInfo recordInfo) {
        return "id@" + recordInfo.id + ",userRecordType@" + recordInfo.userRecordType + ",length@" + recordInfo.data.length + ",isUpdate@" + recordInfo.isUpdate + ",compactCount@" + recordInfo.compactCount + ",data@" + EncodeJournal.encode(recordInfo.data);
    }

    private static String encode(byte[] data) {
        return Base64.encodeBytes((byte[])data, (int)0, (int)data.length, (int)24);
    }

    public void printUsage() {
        int i;
        for (i = 0; i < 10; ++i) {
            System.err.println();
        }
        System.err.println("This method will export the journal at low level record.");
        System.err.println();
        System.err.println();
        for (i = 0; i < 10; ++i) {
            System.err.println();
        }
    }
}

