/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.destination;

import io.airlift.airline.Option;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.management.JMSManagementHelper;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;

public abstract class DestinationAction
extends ConnectionAbstract {
    public static final String JMS_QUEUE = "jms-queue";
    public static final String JMS_TOPIC = "topic";
    public static final String CORE_QUEUE = "core-queue";
    @Option(name={"--type"}, description="type of destination to be created (one of jms-queue, topic and core-queue, default jms-queue")
    String destType = "jms-queue";
    @Option(name={"--name"}, description="destination name")
    String name;

    public void performJmsManagement(ManagementCallback<Message> cb) throws Exception {
        try (ActiveMQConnectionFactory factory = this.createConnectionFactory();
             ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
             ActiveMQSession session = (ActiveMQSession)connection.createSession(false, 1);){
            Queue managementQueue = ActiveMQJMSClient.createQueue((String)"activemq.management");
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            connection.start();
            Message message = session.createMessage();
            cb.setUpInvocation(message);
            Message reply = requestor.request(message);
            boolean result = JMSManagementHelper.hasOperationSucceeded((Message)reply);
            if (result) {
                cb.requestSuccessful(reply);
            } else {
                cb.requestFailed(reply);
            }
        }
    }

    public void performCoreManagement(ManagementCallback<ClientMessage> cb) throws Exception {
        try (ActiveMQConnectionFactory factory = this.createConnectionFactory();
             ServerLocator locator = factory.getServerLocator();
             ClientSessionFactory sessionFactory = locator.createSessionFactory();
             ClientSession session = sessionFactory.createSession(this.user, this.password, false, true, true, false, 0x100000);){
            session.start();
            ClientRequestor requestor = new ClientRequestor(session, "jms.queue.activemq.management");
            ClientMessage message = session.createMessage(false);
            cb.setUpInvocation(message);
            ClientMessage reply = requestor.request(message);
            if (ManagementHelper.hasOperationSucceeded((org.apache.activemq.artemis.api.core.Message)reply)) {
                cb.requestSuccessful(reply);
            } else {
                cb.requestFailed(reply);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.input("--name", "Please provide the destination name:", "");
        }
        return this.name;
    }

    public String getDestType() {
        return this.destType;
    }

    public void setDestType(String destType) {
        this.destType = destType;
    }

    public static interface ManagementCallback<T> {
        public void setUpInvocation(T var1) throws Exception;

        public void requestSuccessful(T var1) throws Exception;

        public void requestFailed(T var1) throws Exception;
    }
}

