/*
 * Decompiled with CFR 0.152.
 */
package org.apache.artemis.client.cdi.configuration;

import java.util.Map;
import javax.enterprise.inject.Vetoed;
import org.apache.artemis.client.cdi.configuration.ArtemisClientConfiguration;

@Vetoed
public class DefaultArtemisClientConfigurationImpl
implements ArtemisClientConfiguration {
    private String host;
    private Integer port;
    private String url;
    private String username;
    private String password;
    private boolean ha;

    public DefaultArtemisClientConfigurationImpl() {
    }

    public DefaultArtemisClientConfigurationImpl(Map<String, Object> params) {
        this.host = (String)params.get("host");
        this.port = (Integer)params.get("port");
        this.url = (String)params.get("url");
        this.username = (String)params.get("username");
        this.password = (String)params.get("password");
        Boolean isHa = (Boolean)params.get("ha");
        if (isHa == null) {
            isHa = false;
        }
        this.ha = isHa;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getConnectorFactory() {
        return this.startEmbeddedBroker() ? IN_VM_CONNECTOR : REMOTE_CONNECTOR;
    }

    @Override
    public boolean startEmbeddedBroker() {
        return this.host == null && this.url == null;
    }

    @Override
    public boolean isHa() {
        return this.ha;
    }

    @Override
    public boolean hasAuthentication() {
        return this.getUsername() != null && !this.getUsername().isEmpty();
    }
}

