/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import javax.management.ObjectName;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressPolicyControl;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationQueueConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationQueuePolicyControl;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationQueuePolicyManager;

public abstract class AMQPFederationManagementSupport {
    public static final String FEDERATION_POLICY_RESOURCE_TEMPLATE = "brokerconnection.local.federation.policy.%s";
    public static final String FEDERATION_CONSUMER_RESOURCE_TEMPLATE = "brokerconnection.local.federation.policy.%s.consumer.%s";
    public static final String FEDERATION_POLICY_NAME_TEMPLATE = "serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s";
    public static final String FEDERATION_QUEUE_CONSUMER_NAME_TEMPLATE = "serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,fqqn=%s";
    public static final String FEDERATION_ADDRESS_CONSUMER_NAME_TEMPLATE = "serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,address=%s";

    public static void registerAddressPolicyControl(String brokerConnection, AMQPFederationAddressPolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationAddressPolicyControl control = new AMQPFederationAddressPolicyControl(manager);
        String policyName = manager.getPolicyName();
        management.registerInJMX(AMQPFederationManagementSupport.getFederationPolicyObjectName(management, brokerConnection, federation.getName(), manager.getPolicyType().toString(), policyName), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationPolicyResourceName(policyName), (Object)control);
    }

    public static void unregisterAddressPolicyControl(String brokerConnection, AMQPFederationAddressPolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String policyName = manager.getPolicyName();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationPolicyObjectName(management, brokerConnection, federation.getName(), manager.getPolicyType().toString(), policyName));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationPolicyResourceName(policyName));
    }

    public static void registerQueuePolicyControl(String brokerConnection, AMQPFederationQueuePolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationQueuePolicyControl control = new AMQPFederationQueuePolicyControl(manager);
        String policyName = manager.getPolicyName();
        management.registerInJMX(AMQPFederationManagementSupport.getFederationPolicyObjectName(management, brokerConnection, federation.getName(), manager.getPolicyType().toString(), policyName), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationPolicyResourceName(policyName), (Object)control);
    }

    public static void unregisterQueuePolicyControl(String brokerConnection, AMQPFederationQueuePolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String policyName = manager.getPolicyName();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationPolicyObjectName(management, brokerConnection, federation.getName(), manager.getPolicyType().toString(), policyName));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationPolicyResourceName(policyName));
    }

    public static String getFederationPolicyResourceName(String policyName) {
        return String.format(FEDERATION_POLICY_RESOURCE_TEMPLATE, policyName);
    }

    public static ObjectName getFederationPolicyObjectName(ManagementService management, String brokerConnection, String federationName, String policyType, String policyName) throws Exception {
        String brokerConnectionName = management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection);
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s", brokerConnectionName, ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName)));
    }

    public static void registerAddressConsumerControl(String brokerConnection, AMQPFederationAddressPolicyManager manager, AMQPFederationAddressConsumer consumer) throws Exception {
        AMQPFederation federation = consumer.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationConsumerControlType control = new AMQPFederationConsumerControlType(consumer);
        String policyName = manager.getPolicyName();
        management.registerInJMX(AMQPFederationManagementSupport.getFederationAddressConsumerObjectName(management, brokerConnection, federation.getName(), manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getAddress()), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationAddressConsumerResourceName(policyName, consumer.getConsumerInfo().getAddress()), (Object)control);
    }

    public static void unregisterAddressConsumerControl(String brokerConnection, AMQPFederationAddressPolicyManager manager, AMQPFederationAddressConsumer consumer) throws Exception {
        AMQPFederation federation = consumer.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String policyName = manager.getPolicyName();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationAddressConsumerObjectName(management, brokerConnection, federation.getName(), manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getAddress()));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationAddressConsumerResourceName(policyName, consumer.getConsumerInfo().getAddress()));
    }

    public static void registerQueueConsumerControl(String brokerConnection, AMQPFederationQueuePolicyManager manager, AMQPFederationQueueConsumer consumer) throws Exception {
        AMQPFederation federation = consumer.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationConsumerControlType control = new AMQPFederationConsumerControlType(consumer);
        String policyName = manager.getPolicyName();
        management.registerInJMX(AMQPFederationManagementSupport.getFederationQueueConsumerObjectName(management, brokerConnection, federation.getName(), manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getFqqn()), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationQueueConsumerResourceName(policyName, consumer.getConsumerInfo().getFqqn()), (Object)control);
    }

    public static void unregisterQueueConsumerControl(String brokerConnection, AMQPFederationQueuePolicyManager manager, AMQPFederationQueueConsumer consumer) throws Exception {
        AMQPFederation federation = consumer.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String policyName = manager.getPolicyName();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationQueueConsumerObjectName(management, brokerConnection, federation.getName(), manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getFqqn()));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationQueueConsumerResourceName(policyName, consumer.getConsumerInfo().getFqqn()));
    }

    public static String getFederationAddressConsumerResourceName(String policyName, String address) {
        return String.format(FEDERATION_CONSUMER_RESOURCE_TEMPLATE, policyName, address);
    }

    public static String getFederationQueueConsumerResourceName(String policyName, String fqqn) {
        return String.format(FEDERATION_CONSUMER_RESOURCE_TEMPLATE, policyName, fqqn);
    }

    public static ObjectName getFederationAddressConsumerObjectName(ManagementService management, String brokerConnection, String federationName, String policyType, String policyName, String address) throws Exception {
        String brokerConnectionName = management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection);
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,address=%s", brokerConnectionName, ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(address)));
    }

    public static ObjectName getFederationQueueConsumerObjectName(ManagementService management, String brokerConnection, String federationName, String policyType, String policyName, String fqqn) throws Exception {
        String brokerConnectionName = management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection);
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,fqqn=%s", brokerConnectionName, ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(fqqn)));
    }
}

