/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton.transaction;

import java.nio.ByteBuffer;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionImpl;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.jboss.logging.Logger;

public class ProtonTransactionHandler
implements ProtonDeliveryHandler {
    private static final Logger log = Logger.getLogger(ProtonTransactionHandler.class);
    private final int amqpCredit;
    private final int amqpLowMark;
    final AMQPSessionCallback sessionSPI;
    final AMQPConnectionContext connection;
    private final ByteBuffer DECODE_BUFFER = ByteBuffer.allocate(64);

    public ProtonTransactionHandler(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection) {
        this.sessionSPI = sessionSPI;
        this.connection = connection;
        this.amqpCredit = connection.getAmqpCredits();
        this.amqpLowMark = connection.getAmqpLowCredits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void onMessage(final Delivery delivery) throws ActiveMQAMQPException {
        Receiver receiver;
        block25: {
            receiver = (Receiver)delivery.getLink();
            if (delivery.isReadable()) break block25;
            this.sessionSPI.afterIO(new IOCallback(delivery){
                final /* synthetic */ Delivery val$delivery;
                {
                    this.val$delivery = delivery;
                }

                public void done() {
                    ProtonTransactionHandler.this.connection.lock();
                    try {
                        this.val$delivery.settle();
                    }
                    finally {
                        ProtonTransactionHandler.this.connection.unlock();
                    }
                    ProtonTransactionHandler.this.connection.flush();
                }

                public void onError(int errorCode, String errorMessage) {
                }
            });
            return;
        }
        try {
            MessageImpl msg;
            this.connection.lock();
            try {
                if (receiver.getCredit() < this.amqpLowMark) {
                    receiver.flow(this.amqpCredit);
                }
                ByteBuffer buffer = delivery.available() > this.DECODE_BUFFER.capacity() ? ByteBuffer.allocate(delivery.available()) : (ByteBuffer)this.DECODE_BUFFER.clear();
                buffer.limit(receiver.recv(buffer.array(), buffer.arrayOffset(), buffer.capacity()));
                receiver.advance();
                msg = this.decodeMessage(buffer);
            }
            finally {
                this.connection.unlock();
            }
            Object action = ((AmqpValue)msg.getBody()).getValue();
            if (action instanceof Declare) {
                Binary txID = this.sessionSPI.newTransaction();
                Declared declared = new Declared();
                declared.setTxnId(txID);
                this.connection.lock();
                try {
                    delivery.disposition((DeliveryState)declared);
                }
                finally {
                    this.connection.unlock();
                }
            } else if (action instanceof Discharge) {
                Discharge discharge = (Discharge)action;
                Binary txID = discharge.getTxnId();
                ProtonTransactionImpl tx = (ProtonTransactionImpl)this.sessionSPI.getTransaction(txID, true);
                tx.discharge();
                IOCallback ioAction = new IOCallback(){

                    public void done() {
                        ProtonTransactionHandler.this.connection.lock();
                        try {
                            delivery.disposition((DeliveryState)new Accepted());
                        }
                        finally {
                            ProtonTransactionHandler.this.connection.unlock();
                        }
                    }

                    public void onError(int errorCode, String errorMessage) {
                    }
                };
                if (discharge.getFail().booleanValue()) {
                    this.sessionSPI.withinContext(() -> tx.rollback());
                    this.sessionSPI.afterIO(ioAction);
                } else {
                    this.sessionSPI.withinContext(() -> tx.commit());
                    this.sessionSPI.afterIO(ioAction);
                }
            }
            this.sessionSPI.afterIO(new /* invalid duplicate definition of identical inner class */);
        }
        catch (ActiveMQAMQPException amqpE) {
            log.warn((Object)amqpE.getMessage(), (Throwable)((Object)amqpE));
            this.connection.lock();
            try {
                delivery.disposition((DeliveryState)this.createRejected(amqpE.getAmqpError(), amqpE.getMessage()));
            }
            finally {
                this.connection.unlock();
            }
            this.connection.flush();
            this.sessionSPI.afterIO(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Throwable e) {
            log.warn((Object)e.getMessage(), e);
            this.connection.lock();
            try {
                delivery.disposition((DeliveryState)this.createRejected(Symbol.getSymbol((String)"failed"), e.getMessage()));
            }
            finally {
                this.connection.unlock();
            }
            this.connection.flush();
            this.sessionSPI.afterIO(new /* invalid duplicate definition of identical inner class */);
            {
                catch (Throwable throwable) {
                    this.sessionSPI.afterIO(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void onFlow(int credits, boolean drain) {
    }

    @Override
    public void close(boolean linkRemoteClose) throws ActiveMQAMQPException {
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
    }

    private Rejected createRejected(Symbol amqpError, String message) {
        Rejected rejected = new Rejected();
        ErrorCondition condition = new ErrorCondition();
        condition.setCondition(amqpError);
        condition.setDescription(message);
        rejected.setError(condition);
        return rejected;
    }

    private MessageImpl decodeMessage(ByteBuffer encoded) {
        MessageImpl message = (MessageImpl)Message.Factory.create();
        message.decode(encoded);
        return message;
    }
}

