/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPConnectionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ExtCapability;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ProtonHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.jboss.logging.Logger;

public class AMQPConnectionContext
extends ProtonInitializable
implements EventHandler {
    private static final Logger log = Logger.getLogger(AMQPConnectionContext.class);
    public static final Symbol CONNECTION_OPEN_FAILED = Symbol.valueOf((String)"amqp:connection-establishment-failed");
    public static final String AMQP_CONTAINER_ID = "amqp-container-id";
    protected final ProtonHandler handler;
    protected AMQPConnectionCallback connectionCallback;
    private final String containerId;
    private final Map<Symbol, Object> connectionProperties = new HashMap<Symbol, Object>();
    private final ScheduledExecutorService scheduledPool;
    private final Map<Session, AMQPSessionContext> sessions = new ConcurrentHashMap<Session, AMQPSessionContext>();
    private final ProtonProtocolManager protocolManager;
    private final boolean useCoreSubscriptionNaming;

    public AMQPConnectionContext(ProtonProtocolManager protocolManager, AMQPConnectionCallback connectionSP, String containerId, int idleTimeout, int maxFrameSize, int channelMax, boolean useCoreSubscriptionNaming, ScheduledExecutorService scheduledPool) {
        this.protocolManager = protocolManager;
        this.connectionCallback = connectionSP;
        this.useCoreSubscriptionNaming = useCoreSubscriptionNaming;
        this.containerId = containerId != null ? containerId : UUID.randomUUID().toString();
        this.connectionProperties.put(AmqpSupport.PRODUCT, "apache-activemq-artemis");
        this.connectionProperties.put(AmqpSupport.VERSION, VersionLoader.getVersion().getFullVersion());
        this.scheduledPool = scheduledPool;
        this.connectionCallback.setConnection(this);
        this.handler = new ProtonHandler(protocolManager.getServer().getExecutorFactory().getExecutor());
        this.handler.addEventHandler(this);
        Transport transport = this.handler.getTransport();
        transport.setEmitFlowEventOnSend(false);
        if (idleTimeout > 0) {
            transport.setIdleTimeout(idleTimeout);
        }
        transport.setChannelMax(channelMax);
        transport.setMaxFrameSize(maxFrameSize);
    }

    protected AMQPSessionContext newSessionExtension(Session realSession) throws ActiveMQAMQPException {
        AMQPSessionCallback sessionSPI = this.connectionCallback.createSessionCallback(this);
        AMQPSessionContext protonSession = new AMQPSessionContext(sessionSPI, this, realSession);
        return protonSession;
    }

    public SASLResult getSASLResult() {
        return this.handler.getSASLResult();
    }

    public void inputBuffer(ByteBuf buffer) {
        if (log.isTraceEnabled()) {
            ByteUtil.debugFrame((Logger)log, (String)"Buffer Received ", (ByteBuf)buffer);
        }
        this.handler.inputBuffer(buffer);
    }

    public void destroy() {
        this.connectionCallback.close();
    }

    public boolean isSyncOnFlush() {
        return false;
    }

    public boolean tryLock(long time, TimeUnit timeUnit) {
        return this.handler.tryLock(time, timeUnit);
    }

    public void lock() {
        this.handler.lock();
    }

    public void unlock() {
        this.handler.unlock();
    }

    public int capacity() {
        return this.handler.capacity();
    }

    public void flush() {
        this.handler.flush();
    }

    public void close(ErrorCondition errorCondition) {
        this.handler.close(errorCondition);
    }

    protected AMQPSessionContext getSessionExtension(Session realSession) throws ActiveMQAMQPException {
        AMQPSessionContext sessionExtension = this.sessions.get(realSession);
        if (sessionExtension == null) {
            sessionExtension = this.newSessionExtension(realSession);
            realSession.setContext((Object)sessionExtension);
            this.sessions.put(realSession, sessionExtension);
        }
        return sessionExtension;
    }

    protected boolean validateConnection(Connection connection) {
        return this.connectionCallback.validateConnection(connection, this.handler.getSASLResult());
    }

    public boolean checkDataReceived() {
        return this.handler.checkDataReceived();
    }

    public long getCreationTime() {
        return this.handler.getCreationTime();
    }

    public String getRemoteContainer() {
        return this.handler.getConnection().getRemoteContainer();
    }

    public String getPubSubPrefix() {
        return null;
    }

    protected void initInternal() throws Exception {
    }

    protected void remoteLinkOpened(Link link) throws Exception {
        AMQPSessionContext protonSession = this.getSessionExtension(link.getSession());
        link.setSource(link.getRemoteSource());
        link.setTarget(link.getRemoteTarget());
        if (link instanceof Receiver) {
            Receiver receiver = (Receiver)link;
            if (link.getRemoteTarget() instanceof Coordinator) {
                Coordinator coordinator = (Coordinator)link.getRemoteTarget();
                protonSession.addTransactionHandler(coordinator, receiver);
            } else {
                protonSession.addReceiver(receiver);
            }
        } else {
            Sender sender = (Sender)link;
            protonSession.addSender(sender);
        }
    }

    public Symbol[] getConnectionCapabilitiesOffered() {
        URI tc = this.connectionCallback.getFailoverList();
        if (tc != null) {
            HashMap<Symbol, Object> hostDetails = new HashMap<Symbol, Object>();
            hostDetails.put(AmqpSupport.NETWORK_HOST, tc.getHost());
            boolean isSSL = tc.getQuery().contains("sslEnabled=true");
            if (isSSL) {
                hostDetails.put(AmqpSupport.SCHEME, "amqps");
            } else {
                hostDetails.put(AmqpSupport.SCHEME, "amqp");
            }
            hostDetails.put(AmqpSupport.HOSTNAME, tc.getHost());
            hostDetails.put(AmqpSupport.PORT, tc.getPort());
            this.connectionProperties.put(AmqpSupport.FAILOVER_SERVER_LIST, Arrays.asList(hostDetails));
        }
        return ExtCapability.getCapabilities();
    }

    public void open(Map<Symbol, Object> connectionProperties) {
        this.handler.open(this.containerId, connectionProperties);
    }

    public String getContainer() {
        return this.containerId;
    }

    public void addEventHandler(EventHandler eventHandler) {
        this.handler.addEventHandler(eventHandler);
    }

    public ProtonProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public int getAmqpLowCredits() {
        if (this.protocolManager != null) {
            return this.protocolManager.getAmqpLowCredits();
        }
        return 30;
    }

    public int getAmqpCredits() {
        if (this.protocolManager != null) {
            return this.protocolManager.getAmqpCredits();
        }
        return 100;
    }

    public boolean isUseCoreSubscriptionNaming() {
        return this.useCoreSubscriptionNaming;
    }

    @Override
    public void onInit(Connection connection) throws Exception {
    }

    @Override
    public void onLocalOpen(Connection connection) throws Exception {
    }

    @Override
    public void onLocalClose(Connection connection) throws Exception {
    }

    @Override
    public void onFinal(Connection connection) throws Exception {
    }

    @Override
    public void onInit(Session session) throws Exception {
    }

    @Override
    public void onFinal(Session session) throws Exception {
    }

    @Override
    public void onInit(Link link) throws Exception {
    }

    @Override
    public void onLocalOpen(Link link) throws Exception {
    }

    @Override
    public void onLocalClose(Link link) throws Exception {
    }

    @Override
    public void onFinal(Link link) throws Exception {
    }

    @Override
    public void onAuthInit(ProtonHandler handler, Connection connection, boolean sasl) {
        if (sasl) {
            handler.createServerSASL(this.connectionCallback.getSASLMechnisms());
        } else if (!this.connectionCallback.isSupportsAnonymous()) {
            this.connectionCallback.sendSASLSupported();
            this.connectionCallback.close();
            handler.close(null);
        }
    }

    @Override
    public void onTransport(Transport transport) {
        this.handler.flushBytes();
    }

    @Override
    public void pushBytes(ByteBuf bytes) {
        this.connectionCallback.onTransport(bytes, this);
    }

    @Override
    public boolean flowControl(ReadyListener readyListener) {
        return this.connectionCallback.isWritable(readyListener);
    }

    @Override
    public void onRemoteOpen(Connection connection) throws Exception {
        long nextKeepAliveTime;
        this.lock();
        try {
            try {
                this.initInternal();
            }
            catch (Exception e) {
                log.error((Object)"Error init connection", (Throwable)e);
            }
            if (!this.validateConnection(connection)) {
                connection.close();
            } else {
                connection.setContext((Object)this);
                connection.setContainer(this.containerId);
                connection.setProperties(this.connectionProperties);
                connection.setOfferedCapabilities(this.getConnectionCapabilitiesOffered());
                connection.open();
            }
        }
        finally {
            this.unlock();
        }
        this.initialise();
        if (!(connection.getRemoteProperties() != null && connection.getRemoteProperties().containsKey(CONNECTION_OPEN_FAILED) || (nextKeepAliveTime = this.handler.tick(true)) <= 0L || this.scheduledPool == null)) {
            this.scheduledPool.schedule(new Runnable(){

                @Override
                public void run() {
                    long rescheduleAt = AMQPConnectionContext.this.handler.tick(false) - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    if (rescheduleAt > 0L) {
                        AMQPConnectionContext.this.scheduledPool.schedule(this, rescheduleAt, TimeUnit.MILLISECONDS);
                    }
                }
            }, nextKeepAliveTime - TimeUnit.NANOSECONDS.toMillis(System.nanoTime()), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void onRemoteClose(Connection connection) {
        this.lock();
        try {
            connection.close();
            connection.free();
        }
        finally {
            this.unlock();
        }
        for (AMQPSessionContext protonSession : this.sessions.values()) {
            protonSession.close();
        }
        this.sessions.clear();
        this.handler.flushBytes();
        this.destroy();
    }

    @Override
    public void onLocalOpen(Session session) throws Exception {
        this.getSessionExtension(session);
    }

    @Override
    public void onRemoteOpen(Session session) throws Exception {
        this.getSessionExtension(session).initialise();
        this.lock();
        try {
            session.open();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void onLocalClose(Session session) throws Exception {
    }

    @Override
    public void onRemoteClose(Session session) throws Exception {
        this.lock();
        try {
            session.close();
            session.free();
        }
        finally {
            this.unlock();
        }
        AMQPSessionContext sessionContext = (AMQPSessionContext)session.getContext();
        if (sessionContext != null) {
            sessionContext.close();
            this.sessions.remove(session);
            session.setContext(null);
        }
    }

    @Override
    public void onRemoteOpen(Link link) throws Exception {
        this.remoteLinkOpened(link);
    }

    @Override
    public void onFlow(Link link) throws Exception {
        if (link.getContext() != null) {
            ((ProtonDeliveryHandler)link.getContext()).onFlow(link.getCredit(), link.getDrain());
        }
    }

    @Override
    public void onRemoteClose(Link link) throws Exception {
        this.lock();
        try {
            link.close();
            link.free();
        }
        finally {
            this.unlock();
        }
        ProtonDeliveryHandler linkContext = (ProtonDeliveryHandler)link.getContext();
        if (linkContext != null) {
            linkContext.close(true);
        }
    }

    @Override
    public void onRemoteDetach(Link link) throws Exception {
        this.lock();
        try {
            link.detach();
            link.free();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void onLocalDetach(Link link) throws Exception {
        Object context = link.getContext();
        if (context instanceof ProtonServerSenderContext) {
            ProtonServerSenderContext senderContext = (ProtonServerSenderContext)context;
            senderContext.close(false);
        }
    }

    @Override
    public void onDelivery(Delivery delivery) throws Exception {
        ProtonDeliveryHandler handler = (ProtonDeliveryHandler)delivery.getLink().getContext();
        if (handler != null) {
            handler.onMessage(delivery);
        } else {
            log.warn((Object)("Handler is null, can't delivery " + delivery), (Throwable)new Exception("tracing location"));
        }
    }
}

