/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.client;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.client.AMQPClientConnectionFactory;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.jboss.logging.Logger;

public class ProtonClientConnectionManager
implements BaseConnectionLifeCycleListener<ProtonProtocolManager>,
BufferHandler {
    private final Map<Object, ActiveMQProtonRemotingConnection> connectionMap = new ConcurrentHashMap<Object, ActiveMQProtonRemotingConnection>();
    private static final Logger log = Logger.getLogger(ProtonClientConnectionManager.class);
    private final AMQPClientConnectionFactory connectionFactory;
    private final Optional<EventHandler> eventHandler;

    public ProtonClientConnectionManager(AMQPClientConnectionFactory connectionFactory, Optional<EventHandler> eventHandler) {
        this.connectionFactory = connectionFactory;
        this.eventHandler = eventHandler;
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, ProtonProtocolManager protocolManager) {
        ActiveMQProtonRemotingConnection amqpConnection = this.connectionFactory.createConnection(protocolManager, connection, this.eventHandler);
        this.connectionMap.put(connection.getID(), amqpConnection);
        log.info((Object)("Connection " + amqpConnection.getRemoteAddress() + " created"));
    }

    public void connectionDestroyed(Object connectionID) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.remove(connectionID);
        if (connection != null) {
            log.info((Object)("Connection " + connection.getRemoteAddress() + " destroyed"));
            connection.disconnect(false);
        }
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.get(connectionID);
        if (connection != null) {
            log.info((Object)("Connection " + connection.getRemoteAddress() + " exception: " + me.getMessage()));
            connection.fail(me);
        }
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.get(connectionID);
        if (connection != null) {
            log.info((Object)("Connection " + connection.getRemoteAddress() + " ready"));
            connection.getTransportConnection().fireReady(true);
        }
    }

    public void stop() {
        for (RemotingConnection remotingConnection : this.connectionMap.values()) {
            remotingConnection.disconnect(false);
        }
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.get(connectionID);
        if (connection != null) {
            connection.bufferReceived(connectionID, buffer);
        }
    }
}

