/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CuratorClosedException;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.GetACLBuilder;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.GetConfigBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.api.ReconfigBuilder;
import org.apache.curator.framework.api.RemoveWatchesBuilder;
import org.apache.curator.framework.api.SetACLBuilder;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.curator.framework.api.SyncBuilder;
import org.apache.curator.framework.api.WatchesBuilder;
import org.apache.curator.framework.api.transaction.CuratorMultiTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.imps.BackgroundSyncImpl;
import org.apache.curator.framework.imps.CreateBuilderImpl;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.imps.CuratorMultiTransactionImpl;
import org.apache.curator.framework.imps.CuratorTransactionImpl;
import org.apache.curator.framework.imps.DeleteBuilderImpl;
import org.apache.curator.framework.imps.EnsembleTracker;
import org.apache.curator.framework.imps.ExistsBuilderImpl;
import org.apache.curator.framework.imps.FailedDeleteManager;
import org.apache.curator.framework.imps.FailedRemoveWatchManager;
import org.apache.curator.framework.imps.GetACLBuilderImpl;
import org.apache.curator.framework.imps.GetChildrenBuilderImpl;
import org.apache.curator.framework.imps.GetConfigBuilderImpl;
import org.apache.curator.framework.imps.GetDataBuilderImpl;
import org.apache.curator.framework.imps.NamespaceFacadeCache;
import org.apache.curator.framework.imps.NamespaceImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.ReconfigBuilderImpl;
import org.apache.curator.framework.imps.RemoveWatchesBuilderImpl;
import org.apache.curator.framework.imps.SetACLBuilderImpl;
import org.apache.curator.framework.imps.SetDataBuilderImpl;
import org.apache.curator.framework.imps.SyncBuilderImpl;
import org.apache.curator.framework.imps.TransactionOpImpl;
import org.apache.curator.framework.imps.WatcherRemovalFacade;
import org.apache.curator.framework.imps.WatcherRemovalManager;
import org.apache.curator.framework.imps.WatchesBuilderImpl;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public abstract class CuratorFrameworkBase
implements CuratorFramework {
    abstract NamespaceImpl getNamespaceImpl();

    @Override
    public final CuratorFramework nonNamespaceView() {
        return this.usingNamespace(null);
    }

    @Override
    public final String getNamespace() {
        NamespaceImpl namespace = this.getNamespaceImpl();
        String str = namespace.getNamespace();
        return str != null ? str : "";
    }

    @Override
    @Deprecated
    public EnsurePath newNamespaceAwareEnsurePath(String path) {
        NamespaceImpl namespace = this.getNamespaceImpl();
        return namespace.newNamespaceAwareEnsurePath(path);
    }

    final String unfixForNamespace(String path) {
        NamespaceImpl namespace = this.getNamespaceImpl();
        return namespace.unfixForNamespace(path);
    }

    final String fixForNamespace(String path) {
        NamespaceImpl namespace = this.getNamespaceImpl();
        return namespace.fixForNamespace(path, false);
    }

    abstract void validateConnection(Watcher.Event.KeeperState var1);

    final String fixForNamespace(String path, boolean isSequential) {
        NamespaceImpl namespace = this.getNamespaceImpl();
        return namespace.fixForNamespace(path, isSequential);
    }

    protected final void checkState() {
        CuratorFrameworkState state = this.getState();
        switch (state) {
            case STARTED: {
                return;
            }
            case STOPPED: {
                throw new CuratorClosedException();
            }
        }
        String msg = String.format("Expected state [%s] was [%s]", new Object[]{CuratorFrameworkState.STARTED, state});
        throw new IllegalStateException(msg);
    }

    final ZooKeeper getZooKeeper() throws Exception {
        return this.getZookeeperClient().getZooKeeper();
    }

    protected final void internalSync(CuratorFrameworkBase impl, String path, Object context) {
        BackgroundSyncImpl operation = new BackgroundSyncImpl(impl, context);
        this.processBackgroundOperation(new OperationAndData<String>(operation, path, null, null, context, null), null);
    }

    abstract byte[] getDefaultData();

    abstract CompressionProvider getCompressionProvider();

    abstract ACLProvider getAclProvider();

    abstract boolean useContainerParentsIfAvailable();

    abstract EnsembleTracker getEnsembleTracker();

    abstract NamespaceFacadeCache getNamespaceFacadeCache();

    @Override
    public CreateBuilder create() {
        this.checkState();
        return new CreateBuilderImpl(this);
    }

    @Override
    public DeleteBuilder delete() {
        this.checkState();
        return new DeleteBuilderImpl(this);
    }

    @Override
    public ExistsBuilder checkExists() {
        this.checkState();
        return new ExistsBuilderImpl(this);
    }

    @Override
    public GetDataBuilder getData() {
        this.checkState();
        return new GetDataBuilderImpl(this);
    }

    @Override
    public SetDataBuilder setData() {
        this.checkState();
        return new SetDataBuilderImpl(this);
    }

    @Override
    public GetChildrenBuilder getChildren() {
        this.checkState();
        return new GetChildrenBuilderImpl(this);
    }

    @Override
    public GetACLBuilder getACL() {
        this.checkState();
        return new GetACLBuilderImpl(this);
    }

    @Override
    public SetACLBuilder setACL() {
        this.checkState();
        return new SetACLBuilderImpl(this);
    }

    @Override
    public ReconfigBuilder reconfig() {
        this.checkState();
        return new ReconfigBuilderImpl(this);
    }

    @Override
    public GetConfigBuilder getConfig() {
        this.checkState();
        return new GetConfigBuilderImpl(this);
    }

    @Override
    public CuratorTransaction inTransaction() {
        this.checkState();
        return new CuratorTransactionImpl(this);
    }

    @Override
    public CuratorMultiTransaction transaction() {
        this.checkState();
        return new CuratorMultiTransactionImpl(this);
    }

    @Override
    public TransactionOp transactionOp() {
        this.checkState();
        return new TransactionOpImpl(this);
    }

    @Override
    public void sync(String path, Object context) {
        this.checkState();
        path = this.fixForNamespace(path);
        this.internalSync(this, path, context);
    }

    @Override
    public SyncBuilder sync() {
        this.checkState();
        return new SyncBuilderImpl(this);
    }

    @Override
    public final RemoveWatchesBuilder watches() {
        this.checkState();
        return new RemoveWatchesBuilderImpl(this);
    }

    @Override
    public final WatchesBuilder watchers() {
        Preconditions.checkState((boolean)this.getZookeeperCompatibility().hasPersistentWatchers(), (Object)"watchers() is not supported in the ZooKeeper library and/or server being used. Use watches() instead.");
        this.checkState();
        return new WatchesBuilderImpl(this);
    }

    @Override
    public final void createContainers(String path) throws Exception {
        this.checkExists().creatingParentContainersIfNeeded().forPath(ZKPaths.makePath((String)path, (String)"foo"));
    }

    @Override
    public final WatcherRemoveCuratorFramework newWatcherRemoveCuratorFramework() {
        return new WatcherRemovalFacade(this);
    }

    WatcherRemovalManager getWatcherRemovalManager() {
        return null;
    }

    abstract FailedDeleteManager getFailedDeleteManager();

    abstract FailedRemoveWatchManager getFailedRemoveWatcherManager();

    abstract void logError(String var1, Throwable var2);

    abstract <DATA_TYPE> void processBackgroundOperation(OperationAndData<DATA_TYPE> var1, CuratorEvent var2);

    abstract <DATA_TYPE> boolean queueOperation(OperationAndData<DATA_TYPE> var1);
}

