/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.impl;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MBeanRegistry {
    private final List<MBeanHandle> mBeanHandles = new ArrayList<MBeanHandle>();

    public final ObjectName registerMBean(Object pMBean, String ... pOptionalName) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        List<MBeanHandle> list = this.mBeanHandles;
        synchronized (list) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                String name = pOptionalName != null && pOptionalName.length > 0 ? pOptionalName[0] : null;
                ObjectName registeredName = this.registerMBeanAtServer(server, pMBean, name);
                this.mBeanHandles.add(new MBeanHandle(server, registeredName));
                return registeredName;
            }
            catch (RuntimeException exp) {
                throw new IllegalStateException("Could not register " + pMBean + ": " + exp, exp);
            }
        }
    }

    private ObjectName registerMBeanAtServer(MBeanServer pServer, Object pMBean, String pName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException, MalformedObjectNameException {
        ObjectName oName = pName != null ? new ObjectName(pName) : null;
        return pServer.registerMBean(pMBean, oName).getObjectName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBean(ObjectName pObjectName) throws MBeanRegistrationException {
        List<MBeanHandle> list = this.mBeanHandles;
        synchronized (list) {
            MBeanHandle toRemove = null;
            for (MBeanHandle handle : this.mBeanHandles) {
                if (!handle.objectName.equals(pObjectName)) continue;
                try {
                    handle.server.unregisterMBean(pObjectName);
                    toRemove = handle;
                    break;
                }
                catch (InstanceNotFoundException e) {
                    throw new IllegalStateException("No MBean " + pObjectName + " registered (although still in this registry)", e);
                }
            }
            if (toRemove != null) {
                this.mBeanHandles.remove(toRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() throws JMException {
        List<MBeanHandle> list = this.mBeanHandles;
        synchronized (list) {
            ArrayList<JMException> exceptions = new ArrayList<JMException>();
            ArrayList<MBeanHandle> unregistered = new ArrayList<MBeanHandle>();
            for (MBeanHandle handle : this.mBeanHandles) {
                try {
                    unregistered.add(handle);
                    handle.server.unregisterMBean(handle.objectName);
                }
                catch (InstanceNotFoundException | MBeanRegistrationException e) {
                    exceptions.add(e);
                }
            }
            this.mBeanHandles.removeAll(unregistered);
            if (exceptions.size() == 1) {
                throw (JMException)exceptions.get(0);
            }
            if (exceptions.size() > 1) {
                StringBuilder ret = new StringBuilder();
                for (JMException e : exceptions) {
                    ret.append(e.getMessage()).append(", ");
                }
                throw new JMException(ret.substring(0, ret.length() - 2));
            }
        }
    }

    private static final class MBeanHandle {
        private final ObjectName objectName;
        private final MBeanServer server;

        private MBeanHandle(MBeanServer pServer, ObjectName pRegisteredName) {
            this.server = pServer;
            this.objectName = pRegisteredName;
        }
    }
}

