/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.object;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.json.JSONStructure;
import org.jolokia.service.serializer.object.OpenTypeConverter;
import org.jolokia.service.serializer.object.OpenTypeDeserializer;

class TabularDataConverter
extends OpenTypeConverter<TabularType> {
    private static final String TD_KEY_KEY = "key";
    private static final String TD_KEY_VALUE = "value";

    public TabularDataConverter(OpenTypeDeserializer pDispatcher) {
        super(pDispatcher);
    }

    @Override
    boolean canConvert(OpenType pType) {
        return pType instanceof TabularType;
    }

    @Override
    Object convertToObject(TabularType pType, Object pFrom) {
        JSONObject value = this.getAsJsonObject(pFrom);
        if (this.checkForMapAttributeWithSimpleKey(pType)) {
            return this.convertToTabularTypeFromMap(pType, value);
        }
        if (this.checkForFullTabularDataRepresentation(value, pType)) {
            return this.convertTabularDataFromFullRepresentation(value, pType);
        }
        TabularDataSupport tabularData = new TabularDataSupport(pType);
        this.putRowsToTabularData(tabularData, value, pType.getIndexNames().size());
        return tabularData;
    }

    private JSONObject getAsJsonObject(Object pFrom) {
        JSONStructure jsonVal = this.toJSON(pFrom);
        if (!(jsonVal instanceof JSONObject)) {
            throw new IllegalArgumentException("Expected JSON type for a TabularData is JSONObject, not " + jsonVal.getClass());
        }
        return (JSONObject)jsonVal;
    }

    private boolean checkForMapAttributeWithSimpleKey(TabularType pType) {
        return this.checkForMapKey(pType) && this.checkForMapValue(pType);
    }

    private boolean checkForMapValue(TabularType pType) {
        CompositeType rowType = pType.getRowType();
        return rowType.containsKey(TD_KEY_VALUE) && rowType.containsKey(TD_KEY_KEY) && rowType.keySet().size() == 2;
    }

    private boolean checkForMapKey(TabularType pType) {
        List<String> indexNames = pType.getIndexNames();
        return indexNames.size() == 1 && indexNames.contains(TD_KEY_KEY) && pType.getRowType().getType(TD_KEY_KEY) instanceof SimpleType;
    }

    private boolean checkForFullTabularDataRepresentation(JSONObject pValue, TabularType pType) {
        if (pValue.containsKey((Object)"indexNames") && pValue.containsKey((Object)"values") && pValue.size() == 2) {
            Object jsonVal = pValue.get((Object)"indexNames");
            if (!(jsonVal instanceof JSONArray)) {
                throw new IllegalArgumentException("Index names for tabular data must given as JSON array, not " + jsonVal.getClass());
            }
            JSONArray indexNames = (JSONArray)jsonVal;
            List<String> tabularIndexNames = pType.getIndexNames();
            if (indexNames.size() != tabularIndexNames.size()) {
                throw new IllegalArgumentException("Given array with index names must have " + tabularIndexNames.size() + " entries (given: " + indexNames.toJSONString() + ", required: " + tabularIndexNames + ")");
            }
            for (Object index : indexNames) {
                if (tabularIndexNames.contains(index.toString())) continue;
                throw new IllegalArgumentException("No index with name '" + index + "' known (given: " + indexNames.toJSONString() + ", required: " + tabularIndexNames + ")");
            }
            return true;
        }
        return false;
    }

    private TabularData convertToTabularTypeFromMap(TabularType pType, JSONObject pValue) {
        CompositeType rowType = pType.getRowType();
        TabularDataSupport tabularData = new TabularDataSupport(pType);
        for (Map.Entry entry : pValue.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TD_KEY_KEY, this.getDispatcher().deserialize(rowType.getType(TD_KEY_KEY), entry.getKey()));
            map.put(TD_KEY_VALUE, this.getDispatcher().deserialize(rowType.getType(TD_KEY_VALUE), entry.getValue()));
            try {
                CompositeDataSupport compositeData = new CompositeDataSupport(rowType, map);
                tabularData.put(compositeData);
            }
            catch (OpenDataException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return tabularData;
    }

    private TabularData convertTabularDataFromFullRepresentation(JSONObject pValue, TabularType pType) {
        JSONStructure jsonVal = (JSONStructure)pValue.get((Object)"values");
        if (!(jsonVal instanceof JSONArray)) {
            throw new IllegalArgumentException("Values for tabular data of type " + pType + " must given as JSON array, not " + jsonVal.getClass());
        }
        TabularDataSupport tabularData = new TabularDataSupport(pType);
        for (Object val : (JSONArray)jsonVal) {
            if (!(val instanceof JSONObject)) {
                throw new IllegalArgumentException("Tabular-Data values must be given as JSON objects, not " + val.getClass());
            }
            tabularData.put((CompositeData)this.getDispatcher().deserialize(pType.getRowType(), val));
        }
        return tabularData;
    }

    private void putRowsToTabularData(TabularDataSupport pTabularData, JSONObject pValue, int pLevel) {
        TabularType type = pTabularData.getTabularType();
        for (Object value : pValue.values()) {
            if (!(value instanceof JSONObject)) {
                throw new IllegalArgumentException("Cannot convert " + pValue.toJSONString() + " to type " + type + " because the object values provided (" + value.getClass() + ") is not of the expected type JSONObject at level " + pLevel);
            }
            JSONObject jsonValue = (JSONObject)value;
            if (pLevel > 1) {
                this.putRowsToTabularData(pTabularData, jsonValue, pLevel - 1);
                continue;
            }
            pTabularData.put((CompositeData)this.getDispatcher().deserialize(type.getRowType(), jsonValue));
        }
    }
}

