/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.backoff;

import java.io.Closeable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.util.backoff.BackOff;
import org.apache.camel.util.backoff.BackOffTimer;
import org.apache.camel.util.backoff.BackOffTimerTask;
import org.apache.camel.util.function.ThrowingFunction;

public class SimpleBackOffTimer
implements BackOffTimer,
Closeable {
    private final ScheduledExecutorService scheduler;
    private final String name;
    private final Set<BackOffTimerTask> tasks = new CopyOnWriteArraySet<BackOffTimerTask>();

    public SimpleBackOffTimer(ScheduledExecutorService scheduler) {
        this("SimpleBackOffTimer", scheduler);
    }

    public SimpleBackOffTimer(String name, ScheduledExecutorService scheduler) {
        this.name = name;
        this.scheduler = scheduler;
    }

    @Override
    public BackOffTimer.Task schedule(BackOff backOff, ThrowingFunction<BackOffTimer.Task, Boolean, Exception> function) {
        BackOffTimerTask task = new BackOffTimerTask(this, backOff, this.scheduler, function);
        long delay = task.next();
        if (delay != -1L) {
            this.tasks.add(task);
            this.scheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
        } else {
            task.cancel();
        }
        return task;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void remove(BackOffTimer.Task task) {
        this.tasks.remove(task);
    }

    @Override
    public Set<BackOffTimer.Task> getTasks() {
        return Collections.unmodifiableSet(this.tasks);
    }

    @Override
    public int size() {
        return this.tasks.size();
    }

    @Override
    public void close() {
        this.tasks.clear();
    }
}

