/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.remoting;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.spring.remoting.SecureRemoteInvocationFactory;
import org.apache.shiro.subject.ExecutionException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.support.DefaultRemoteInvocationExecutor;
import org.springframework.remoting.support.RemoteInvocation;

public class SecureRemoteInvocationExecutor
extends DefaultRemoteInvocationExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureRemoteInvocationExecutor.class);
    private SecurityManager securityManager;

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public Object invoke(final RemoteInvocation invocation, final Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Serializable sessionId;
            SecurityManager securityManager = this.securityManager != null ? this.securityManager : SecurityUtils.getSecurityManager();
            Subject.Builder builder = new Subject.Builder(securityManager);
            String host = (String)((Object)invocation.getAttribute(SecureRemoteInvocationFactory.HOST_KEY));
            if (host != null) {
                builder.host(host);
            }
            if ((sessionId = invocation.getAttribute(SecureRemoteInvocationFactory.SESSION_ID_KEY)) != null) {
                builder.sessionId(sessionId);
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("RemoteInvocation did not contain a Shiro Session id attribute under key [" + SecureRemoteInvocationFactory.SESSION_ID_KEY + "].  A Subject based on an existing Session will not be available during the method invocation.");
            }
            Subject subject = builder.buildSubject();
            return subject.execute(new Callable(){

                public Object call() throws Exception {
                    return SecureRemoteInvocationExecutor.super.invoke(invocation, targetObject);
                }
            });
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)cause;
            }
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            if (cause instanceof InvocationTargetException) {
                throw (InvocationTargetException)cause;
            }
            throw new InvocationTargetException(cause);
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }
}

