/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jms.DefaultQueueBrowseStrategy;
import org.apache.camel.component.jms.JmsBrowsableEndpoint;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.spi.BrowsableEndpoint;
import org.springframework.jms.core.JmsOperations;

@ManagedResource(description="Managed JMS Queue Endpoint")
public class JmsQueueEndpoint
extends JmsEndpoint
implements JmsBrowsableEndpoint,
BrowsableEndpoint {
    private int maximumBrowseSize = -1;
    private final QueueBrowseStrategy queueBrowseStrategy;

    public JmsQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration) {
        this(uri, component, destination, configuration, null);
        this.setDestinationType("queue");
    }

    public JmsQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        super(uri, component, destination, false, configuration);
        this.setDestinationType("queue");
        this.queueBrowseStrategy = queueBrowseStrategy == null ? this.createQueueBrowseStrategy() : queueBrowseStrategy;
    }

    public JmsQueueEndpoint(String endpointUri, String destination, QueueBrowseStrategy queueBrowseStrategy) {
        super(endpointUri, destination, false);
        this.setDestinationType("queue");
        this.queueBrowseStrategy = queueBrowseStrategy == null ? this.createQueueBrowseStrategy() : queueBrowseStrategy;
    }

    public JmsQueueEndpoint(String endpointUri, String destination) {
        super(endpointUri, destination, false);
        this.setDestinationType("queue");
        this.queueBrowseStrategy = this.createQueueBrowseStrategy();
    }

    @Override
    @ManagedAttribute
    public int getMaximumBrowseSize() {
        return this.maximumBrowseSize;
    }

    @ManagedAttribute
    public void setMaximumBrowseSize(int maximumBrowseSize) {
        this.maximumBrowseSize = maximumBrowseSize;
    }

    public int getBrowseLimit() {
        return this.maximumBrowseSize;
    }

    public void setBrowseLimit(int browseLimit) {
        this.maximumBrowseSize = browseLimit;
    }

    public List<Exchange> getExchanges() {
        return this.getExchanges(this.maximumBrowseSize, null);
    }

    public BrowsableEndpoint.BrowseStatus getBrowseStatus(int limit) {
        if (this.queueBrowseStrategy == null) {
            return new BrowsableEndpoint.BrowseStatus(0, 0L, 0L);
        }
        String queue = this.getDestinationName();
        JmsOperations template = this.getConfiguration().createInOnlyTemplate(this, false, queue);
        return this.queueBrowseStrategy.browseStatus(template, queue, this, limit);
    }

    public List<Exchange> getExchanges(int limit, Predicate filter) {
        if (this.queueBrowseStrategy == null) {
            return Collections.emptyList();
        }
        String queue = this.getDestinationName();
        JmsOperations template = this.getConfiguration().createInOnlyTemplate(this, false, queue);
        List<Object> list = this.queueBrowseStrategy.browse(template, queue, this, limit);
        if (filter != null) {
            list = list.stream().filter(filter).collect(Collectors.toList());
        }
        return list;
    }

    protected QueueBrowseStrategy createQueueBrowseStrategy() {
        return new DefaultQueueBrowseStrategy();
    }
}

