/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.support.processor.ConvertBodyProcessor;

public class ConvertBodyReifier
extends ProcessorReifier<ConvertBodyDefinition> {
    public ConvertBodyReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ConvertBodyDefinition)ConvertBodyDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Class typeClass = this.parse(Class.class, this.or(((ConvertBodyDefinition)this.definition).getTypeClass(), this.parseString(((ConvertBodyDefinition)this.definition).getType())));
        String charset = ConvertBodyReifier.validateCharset(this.parseString(((ConvertBodyDefinition)this.definition).getCharset()));
        boolean mandatory = true;
        if (((ConvertBodyDefinition)this.definition).getMandatory() != null) {
            mandatory = this.parseBoolean(((ConvertBodyDefinition)this.definition).getMandatory(), true);
        }
        ConvertBodyProcessor answer = new ConvertBodyProcessor(typeClass, charset, mandatory);
        answer.setDisabled(ConvertBodyReifier.isDisabled(this.camelContext, (NamedNode)this.definition));
        return answer;
    }

    public static String validateCharset(String charset) throws UnsupportedCharsetException {
        if (charset != null) {
            if (Charset.isSupported(charset)) {
                return Charset.forName(charset).name();
            }
            throw new UnsupportedCharsetException(charset);
        }
        return null;
    }
}

