/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.xmpp;

import ietf.params.xml.ns.xmpp_sasl.Auth;
import ietf.params.xml.ns.xmpp_sasl.Challenge;
import ietf.params.xml.ns.xmpp_sasl.Success;
import ietf.params.xml.ns.xmpp_tls.Proceed;
import ietf.params.xml.ns.xmpp_tls.Starttls;
import jabber.client.Body;
import jabber.client.Error;
import jabber.client.Iq;
import jabber.client.Message;
import jabber.client.Presence;
import jabber.iq.auth.Query;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.transport.xmpp.XmppTransport;
import org.apache.activemq.transport.xmpp.command.Handler;
import org.apache.activemq.transport.xmpp.command.HandlerRegistry;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.IntSequenceGenerator;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jabber.protocol.disco_info.Feature;
import org.jabber.protocol.disco_info.Identity;
import org.jabber.protocol.muc_user.Item;
import org.jabber.protocol.muc_user.X;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolConverter {
    private static final transient Log LOG = LogFactory.getLog(ProtocolConverter.class);
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private static final IdGenerator CLIENT_ID_GENERATOR = new IdGenerator("xmpp");
    private HandlerRegistry registry = new HandlerRegistry();
    private XmppTransport transport;
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, -1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final ConnectionInfo connectionInfo = new ConnectionInfo(this.connectionId);
    private final SessionInfo sessionInfo = new SessionInfo(this.sessionId);
    private final ProducerInfo producerInfo = new ProducerInfo(this.producerId);
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final IntSequenceGenerator tempDestinationIdGenerator = new IntSequenceGenerator();
    private final Map<Integer, Handler<Response>> responseHandlers = new ConcurrentHashMap<Integer, Handler<Response>>();
    private final Map<ConsumerId, Handler<MessageDispatch>> subscriptionsByConsumerId = new ConcurrentHashMap<ConsumerId, Handler<MessageDispatch>>();
    private final Map<String, ConsumerInfo> jidToConsumerMap = new HashMap<String, ConsumerInfo>();
    private final Map<String, ConsumerInfo> jidToInboxConsumerMap = new HashMap<String, ConsumerInfo>();
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private ActiveMQTempQueue inboxDestination;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);

    public ProtocolConverter(XmppTransport transport) {
        this.transport = transport;
        this.initialiseRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    protected void initialiseRegistry() {
        this.registry.registerHandler(Message.class, new Handler<Message>(){

            @Override
            public void handle(Message event) throws Exception {
                ProtocolConverter.this.onMessage(event);
            }
        });
        this.registry.registerHandler(Auth.class, new Handler<Auth>(){

            @Override
            public void handle(Auth event) throws Exception {
                ProtocolConverter.this.onAuth(event);
            }
        });
        this.registry.registerHandler(Starttls.class, new Handler<Starttls>(){

            @Override
            public void handle(Starttls event) throws Exception {
                ProtocolConverter.this.onStarttls(event);
            }
        });
        this.registry.registerHandler(Iq.class, new Handler<Iq>(){

            @Override
            public void handle(Iq event) throws Exception {
                ProtocolConverter.this.onIq(event);
            }
        });
        this.registry.registerHandler(Presence.class, new Handler<Presence>(){

            @Override
            public void handle(Presence event) throws Exception {
                ProtocolConverter.this.onPresence(event);
            }
        });
    }

    public void onXmppCommand(Object command) throws Exception {
        Handler handler = this.registry.getHandler(command.getClass());
        if (handler == null) {
            this.unknownCommand(command);
        } else {
            handler.handle(command);
        }
    }

    public void onActiveMQCommand(Command command) throws Exception {
        if (command.isResponse()) {
            Response response = (Response)command;
            Handler<Response> handler = this.responseHandlers.remove(new Integer(response.getCorrelationId()));
            if (handler != null) {
                handler.handle(response);
            } else {
                LOG.warn((Object)("No handler for response: " + response));
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            Handler<MessageDispatch> handler = this.subscriptionsByConsumerId.get(md.getConsumerId());
            if (handler != null) {
                handler.handle(md);
            } else {
                LOG.warn((Object)("No handler for message: " + md));
            }
        }
    }

    protected void unknownCommand(Object command) throws Exception {
        LOG.warn((Object)("Unkown command: " + command + " of type: " + command.getClass().getName()));
    }

    protected void onIq(Iq iq) throws Exception {
        Object any = iq.getAny();
        if (any instanceof Query) {
            this.onAuthQuery(any, iq);
        } else if (any instanceof jabber.iq._private.Query) {
            jabber.iq._private.Query query = (jabber.iq._private.Query)any;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Iq Private " + this.debugString(iq) + " any: " + query.getAny()));
            }
            Iq result = this.createResult(iq);
            jabber.iq._private.Query answer = new jabber.iq._private.Query();
            result.setAny(answer);
            this.transport.marshall(result);
        } else if (any instanceof jabber.iq.roster.Query) {
            jabber.iq.roster.Query query = (jabber.iq.roster.Query)any;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Iq Roster " + this.debugString(iq) + " item: " + query.getItem()));
            }
            Iq result = this.createResult(iq);
            jabber.iq.roster.Query roster = new jabber.iq.roster.Query();
            result.setAny(roster);
            this.transport.marshall(result);
        } else if (any instanceof org.jabber.protocol.disco_items.Query) {
            this.onDiscoItems(iq, (org.jabber.protocol.disco_items.Query)any);
        } else if (any instanceof org.jabber.protocol.disco_info.Query) {
            this.onDiscoInfo(iq, (org.jabber.protocol.disco_info.Query)any);
        } else {
            if (any instanceof Element) {
                Element element = (Element)any;
                LOG.warn((Object)("Iq Unknown " + this.debugString(iq) + " element namespace: " + element.getNamespaceURI() + " localName: " + element.getLocalName()));
            } else {
                LOG.warn((Object)("Iq Unknown " + this.debugString(iq) + " any: " + any + " of type: " + any.getClass().getName()));
            }
            Iq result = this.createResult(iq);
            Error error = new Error();
            error.setUnexpectedRequest("Don't understand: " + any.toString());
            result.setAny(error);
            this.transport.marshall(result);
        }
    }

    protected void onAuthQuery(Object any, final Iq iq) throws IOException, JMSException {
        Query query = (Query)any;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Iq Auth Query " + this.debugString(iq) + " resource: " + query.getResource() + " username: " + query.getUsername()));
        }
        if (query.getPassword() == null) {
            Iq result = this.createResult(iq);
            Query required = new Query();
            required.setPassword("");
            required.setUsername("");
            result.setAny(required);
            this.transport.marshall(result);
            return;
        }
        this.connectionInfo.setUserName(query.getUsername());
        this.connectionInfo.setPassword(query.getPassword());
        if (this.connectionInfo.getClientId() == null) {
            this.connectionInfo.setClientId(CLIENT_ID_GENERATOR.generateId());
        }
        this.sendToActiveMQ((Command)this.connectionInfo, new Handler<Response>(){

            @Override
            public void handle(Response response) throws Exception {
                Iq result = ProtocolConverter.this.createResult(iq);
                if (response instanceof ExceptionResponse) {
                    ExceptionResponse exceptionResponse = (ExceptionResponse)response;
                    Throwable exception = exceptionResponse.getException();
                    LOG.warn((Object)("Failed to create connection: " + exception), exception);
                    Error error = new Error();
                    result.setError(error);
                    StringWriter buffer = new StringWriter();
                    exception.printStackTrace(new PrintWriter(buffer));
                    error.setInternalServerError(buffer.toString());
                } else {
                    ProtocolConverter.this.connected.set(true);
                }
                ProtocolConverter.this.transport.marshall(result);
                ProtocolConverter.this.sendToActiveMQ((Command)ProtocolConverter.this.sessionInfo, ProtocolConverter.this.createErrorHandler("create sesssion"));
                ProtocolConverter.this.sendToActiveMQ((Command)ProtocolConverter.this.producerInfo, ProtocolConverter.this.createErrorHandler("create producer"));
            }
        });
        String to = query.getUsername();
        this.createDestination(to);
    }

    public void createDestination(String to) throws IOException, JMSException {
        ActiveMQDestination destination = this.createActiveMQDestination(to);
        if (destination == null) {
            LOG.debug((Object)("Unable to create destination for " + to));
            return;
        }
        this.subscribe(to, destination, this.jidToConsumerMap);
        if (this.inboxDestination == null) {
            this.inboxDestination = new ActiveMQTempQueue(this.connectionInfo.getConnectionId(), (long)this.tempDestinationIdGenerator.getNextSequenceId());
            DestinationInfo info = new DestinationInfo();
            info.setConnectionId(this.connectionInfo.getConnectionId());
            info.setOperationType((byte)0);
            info.setDestination((ActiveMQDestination)this.inboxDestination);
            this.sendToActiveMQ((Command)info, null);
            this.subscribe(to, (ActiveMQDestination)this.inboxDestination, this.jidToInboxConsumerMap);
        }
    }

    protected String debugString(Iq iq) {
        return "to: " + iq.getTo() + " type: " + iq.getType() + " from: " + iq.getFrom() + " id: " + iq.getId();
    }

    protected void onDiscoItems(Iq iq, org.jabber.protocol.disco_items.Query query) throws IOException {
        String to = iq.getTo();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Iq Disco Items query " + this.debugString(iq) + " node: " + query.getNode() + " item: " + query.getItem()));
        }
        Iq result = this.createResult(iq);
        org.jabber.protocol.disco_items.Query answer = new org.jabber.protocol.disco_items.Query();
        if (to == null || to.length() == 0) {
            answer.getItem().add(this.createItem("queues", "Queues", "queues"));
            answer.getItem().add(this.createItem("topics", "Topics", "topics"));
        }
        result.setAny(answer);
        this.transport.marshall(result);
    }

    protected void onDiscoInfo(Iq iq, org.jabber.protocol.disco_info.Query query) throws IOException {
        String to = iq.getTo();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Iq Disco Info query " + this.debugString(iq) + " node: " + query.getNode() + " features: " + query.getFeature() + " identity: " + query.getIdentity()));
        }
        Iq result = this.createResult(iq);
        org.jabber.protocol.disco_info.Query answer = new org.jabber.protocol.disco_info.Query();
        answer.setNode(to);
        answer.getFeature().add(this.createFeature("http://jabber.org/protocol/disco#info"));
        answer.getFeature().add(this.createFeature("http://jabber.org/protocol/disco#items"));
        if (to == null || to.length() == 0) {
            answer.getIdentity().add(this.createIdentity("directory", "chatroom", "queues"));
            answer.getIdentity().add(this.createIdentity("directory", "chatroom", "topics"));
        } else if (to.equals("queues")) {
            answer.getIdentity().add(this.createIdentity("conference", "queue.a", "text"));
            answer.getIdentity().add(this.createIdentity("conference", "queue.b", "text"));
        } else if (to.equals("topics")) {
            answer.getIdentity().add(this.createIdentity("conference", "topic.x", "text"));
            answer.getIdentity().add(this.createIdentity("conference", "topic.y", "text"));
            answer.getIdentity().add(this.createIdentity("conference", "topic.z", "text"));
        } else {
            answer.getIdentity().add(this.createIdentity("conference", to, "text"));
            answer.getFeature().add(this.createFeature("http://jabber.org/protocol/muc"));
            answer.getFeature().add(this.createFeature("muc-open"));
        }
        result.setAny(answer);
        this.transport.marshall(result);
    }

    protected void onPresence(Presence presence) throws IOException, JMSException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Presence: " + presence.getFrom() + " id: " + presence.getId() + " to: " + presence.getTo() + " type: " + presence.getType() + " showOrStatusOrPriority: " + presence.getShowOrStatusOrPriority() + " any: " + presence.getAny()));
        }
        Item item = new Item();
        item.setAffiliation("owner");
        item.setRole("moderator");
        item.setNick("broker");
        this.sendPresence(presence, item);
        String to = presence.getTo();
        if (to != null) {
            to = to.substring(0, to.indexOf("/"));
        }
        this.createDestination(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribe(final String to, ActiveMQDestination destination, Map<String, ConsumerInfo> consumerMap) {
        boolean createConsumer = false;
        ConsumerInfo consumerInfo = null;
        Map<String, ConsumerInfo> map = consumerMap;
        synchronized (map) {
            consumerInfo = consumerMap.get(to);
            if (consumerInfo == null) {
                consumerInfo = new ConsumerInfo();
                consumerMap.put(to, consumerInfo);
                ConsumerId consumerId = new ConsumerId(this.sessionId, this.consumerIdGenerator.getNextSequenceId());
                consumerInfo.setConsumerId(consumerId);
                consumerInfo.setPrefetchSize(10);
                consumerInfo.setNoLocal(true);
                createConsumer = true;
            }
        }
        if (!createConsumer) {
            return;
        }
        consumerInfo.setDestination(destination);
        this.subscriptionsByConsumerId.put(consumerInfo.getConsumerId(), new Handler<MessageDispatch>(){

            @Override
            public void handle(final MessageDispatch messageDispatch) throws Exception {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Receiving inbound: " + messageDispatch.getMessage()));
                }
                final MessageAck ack = new MessageAck(messageDispatch, 2, 1);
                FutureTask<Void> task = new FutureTask<Void>(new Callable<Void>(){

                    @Override
                    public Void call() {
                        ProtocolConverter.this.sendToActiveMQ((Command)ack, ProtocolConverter.this.createErrorHandler("Ack of message: " + messageDispatch.getMessage().getMessageId()));
                        return null;
                    }
                });
                ProtocolConverter.this.scheduledThreadPoolExecutor.submit(task);
                Message message = ProtocolConverter.this.createXmppMessage(to, messageDispatch);
                if (message != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Sending message to XMPP client from: " + message.getFrom() + " to: " + message.getTo() + " type: " + message.getType() + " with body: " + message.getAny()));
                    }
                    ProtocolConverter.this.transport.marshall(message);
                }
            }
        });
        this.sendToActiveMQ((Command)consumerInfo, this.createErrorHandler("subscribe to destination: " + destination));
    }

    protected Message createXmppMessage(String to, MessageDispatch messageDispatch) throws IOException, JMSException {
        org.apache.activemq.command.Message message = messageDispatch.getMessage();
        Message answer = new Message();
        String from = (String)message.getProperty("XMPPFrom");
        if (from == null) {
            from = to;
            int idx = from.indexOf(47);
            if (idx > 0) {
                from = from.substring(0, idx) + "/broker";
            }
            answer.setType("groupchat");
        } else {
            answer.setType("chat");
        }
        LOG.debug((Object)("Sending message from " + from + " and to " + to));
        answer.setFrom(from);
        answer.setTo(to);
        if (message instanceof ActiveMQTextMessage) {
            ActiveMQTextMessage activeMQTextMessage = (ActiveMQTextMessage)message;
            Body body = new Body();
            String text = activeMQTextMessage.getText();
            LOG.info((Object)("Setting the body text to be: " + text));
            body.setValue(text);
            answer.getAny().add(body);
        } else {
            LOG.warn((Object)("Could not convert the message to a complete Jabber message: " + message));
        }
        return answer;
    }

    protected void sendPresence(Presence presence, Item item) throws IOException {
        Presence answer = new Presence();
        answer.setFrom(presence.getTo());
        answer.setType(presence.getType());
        answer.setTo(presence.getFrom());
        X x = new X();
        x.getDeclineOrDestroyOrInvite().add(item);
        answer.getShowOrStatusOrPriority().add(x);
        this.transport.marshall(answer);
    }

    protected org.jabber.protocol.disco_items.Item createItem(String jid, String name, String node) {
        org.jabber.protocol.disco_items.Item answer = new org.jabber.protocol.disco_items.Item();
        answer.setJid(jid);
        answer.setName(name);
        answer.setNode(node);
        return answer;
    }

    protected Identity createIdentity(String category, String type, String name) {
        Identity answer = new Identity();
        answer.setCategory(category);
        answer.setName(name);
        answer.setType(type);
        return answer;
    }

    protected Feature createFeature(String var) {
        Feature feature = new Feature();
        feature.setVar(var);
        return feature;
    }

    protected Iq createResult(Iq iq) {
        Iq result = new Iq();
        result.setId(iq.getId());
        result.setFrom(this.transport.getFrom());
        result.setTo(iq.getFrom());
        result.setLang(iq.getLang());
        result.setType("result");
        return result;
    }

    protected void sendToActiveMQ(Command command, Handler<Response> handler) {
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.responseHandlers.put(command.getCommandId(), handler);
        }
        this.transport.getTransportListener().onCommand((Object)command);
    }

    protected void onStarttls(Starttls starttls) throws Exception {
        LOG.debug((Object)"Starttls");
        this.transport.marshall(new Proceed());
    }

    protected void onMessage(Message message) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Message from: " + message.getFrom() + " to: " + message.getTo() + " subjectOrBodyOrThread: " + message.getSubjectOrBodyOrThread()));
        }
        ActiveMQMessage activeMQMessage = this.createActiveMQMessage(message);
        ActiveMQDestination destination = this.createActiveMQDestination(message.getTo());
        activeMQMessage.setMessageId(new MessageId(this.producerInfo, this.messageIdGenerator.getNextSequenceId()));
        activeMQMessage.setDestination(destination);
        activeMQMessage.setProducerId(this.producerId);
        activeMQMessage.setTimestamp(System.currentTimeMillis());
        this.addActiveMQMessageHeaders(activeMQMessage, message);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending ActiveMQ message: " + activeMQMessage));
        }
        this.sendToActiveMQ((Command)activeMQMessage, this.createErrorHandler("send message"));
    }

    protected Handler<Response> createErrorHandler(final String text) {
        return new Handler<Response>(){

            @Override
            public void handle(Response event) throws Exception {
                if (event instanceof ExceptionResponse) {
                    ExceptionResponse exceptionResponse = (ExceptionResponse)event;
                    Throwable exception = exceptionResponse.getException();
                    LOG.error((Object)("Failed to " + text + ". Reason: " + exception), exception);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Completed " + text));
                }
            }
        };
    }

    protected ActiveMQDestination createActiveMQDestination(String jabberDestination) throws JMSException {
        if (jabberDestination == null) {
            return null;
        }
        String name = jabberDestination;
        int idx = jabberDestination.indexOf(64);
        if (idx > 0) {
            name = name.substring(0, idx);
        }
        if (name.equalsIgnoreCase("ActiveMQ.Agent")) {
            name = "ActiveMQ.Agent";
        }
        return new ActiveMQTopic(name);
    }

    protected ActiveMQMessage createActiveMQMessage(Message message) throws JMSException {
        ActiveMQTextMessage answer = new ActiveMQTextMessage();
        String text = "";
        List<Object> list = message.getSubjectOrBodyOrThread();
        for (Object object : list) {
            if (!(object instanceof Body)) continue;
            Body body = (Body)object;
            text = body.getValue();
            break;
        }
        answer.setText(text);
        return answer;
    }

    protected void addActiveMQMessageHeaders(ActiveMQMessage answer, Message message) throws JMSException {
        answer.setStringProperty("XMPPFrom", message.getFrom());
        answer.setStringProperty("XMPPID", message.getId());
        answer.setStringProperty("XMPPLang", message.getLang());
        answer.setStringProperty("XMPPTo", message.getTo());
        answer.setJMSType(message.getType());
        ActiveMQDestination replyTo = this.createActiveMQDestination(message.getFrom());
        if (replyTo == null) {
            replyTo = this.inboxDestination;
        }
        LOG.info((Object)("Setting reply to destination to: " + replyTo));
        answer.setJMSReplyTo((Destination)replyTo);
    }

    protected void onAuth(Auth auth) throws Exception {
        String value;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Auth mechanism: " + auth.getMechanism() + " value: " + auth.getValue()));
        }
        if ((value = this.createChallengeValue(auth)) != null) {
            Challenge challenge = new Challenge();
            challenge.setValue(value);
            this.transport.marshall(challenge);
        } else {
            this.transport.marshall(new Success());
        }
    }

    protected String createChallengeValue(Auth auth) {
        return null;
    }
}

