/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.config;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.ConnectionFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.web.config.WebConsoleConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfiguration
implements WebConsoleConfiguration {
    @Override
    public ConnectionFactory getConnectionFactory() {
        return null;
    }

    @Override
    public String getJmxPassword() {
        return null;
    }

    @Override
    public Collection<JMXServiceURL> getJmxUrls() {
        return null;
    }

    @Override
    public String getJmxUser() {
        return null;
    }

    protected ConnectionFactory makeConnectionFactory(String jmsUrl, String jmsUser, String jmsPassword) {
        if (jmsUser != null && jmsUser.length() > 0) {
            return new ActiveMQConnectionFactory(jmsUser, jmsPassword, jmsUrl);
        }
        return new ActiveMQConnectionFactory(jmsUrl);
    }

    protected Collection<JMXServiceURL> makeJmxUrls(String jmxUrls) {
        String[] urls = jmxUrls.split(",");
        if (urls == null || urls.length == 0) {
            urls = new String[]{jmxUrls};
        }
        try {
            ArrayList<JMXServiceURL> result = new ArrayList<JMXServiceURL>(jmxUrls.length());
            for (String url : urls) {
                result.add(new JMXServiceURL(url));
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JMX-url", e);
        }
    }
}

