/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.web.BrokerFacade;
import org.apache.activemq.web.DestinationFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class CopyMessage
extends DestinationFacade
implements Controller {
    private String messageId;
    private String destination;
    private static final Logger log = LoggerFactory.getLogger(CopyMessage.class);

    public CopyMessage(BrokerFacade brokerFacade) {
        super(brokerFacade);
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.messageId != null) {
            QueueViewMBean queueView = this.getQueueView();
            if (queueView != null) {
                log.info(this.getJMSDestination() + "(" + this.messageId + ") copy to " + this.destination);
                queueView.copyMessageTo(this.messageId, this.destination);
            } else {
                log.warn("No queue named: " + this.getPhysicalDestinationName());
            }
        }
        return this.redirectToDestinationView();
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}

