/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.config;

import jakarta.jms.ConnectionFactory;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.web.config.AbstractConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class OsgiConfiguration
extends AbstractConfiguration
implements ManagedService {
    private ServiceRegistration service;
    private String jmxUrl = "service:jmx:rmi:///jndi/rmi://localhost:1099/karaf-root";
    private String jmxUser;
    private String jmxPassword;
    private String jmsUrl = "tcp://localhost:61616";
    private String jmsUser;
    private String jmsPassword;

    public OsgiConfiguration() {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", "org.apache.activemq.webconsole");
        this.service = context.registerService(ManagedService.class.getName(), (Object)this, properties);
    }

    public String getJmxPassword() {
        return this.jmxPassword;
    }

    public Collection<JMXServiceURL> getJmxUrls() {
        return this.makeJmxUrls(this.jmxUrl);
    }

    public String getJmxUser() {
        return this.jmxUser;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.makeConnectionFactory(this.jmsUrl, this.jmsUser, this.jmsPassword);
    }

    public void updated(Dictionary dictionary) throws ConfigurationException {
        if (dictionary != null) {
            this.jmxUrl = (String)dictionary.get("webconsole.jmx.url");
            if (this.jmxUrl == null) {
                throw new IllegalArgumentException("A JMS-url must be specified (system property webconsole.jmx.url");
            }
            this.jmxUser = (String)dictionary.get("webconsole.jmx.user");
            this.jmxPassword = (String)dictionary.get("webconsole.jmx.password");
            this.jmsUrl = (String)dictionary.get("webconsole.jms.url");
            this.jmsUser = (String)dictionary.get("webconsole.jms.user");
            this.jmsPassword = (String)dictionary.get("webconsole.jms.password");
        }
    }
}

