
package org.apache.activemq.schema.core;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.activemq.plugin.jaxb2_commons.ElementAwareEqualsStrategy;
import org.jvnet.jaxb.lang.Equals;
import org.jvnet.jaxb.lang.EqualsStrategy;
import org.jvnet.jaxb.lang.HashCode;
import org.jvnet.jaxb.lang.HashCodeStrategy;
import org.jvnet.jaxb.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Classe Java pour anonymous complex type.
 * 
 * <p>Le fragment de schéma suivant indique le contenu attendu figurant dans cette classe.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;attribute name="adminPermissionGroupSearchFilter" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="authentication" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="connectionPassword" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="connectionProtocol" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="connectionURL" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="connectionUsername" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="groupClass" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="groupNameAttribute" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="groupObjectClass" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="legacyGroupMapping" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="permissionGroupMemberAttribute" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="queueSearchBase" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="readPermissionGroupSearchFilter" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="refreshDisabled" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="refreshInterval" type="{http://www.w3.org/2001/XMLSchema}integer" /&gt;
 *       &lt;attribute name="tempSearchBase" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="topicSearchBase" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="userNameAttribute" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="userObjectClass" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="writePermissionGroupSearchFilter" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}ID" /&gt;
 *       &lt;anyAttribute processContents='lax' namespace='##other'/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "cachedLDAPAuthorizationMap")
public class DtoCachedLDAPAuthorizationMap implements Equals, HashCode, ToString
{

    @XmlAttribute(name = "adminPermissionGroupSearchFilter")
    protected String adminPermissionGroupSearchFilter;
    @XmlAttribute(name = "authentication")
    protected String authentication;
    @XmlAttribute(name = "connectionPassword")
    protected String connectionPassword;
    @XmlAttribute(name = "connectionProtocol")
    protected String connectionProtocol;
    @XmlAttribute(name = "connectionURL")
    protected String connectionURL;
    @XmlAttribute(name = "connectionUsername")
    protected String connectionUsername;
    @XmlAttribute(name = "groupClass")
    protected String groupClass;
    @XmlAttribute(name = "groupNameAttribute")
    protected String groupNameAttribute;
    @XmlAttribute(name = "groupObjectClass")
    protected String groupObjectClass;
    @XmlAttribute(name = "legacyGroupMapping")
    protected Boolean legacyGroupMapping;
    @XmlAttribute(name = "permissionGroupMemberAttribute")
    protected String permissionGroupMemberAttribute;
    @XmlAttribute(name = "queueSearchBase")
    protected String queueSearchBase;
    @XmlAttribute(name = "readPermissionGroupSearchFilter")
    protected String readPermissionGroupSearchFilter;
    @XmlAttribute(name = "refreshDisabled")
    protected Boolean refreshDisabled;
    @XmlAttribute(name = "refreshInterval")
    protected BigInteger refreshInterval;
    @XmlAttribute(name = "tempSearchBase")
    protected String tempSearchBase;
    @XmlAttribute(name = "topicSearchBase")
    protected String topicSearchBase;
    @XmlAttribute(name = "userNameAttribute")
    protected String userNameAttribute;
    @XmlAttribute(name = "userObjectClass")
    protected String userObjectClass;
    @XmlAttribute(name = "writePermissionGroupSearchFilter")
    protected String writePermissionGroupSearchFilter;
    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected String id;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    /**
     * Obtient la valeur de la propriété adminPermissionGroupSearchFilter.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAdminPermissionGroupSearchFilter() {
        return adminPermissionGroupSearchFilter;
    }

    /**
     * Définit la valeur de la propriété adminPermissionGroupSearchFilter.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAdminPermissionGroupSearchFilter(String value) {
        this.adminPermissionGroupSearchFilter = value;
    }

    /**
     * Obtient la valeur de la propriété authentication.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAuthentication() {
        return authentication;
    }

    /**
     * Définit la valeur de la propriété authentication.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAuthentication(String value) {
        this.authentication = value;
    }

    /**
     * Obtient la valeur de la propriété connectionPassword.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getConnectionPassword() {
        return connectionPassword;
    }

    /**
     * Définit la valeur de la propriété connectionPassword.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setConnectionPassword(String value) {
        this.connectionPassword = value;
    }

    /**
     * Obtient la valeur de la propriété connectionProtocol.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getConnectionProtocol() {
        return connectionProtocol;
    }

    /**
     * Définit la valeur de la propriété connectionProtocol.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setConnectionProtocol(String value) {
        this.connectionProtocol = value;
    }

    /**
     * Obtient la valeur de la propriété connectionURL.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getConnectionURL() {
        return connectionURL;
    }

    /**
     * Définit la valeur de la propriété connectionURL.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setConnectionURL(String value) {
        this.connectionURL = value;
    }

    /**
     * Obtient la valeur de la propriété connectionUsername.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getConnectionUsername() {
        return connectionUsername;
    }

    /**
     * Définit la valeur de la propriété connectionUsername.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setConnectionUsername(String value) {
        this.connectionUsername = value;
    }

    /**
     * Obtient la valeur de la propriété groupClass.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGroupClass() {
        return groupClass;
    }

    /**
     * Définit la valeur de la propriété groupClass.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGroupClass(String value) {
        this.groupClass = value;
    }

    /**
     * Obtient la valeur de la propriété groupNameAttribute.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGroupNameAttribute() {
        return groupNameAttribute;
    }

    /**
     * Définit la valeur de la propriété groupNameAttribute.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGroupNameAttribute(String value) {
        this.groupNameAttribute = value;
    }

    /**
     * Obtient la valeur de la propriété groupObjectClass.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGroupObjectClass() {
        return groupObjectClass;
    }

    /**
     * Définit la valeur de la propriété groupObjectClass.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGroupObjectClass(String value) {
        this.groupObjectClass = value;
    }

    /**
     * Obtient la valeur de la propriété legacyGroupMapping.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isLegacyGroupMapping() {
        return legacyGroupMapping;
    }

    /**
     * Définit la valeur de la propriété legacyGroupMapping.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setLegacyGroupMapping(Boolean value) {
        this.legacyGroupMapping = value;
    }

    /**
     * Obtient la valeur de la propriété permissionGroupMemberAttribute.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPermissionGroupMemberAttribute() {
        return permissionGroupMemberAttribute;
    }

    /**
     * Définit la valeur de la propriété permissionGroupMemberAttribute.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPermissionGroupMemberAttribute(String value) {
        this.permissionGroupMemberAttribute = value;
    }

    /**
     * Obtient la valeur de la propriété queueSearchBase.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getQueueSearchBase() {
        return queueSearchBase;
    }

    /**
     * Définit la valeur de la propriété queueSearchBase.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setQueueSearchBase(String value) {
        this.queueSearchBase = value;
    }

    /**
     * Obtient la valeur de la propriété readPermissionGroupSearchFilter.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getReadPermissionGroupSearchFilter() {
        return readPermissionGroupSearchFilter;
    }

    /**
     * Définit la valeur de la propriété readPermissionGroupSearchFilter.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setReadPermissionGroupSearchFilter(String value) {
        this.readPermissionGroupSearchFilter = value;
    }

    /**
     * Obtient la valeur de la propriété refreshDisabled.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isRefreshDisabled() {
        return refreshDisabled;
    }

    /**
     * Définit la valeur de la propriété refreshDisabled.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRefreshDisabled(Boolean value) {
        this.refreshDisabled = value;
    }

    /**
     * Obtient la valeur de la propriété refreshInterval.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getRefreshInterval() {
        return refreshInterval;
    }

    /**
     * Définit la valeur de la propriété refreshInterval.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setRefreshInterval(BigInteger value) {
        this.refreshInterval = value;
    }

    /**
     * Obtient la valeur de la propriété tempSearchBase.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTempSearchBase() {
        return tempSearchBase;
    }

    /**
     * Définit la valeur de la propriété tempSearchBase.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTempSearchBase(String value) {
        this.tempSearchBase = value;
    }

    /**
     * Obtient la valeur de la propriété topicSearchBase.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTopicSearchBase() {
        return topicSearchBase;
    }

    /**
     * Définit la valeur de la propriété topicSearchBase.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTopicSearchBase(String value) {
        this.topicSearchBase = value;
    }

    /**
     * Obtient la valeur de la propriété userNameAttribute.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUserNameAttribute() {
        return userNameAttribute;
    }

    /**
     * Définit la valeur de la propriété userNameAttribute.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUserNameAttribute(String value) {
        this.userNameAttribute = value;
    }

    /**
     * Obtient la valeur de la propriété userObjectClass.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUserObjectClass() {
        return userObjectClass;
    }

    /**
     * Définit la valeur de la propriété userObjectClass.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUserObjectClass(String value) {
        this.userObjectClass = value;
    }

    /**
     * Obtient la valeur de la propriété writePermissionGroupSearchFilter.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getWritePermissionGroupSearchFilter() {
        return writePermissionGroupSearchFilter;
    }

    /**
     * Définit la valeur de la propriété writePermissionGroupSearchFilter.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setWritePermissionGroupSearchFilter(String value) {
        this.writePermissionGroupSearchFilter = value;
    }

    /**
     * Obtient la valeur de la propriété id.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Définit la valeur de la propriété id.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theAdminPermissionGroupSearchFilter;
            theAdminPermissionGroupSearchFilter = this.getAdminPermissionGroupSearchFilter();
            strategy.appendField(locator, this, "adminPermissionGroupSearchFilter", buffer, theAdminPermissionGroupSearchFilter, (this.adminPermissionGroupSearchFilter!= null));
        }
        {
            String theAuthentication;
            theAuthentication = this.getAuthentication();
            strategy.appendField(locator, this, "authentication", buffer, theAuthentication, (this.authentication!= null));
        }
        {
            String theConnectionPassword;
            theConnectionPassword = this.getConnectionPassword();
            strategy.appendField(locator, this, "connectionPassword", buffer, theConnectionPassword, (this.connectionPassword!= null));
        }
        {
            String theConnectionProtocol;
            theConnectionProtocol = this.getConnectionProtocol();
            strategy.appendField(locator, this, "connectionProtocol", buffer, theConnectionProtocol, (this.connectionProtocol!= null));
        }
        {
            String theConnectionURL;
            theConnectionURL = this.getConnectionURL();
            strategy.appendField(locator, this, "connectionURL", buffer, theConnectionURL, (this.connectionURL!= null));
        }
        {
            String theConnectionUsername;
            theConnectionUsername = this.getConnectionUsername();
            strategy.appendField(locator, this, "connectionUsername", buffer, theConnectionUsername, (this.connectionUsername!= null));
        }
        {
            String theGroupClass;
            theGroupClass = this.getGroupClass();
            strategy.appendField(locator, this, "groupClass", buffer, theGroupClass, (this.groupClass!= null));
        }
        {
            String theGroupNameAttribute;
            theGroupNameAttribute = this.getGroupNameAttribute();
            strategy.appendField(locator, this, "groupNameAttribute", buffer, theGroupNameAttribute, (this.groupNameAttribute!= null));
        }
        {
            String theGroupObjectClass;
            theGroupObjectClass = this.getGroupObjectClass();
            strategy.appendField(locator, this, "groupObjectClass", buffer, theGroupObjectClass, (this.groupObjectClass!= null));
        }
        {
            Boolean theLegacyGroupMapping;
            theLegacyGroupMapping = this.isLegacyGroupMapping();
            strategy.appendField(locator, this, "legacyGroupMapping", buffer, theLegacyGroupMapping, (this.legacyGroupMapping!= null));
        }
        {
            String thePermissionGroupMemberAttribute;
            thePermissionGroupMemberAttribute = this.getPermissionGroupMemberAttribute();
            strategy.appendField(locator, this, "permissionGroupMemberAttribute", buffer, thePermissionGroupMemberAttribute, (this.permissionGroupMemberAttribute!= null));
        }
        {
            String theQueueSearchBase;
            theQueueSearchBase = this.getQueueSearchBase();
            strategy.appendField(locator, this, "queueSearchBase", buffer, theQueueSearchBase, (this.queueSearchBase!= null));
        }
        {
            String theReadPermissionGroupSearchFilter;
            theReadPermissionGroupSearchFilter = this.getReadPermissionGroupSearchFilter();
            strategy.appendField(locator, this, "readPermissionGroupSearchFilter", buffer, theReadPermissionGroupSearchFilter, (this.readPermissionGroupSearchFilter!= null));
        }
        {
            Boolean theRefreshDisabled;
            theRefreshDisabled = this.isRefreshDisabled();
            strategy.appendField(locator, this, "refreshDisabled", buffer, theRefreshDisabled, (this.refreshDisabled!= null));
        }
        {
            BigInteger theRefreshInterval;
            theRefreshInterval = this.getRefreshInterval();
            strategy.appendField(locator, this, "refreshInterval", buffer, theRefreshInterval, (this.refreshInterval!= null));
        }
        {
            String theTempSearchBase;
            theTempSearchBase = this.getTempSearchBase();
            strategy.appendField(locator, this, "tempSearchBase", buffer, theTempSearchBase, (this.tempSearchBase!= null));
        }
        {
            String theTopicSearchBase;
            theTopicSearchBase = this.getTopicSearchBase();
            strategy.appendField(locator, this, "topicSearchBase", buffer, theTopicSearchBase, (this.topicSearchBase!= null));
        }
        {
            String theUserNameAttribute;
            theUserNameAttribute = this.getUserNameAttribute();
            strategy.appendField(locator, this, "userNameAttribute", buffer, theUserNameAttribute, (this.userNameAttribute!= null));
        }
        {
            String theUserObjectClass;
            theUserObjectClass = this.getUserObjectClass();
            strategy.appendField(locator, this, "userObjectClass", buffer, theUserObjectClass, (this.userObjectClass!= null));
        }
        {
            String theWritePermissionGroupSearchFilter;
            theWritePermissionGroupSearchFilter = this.getWritePermissionGroupSearchFilter();
            strategy.appendField(locator, this, "writePermissionGroupSearchFilter", buffer, theWritePermissionGroupSearchFilter, (this.writePermissionGroupSearchFilter!= null));
        }
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId, (this.id!= null));
        }
        return buffer;
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theAdminPermissionGroupSearchFilter;
            theAdminPermissionGroupSearchFilter = this.getAdminPermissionGroupSearchFilter();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "adminPermissionGroupSearchFilter", theAdminPermissionGroupSearchFilter), currentHashCode, theAdminPermissionGroupSearchFilter, (this.adminPermissionGroupSearchFilter!= null));
        }
        {
            String theAuthentication;
            theAuthentication = this.getAuthentication();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "authentication", theAuthentication), currentHashCode, theAuthentication, (this.authentication!= null));
        }
        {
            String theConnectionPassword;
            theConnectionPassword = this.getConnectionPassword();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "connectionPassword", theConnectionPassword), currentHashCode, theConnectionPassword, (this.connectionPassword!= null));
        }
        {
            String theConnectionProtocol;
            theConnectionProtocol = this.getConnectionProtocol();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "connectionProtocol", theConnectionProtocol), currentHashCode, theConnectionProtocol, (this.connectionProtocol!= null));
        }
        {
            String theConnectionURL;
            theConnectionURL = this.getConnectionURL();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "connectionURL", theConnectionURL), currentHashCode, theConnectionURL, (this.connectionURL!= null));
        }
        {
            String theConnectionUsername;
            theConnectionUsername = this.getConnectionUsername();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "connectionUsername", theConnectionUsername), currentHashCode, theConnectionUsername, (this.connectionUsername!= null));
        }
        {
            String theGroupClass;
            theGroupClass = this.getGroupClass();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "groupClass", theGroupClass), currentHashCode, theGroupClass, (this.groupClass!= null));
        }
        {
            String theGroupNameAttribute;
            theGroupNameAttribute = this.getGroupNameAttribute();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "groupNameAttribute", theGroupNameAttribute), currentHashCode, theGroupNameAttribute, (this.groupNameAttribute!= null));
        }
        {
            String theGroupObjectClass;
            theGroupObjectClass = this.getGroupObjectClass();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "groupObjectClass", theGroupObjectClass), currentHashCode, theGroupObjectClass, (this.groupObjectClass!= null));
        }
        {
            Boolean theLegacyGroupMapping;
            theLegacyGroupMapping = this.isLegacyGroupMapping();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "legacyGroupMapping", theLegacyGroupMapping), currentHashCode, theLegacyGroupMapping, (this.legacyGroupMapping!= null));
        }
        {
            String thePermissionGroupMemberAttribute;
            thePermissionGroupMemberAttribute = this.getPermissionGroupMemberAttribute();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "permissionGroupMemberAttribute", thePermissionGroupMemberAttribute), currentHashCode, thePermissionGroupMemberAttribute, (this.permissionGroupMemberAttribute!= null));
        }
        {
            String theQueueSearchBase;
            theQueueSearchBase = this.getQueueSearchBase();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "queueSearchBase", theQueueSearchBase), currentHashCode, theQueueSearchBase, (this.queueSearchBase!= null));
        }
        {
            String theReadPermissionGroupSearchFilter;
            theReadPermissionGroupSearchFilter = this.getReadPermissionGroupSearchFilter();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "readPermissionGroupSearchFilter", theReadPermissionGroupSearchFilter), currentHashCode, theReadPermissionGroupSearchFilter, (this.readPermissionGroupSearchFilter!= null));
        }
        {
            Boolean theRefreshDisabled;
            theRefreshDisabled = this.isRefreshDisabled();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "refreshDisabled", theRefreshDisabled), currentHashCode, theRefreshDisabled, (this.refreshDisabled!= null));
        }
        {
            BigInteger theRefreshInterval;
            theRefreshInterval = this.getRefreshInterval();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "refreshInterval", theRefreshInterval), currentHashCode, theRefreshInterval, (this.refreshInterval!= null));
        }
        {
            String theTempSearchBase;
            theTempSearchBase = this.getTempSearchBase();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "tempSearchBase", theTempSearchBase), currentHashCode, theTempSearchBase, (this.tempSearchBase!= null));
        }
        {
            String theTopicSearchBase;
            theTopicSearchBase = this.getTopicSearchBase();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "topicSearchBase", theTopicSearchBase), currentHashCode, theTopicSearchBase, (this.topicSearchBase!= null));
        }
        {
            String theUserNameAttribute;
            theUserNameAttribute = this.getUserNameAttribute();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "userNameAttribute", theUserNameAttribute), currentHashCode, theUserNameAttribute, (this.userNameAttribute!= null));
        }
        {
            String theUserObjectClass;
            theUserObjectClass = this.getUserObjectClass();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "userObjectClass", theUserObjectClass), currentHashCode, theUserObjectClass, (this.userObjectClass!= null));
        }
        {
            String theWritePermissionGroupSearchFilter;
            theWritePermissionGroupSearchFilter = this.getWritePermissionGroupSearchFilter();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "writePermissionGroupSearchFilter", theWritePermissionGroupSearchFilter), currentHashCode, theWritePermissionGroupSearchFilter, (this.writePermissionGroupSearchFilter!= null));
        }
        {
            String theId;
            theId = this.getId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "id", theId), currentHashCode, theId, (this.id!= null));
        }
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, strategy);
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final DtoCachedLDAPAuthorizationMap that = ((DtoCachedLDAPAuthorizationMap) object);
        {
            String lhsAdminPermissionGroupSearchFilter;
            lhsAdminPermissionGroupSearchFilter = this.getAdminPermissionGroupSearchFilter();
            String rhsAdminPermissionGroupSearchFilter;
            rhsAdminPermissionGroupSearchFilter = that.getAdminPermissionGroupSearchFilter();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "adminPermissionGroupSearchFilter", lhsAdminPermissionGroupSearchFilter), LocatorUtils.property(thatLocator, "adminPermissionGroupSearchFilter", rhsAdminPermissionGroupSearchFilter), lhsAdminPermissionGroupSearchFilter, rhsAdminPermissionGroupSearchFilter, (this.adminPermissionGroupSearchFilter!= null), (that.adminPermissionGroupSearchFilter!= null))) {
                return false;
            }
        }
        {
            String lhsAuthentication;
            lhsAuthentication = this.getAuthentication();
            String rhsAuthentication;
            rhsAuthentication = that.getAuthentication();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "authentication", lhsAuthentication), LocatorUtils.property(thatLocator, "authentication", rhsAuthentication), lhsAuthentication, rhsAuthentication, (this.authentication!= null), (that.authentication!= null))) {
                return false;
            }
        }
        {
            String lhsConnectionPassword;
            lhsConnectionPassword = this.getConnectionPassword();
            String rhsConnectionPassword;
            rhsConnectionPassword = that.getConnectionPassword();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "connectionPassword", lhsConnectionPassword), LocatorUtils.property(thatLocator, "connectionPassword", rhsConnectionPassword), lhsConnectionPassword, rhsConnectionPassword, (this.connectionPassword!= null), (that.connectionPassword!= null))) {
                return false;
            }
        }
        {
            String lhsConnectionProtocol;
            lhsConnectionProtocol = this.getConnectionProtocol();
            String rhsConnectionProtocol;
            rhsConnectionProtocol = that.getConnectionProtocol();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "connectionProtocol", lhsConnectionProtocol), LocatorUtils.property(thatLocator, "connectionProtocol", rhsConnectionProtocol), lhsConnectionProtocol, rhsConnectionProtocol, (this.connectionProtocol!= null), (that.connectionProtocol!= null))) {
                return false;
            }
        }
        {
            String lhsConnectionURL;
            lhsConnectionURL = this.getConnectionURL();
            String rhsConnectionURL;
            rhsConnectionURL = that.getConnectionURL();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "connectionURL", lhsConnectionURL), LocatorUtils.property(thatLocator, "connectionURL", rhsConnectionURL), lhsConnectionURL, rhsConnectionURL, (this.connectionURL!= null), (that.connectionURL!= null))) {
                return false;
            }
        }
        {
            String lhsConnectionUsername;
            lhsConnectionUsername = this.getConnectionUsername();
            String rhsConnectionUsername;
            rhsConnectionUsername = that.getConnectionUsername();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "connectionUsername", lhsConnectionUsername), LocatorUtils.property(thatLocator, "connectionUsername", rhsConnectionUsername), lhsConnectionUsername, rhsConnectionUsername, (this.connectionUsername!= null), (that.connectionUsername!= null))) {
                return false;
            }
        }
        {
            String lhsGroupClass;
            lhsGroupClass = this.getGroupClass();
            String rhsGroupClass;
            rhsGroupClass = that.getGroupClass();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "groupClass", lhsGroupClass), LocatorUtils.property(thatLocator, "groupClass", rhsGroupClass), lhsGroupClass, rhsGroupClass, (this.groupClass!= null), (that.groupClass!= null))) {
                return false;
            }
        }
        {
            String lhsGroupNameAttribute;
            lhsGroupNameAttribute = this.getGroupNameAttribute();
            String rhsGroupNameAttribute;
            rhsGroupNameAttribute = that.getGroupNameAttribute();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "groupNameAttribute", lhsGroupNameAttribute), LocatorUtils.property(thatLocator, "groupNameAttribute", rhsGroupNameAttribute), lhsGroupNameAttribute, rhsGroupNameAttribute, (this.groupNameAttribute!= null), (that.groupNameAttribute!= null))) {
                return false;
            }
        }
        {
            String lhsGroupObjectClass;
            lhsGroupObjectClass = this.getGroupObjectClass();
            String rhsGroupObjectClass;
            rhsGroupObjectClass = that.getGroupObjectClass();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "groupObjectClass", lhsGroupObjectClass), LocatorUtils.property(thatLocator, "groupObjectClass", rhsGroupObjectClass), lhsGroupObjectClass, rhsGroupObjectClass, (this.groupObjectClass!= null), (that.groupObjectClass!= null))) {
                return false;
            }
        }
        {
            Boolean lhsLegacyGroupMapping;
            lhsLegacyGroupMapping = this.isLegacyGroupMapping();
            Boolean rhsLegacyGroupMapping;
            rhsLegacyGroupMapping = that.isLegacyGroupMapping();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "legacyGroupMapping", lhsLegacyGroupMapping), LocatorUtils.property(thatLocator, "legacyGroupMapping", rhsLegacyGroupMapping), lhsLegacyGroupMapping, rhsLegacyGroupMapping, (this.legacyGroupMapping!= null), (that.legacyGroupMapping!= null))) {
                return false;
            }
        }
        {
            String lhsPermissionGroupMemberAttribute;
            lhsPermissionGroupMemberAttribute = this.getPermissionGroupMemberAttribute();
            String rhsPermissionGroupMemberAttribute;
            rhsPermissionGroupMemberAttribute = that.getPermissionGroupMemberAttribute();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "permissionGroupMemberAttribute", lhsPermissionGroupMemberAttribute), LocatorUtils.property(thatLocator, "permissionGroupMemberAttribute", rhsPermissionGroupMemberAttribute), lhsPermissionGroupMemberAttribute, rhsPermissionGroupMemberAttribute, (this.permissionGroupMemberAttribute!= null), (that.permissionGroupMemberAttribute!= null))) {
                return false;
            }
        }
        {
            String lhsQueueSearchBase;
            lhsQueueSearchBase = this.getQueueSearchBase();
            String rhsQueueSearchBase;
            rhsQueueSearchBase = that.getQueueSearchBase();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "queueSearchBase", lhsQueueSearchBase), LocatorUtils.property(thatLocator, "queueSearchBase", rhsQueueSearchBase), lhsQueueSearchBase, rhsQueueSearchBase, (this.queueSearchBase!= null), (that.queueSearchBase!= null))) {
                return false;
            }
        }
        {
            String lhsReadPermissionGroupSearchFilter;
            lhsReadPermissionGroupSearchFilter = this.getReadPermissionGroupSearchFilter();
            String rhsReadPermissionGroupSearchFilter;
            rhsReadPermissionGroupSearchFilter = that.getReadPermissionGroupSearchFilter();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "readPermissionGroupSearchFilter", lhsReadPermissionGroupSearchFilter), LocatorUtils.property(thatLocator, "readPermissionGroupSearchFilter", rhsReadPermissionGroupSearchFilter), lhsReadPermissionGroupSearchFilter, rhsReadPermissionGroupSearchFilter, (this.readPermissionGroupSearchFilter!= null), (that.readPermissionGroupSearchFilter!= null))) {
                return false;
            }
        }
        {
            Boolean lhsRefreshDisabled;
            lhsRefreshDisabled = this.isRefreshDisabled();
            Boolean rhsRefreshDisabled;
            rhsRefreshDisabled = that.isRefreshDisabled();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "refreshDisabled", lhsRefreshDisabled), LocatorUtils.property(thatLocator, "refreshDisabled", rhsRefreshDisabled), lhsRefreshDisabled, rhsRefreshDisabled, (this.refreshDisabled!= null), (that.refreshDisabled!= null))) {
                return false;
            }
        }
        {
            BigInteger lhsRefreshInterval;
            lhsRefreshInterval = this.getRefreshInterval();
            BigInteger rhsRefreshInterval;
            rhsRefreshInterval = that.getRefreshInterval();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "refreshInterval", lhsRefreshInterval), LocatorUtils.property(thatLocator, "refreshInterval", rhsRefreshInterval), lhsRefreshInterval, rhsRefreshInterval, (this.refreshInterval!= null), (that.refreshInterval!= null))) {
                return false;
            }
        }
        {
            String lhsTempSearchBase;
            lhsTempSearchBase = this.getTempSearchBase();
            String rhsTempSearchBase;
            rhsTempSearchBase = that.getTempSearchBase();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "tempSearchBase", lhsTempSearchBase), LocatorUtils.property(thatLocator, "tempSearchBase", rhsTempSearchBase), lhsTempSearchBase, rhsTempSearchBase, (this.tempSearchBase!= null), (that.tempSearchBase!= null))) {
                return false;
            }
        }
        {
            String lhsTopicSearchBase;
            lhsTopicSearchBase = this.getTopicSearchBase();
            String rhsTopicSearchBase;
            rhsTopicSearchBase = that.getTopicSearchBase();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "topicSearchBase", lhsTopicSearchBase), LocatorUtils.property(thatLocator, "topicSearchBase", rhsTopicSearchBase), lhsTopicSearchBase, rhsTopicSearchBase, (this.topicSearchBase!= null), (that.topicSearchBase!= null))) {
                return false;
            }
        }
        {
            String lhsUserNameAttribute;
            lhsUserNameAttribute = this.getUserNameAttribute();
            String rhsUserNameAttribute;
            rhsUserNameAttribute = that.getUserNameAttribute();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "userNameAttribute", lhsUserNameAttribute), LocatorUtils.property(thatLocator, "userNameAttribute", rhsUserNameAttribute), lhsUserNameAttribute, rhsUserNameAttribute, (this.userNameAttribute!= null), (that.userNameAttribute!= null))) {
                return false;
            }
        }
        {
            String lhsUserObjectClass;
            lhsUserObjectClass = this.getUserObjectClass();
            String rhsUserObjectClass;
            rhsUserObjectClass = that.getUserObjectClass();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "userObjectClass", lhsUserObjectClass), LocatorUtils.property(thatLocator, "userObjectClass", rhsUserObjectClass), lhsUserObjectClass, rhsUserObjectClass, (this.userObjectClass!= null), (that.userObjectClass!= null))) {
                return false;
            }
        }
        {
            String lhsWritePermissionGroupSearchFilter;
            lhsWritePermissionGroupSearchFilter = this.getWritePermissionGroupSearchFilter();
            String rhsWritePermissionGroupSearchFilter;
            rhsWritePermissionGroupSearchFilter = that.getWritePermissionGroupSearchFilter();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "writePermissionGroupSearchFilter", lhsWritePermissionGroupSearchFilter), LocatorUtils.property(thatLocator, "writePermissionGroupSearchFilter", rhsWritePermissionGroupSearchFilter), lhsWritePermissionGroupSearchFilter, rhsWritePermissionGroupSearchFilter, (this.writePermissionGroupSearchFilter!= null), (that.writePermissionGroupSearchFilter!= null))) {
                return false;
            }
        }
        {
            String lhsId;
            lhsId = this.getId();
            String rhsId;
            rhsId = that.getId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "id", lhsId), LocatorUtils.property(thatLocator, "id", rhsId), lhsId, rhsId, (this.id!= null), (that.id!= null))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        final EqualsStrategy strategy = new ElementAwareEqualsStrategy();
        return equals(null, null, object, strategy);
    }

}
