/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util.oxm;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.util.oxm.AbstractXMLMessageTransformer;

public class XStreamMessageTransformer
extends AbstractXMLMessageTransformer {
    private XStream xStream;
    private HierarchicalStreamDriver streamDriver;

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    public HierarchicalStreamDriver getStreamDriver() {
        return this.streamDriver;
    }

    public void setStreamDriver(HierarchicalStreamDriver streamDriver) {
        this.streamDriver = streamDriver;
    }

    protected XStream createXStream() {
        return new XStream();
    }

    @Override
    protected String marshall(Session session, ObjectMessage objectMessage) throws JMSException {
        Serializable object = objectMessage.getObject();
        StringWriter buffer = new StringWriter();
        Object out = this.streamDriver != null ? this.streamDriver.createWriter((Writer)buffer) : new PrettyPrintWriter((Writer)buffer);
        this.getXStream().marshal((Object)object, out);
        return buffer.toString();
    }

    @Override
    protected Object unmarshall(Session session, TextMessage textMessage) throws JMSException {
        Object in = this.streamDriver != null ? this.streamDriver.createReader((Reader)new StringReader(textMessage.getText())) : new XppReader((Reader)new StringReader(textMessage.getText()));
        return this.getXStream().unmarshal(in);
    }
}

