/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.net.InetSocketAddress;
import java.net.URI;
import javax.servlet.Servlet;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.transport.TransportServerSupport;
import org.apache.activemq.transport.ws.StompServlet;
import org.apache.activemq.util.ServiceStopper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WSTransportServer
extends TransportServerSupport {
    private URI bindAddress;
    private Server server;
    private Connector connector;

    public WSTransportServer(URI location) {
        super(location);
        this.bindAddress = location;
    }

    protected void doStart() throws Exception {
        this.server = new Server();
        if (this.connector == null) {
            this.connector = new SelectChannelConnector();
        }
        this.connector.setHost(this.bindAddress.getHost());
        this.connector.setPort(this.bindAddress.getPort());
        this.connector.setServer(this.server);
        this.server.addConnector(this.connector);
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 0);
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)new StompServlet());
        contextHandler.addServlet(holder, "/");
        contextHandler.setAttribute("acceptListener", (Object)this.getAcceptListener());
        this.server.start();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        Server temp = this.server;
        this.server = null;
        if (temp != null) {
            temp.stop();
        }
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }
}

