/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.UTFDataFormatException;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class DataByteArrayInputStreamTest {
    @Test
    public void testOneByteCharacters() throws Exception {
        this.testCodePointRange(0, 127);
    }

    @Test
    public void testTwoBytesCharacters() throws Exception {
        this.testCodePointRange(128, 2047);
    }

    @Test
    public void testThreeBytesCharacters() throws Exception {
        this.testCodePointRange(2048, 65535);
    }

    @Test
    public void testFourBytesCharacters() throws Exception {
        this.testCodePointRange(65536, 0x10FFFF);
    }

    @Test
    public void testFourBytesCharacterEncodedAsBytes() throws Exception {
        this.testInvalidCharacterBytes(new byte[]{-16, -128, -128, -128}, 4);
        this.testInvalidCharacterBytes(new byte[]{-9, -65, -65, -65}, 4);
    }

    private void testCodePointRange(int from, int to) throws Exception {
        StringBuilder accumulator = new StringBuilder();
        for (int codePoint = from; codePoint <= to; ++codePoint) {
            String val = String.valueOf(Character.toChars(codePoint));
            accumulator.append(val);
            this.doMarshallUnMarshallValidation(val);
        }
        if (accumulator.length() > 20000) {
            this.doMarshallUnMarshallValidation(accumulator.substring(accumulator.length() - 20000));
        } else {
            this.doMarshallUnMarshallValidation(accumulator.toString());
        }
    }

    private void doMarshallUnMarshallValidation(String value) throws Exception {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream();
        out.writeUTF(value);
        out.close();
        DataByteArrayInputStream in = new DataByteArrayInputStream(out.getData());
        String readBack = in.readUTF();
        Assert.assertEquals((Object)value, (Object)readBack);
    }

    @Test
    public void testTwoBytesOutOfRangeCharacter() throws Exception {
        this.testInvalidCharacterBytes(new byte[]{-64, 127}, 2);
        this.testInvalidCharacterBytes(new byte[]{-33, -64}, 2);
    }

    @Test
    public void testThreeBytesOutOfRangeCharacter() throws Exception {
        this.testInvalidCharacterBytes(new byte[]{-32, -128, 127}, 3);
        this.testInvalidCharacterBytes(new byte[]{-17, -65, -64}, 3);
    }

    @Test
    public void testFourBytesOutOfRangeCharacter() throws Exception {
        this.testInvalidCharacterBytes(new byte[]{-16, -128, -128, 127}, 4);
        this.testInvalidCharacterBytes(new byte[]{-9, -65, -65, -64}, 4);
    }

    private void testInvalidCharacterBytes(byte[] bytes, int encodedSize) throws Exception {
        String val = new String(bytes);
        this.doMarshallUnMarshallValidation(val);
        DataByteArrayOutputStream out = new DataByteArrayOutputStream();
        out.writeShort(encodedSize);
        out.write(bytes);
        out.close();
        DataByteArrayInputStream in = new DataByteArrayInputStream(out.getData());
        Assert.assertThrows(UTFDataFormatException.class, () -> in.readUTF());
    }

    @Test
    public void testReadLong() throws Exception {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream(8);
        out.writeLong(Long.MAX_VALUE);
        out.close();
        DataByteArrayInputStream in = new DataByteArrayInputStream(out.getData());
        long readBack = in.readLong();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)readBack);
    }
}

