/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.openwire.DataStreamMarshaller;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v10.ExceptionResponseMarshaller;
import org.apache.activemq.util.ByteSequence;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OpenWireValidationTest {
    protected final int version;
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    @Before
    public void before() {
        initialized.set(false);
    }

    @Parameterized.Parameters(name="version={0}")
    public static Collection<Object[]> data() {
        List<Integer> versions = List.of(Integer.valueOf(1), Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12));
        ArrayList<Object[]> versionObjs = new ArrayList<Object[]>();
        for (int i : versions) {
            versionObjs.add(new Object[]{i});
        }
        Assert.assertTrue((String)"List of Openwire versions does not include latest version", (boolean)versions.contains(12));
        return versionObjs;
    }

    public OpenWireValidationTest(int version) {
        this.version = version;
    }

    @Test
    public void testOpenwireThrowableValidation() throws Exception {
        OpenWireFormat format = new OpenWireFormat();
        Class<?> marshallerFactory = this.getMarshallerFactory();
        Method createMarshallerMap = marshallerFactory.getMethod("createMarshallerMap", OpenWireFormat.class);
        DataStreamMarshaller[] map = (DataStreamMarshaller[])createMarshallerMap.invoke(marshallerFactory, format);
        map[31] = this.getExceptionMarshaller();
        format.setVersion(this.version);
        ExceptionResponse r = new ExceptionResponse();
        r.setException((Throwable)new Exception());
        ByteSequence bss = format.marshal((Object)r);
        ExceptionResponse response = (ExceptionResponse)format.unmarshal(bss);
        Assert.assertTrue((boolean)(response.getException() instanceof IllegalArgumentException));
        Assert.assertTrue((boolean)response.getException().getMessage().contains("is not assignable to Throwable"));
        Assert.assertFalse((boolean)initialized.get());
    }

    private Class<?> getMarshallerFactory() throws ClassNotFoundException {
        return Class.forName("org.apache.activemq.openwire.v" + this.version + ".MarshallerFactory");
    }

    protected DataStreamMarshaller getExceptionMarshaller() {
        switch (this.version) {
            case 12: {
                return new org.apache.activemq.openwire.v12.ExceptionResponseMarshaller(){

                    protected void looseMarshalThrowable(OpenWireFormat wireFormat, Throwable o, DataOutput dataOut) throws IOException {
                        dataOut.writeBoolean(o != null);
                        this.looseMarshalString(NotAThrowable.class.getName(), dataOut);
                        this.looseMarshalString(o.getMessage(), dataOut);
                    }
                };
            }
            case 11: {
                return new org.apache.activemq.openwire.v11.ExceptionResponseMarshaller(){

                    protected void looseMarshalThrowable(OpenWireFormat wireFormat, Throwable o, DataOutput dataOut) throws IOException {
                        dataOut.writeBoolean(o != null);
                        this.looseMarshalString(NotAThrowable.class.getName(), dataOut);
                        this.looseMarshalString(o.getMessage(), dataOut);
                    }
                };
            }
            case 10: {
                return new ExceptionResponseMarshaller(){

                    protected void looseMarshalThrowable(OpenWireFormat wireFormat, Throwable o, DataOutput dataOut) throws IOException {
                        dataOut.writeBoolean(o != null);
                        this.looseMarshalString(NotAThrowable.class.getName(), dataOut);
                        this.looseMarshalString(o.getMessage(), dataOut);
                    }
                };
            }
            case 9: {
                return new org.apache.activemq.openwire.v9.ExceptionResponseMarshaller(){

                    protected void looseMarshalThrowable(OpenWireFormat wireFormat, Throwable o, DataOutput dataOut) throws IOException {
                        dataOut.writeBoolean(o != null);
                        this.looseMarshalString(NotAThrowable.class.getName(), dataOut);
                        this.looseMarshalString(o.getMessage(), dataOut);
                    }
                };
            }
            case 1: {
                return new org.apache.activemq.openwire.v1.ExceptionResponseMarshaller(){

                    protected void looseMarshalThrowable(OpenWireFormat wireFormat, Throwable o, DataOutput dataOut) throws IOException {
                        dataOut.writeBoolean(o != null);
                        this.looseMarshalString(NotAThrowable.class.getName(), dataOut);
                        this.looseMarshalString(o.getMessage(), dataOut);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Unknown openwire version of " + this.version);
    }

    static class NotAThrowable {
        private String message;

        public NotAThrowable(String message) {
            this.message = message;
        }

        public NotAThrowable() {
        }

        static {
            initialized.set(true);
        }
    }
}

