/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ActiveMQMessageIsMarshalledTest {
    private final MessageType messageType;

    @Parameterized.Parameters(name="messageType={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MessageType.BYTES}, {MessageType.MAP}, {MessageType.TEXT}, {MessageType.OBJECT}, {MessageType.STREAM}, {MessageType.MESSAGE});
    }

    public ActiveMQMessageIsMarshalledTest(MessageType messageType) {
        this.messageType = messageType;
    }

    @Test
    public void testIsMarshalledWithBodyAndProperties() throws Exception {
        ActiveMQMessage message = this.getMessage(true, true);
        this.assertIsMarshalled(message, true, true);
    }

    @Test
    public void testIsMarshalledWithPropertyEmptyBody() throws Exception {
        ActiveMQMessage message = this.getMessage(false, true);
        this.assertIsMarshalled(message, false, true);
    }

    @Test
    public void testIsMarshalledWithBodyEmptyProperties() throws Exception {
        ActiveMQMessage message = this.getMessage(true, false);
        this.assertIsMarshalled(message, true, false);
    }

    @Test
    public void testIsMarshalledWithEmptyBodyEmptyProperties() throws Exception {
        ActiveMQMessage message = this.getMessage(false, false);
        Assert.assertTrue((boolean)message.isMarshalled());
    }

    private ActiveMQMessage getMessage(boolean includeBody, boolean includeProperties) throws Exception {
        if (MessageType.BYTES == this.messageType) {
            return this.getBytesMessage(includeBody, includeProperties);
        }
        if (MessageType.TEXT == this.messageType) {
            return this.getTextMessage(includeBody, includeProperties);
        }
        if (MessageType.MAP == this.messageType) {
            return this.getMapMessage(includeBody, includeProperties);
        }
        if (MessageType.OBJECT == this.messageType) {
            return this.getObjectMessage(includeBody, includeProperties);
        }
        if (MessageType.STREAM == this.messageType) {
            return this.getStreamMessage(includeBody, includeProperties);
        }
        if (MessageType.MESSAGE == this.messageType) {
            return this.getActiveMQMessage(includeBody, includeProperties);
        }
        return null;
    }

    private ActiveMQBytesMessage getBytesMessage(boolean includeBody, boolean includeProperties) throws Exception {
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        if (includeBody) {
            message.writeBytes(new byte[10]);
        }
        if (includeProperties) {
            message.setProperty("test", (Object)"test");
        }
        return message;
    }

    private ActiveMQMapMessage getMapMessage(boolean includeBody, boolean includeProperties) throws Exception {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        if (includeBody) {
            message.setString("stringbody", "stringbody");
        }
        if (includeProperties) {
            message.setProperty("test", (Object)"test");
        }
        return message;
    }

    private ActiveMQTextMessage getTextMessage(boolean includeBody, boolean includeProperties) throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        if (includeBody) {
            message.setText("test");
        }
        if (includeProperties) {
            message.setProperty("test", (Object)"test");
        }
        return message;
    }

    private ActiveMQObjectMessage getObjectMessage(boolean includeBody, boolean includeProperties) throws Exception {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        ActiveMQConnection con = ActiveMQConnection.makeConnection();
        con.setObjectMessageSerializationDefered(true);
        message.setConnection(con);
        if (includeBody) {
            message.setObject((Serializable)((Object)"test"));
        }
        if (includeProperties) {
            message.setProperty("test", (Object)"test");
        }
        return message;
    }

    private ActiveMQStreamMessage getStreamMessage(boolean includeBody, boolean includeProperties) throws Exception {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        if (includeBody) {
            message.writeBytes(new byte[10]);
        }
        if (includeProperties) {
            message.setProperty("test", (Object)"test");
        }
        return message;
    }

    private ActiveMQMessage getActiveMQMessage(boolean includeBody, boolean includeProperties) throws Exception {
        ActiveMQMessage message = new ActiveMQMessage();
        if (includeBody) {
            message.setContent(new ByteSequence(new byte[10]));
        }
        if (includeProperties) {
            message.setProperty("test", (Object)"test");
        }
        return message;
    }

    private void assertIsMarshalled(ActiveMQMessage message, boolean includeBody, boolean includeProperties) throws Exception {
        if (ActiveMQMessage.class.equals(message.getClass())) {
            Assert.assertFalse((message.isMarshalled() == includeProperties ? 1 : 0) != 0);
        } else {
            Assert.assertFalse((boolean)message.isMarshalled());
            message.onSend();
            message.beforeMarshall((WireFormat)new OpenWireFormat());
            Assert.assertTrue((boolean)message.isMarshalled());
            Assert.assertTrue((message.getMarshalledProperties() != null == includeProperties ? 1 : 0) != 0);
            Assert.assertTrue((message.getContent() != null == includeBody ? 1 : 0) != 0);
        }
    }

    protected static enum MessageType {
        BYTES,
        MAP,
        TEXT,
        OBJECT,
        STREAM,
        MESSAGE;

    }
}

