/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.IOException;
import java.net.URL;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.DefaultBlobDownloadStrategy;
import org.apache.activemq.blob.FileSystemBlobStrategy;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.junit.Assert;
import org.junit.Test;

public class DownloadStrategyTest {
    @Test
    public void testDefaultBlobDownloadStrategy() throws Exception {
        BlobTransferPolicy transferPolicy = new BlobTransferPolicy();
        DefaultBlobDownloadStrategy downloadStrategy = new DefaultBlobDownloadStrategy(transferPolicy);
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        message.setURL(new URL("https://www.apache.org"));
        try {
            downloadStrategy.getInputStream(message);
            Assert.fail((String)"Failure expected on an incorrect blob message URL");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        transferPolicy.setUploadUrl("https://www.apache.org");
        downloadStrategy.getInputStream(message).close();
    }

    @Test
    public void testFileBlobDownloadStrategy() throws Exception {
        BlobTransferPolicy transferPolicy = new BlobTransferPolicy();
        transferPolicy.setUploadUrl("file:/tmp/xyz");
        FileSystemBlobStrategy downloadStrategy = new FileSystemBlobStrategy(transferPolicy);
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        message.setURL(new URL("https://www.apache.org"));
        try {
            downloadStrategy.getInputStream(message);
            Assert.fail((String)"Failure expected on an incorrect blob message URL");
        }
        catch (IOException ex) {
            Assert.assertEquals((Object)"The message URL protocol is incorrect", (Object)ex.getMessage());
        }
    }
}

