/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.IOException;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.util.IOExceptionSupport;

public class OpenWireUtil {
    static final String jmsPackageToReplace = "javax.jms";
    static final String jmsPackageToUse = "jakarta.jms";

    public static void validateIsThrowable(Class<?> clazz) {
        if (!Throwable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is not assignable to Throwable");
        }
    }

    public static void validateBufferSize(OpenWireFormat wireFormat, int size) throws IOException {
        OpenWireUtil.validateLessThanFrameSize(wireFormat, size);
        if (wireFormat.isMaxFrameSizeEnabled() && (long)size > wireFormat.getMaxFrameSize()) {
            throw IOExceptionSupport.createFrameSizeException(size, wireFormat.getMaxFrameSize());
        }
    }

    private static void validateLessThanFrameSize(OpenWireFormat wireFormat, int size) throws IOException {
        OpenWireFormat.MarshallingContext context = wireFormat.getMarshallingContext();
        if (context == null || context.getFrameSize() < 0) {
            return;
        }
        context.increment(size);
        if (context.getEstimatedAllocated() > context.getFrameSize()) {
            throw IOExceptionSupport.createFrameSizeBufferException(context.getEstimatedAllocated(), context.getFrameSize());
        }
    }

    public static String convertJmsPackage(String className) {
        if (className != null && className.startsWith(jmsPackageToReplace)) {
            return className.replace(jmsPackageToReplace, jmsPackageToUse);
        }
        return className;
    }
}

