/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AutoFailTestSupport
extends TestCase {
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_ERROR = 1;
    private static final Logger LOG = LoggerFactory.getLogger(AutoFailTestSupport.class);
    private long maxTestTime = 300000L;
    private Thread autoFailThread;
    private boolean verbose = true;
    private boolean useAutoFail;
    private AtomicBoolean isTestSuccess;

    protected void setUp() throws Exception {
        if (this.isAutoFail()) {
            this.startAutoFailThread();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.stopAutoFailThread();
    }

    public void startAutoFailThread() {
        this.setAutoFail(true);
        this.isTestSuccess = new AtomicBoolean(false);
        this.autoFailThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(AutoFailTestSupport.this.getMaxTestTime());
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    if (!AutoFailTestSupport.this.isTestSuccess.get()) {
                        LOG.error("Test case has exceeded the maximum allotted time to run of: " + AutoFailTestSupport.this.getMaxTestTime() + " ms.");
                        AutoFailTestSupport.dumpAllThreads(AutoFailTestSupport.this.getName());
                        if (System.getProperty("org.apache.activemq.AutoFailTestSupport.disableSystemExit") == null) {
                            System.exit(1);
                        } else {
                            LOG.error("No system.exit as it kills surefire - forkedProcessTimeoutInSeconds (surefire.timeout) will kick in eventually see pom.xml surefire plugin config");
                        }
                    }
                }
            }
        }, "AutoFailThread");
        if (this.verbose) {
            LOG.info("Starting auto fail thread...");
        }
        LOG.info("Starting auto fail thread...");
        this.autoFailThread.start();
    }

    public void stopAutoFailThread() {
        if (this.isAutoFail() && this.autoFailThread != null && this.autoFailThread.isAlive()) {
            this.isTestSuccess.set(true);
            if (this.verbose) {
                LOG.info("Stopping auto fail thread...");
            }
            LOG.info("Stopping auto fail thread...");
            this.autoFailThread.interrupt();
        }
    }

    public void setAutoFail(boolean val) {
        this.useAutoFail = val;
    }

    public boolean isAutoFail() {
        return this.useAutoFail;
    }

    public void setMaxTestTime(long val) {
        this.maxTestTime = val;
    }

    public long getMaxTestTime() {
        return this.maxTestTime;
    }

    public static void dumpAllThreads(String prefix) {
        Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> stackEntry : stacks.entrySet()) {
            System.err.println(prefix + " " + stackEntry.getKey());
            for (StackTraceElement element : stackEntry.getValue()) {
                System.err.println("     " + element);
            }
        }
    }
}

