/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.policy.MessageEvictionStrategySupport;

public class UniquePropertyMessageEvictionStrategy
extends MessageEvictionStrategySupport {
    protected String propertyName;

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public MessageReference[] evictMessages(LinkedList messages) throws IOException {
        LinkedList messageReferences = new LinkedList(messages);
        HashMap<Object, MessageReference> pivots = new HashMap<Object, MessageReference>();
        for (MessageReference reference : messageReferences) {
            if (this.propertyName == null || reference.getMessage().getProperty(this.propertyName) == null) continue;
            Object key = reference.getMessage().getProperty(this.propertyName);
            if (pivots.containsKey(key)) {
                MessageReference pivot = (MessageReference)pivots.get(key);
                if (reference.getMessage().getTimestamp() <= pivot.getMessage().getTimestamp()) continue;
                pivots.put(key, reference);
                continue;
            }
            pivots.put(key, reference);
        }
        if (pivots.isEmpty() || pivots.values().size() == messageReferences.size()) {
            return new MessageReference[]{(MessageReference)messages.removeFirst()};
        }
        messages.removeIf(message -> !pivots.containsValue(message));
        messageReferences.removeAll(pivots.values());
        return messageReferences.toArray(new MessageReference[0]);
    }
}

