/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationMethod;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.Nullable;

final class BeanMethod
extends ConfigurationMethod {
    BeanMethod(MethodMetadata metadata, ConfigurationClass configurationClass) {
        super(metadata, configurationClass);
    }

    @Override
    public void validate(ProblemReporter problemReporter) {
        if ("void".equals(this.getMetadata().getReturnTypeName())) {
            problemReporter.error(new VoidDeclaredMethodError());
        }
        if (this.getMetadata().isStatic()) {
            return;
        }
        if (this.configurationClass.getMetadata().isAnnotated(Configuration.class.getName()) && !this.getMetadata().isOverridable()) {
            problemReporter.error(new NonOverridableMethodError());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof BeanMethod)) return false;
        BeanMethod that = (BeanMethod)other;
        if (!this.metadata.equals(that.metadata)) return false;
        return true;
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public String toString() {
        return "BeanMethod: " + String.valueOf(this.metadata);
    }

    private class VoidDeclaredMethodError
    extends Problem {
        VoidDeclaredMethodError() {
            super("@Bean method '%s' must not be declared as void; change the method's return type or its annotation.".formatted(BeanMethod.this.getMetadata().getMethodName()), BeanMethod.this.getResourceLocation());
        }
    }

    private class NonOverridableMethodError
    extends Problem {
        NonOverridableMethodError() {
            super("@Bean method '%s' must not be private or final; change the method's modifiers to continue.".formatted(BeanMethod.this.getMetadata().getMethodName()), BeanMethod.this.getResourceLocation());
        }
    }
}

