/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import com.google.common.base.Charsets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.CompactionDriver;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.zookeeper.KeeperException;

public class CompactRange
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;
    private byte[] startRow;
    private byte[] endRow;
    private byte[] iterators;
    private String namespaceId;

    public CompactRange(String tableId, byte[] startRow, byte[] endRow, List<IteratorSetting> iterators) throws ThriftTableOperationException {
        this.tableId = tableId;
        this.startRow = startRow.length == 0 ? null : startRow;
        this.endRow = endRow.length == 0 ? null : endRow;
        Instance inst = HdfsZooInstance.getInstance();
        this.namespaceId = Tables.getNamespaceId((Instance)inst, (String)tableId);
        if (iterators.size() > 0) {
            this.iterators = WritableUtils.toByteArray((Writable[])new Writable[]{new CompactionIterators(this.startRow, this.endRow, iterators)});
        } else {
            iterators = null;
        }
        if (this.startRow != null && this.endRow != null && new Text(startRow).compareTo((BinaryComparable)new Text(endRow)) >= 0) {
            throw new ThriftTableOperationException(tableId, null, TableOperation.COMPACT, TableOperationExceptionType.BAD_RANGE, "start row must be less than end row");
        }
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveNamespace(this.namespaceId, tid, false, true, TableOperation.COMPACT) + Utils.reserveTable(this.tableId, tid, false, true, TableOperation.COMPACT);
    }

    @Override
    public Repo<Master> call(final long tid, Master environment) throws Exception {
        String zTablePath = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/tables" + "/" + this.tableId + "/compact-id";
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            byte[] cid = zoo.mutate(zTablePath, null, null, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] currentValue) throws Exception {
                    String cvs = new String(currentValue, Charsets.UTF_8);
                    String[] tokens = cvs.split(",");
                    long flushID = Long.parseLong(tokens[0]);
                    ++flushID;
                    String txidString = String.format("%016x", tid);
                    for (int i = 1; i < tokens.length; ++i) {
                        if (tokens[i].startsWith(txidString)) continue;
                        throw new ThriftTableOperationException(CompactRange.this.tableId, null, TableOperation.COMPACT, TableOperationExceptionType.OTHER, "Another compaction with iterators is running");
                    }
                    StringBuilder encodedIterators = new StringBuilder();
                    if (CompactRange.this.iterators != null) {
                        Hex hex = new Hex();
                        encodedIterators.append(",");
                        encodedIterators.append(txidString);
                        encodedIterators.append("=");
                        encodedIterators.append(new String(hex.encode(CompactRange.this.iterators), Charsets.UTF_8));
                    }
                    return (Long.toString(flushID) + encodedIterators).getBytes(Charsets.UTF_8);
                }
            });
            return new CompactionDriver(Long.parseLong(new String(cid, Charsets.UTF_8).split(",")[0]), this.tableId, this.startRow, this.endRow);
        }
        catch (KeeperException.NoNodeException nne) {
            throw new ThriftTableOperationException(this.tableId, null, TableOperation.COMPACT, TableOperationExceptionType.NOTFOUND, null);
        }
    }

    static void removeIterators(final long txid, String tableId) throws Exception {
        String zTablePath = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/tables" + "/" + tableId + "/compact-id";
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        zoo.mutate(zTablePath, null, null, new IZooReaderWriter.Mutator(){

            public byte[] mutate(byte[] currentValue) throws Exception {
                String cvs = new String(currentValue, Charsets.UTF_8);
                String[] tokens = cvs.split(",");
                long flushID = Long.parseLong(tokens[0]);
                String txidString = String.format("%016x", txid);
                StringBuilder encodedIterators = new StringBuilder();
                for (int i = 1; i < tokens.length; ++i) {
                    if (tokens[i].startsWith(txidString)) continue;
                    encodedIterators.append(",");
                    encodedIterators.append(tokens[i]);
                }
                return (Long.toString(flushID) + encodedIterators).getBytes(Charsets.UTF_8);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo(long tid, Master environment) throws Exception {
        try {
            CompactRange.removeIterators(tid, this.tableId);
        }
        finally {
            Utils.unreserveNamespace(this.namespaceId, tid, false);
            Utils.unreserveTable(this.tableId, tid, false);
        }
    }

    public static class CompactionIterators
    implements Writable {
        byte[] startRow;
        byte[] endRow;
        List<IteratorSetting> iterators;

        public CompactionIterators(byte[] startRow, byte[] endRow, List<IteratorSetting> iterators) {
            this.startRow = startRow;
            this.endRow = endRow;
            this.iterators = iterators;
        }

        public CompactionIterators() {
            this.startRow = null;
            this.endRow = null;
            this.iterators = Collections.emptyList();
        }

        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.startRow != null);
            if (this.startRow != null) {
                out.writeInt(this.startRow.length);
                out.write(this.startRow);
            }
            out.writeBoolean(this.endRow != null);
            if (this.endRow != null) {
                out.writeInt(this.endRow.length);
                out.write(this.endRow);
            }
            out.writeInt(this.iterators.size());
            for (IteratorSetting is : this.iterators) {
                is.write(out);
            }
        }

        public void readFields(DataInput in) throws IOException {
            if (in.readBoolean()) {
                this.startRow = new byte[in.readInt()];
                in.readFully(this.startRow);
            } else {
                this.startRow = null;
            }
            if (in.readBoolean()) {
                this.endRow = new byte[in.readInt()];
                in.readFully(this.endRow);
            } else {
                this.endRow = null;
            }
            int num = in.readInt();
            this.iterators = new ArrayList<IteratorSetting>(num);
            for (int i = 0; i < num; ++i) {
                this.iterators.add(new IteratorSetting(in));
            }
        }

        public Text getEndRow() {
            if (this.endRow == null) {
                return null;
            }
            return new Text(this.endRow);
        }

        public Text getStartRow() {
            if (this.startRow == null) {
                return null;
            }
            return new Text(this.startRow);
        }

        public List<IteratorSetting> getIterators() {
            return this.iterators;
        }
    }
}

