/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.CloneInfo;
import org.apache.accumulo.master.tableOps.CloneZookeeper;
import org.apache.accumulo.master.tableOps.FinishCloneTable;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.log4j.Logger;

class ClonePermissions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public ClonePermissions(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        for (TablePermission permission : TablePermission.values()) {
            try {
                AuditedSecurityOperation.getInstance().grantTablePermission(SystemCredentials.get().toThrift(environment.getInstance()), this.cloneInfo.user, this.cloneInfo.tableId, permission, this.cloneInfo.namespaceId);
            }
            catch (ThriftSecurityException e) {
                Logger.getLogger(FinishCloneTable.class).error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        try {
            return new CloneZookeeper(this.cloneInfo);
        }
        catch (NamespaceNotFoundException e) {
            throw new ThriftTableOperationException(null, this.cloneInfo.tableName, TableOperation.CLONE, TableOperationExceptionType.NAMESPACE_NOTFOUND, "Namespace for target table not found");
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        AuditedSecurityOperation.getInstance().deleteTable(SystemCredentials.get().toThrift(environment.getInstance()), this.cloneInfo.tableId, this.cloneInfo.namespaceId);
    }
}

