/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.master.EventCoordinator;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.state.MergeStats;
import org.apache.accumulo.master.state.TableCounts;
import org.apache.accumulo.master.state.TableStats;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.ClosableIterator;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.tablets.TabletTime;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;

class TabletGroupWatcher
extends Daemon {
    private static final String ASSIGNMENT_BUFFER_SEPARATOR = ", ";
    private static final int ASSINGMENT_BUFFER_MAX_LENGTH = 4096;
    private final Master master;
    final TabletStateStore store;
    final TabletGroupWatcher dependentWatcher;
    final TableStats stats = new TableStats();

    TabletGroupWatcher(Master master, TabletStateStore store, TabletGroupWatcher dependentWatcher) {
        this.master = master;
        this.store = store;
        this.dependentWatcher = dependentWatcher;
    }

    Map<Text, TableCounts> getStats() {
        return this.stats.getLast();
    }

    TableCounts getStats(Text tableId) {
        return this.stats.getLast(tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setName("Watching " + this.store.name());
        int[] oldCounts = new int[TabletState.values().length];
        EventCoordinator.Listener eventListener = this.master.nextEvent.getListener();
        while (this.master.stillMaster()) {
            UtilWaitThread.sleep((long)100L);
            int totalUnloaded = 0;
            int unloaded = 0;
            ClosableIterator iter = null;
            try {
                HashMap<Text, MergeStats> mergeStatsCache = new HashMap<Text, MergeStats>();
                HashMap<Text, MergeStats> currentMerges = new HashMap<Text, MergeStats>();
                for (MergeInfo merge : this.master.merges()) {
                    if (merge.getExtent() == null) continue;
                    currentMerges.put(merge.getExtent().getTableId(), new MergeStats(merge));
                }
                TreeMap currentTServers = new TreeMap();
                for (TServerInstance entry : this.master.tserverSet.getCurrentServers()) {
                    currentTServers.put(entry, this.master.tserverStatus.get(entry));
                }
                if (currentTServers.size() == 0) {
                    eventListener.waitForEvents(60000L);
                    continue;
                }
                TreeMap<TServerInstance, TabletServerStatus> destinations = new TreeMap<TServerInstance, TabletServerStatus>(currentTServers);
                destinations.keySet().removeAll(this.master.serversToShutdown);
                ArrayList<Assignment> assignments = new ArrayList<Assignment>();
                ArrayList<Assignment> assigned = new ArrayList<Assignment>();
                ArrayList<TabletLocationState> assignedToDeadServers = new ArrayList<TabletLocationState>();
                HashMap<KeyExtent, TServerInstance> unassigned = new HashMap<KeyExtent, TServerInstance>();
                int[] counts = new int[TabletState.values().length];
                this.stats.begin();
                for (TabletLocationState tls : this.store) {
                    TServerInstance dest;
                    Text tableId;
                    MergeStats mergeStats;
                    if (tls == null || TableManager.getInstance().getTableState(tls.extent.getTableId().toString()) == null) continue;
                    if (Master.log.isTraceEnabled()) {
                        Master.log.trace((Object)(tls + " walogs " + tls.walogs.size()));
                    }
                    if (unassigned.size() + unloaded > 5000 * currentTServers.size()) {
                        this.flushChanges(destinations, assignments, assigned, assignedToDeadServers, unassigned);
                        assignments.clear();
                        assigned.clear();
                        assignedToDeadServers.clear();
                        unassigned.clear();
                        unloaded = 0;
                        eventListener.waitForEvents(60000L);
                    }
                    if ((mergeStats = (MergeStats)mergeStatsCache.get(tableId = tls.extent.getTableId())) == null) {
                        mergeStats = (MergeStats)currentMerges.get(tableId);
                        if (mergeStats == null) {
                            mergeStats = new MergeStats(new MergeInfo());
                        }
                        mergeStatsCache.put(tableId, mergeStats);
                    }
                    Master.TabletGoalState goal = this.master.getGoalState(tls, mergeStats.getMergeInfo());
                    TServerInstance server = tls.getServer();
                    TabletState state = tls.getState(currentTServers.keySet());
                    if (Master.log.isTraceEnabled()) {
                        Master.log.trace((Object)("Goal state " + (Object)((Object)goal) + " current " + state));
                    }
                    this.stats.update(tableId, state);
                    mergeStats.update(tls.extent, state, tls.chopped, !tls.walogs.isEmpty());
                    this.sendChopRequest(mergeStats.getMergeInfo(), state, tls);
                    this.sendSplitRequest(mergeStats.getMergeInfo(), state, tls);
                    if (state == TabletState.ASSIGNED) {
                        goal = Master.TabletGoalState.HOSTED;
                    }
                    if (goal == Master.TabletGoalState.UNASSIGNED && state == TabletState.HOSTED && ((Object)this.master.serversToShutdown).equals(currentTServers.keySet()) && this.dependentWatcher != null && this.dependentWatcher.assignedOrHosted() > 0) {
                        goal = Master.TabletGoalState.HOSTED;
                    }
                    if (goal == Master.TabletGoalState.HOSTED) {
                        if (state != TabletState.HOSTED && !tls.walogs.isEmpty() && this.master.recoveryManager.recoverLogs(tls.extent, tls.walogs)) continue;
                        switch (state) {
                            case HOSTED: {
                                if (!server.equals(this.master.migrations.get(tls.extent))) break;
                                this.master.migrations.remove(tls.extent);
                                break;
                            }
                            case ASSIGNED_TO_DEAD_SERVER: {
                                assignedToDeadServers.add(tls);
                                if (!server.equals(this.master.migrations.get(tls.extent))) break;
                                this.master.migrations.remove(tls.extent);
                                break;
                            }
                            case UNASSIGNED: {
                                dest = (TServerInstance)this.master.migrations.get(tls.extent);
                                if (dest != null) {
                                    if (destinations.keySet().contains(dest)) {
                                        assignments.add(new Assignment(tls.extent, dest));
                                        break;
                                    }
                                    this.master.migrations.remove(tls.extent);
                                    unassigned.put(tls.extent, server);
                                    break;
                                }
                                unassigned.put(tls.extent, server);
                                break;
                            }
                            case ASSIGNED: {
                                assigned.add(new Assignment(tls.extent, tls.future));
                            }
                        }
                    } else {
                        switch (state) {
                            case UNASSIGNED: {
                                dest = (TServerInstance)this.master.migrations.get(tls.extent);
                                TableState tableState = TableManager.getInstance().getTableState(tls.extent.getTableId().toString());
                                if (dest == null || tableState != TableState.OFFLINE) break;
                                this.master.migrations.remove(tls.extent);
                                break;
                            }
                            case ASSIGNED_TO_DEAD_SERVER: {
                                assignedToDeadServers.add(tls);
                                break;
                            }
                            case HOSTED: {
                                LiveTServerSet.TServerConnection conn = this.master.tserverSet.getConnection(server);
                                if (conn != null) {
                                    conn.unloadTablet(this.master.masterLock, tls.extent, goal != Master.TabletGoalState.DELETED);
                                    ++unloaded;
                                    ++totalUnloaded;
                                    break;
                                }
                                Master.log.warn((Object)("Could not connect to server " + server));
                                break;
                            }
                        }
                    }
                    int n = state.ordinal();
                    counts[n] = counts[n] + 1;
                }
                this.flushChanges(destinations, assignments, assigned, assignedToDeadServers, unassigned);
                this.stats.end();
                for (TabletState state : TabletState.values()) {
                    int i = state.ordinal();
                    if (counts[i] <= 0 || counts[i] == oldCounts[i]) continue;
                    this.master.nextEvent.event("[%s]: %d tablets are %s", this.store.name(), counts[i], state.name());
                }
                Master.log.debug((Object)String.format("[%s]: scan time %.2f seconds", this.store.name(), (double)this.stats.getScanTime() / 1000.0));
                oldCounts = counts;
                if (totalUnloaded > 0) {
                    this.master.nextEvent.event("[%s]: %d tablets unloaded", this.store.name(), totalUnloaded);
                }
                this.updateMergeState(mergeStatsCache);
                Master.log.debug((Object)String.format("[%s] sleeping for %.2f seconds", this.store.name(), 60.0));
                eventListener.waitForEvents(60000L);
            }
            catch (Exception ex) {
                Master.log.error((Object)("Error processing table state for store " + this.store.name()), (Throwable)ex);
                if (ex.getCause() != null && ex.getCause() instanceof TabletLocationState.BadLocationStateException) {
                    this.repairMetadata(((TabletLocationState.BadLocationStateException)ex.getCause()).getEncodedEndRow());
                    continue;
                }
                UtilWaitThread.sleep((long)1000L);
            }
            finally {
                if (iter == null) continue;
                try {
                    iter.close();
                }
                catch (IOException ex) {
                    Master.log.warn((Object)("Error closing TabletLocationState iterator: " + ex), (Throwable)ex);
                }
            }
        }
    }

    private void repairMetadata(Text row) {
        Master.log.debug((Object)("Attempting repair on " + row));
        try {
            HashMap future = new HashMap();
            HashMap assigned = new HashMap();
            KeyExtent extent = new KeyExtent(row, new Value(new byte[]{0}));
            String table = "accumulo.metadata";
            if (extent.isMeta()) {
                table = "accumulo.root";
            }
            Scanner scanner = this.master.getConnector().createScanner(table, Authorizations.EMPTY);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
            scanner.setRange(new Range(row));
            for (Map.Entry entry : scanner) {
                if (((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                    assigned.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) continue;
                future.put(entry.getKey(), entry.getValue());
            }
            if (future.size() > 0 && assigned.size() > 0) {
                Master.log.warn((Object)"Found a tablet assigned and hosted, attempting to repair");
            } else if (future.size() > 1 && assigned.size() == 0) {
                Master.log.warn((Object)"Found a tablet assigned to multiple servers, attempting to repair");
            } else if (future.size() == 0 && assigned.size() > 1) {
                Master.log.warn((Object)"Found a tablet hosted on multiple servers, attempting to repair");
            } else {
                Master.log.info((Object)("Attempted a repair, but nothing seems to be obviously wrong. " + assigned + " " + future));
                return;
            }
            Iterator iter = Iterators.concat(future.entrySet().iterator(), assigned.entrySet().iterator());
            while (iter.hasNext()) {
                Map.Entry entry;
                entry = (Map.Entry)iter.next();
                TServerInstance alive = this.master.tserverSet.find(((Value)entry.getValue()).toString());
                if (alive != null) continue;
                Master.log.info((Object)("Removing entry " + entry));
                BatchWriter bw = this.master.getConnector().createBatchWriter(table, new BatchWriterConfig());
                Mutation m = new Mutation(((Key)entry.getKey()).getRow());
                m.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
                bw.addMutation(m);
                bw.close();
                return;
            }
            Master.log.error((Object)("Metadata table is inconsistent at " + row + " and all assigned/future tservers are still online."));
        }
        catch (Throwable e) {
            Master.log.error((Object)("Error attempting repair of metadata " + row + ": " + e), e);
        }
    }

    private int assignedOrHosted() {
        int result = 0;
        for (TableCounts counts : this.stats.getLast().values()) {
            result += counts.assigned() + counts.hosted();
        }
        return result;
    }

    private void sendSplitRequest(MergeInfo info, TabletState state, TabletLocationState tls) {
        if (!info.getState().equals((Object)MergeState.SPLITTING)) {
            return;
        }
        if (!info.isDelete()) {
            return;
        }
        if (!state.equals((Object)TabletState.HOSTED)) {
            return;
        }
        KeyExtent range = info.getExtent();
        if (tls.extent.overlaps(range)) {
            for (Text splitPoint : new Text[]{range.getPrevEndRow(), range.getEndRow()}) {
                if (splitPoint == null || !tls.extent.contains((BinaryComparable)splitPoint) || splitPoint.equals((Object)tls.extent.getEndRow()) || splitPoint.equals((Object)tls.extent.getPrevEndRow())) continue;
                try {
                    LiveTServerSet.TServerConnection conn = this.master.tserverSet.getConnection(tls.current);
                    if (conn != null) {
                        Master.log.info((Object)("Asking " + tls.current + " to split " + tls.extent + " at " + splitPoint));
                        conn.splitTablet(this.master.masterLock, tls.extent, splitPoint);
                        continue;
                    }
                    Master.log.warn((Object)("Not connected to server " + tls.current));
                }
                catch (NotServingTabletException e) {
                    Master.log.debug((Object)("Error asking tablet server to split a tablet: " + (Object)((Object)e)));
                }
                catch (Exception e) {
                    Master.log.warn((Object)("Error asking tablet server to split a tablet: " + e));
                }
            }
        }
    }

    private void sendChopRequest(MergeInfo info, TabletState state, TabletLocationState tls) {
        if (!info.getState().equals((Object)MergeState.WAITING_FOR_CHOPPED)) {
            return;
        }
        if (!state.equals((Object)TabletState.HOSTED)) {
            return;
        }
        if (tls.chopped) {
            return;
        }
        if (info.needsToBeChopped(tls.extent)) {
            try {
                LiveTServerSet.TServerConnection conn = this.master.tserverSet.getConnection(tls.current);
                if (conn != null) {
                    Master.log.info((Object)("Asking " + tls.current + " to chop " + tls.extent));
                    conn.chop(this.master.masterLock, tls.extent);
                } else {
                    Master.log.warn((Object)("Could not connect to server " + tls.current));
                }
            }
            catch (TException e) {
                Master.log.warn((Object)"Communications error asking tablet server to chop a tablet");
            }
        }
    }

    private void updateMergeState(Map<Text, MergeStats> mergeStatsCache) {
        for (MergeStats stats : mergeStatsCache.values()) {
            try {
                MergeState update = stats.nextMergeState(this.master.getConnector(), this.master);
                if (update == MergeState.COMPLETE) {
                    update = MergeState.NONE;
                }
                if (update != stats.getMergeInfo().getState()) {
                    this.master.setMergeState(stats.getMergeInfo(), update);
                }
                if (update != MergeState.MERGING) continue;
                try {
                    if (stats.getMergeInfo().isDelete()) {
                        this.deleteTablets(stats.getMergeInfo());
                    } else {
                        this.mergeMetadataRecords(stats.getMergeInfo());
                    }
                    update = MergeState.COMPLETE;
                    this.master.setMergeState(stats.getMergeInfo(), update);
                }
                catch (Exception ex) {
                    Master.log.error((Object)"Unable merge metadata table records", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                Master.log.error((Object)("Unable to update merge state for merge " + stats.getMergeInfo().getExtent()), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTablets(MergeInfo info) throws AccumuloException {
        block18: {
            KeyExtent extent = info.getExtent();
            String targetSystemTable = extent.isMeta() ? "accumulo.root" : "accumulo.metadata";
            Master.log.debug((Object)("Deleting tablets for " + extent));
            char timeType = '\u0000';
            KeyExtent followingTablet = null;
            if (extent.getEndRow() != null) {
                Key nextExtent = new Key(extent.getEndRow()).followingKey(PartialKey.ROW);
                followingTablet = this.getHighTablet(new KeyExtent(extent.getTableId(), nextExtent.getRow(), extent.getEndRow()));
                Master.log.debug((Object)("Found following tablet " + followingTablet));
            }
            try {
                Connector conn = this.master.getConnector();
                Text start = extent.getPrevEndRow();
                if (start == null) {
                    start = new Text();
                }
                Master.log.debug((Object)("Making file deletion entries for " + extent));
                Range deleteRange = new Range(KeyExtent.getMetadataEntry((Text)extent.getTableId(), (Text)start), false, KeyExtent.getMetadataEntry((Text)extent.getTableId(), (Text)extent.getEndRow()), true);
                Scanner scanner = conn.createScanner(targetSystemTable, Authorizations.EMPTY);
                scanner.setRange(deleteRange);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
                MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)scanner);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
                TreeSet<FileRef> datafiles = new TreeSet<FileRef>();
                for (Map.Entry entry : scanner) {
                    Key key = (Key)entry.getKey();
                    if (key.compareColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) == 0) {
                        datafiles.add(new FileRef(this.master.fs, key));
                        if (datafiles.size() <= 1000) continue;
                        MetadataTableUtil.addDeleteEntries((KeyExtent)extent, datafiles, (Credentials)SystemCredentials.get());
                        datafiles.clear();
                        continue;
                    }
                    if (MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(key)) {
                        timeType = ((Value)entry.getValue()).toString().charAt(0);
                        continue;
                    }
                    if (key.compareColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) == 0) {
                        throw new IllegalStateException("Tablet " + key.getRow() + " is assigned during a merge!");
                    }
                    if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) continue;
                    String path = ((Value)entry.getValue()).toString();
                    if (path.contains(":")) {
                        datafiles.add(new FileRef(path));
                    } else {
                        datafiles.add(new FileRef(path, this.master.fs.getFullPath(VolumeManager.FileType.TABLE, "/" + extent.getTableId() + path)));
                    }
                    if (datafiles.size() <= 1000) continue;
                    MetadataTableUtil.addDeleteEntries((KeyExtent)extent, datafiles, (Credentials)SystemCredentials.get());
                    datafiles.clear();
                }
                MetadataTableUtil.addDeleteEntries((KeyExtent)extent, datafiles, (Credentials)SystemCredentials.get());
                BatchWriter bw = conn.createBatchWriter(targetSystemTable, new BatchWriterConfig());
                try {
                    this.deleteTablets(info, deleteRange, bw, conn);
                }
                finally {
                    bw.close();
                }
                if (followingTablet != null) {
                    Master.log.debug((Object)("Updating prevRow of " + followingTablet + " to " + extent.getPrevEndRow()));
                    bw = conn.createBatchWriter(targetSystemTable, new BatchWriterConfig());
                    try {
                        Mutation m = new Mutation(followingTablet.getMetadataEntry());
                        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow((Text)extent.getPrevEndRow()));
                        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
                        bw.addMutation(m);
                        bw.flush();
                        break block18;
                    }
                    finally {
                        bw.close();
                    }
                }
                Master.log.debug((Object)("Recreating the last tablet to point to " + extent.getPrevEndRow()));
                String tdir = this.master.getFileSystem().choose(ServerConstants.getBaseUris()) + "/tables" + "/" + extent.getTableId() + "/default_tablet";
                MetadataTableUtil.addTablet((KeyExtent)new KeyExtent(extent.getTableId(), null, extent.getPrevEndRow()), (String)tdir, (Credentials)SystemCredentials.get(), (char)timeType, (ZooLock)this.master.masterLock);
            }
            catch (Exception ex) {
                throw new AccumuloException((Throwable)ex);
            }
        }
    }

    private void mergeMetadataRecords(MergeInfo info) throws AccumuloException {
        KeyExtent range = info.getExtent();
        Master.log.debug((Object)("Merging metadata for " + range));
        KeyExtent stop = this.getHighTablet(range);
        Master.log.debug((Object)("Highest tablet is " + stop));
        Value firstPrevRowValue = null;
        Text stopRow = stop.getMetadataEntry();
        Text start = range.getPrevEndRow();
        if (start == null) {
            start = new Text();
        }
        Range scanRange = new Range(KeyExtent.getMetadataEntry((Text)range.getTableId(), (Text)start), false, stopRow, false);
        String targetSystemTable = "accumulo.metadata";
        if (range.isMeta()) {
            targetSystemTable = "accumulo.root";
        }
        BatchWriter bw = null;
        try {
            long fileCount = 0L;
            Connector conn = this.master.getConnector();
            bw = conn.createBatchWriter(targetSystemTable, new BatchWriterConfig());
            Scanner scanner = conn.createScanner(targetSystemTable, Authorizations.EMPTY);
            scanner.setRange(scanRange);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)scanner);
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            Mutation m = new Mutation(stopRow);
            String maxLogicalTime = null;
            for (Map.Entry entry : scanner) {
                Key key = (Key)entry.getKey();
                Value value = (Value)entry.getValue();
                if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                    m.put(key.getColumnFamily(), key.getColumnQualifier(), value);
                    ++fileCount;
                    continue;
                }
                if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key) && firstPrevRowValue == null) {
                    Master.log.debug((Object)("prevRow entry for lowest tablet is " + value));
                    firstPrevRowValue = new Value(value);
                    continue;
                }
                if (MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(key)) {
                    maxLogicalTime = TabletTime.maxMetadataTime((String)maxLogicalTime, (String)value.toString());
                    continue;
                }
                if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) continue;
                bw.addMutation(MetadataTableUtil.createDeleteMutation((String)range.getTableId().toString(), (String)((Value)entry.getValue()).toString()));
            }
            scanner = conn.createScanner(targetSystemTable, Authorizations.EMPTY);
            scanner.setRange(new Range(stopRow));
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)scanner);
            for (Map.Entry entry : scanner) {
                if (!MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns((Key)entry.getKey())) continue;
                maxLogicalTime = TabletTime.maxMetadataTime((String)maxLogicalTime, (String)((Value)entry.getValue()).toString());
            }
            if (maxLogicalTime != null) {
                MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(maxLogicalTime.getBytes()));
            }
            if (!m.getUpdates().isEmpty()) {
                bw.addMutation(m);
            }
            bw.flush();
            Master.log.debug((Object)("Moved " + fileCount + " files to " + stop));
            if (firstPrevRowValue == null) {
                Master.log.debug((Object)"tablet already merged");
                return;
            }
            stop.setPrevEndRow(KeyExtent.decodePrevEndRow((Value)firstPrevRowValue));
            Mutation updatePrevRow = stop.getPrevRowUpdateMutation();
            Master.log.debug((Object)("Setting the prevRow for last tablet: " + stop));
            bw.addMutation(updatePrevRow);
            bw.flush();
            this.deleteTablets(info, scanRange, bw, conn);
            m = new Mutation(stopRow);
            MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
            bw.addMutation(m);
            bw.flush();
        }
        catch (Exception ex) {
            throw new AccumuloException((Throwable)ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception ex) {
                    throw new AccumuloException((Throwable)ex);
                }
            }
        }
    }

    private void deleteTablets(MergeInfo info, Range scanRange, BatchWriter bw, Connector conn) throws TableNotFoundException, MutationsRejectedException {
        Scanner scanner = conn.createScanner(info.getExtent().isMeta() ? "accumulo.root" : "accumulo.metadata", Authorizations.EMPTY);
        Master.log.debug((Object)("Deleting range " + scanRange));
        scanner.setRange(scanRange);
        RowIterator rowIter = new RowIterator((Iterable)scanner);
        while (rowIter.hasNext()) {
            Iterator row = rowIter.next();
            Mutation m = null;
            while (row.hasNext()) {
                Map.Entry entry = (Map.Entry)row.next();
                Key key = (Key)entry.getKey();
                if (m == null) {
                    m = new Mutation(key.getRow());
                }
                m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
                Master.log.debug((Object)("deleting entry " + key));
            }
            bw.addMutation(m);
        }
        bw.flush();
    }

    private KeyExtent getHighTablet(KeyExtent range) throws AccumuloException {
        try {
            Connector conn = this.master.getConnector();
            Scanner scanner = conn.createScanner(range.isMeta() ? "accumulo.root" : "accumulo.metadata", Authorizations.EMPTY);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            KeyExtent start = new KeyExtent(range.getTableId(), range.getEndRow(), null);
            scanner.setRange(new Range(start.getMetadataEntry(), null));
            Iterator iterator = scanner.iterator();
            if (!iterator.hasNext()) {
                throw new AccumuloException("No last tablet for a merge " + range);
            }
            Map.Entry entry = (Map.Entry)iterator.next();
            KeyExtent highTablet = new KeyExtent(((Key)entry.getKey()).getRow(), KeyExtent.decodePrevEndRow((Value)((Value)entry.getValue())));
            if (highTablet.getTableId() != range.getTableId()) {
                throw new AccumuloException("No last tablet for merge " + range + " " + highTablet);
            }
            return highTablet;
        }
        catch (Exception ex) {
            throw new AccumuloException("Unexpected failure finding the last tablet for a merge " + range, (Throwable)ex);
        }
    }

    private void flushChanges(SortedMap<TServerInstance, TabletServerStatus> currentTServers, List<Assignment> assignments, List<Assignment> assigned, List<TabletLocationState> assignedToDeadServers, Map<KeyExtent, TServerInstance> unassigned) throws DistributedStoreException, TException {
        if (!assignedToDeadServers.isEmpty()) {
            int maxServersToShow = Math.min(assignedToDeadServers.size(), 100);
            Master.log.debug((Object)(assignedToDeadServers.size() + " assigned to dead servers: " + assignedToDeadServers.subList(0, maxServersToShow) + "..."));
            this.store.unassign(assignedToDeadServers);
            this.master.nextEvent.event("Marked %d tablets as unassigned because they don't have current servers", assignedToDeadServers.size());
        }
        if (!currentTServers.isEmpty()) {
            HashMap assignedOut = new HashMap();
            StringBuilder builder = new StringBuilder(64);
            this.master.tabletBalancer.getAssignments(Collections.unmodifiableSortedMap(currentTServers), Collections.unmodifiableMap(unassigned), assignedOut);
            for (Map.Entry assignment : assignedOut.entrySet()) {
                if (unassigned.containsKey(assignment.getKey())) {
                    if (assignment.getValue() == null) continue;
                    if (!currentTServers.containsKey(assignment.getValue())) {
                        Master.log.warn((Object)("balancer assigned " + assignment.getKey() + " to a tablet server that is not current " + assignment.getValue() + " ignoring"));
                        continue;
                    }
                    if (builder.length() > 0) {
                        builder.append(ASSIGNMENT_BUFFER_SEPARATOR);
                    }
                    builder.append(assignment);
                    if (builder.length() > 4096) {
                        builder.append("]");
                        Master.log.debug((Object)(this.store.name() + " assigning tablets: [" + builder.toString()));
                        builder.setLength(0);
                    }
                    assignments.add(new Assignment((KeyExtent)assignment.getKey(), (TServerInstance)assignment.getValue()));
                    continue;
                }
                Master.log.warn((Object)(this.store.name() + " load balancer assigning tablet that was not nominated for assignment " + assignment.getKey()));
            }
            if (builder.length() > 0) {
                builder.append("]");
                Master.log.debug((Object)(this.store.name() + " assigning tablets: [" + builder.toString()));
            }
            if (!unassigned.isEmpty() && assignedOut.isEmpty()) {
                Master.log.warn((Object)"Load balancer failed to assign any tablets");
            }
        }
        if (assignments.size() > 0) {
            Master.log.info((Object)String.format("Assigning %d tablets", assignments.size()));
            this.store.setFutureLocations(assignments);
        }
        assignments.addAll(assigned);
        for (Assignment a : assignments) {
            LiveTServerSet.TServerConnection conn = this.master.tserverSet.getConnection(a.server);
            if (conn != null) {
                conn.assignTablet(this.master.masterLock, a.tablet);
            } else {
                Master.log.warn((Object)("Could not connect to server " + a.server));
            }
            this.master.assignedTablet(a.tablet);
        }
    }
}

