/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.misc.Misc;

public class STDump {
    ST self;

    public STDump(ST self) {
        this.self = self;
    }

    public static String toString(ST self) {
        STDump d = new STDump(self);
        return d.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int n) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getTemplateDeclaratorString() + ":");
        ++n;
        if (this.self.getAttributes() != null) {
            ArrayList<String> attrNames = new ArrayList<String>();
            attrNames.addAll(this.self.getAttributes().keySet());
            Collections.sort(attrNames);
            String longestName = Collections.max(attrNames, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.length() - s2.length();
                }

                @Override
                public /* synthetic */ int compare(Object x0, Object x1) {
                    return this.compare((String)x0, (String)x1);
                }
            });
            int w = longestName.length();
            Iterator i$ = attrNames.iterator();
            while (i$.hasNext()) {
                String attrName;
                String name = attrName = (String)i$.next();
                buf.append(Misc.newline);
                this.indent(buf, n);
                buf.append(String.format("%-" + w + "s = ", name));
                Object value = this.self.getAttributes().get(name);
                buf.append(this.getValueDebugString(value, n));
            }
        }
        buf.append(Misc.newline);
        this.indent(buf, --n);
        buf.append("]");
        return buf.toString();
    }

    protected String getValueDebugString(Object value, int n) {
        StringBuffer buf = new StringBuffer();
        if ((value = Interpreter.convertAnythingIteratableToIterator(value)) instanceof ST) {
            STDump d = new STDump((ST)value);
            buf.append(d.toString(n));
        } else if (value instanceof Iterator) {
            Iterator it = (Iterator)value;
            int na = 0;
            while (it.hasNext()) {
                String v = this.getValueDebugString(it.next(), n);
                if (na > 0) {
                    buf.append(", ");
                }
                buf.append(v);
                ++na;
            }
        } else {
            buf.append(value);
        }
        return buf.toString();
    }

    protected String getTemplateDeclaratorString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(this.self.getName());
        buf.append("(");
        if (this.self.impl.formalArguments != null) {
            buf.append(this.self.impl.formalArguments.keySet());
        }
        buf.append(")@");
        buf.append(String.valueOf(this.hashCode()));
        buf.append(">");
        return buf.toString();
    }

    protected void indent(StringBuilder buf, int n) {
        for (int i = 1; i <= n; ++i) {
            buf.append("   ");
        }
    }
}

