// $ANTLR 3.3 Nov 30, 2010 12:46:29 org/stringtemplate/v4/compiler/Group.g 2011-05-18 18:27:34

/*
 * [The "BSD license"]
 *  Copyright (c) 2011 Terence Parr
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.stringtemplate.v4.compiler;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import org.stringtemplate.v4.misc.*;
import org.stringtemplate.v4.*;
import java.io.File;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class GroupParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "TRUE", "FALSE", "STRING", "ID", "BIGSTRING", "ANONYMOUS_TEMPLATE", "COMMENT", "LINE_COMMENT", "WS", "'import'", "'.'", "'group'", "':'", "'implements'", "','", "';'", "'@'", "'('", "')'", "'::='", "'='", "'['", "']'", "'default'"
    };
    public static final int EOF=-1;
    public static final int T__13=13;
    public static final int T__14=14;
    public static final int T__15=15;
    public static final int T__16=16;
    public static final int T__17=17;
    public static final int T__18=18;
    public static final int T__19=19;
    public static final int T__20=20;
    public static final int T__21=21;
    public static final int T__22=22;
    public static final int T__23=23;
    public static final int T__24=24;
    public static final int T__25=25;
    public static final int T__26=26;
    public static final int T__27=27;
    public static final int TRUE=4;
    public static final int FALSE=5;
    public static final int STRING=6;
    public static final int ID=7;
    public static final int BIGSTRING=8;
    public static final int ANONYMOUS_TEMPLATE=9;
    public static final int COMMENT=10;
    public static final int LINE_COMMENT=11;
    public static final int WS=12;

    // delegates
    // delegators


        public GroupParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public GroupParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return GroupParser.tokenNames; }
    public String getGrammarFileName() { return "org/stringtemplate/v4/compiler/Group.g"; }


    public STGroup group;

    public void displayRecognitionError(String[] tokenNames,
                                        RecognitionException e)
    {
        String msg = getErrorMessage(e, tokenNames);
        group.errMgr.groupSyntaxError(ErrorType.SYNTAX_ERROR, getSourceName(), e, msg);
    }
    public String getSourceName() {
        String fullFileName = super.getSourceName();
        File f = new File(fullFileName); // strip to simple name
        return f.getName();
    }
    public void error(String msg) {
        NoViableAltException e = new NoViableAltException("", 0, 0, input);
        group.errMgr.groupSyntaxError(ErrorType.SYNTAX_ERROR, getSourceName(), e, msg);
        recover(input, null);
    }



    // $ANTLR start "group"
    // org/stringtemplate/v4/compiler/Group.g:148:1: group[STGroup group, String prefix] : ( oldStyleHeader )? ( 'import' STRING | 'import' ID ( '.' ID )* )* ( def[prefix] )+ ;
    public final void group(STGroup group, String prefix) throws RecognitionException {
        Token STRING1=null;


        GroupLexer lexer = (GroupLexer)input.getTokenSource();
        this.group = lexer.group = group;

        try {
            // org/stringtemplate/v4/compiler/Group.g:153:2: ( ( oldStyleHeader )? ( 'import' STRING | 'import' ID ( '.' ID )* )* ( def[prefix] )+ )
            // org/stringtemplate/v4/compiler/Group.g:153:4: ( oldStyleHeader )? ( 'import' STRING | 'import' ID ( '.' ID )* )* ( def[prefix] )+
            {
            // org/stringtemplate/v4/compiler/Group.g:153:4: ( oldStyleHeader )?
            int alt1=2;
            switch ( input.LA(1) ) {
                case 15:
                    {
                    alt1=1;
                    }
                    break;
            }

            switch (alt1) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:153:4: oldStyleHeader
                    {
                    pushFollow(FOLLOW_oldStyleHeader_in_group64);
                    oldStyleHeader();

                    state._fsp--;


                    }
                    break;

            }

            // org/stringtemplate/v4/compiler/Group.g:154:6: ( 'import' STRING | 'import' ID ( '.' ID )* )*
            loop3:
            do {
                int alt3=3;
                switch ( input.LA(1) ) {
                case 13:
                    {
                    switch ( input.LA(2) ) {
                    case STRING:
                        {
                        alt3=1;
                        }
                        break;
                    case ID:
                        {
                        alt3=2;
                        }
                        break;

                    }

                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // org/stringtemplate/v4/compiler/Group.g:154:8: 'import' STRING
            	    {
            	    match(input,13,FOLLOW_13_in_group74); 
            	    STRING1=(Token)match(input,STRING,FOLLOW_STRING_in_group76); 
            	    group.importTemplates(STRING1);

            	    }
            	    break;
            	case 2 :
            	    // org/stringtemplate/v4/compiler/Group.g:155:5: 'import' ID ( '.' ID )*
            	    {
            	    match(input,13,FOLLOW_13_in_group84); 

            	    			MismatchedTokenException e = new MismatchedTokenException(STRING, input);
            	    			reportError(e);
            	    			
            	    match(input,ID,FOLLOW_ID_in_group95); 
            	    // org/stringtemplate/v4/compiler/Group.g:160:7: ( '.' ID )*
            	    loop2:
            	    do {
            	        int alt2=2;
            	        switch ( input.LA(1) ) {
            	        case 14:
            	            {
            	            alt2=1;
            	            }
            	            break;

            	        }

            	        switch (alt2) {
            	    	case 1 :
            	    	    // org/stringtemplate/v4/compiler/Group.g:160:8: '.' ID
            	    	    {
            	    	    match(input,14,FOLLOW_14_in_group98); 
            	    	    match(input,ID,FOLLOW_ID_in_group100); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop2;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);

            // org/stringtemplate/v4/compiler/Group.g:162:9: ( def[prefix] )+
            int cnt4=0;
            loop4:
            do {
                int alt4=2;
                switch ( input.LA(1) ) {
                case ID:
                case 20:
                    {
                    alt4=1;
                    }
                    break;

                }

                switch (alt4) {
            	case 1 :
            	    // org/stringtemplate/v4/compiler/Group.g:162:9: def[prefix]
            	    {
            	    pushFollow(FOLLOW_def_in_group118);
            	    def(prefix);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    if ( cnt4 >= 1 ) break loop4;
                        EarlyExitException eee =
                            new EarlyExitException(4, input);
                        throw eee;
                }
                cnt4++;
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "group"


    // $ANTLR start "oldStyleHeader"
    // org/stringtemplate/v4/compiler/Group.g:165:1: oldStyleHeader : 'group' ID ( ':' ID )? ( 'implements' ID ( ',' ID )* )? ';' ;
    public final void oldStyleHeader() throws RecognitionException {
        try {
            // org/stringtemplate/v4/compiler/Group.g:166:5: ( 'group' ID ( ':' ID )? ( 'implements' ID ( ',' ID )* )? ';' )
            // org/stringtemplate/v4/compiler/Group.g:166:9: 'group' ID ( ':' ID )? ( 'implements' ID ( ',' ID )* )? ';'
            {
            match(input,15,FOLLOW_15_in_oldStyleHeader140); 
            match(input,ID,FOLLOW_ID_in_oldStyleHeader142); 
            // org/stringtemplate/v4/compiler/Group.g:166:20: ( ':' ID )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case 16:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:166:22: ':' ID
                    {
                    match(input,16,FOLLOW_16_in_oldStyleHeader146); 
                    match(input,ID,FOLLOW_ID_in_oldStyleHeader148); 

                    }
                    break;

            }

            // org/stringtemplate/v4/compiler/Group.g:167:6: ( 'implements' ID ( ',' ID )* )?
            int alt7=2;
            switch ( input.LA(1) ) {
                case 17:
                    {
                    alt7=1;
                    }
                    break;
            }

            switch (alt7) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:167:8: 'implements' ID ( ',' ID )*
                    {
                    match(input,17,FOLLOW_17_in_oldStyleHeader160); 
                    match(input,ID,FOLLOW_ID_in_oldStyleHeader162); 
                    // org/stringtemplate/v4/compiler/Group.g:167:24: ( ',' ID )*
                    loop6:
                    do {
                        int alt6=2;
                        switch ( input.LA(1) ) {
                        case 18:
                            {
                            alt6=1;
                            }
                            break;

                        }

                        switch (alt6) {
                    	case 1 :
                    	    // org/stringtemplate/v4/compiler/Group.g:167:25: ',' ID
                    	    {
                    	    match(input,18,FOLLOW_18_in_oldStyleHeader165); 
                    	    match(input,ID,FOLLOW_ID_in_oldStyleHeader167); 

                    	    }
                    	    break;

                    	default :
                    	    break loop6;
                        }
                    } while (true);


                    }
                    break;

            }

            match(input,19,FOLLOW_19_in_oldStyleHeader179); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "oldStyleHeader"


    // $ANTLR start "groupName"
    // org/stringtemplate/v4/compiler/Group.g:171:1: groupName returns [String name] : a= ID ( '.' a= ID )* ;
    public final String groupName() throws RecognitionException {
        String name = null;

        Token a=null;

        StringBuilder buf = new StringBuilder();
        try {
            // org/stringtemplate/v4/compiler/Group.g:173:2: (a= ID ( '.' a= ID )* )
            // org/stringtemplate/v4/compiler/Group.g:173:4: a= ID ( '.' a= ID )*
            {
            a=(Token)match(input,ID,FOLLOW_ID_in_groupName201); 
            buf.append((a!=null?a.getText():null));
            // org/stringtemplate/v4/compiler/Group.g:173:32: ( '.' a= ID )*
            loop8:
            do {
                int alt8=2;
                switch ( input.LA(1) ) {
                case 14:
                    {
                    alt8=1;
                    }
                    break;

                }

                switch (alt8) {
            	case 1 :
            	    // org/stringtemplate/v4/compiler/Group.g:173:33: '.' a= ID
            	    {
            	    match(input,14,FOLLOW_14_in_groupName206); 
            	    a=(Token)match(input,ID,FOLLOW_ID_in_groupName210); 
            	    buf.append((a!=null?a.getText():null));

            	    }
            	    break;

            	default :
            	    break loop8;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return name;
    }
    // $ANTLR end "groupName"


    // $ANTLR start "def"
    // org/stringtemplate/v4/compiler/Group.g:176:1: def[String prefix] : ( templateDef[prefix] | dictDef );
    public final void def(String prefix) throws RecognitionException {
        try {
            // org/stringtemplate/v4/compiler/Group.g:180:20: ( templateDef[prefix] | dictDef )
            int alt9=2;
            switch ( input.LA(1) ) {
            case 20:
                {
                alt9=1;
                }
                break;
            case ID:
                {
                switch ( input.LA(2) ) {
                case 21:
                    {
                    alt9=1;
                    }
                    break;
                case 23:
                    {
                    switch ( input.LA(3) ) {
                    case ID:
                        {
                        alt9=1;
                        }
                        break;
                    case 25:
                        {
                        alt9=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 9, 3, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 9, 2, input);

                    throw nvae;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;
            }

            switch (alt9) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:180:22: templateDef[prefix]
                    {
                    pushFollow(FOLLOW_templateDef_in_def227);
                    templateDef(prefix);

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // org/stringtemplate/v4/compiler/Group.g:180:44: dictDef
                    {
                    pushFollow(FOLLOW_dictDef_in_def232);
                    dictDef();

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {

            		// pretend we already saw an error here
            		state.lastErrorIndex = input.index();
            		error("garbled template definition starting at '"+input.LT(1).getText()+"'");
            	
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "def"


    // $ANTLR start "templateDef"
    // org/stringtemplate/v4/compiler/Group.g:187:1: templateDef[String prefix] : ( ( '@' enclosing= ID '.' name= ID '(' ')' | name= ID '(' formalArgs ')' ) '::=' ( STRING | BIGSTRING | ) | alias= ID '::=' target= ID );
    public final void templateDef(String prefix) throws RecognitionException {
        Token enclosing=null;
        Token name=null;
        Token alias=null;
        Token target=null;
        Token STRING2=null;
        Token BIGSTRING3=null;
        List<FormalArgument> formalArgs4 = null;



            String template=null;
            int n=0; // num char to strip from left, right of template def

        try {
            // org/stringtemplate/v4/compiler/Group.g:192:2: ( ( '@' enclosing= ID '.' name= ID '(' ')' | name= ID '(' formalArgs ')' ) '::=' ( STRING | BIGSTRING | ) | alias= ID '::=' target= ID )
            int alt12=2;
            switch ( input.LA(1) ) {
            case 20:
                {
                alt12=1;
                }
                break;
            case ID:
                {
                switch ( input.LA(2) ) {
                case 21:
                    {
                    alt12=1;
                    }
                    break;
                case 23:
                    {
                    alt12=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 12, 2, input);

                    throw nvae;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }

            switch (alt12) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:192:4: ( '@' enclosing= ID '.' name= ID '(' ')' | name= ID '(' formalArgs ')' ) '::=' ( STRING | BIGSTRING | )
                    {
                    // org/stringtemplate/v4/compiler/Group.g:192:4: ( '@' enclosing= ID '.' name= ID '(' ')' | name= ID '(' formalArgs ')' )
                    int alt10=2;
                    switch ( input.LA(1) ) {
                    case 20:
                        {
                        alt10=1;
                        }
                        break;
                    case ID:
                        {
                        alt10=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 0, input);

                        throw nvae;
                    }

                    switch (alt10) {
                        case 1 :
                            // org/stringtemplate/v4/compiler/Group.g:192:6: '@' enclosing= ID '.' name= ID '(' ')'
                            {
                            match(input,20,FOLLOW_20_in_templateDef256); 
                            enclosing=(Token)match(input,ID,FOLLOW_ID_in_templateDef260); 
                            match(input,14,FOLLOW_14_in_templateDef262); 
                            name=(Token)match(input,ID,FOLLOW_ID_in_templateDef266); 
                            match(input,21,FOLLOW_21_in_templateDef268); 
                            match(input,22,FOLLOW_22_in_templateDef270); 

                            }
                            break;
                        case 2 :
                            // org/stringtemplate/v4/compiler/Group.g:193:5: name= ID '(' formalArgs ')'
                            {
                            name=(Token)match(input,ID,FOLLOW_ID_in_templateDef278); 
                            match(input,21,FOLLOW_21_in_templateDef280); 
                            pushFollow(FOLLOW_formalArgs_in_templateDef282);
                            formalArgs4=formalArgs();

                            state._fsp--;

                            match(input,22,FOLLOW_22_in_templateDef284); 

                            }
                            break;

                    }

                    match(input,23,FOLLOW_23_in_templateDef295); 
                    Token templateToken = input.LT(1);
                    // org/stringtemplate/v4/compiler/Group.g:197:6: ( STRING | BIGSTRING | )
                    int alt11=3;
                    switch ( input.LA(1) ) {
                    case STRING:
                        {
                        alt11=1;
                        }
                        break;
                    case BIGSTRING:
                        {
                        alt11=2;
                        }
                        break;
                    case EOF:
                    case ID:
                    case 20:
                        {
                        alt11=3;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 11, 0, input);

                        throw nvae;
                    }

                    switch (alt11) {
                        case 1 :
                            // org/stringtemplate/v4/compiler/Group.g:197:8: STRING
                            {
                            STRING2=(Token)match(input,STRING,FOLLOW_STRING_in_templateDef311); 
                            template=(STRING2!=null?STRING2.getText():null); n=1;

                            }
                            break;
                        case 2 :
                            // org/stringtemplate/v4/compiler/Group.g:198:8: BIGSTRING
                            {
                            BIGSTRING3=(Token)match(input,BIGSTRING,FOLLOW_BIGSTRING_in_templateDef326); 
                            template=(BIGSTRING3!=null?BIGSTRING3.getText():null); n=2;

                            }
                            break;
                        case 3 :
                            // org/stringtemplate/v4/compiler/Group.g:199:8: 
                            {

                            	    	template = "";
                            	    	String msg = "missing template at '"+input.LT(1).getText()+"'";
                                        NoViableAltException e = new NoViableAltException("", 0, 0, input);
                                	    group.errMgr.groupSyntaxError(ErrorType.SYNTAX_ERROR, getSourceName(), e, msg);
                                	    

                            }
                            break;

                    }


                    	    if ( (name!=null?name.getTokenIndex():0) >= 0 ) { // if ID missing
                    			template = Misc.strip(template, n);
                    			String templateName = (name!=null?name.getText():null);
                    			if ( prefix.length()>0 ) templateName = prefix+"/"+(name!=null?name.getText():null);
                    			group.defineTemplateOrRegion(templateName, (enclosing!=null?enclosing.getText():null), templateToken,
                    										 template, name, formalArgs4);
                    		}
                    	    

                    }
                    break;
                case 2 :
                    // org/stringtemplate/v4/compiler/Group.g:215:6: alias= ID '::=' target= ID
                    {
                    alias=(Token)match(input,ID,FOLLOW_ID_in_templateDef361); 
                    match(input,23,FOLLOW_23_in_templateDef363); 
                    target=(Token)match(input,ID,FOLLOW_ID_in_templateDef367); 
                    group.defineTemplateAlias(alias, target);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "templateDef"


    // $ANTLR start "formalArgs"
    // org/stringtemplate/v4/compiler/Group.g:218:1: formalArgs returns [List<FormalArgument> args] : ( formalArg[$args] ( ',' formalArg[$args] )* ( ',' formalArgWithDefaultValue[$args] )* | formalArgWithDefaultValue[$args] ( ',' formalArgWithDefaultValue[$args] )* | );
    public final List<FormalArgument> formalArgs() throws RecognitionException {
        List<FormalArgument> args = null;

        args = new ArrayList<FormalArgument>();
        try {
            // org/stringtemplate/v4/compiler/Group.g:220:5: ( formalArg[$args] ( ',' formalArg[$args] )* ( ',' formalArgWithDefaultValue[$args] )* | formalArgWithDefaultValue[$args] ( ',' formalArgWithDefaultValue[$args] )* | )
            int alt16=3;
            switch ( input.LA(1) ) {
            case ID:
                {
                switch ( input.LA(2) ) {
                case 18:
                case 22:
                    {
                    alt16=1;
                    }
                    break;
                case 24:
                    {
                    alt16=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 16, 1, input);

                    throw nvae;
                }

                }
                break;
            case 22:
                {
                alt16=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 16, 0, input);

                throw nvae;
            }

            switch (alt16) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:220:7: formalArg[$args] ( ',' formalArg[$args] )* ( ',' formalArgWithDefaultValue[$args] )*
                    {
                    pushFollow(FOLLOW_formalArg_in_formalArgs392);
                    formalArg(args);

                    state._fsp--;

                    // org/stringtemplate/v4/compiler/Group.g:221:6: ( ',' formalArg[$args] )*
                    loop13:
                    do {
                        int alt13=2;
                        switch ( input.LA(1) ) {
                        case 18:
                            {
                            switch ( input.LA(2) ) {
                            case ID:
                                {
                                switch ( input.LA(3) ) {
                                case 18:
                                case 22:
                                    {
                                    alt13=1;
                                    }
                                    break;

                                }

                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt13) {
                    	case 1 :
                    	    // org/stringtemplate/v4/compiler/Group.g:221:8: ',' formalArg[$args]
                    	    {
                    	    match(input,18,FOLLOW_18_in_formalArgs402); 
                    	    pushFollow(FOLLOW_formalArg_in_formalArgs404);
                    	    formalArg(args);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop13;
                        }
                    } while (true);

                    // org/stringtemplate/v4/compiler/Group.g:222:6: ( ',' formalArgWithDefaultValue[$args] )*
                    loop14:
                    do {
                        int alt14=2;
                        switch ( input.LA(1) ) {
                        case 18:
                            {
                            alt14=1;
                            }
                            break;

                        }

                        switch (alt14) {
                    	case 1 :
                    	    // org/stringtemplate/v4/compiler/Group.g:222:8: ',' formalArgWithDefaultValue[$args]
                    	    {
                    	    match(input,18,FOLLOW_18_in_formalArgs417); 
                    	    pushFollow(FOLLOW_formalArgWithDefaultValue_in_formalArgs419);
                    	    formalArgWithDefaultValue(args);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop14;
                        }
                    } while (true);


                    }
                    break;
                case 2 :
                    // org/stringtemplate/v4/compiler/Group.g:223:7: formalArgWithDefaultValue[$args] ( ',' formalArgWithDefaultValue[$args] )*
                    {
                    pushFollow(FOLLOW_formalArgWithDefaultValue_in_formalArgs431);
                    formalArgWithDefaultValue(args);

                    state._fsp--;

                    // org/stringtemplate/v4/compiler/Group.g:223:40: ( ',' formalArgWithDefaultValue[$args] )*
                    loop15:
                    do {
                        int alt15=2;
                        switch ( input.LA(1) ) {
                        case 18:
                            {
                            alt15=1;
                            }
                            break;

                        }

                        switch (alt15) {
                    	case 1 :
                    	    // org/stringtemplate/v4/compiler/Group.g:223:42: ',' formalArgWithDefaultValue[$args]
                    	    {
                    	    match(input,18,FOLLOW_18_in_formalArgs436); 
                    	    pushFollow(FOLLOW_formalArgWithDefaultValue_in_formalArgs438);
                    	    formalArgWithDefaultValue(args);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop15;
                        }
                    } while (true);


                    }
                    break;
                case 3 :
                    // org/stringtemplate/v4/compiler/Group.g:225:2: 
                    {
                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return args;
    }
    // $ANTLR end "formalArgs"


    // $ANTLR start "formalArg"
    // org/stringtemplate/v4/compiler/Group.g:227:1: formalArg[List<FormalArgument> args] : ID ;
    public final void formalArg(List<FormalArgument> args) throws RecognitionException {
        Token ID5=null;

        try {
            // org/stringtemplate/v4/compiler/Group.g:228:2: ( ID )
            // org/stringtemplate/v4/compiler/Group.g:228:4: ID
            {
            ID5=(Token)match(input,ID,FOLLOW_ID_in_formalArg460); 
            args.add(new FormalArgument((ID5!=null?ID5.getText():null)));

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "formalArg"


    // $ANTLR start "formalArgWithDefaultValue"
    // org/stringtemplate/v4/compiler/Group.g:232:1: formalArgWithDefaultValue[List<FormalArgument> args] : ID ( '=' a= STRING | '=' a= ANONYMOUS_TEMPLATE | '=' a= 'true' | '=' a= 'false' ) ;
    public final void formalArgWithDefaultValue(List<FormalArgument> args) throws RecognitionException {
        Token a=null;
        Token ID6=null;

        try {
            // org/stringtemplate/v4/compiler/Group.g:233:2: ( ID ( '=' a= STRING | '=' a= ANONYMOUS_TEMPLATE | '=' a= 'true' | '=' a= 'false' ) )
            // org/stringtemplate/v4/compiler/Group.g:233:4: ID ( '=' a= STRING | '=' a= ANONYMOUS_TEMPLATE | '=' a= 'true' | '=' a= 'false' )
            {
            ID6=(Token)match(input,ID,FOLLOW_ID_in_formalArgWithDefaultValue479); 
            // org/stringtemplate/v4/compiler/Group.g:234:3: ( '=' a= STRING | '=' a= ANONYMOUS_TEMPLATE | '=' a= 'true' | '=' a= 'false' )
            int alt17=4;
            switch ( input.LA(1) ) {
            case 24:
                {
                switch ( input.LA(2) ) {
                case STRING:
                    {
                    alt17=1;
                    }
                    break;
                case ANONYMOUS_TEMPLATE:
                    {
                    alt17=2;
                    }
                    break;
                case TRUE:
                    {
                    alt17=3;
                    }
                    break;
                case FALSE:
                    {
                    alt17=4;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 17, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;
            }

            switch (alt17) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:234:5: '=' a= STRING
                    {
                    match(input,24,FOLLOW_24_in_formalArgWithDefaultValue485); 
                    a=(Token)match(input,STRING,FOLLOW_STRING_in_formalArgWithDefaultValue489); 

                    }
                    break;
                case 2 :
                    // org/stringtemplate/v4/compiler/Group.g:235:5: '=' a= ANONYMOUS_TEMPLATE
                    {
                    match(input,24,FOLLOW_24_in_formalArgWithDefaultValue495); 
                    a=(Token)match(input,ANONYMOUS_TEMPLATE,FOLLOW_ANONYMOUS_TEMPLATE_in_formalArgWithDefaultValue499); 

                    }
                    break;
                case 3 :
                    // org/stringtemplate/v4/compiler/Group.g:236:5: '=' a= 'true'
                    {
                    match(input,24,FOLLOW_24_in_formalArgWithDefaultValue505); 
                    a=(Token)match(input,TRUE,FOLLOW_TRUE_in_formalArgWithDefaultValue509); 

                    }
                    break;
                case 4 :
                    // org/stringtemplate/v4/compiler/Group.g:237:5: '=' a= 'false'
                    {
                    match(input,24,FOLLOW_24_in_formalArgWithDefaultValue515); 
                    a=(Token)match(input,FALSE,FOLLOW_FALSE_in_formalArgWithDefaultValue519); 

                    }
                    break;

            }

            args.add(new FormalArgument((ID6!=null?ID6.getText():null), a));

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "formalArgWithDefaultValue"


    // $ANTLR start "dictDef"
    // org/stringtemplate/v4/compiler/Group.g:251:1: dictDef : ID '::=' dict ;
    public final void dictDef() throws RecognitionException {
        Token ID7=null;
        Map<String,Object> dict8 = null;


        try {
            // org/stringtemplate/v4/compiler/Group.g:252:2: ( ID '::=' dict )
            // org/stringtemplate/v4/compiler/Group.g:252:4: ID '::=' dict
            {
            ID7=(Token)match(input,ID,FOLLOW_ID_in_dictDef544); 
            match(input,23,FOLLOW_23_in_dictDef546); 
            pushFollow(FOLLOW_dict_in_dictDef548);
            dict8=dict();

            state._fsp--;


                    if ( group.rawGetDictionary((ID7!=null?ID7.getText():null))!=null ) {
            			group.errMgr.compileTimeError(ErrorType.MAP_REDEFINITION, null, ID7);
                    }
                    else if ( group.rawGetTemplate((ID7!=null?ID7.getText():null))!=null ) {
            			group.errMgr.compileTimeError(ErrorType.TEMPLATE_REDEFINITION_AS_MAP, null, ID7);
                    }
                    else {
                        group.defineDictionary((ID7!=null?ID7.getText():null), dict8);
                    }
                    

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "dictDef"


    // $ANTLR start "dict"
    // org/stringtemplate/v4/compiler/Group.g:266:1: dict returns [Map<String,Object> mapping] : '[' dictPairs[mapping] ']' ;
    public final Map<String,Object> dict() throws RecognitionException {
        Map<String,Object> mapping = null;

        mapping=new HashMap<String,Object>();
        try {
            // org/stringtemplate/v4/compiler/Group.g:268:2: ( '[' dictPairs[mapping] ']' )
            // org/stringtemplate/v4/compiler/Group.g:268:6: '[' dictPairs[mapping] ']'
            {
            match(input,25,FOLLOW_25_in_dict580); 
            pushFollow(FOLLOW_dictPairs_in_dict582);
            dictPairs(mapping);

            state._fsp--;

            match(input,26,FOLLOW_26_in_dict585); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return mapping;
    }
    // $ANTLR end "dict"


    // $ANTLR start "dictPairs"
    // org/stringtemplate/v4/compiler/Group.g:271:1: dictPairs[Map<String,Object> mapping] : ( keyValuePair[mapping] ( ',' keyValuePair[mapping] )* ( ',' defaultValuePair[mapping] )? | defaultValuePair[mapping] );
    public final void dictPairs(Map<String,Object> mapping) throws RecognitionException {
        try {
            // org/stringtemplate/v4/compiler/Group.g:272:5: ( keyValuePair[mapping] ( ',' keyValuePair[mapping] )* ( ',' defaultValuePair[mapping] )? | defaultValuePair[mapping] )
            int alt20=2;
            switch ( input.LA(1) ) {
            case STRING:
                {
                alt20=1;
                }
                break;
            case 27:
                {
                alt20=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;
            }

            switch (alt20) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:272:7: keyValuePair[mapping] ( ',' keyValuePair[mapping] )* ( ',' defaultValuePair[mapping] )?
                    {
                    pushFollow(FOLLOW_keyValuePair_in_dictPairs600);
                    keyValuePair(mapping);

                    state._fsp--;

                    // org/stringtemplate/v4/compiler/Group.g:273:6: ( ',' keyValuePair[mapping] )*
                    loop18:
                    do {
                        int alt18=2;
                        switch ( input.LA(1) ) {
                        case 18:
                            {
                            switch ( input.LA(2) ) {
                            case STRING:
                                {
                                alt18=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt18) {
                    	case 1 :
                    	    // org/stringtemplate/v4/compiler/Group.g:273:7: ',' keyValuePair[mapping]
                    	    {
                    	    match(input,18,FOLLOW_18_in_dictPairs609); 
                    	    pushFollow(FOLLOW_keyValuePair_in_dictPairs611);
                    	    keyValuePair(mapping);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop18;
                        }
                    } while (true);

                    // org/stringtemplate/v4/compiler/Group.g:273:35: ( ',' defaultValuePair[mapping] )?
                    int alt19=2;
                    switch ( input.LA(1) ) {
                        case 18:
                            {
                            alt19=1;
                            }
                            break;
                    }

                    switch (alt19) {
                        case 1 :
                            // org/stringtemplate/v4/compiler/Group.g:273:36: ',' defaultValuePair[mapping]
                            {
                            match(input,18,FOLLOW_18_in_dictPairs617); 
                            pushFollow(FOLLOW_defaultValuePair_in_dictPairs619);
                            defaultValuePair(mapping);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/stringtemplate/v4/compiler/Group.g:274:7: defaultValuePair[mapping]
                    {
                    pushFollow(FOLLOW_defaultValuePair_in_dictPairs630);
                    defaultValuePair(mapping);

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {

            		error("missing dictionary entry at '"+input.LT(1).getText()+"'");
            	
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "dictPairs"


    // $ANTLR start "defaultValuePair"
    // org/stringtemplate/v4/compiler/Group.g:280:1: defaultValuePair[Map<String,Object> mapping] : 'default' ':' keyValue ;
    public final void defaultValuePair(Map<String,Object> mapping) throws RecognitionException {
        Object keyValue9 = null;


        try {
            // org/stringtemplate/v4/compiler/Group.g:281:2: ( 'default' ':' keyValue )
            // org/stringtemplate/v4/compiler/Group.g:281:4: 'default' ':' keyValue
            {
            match(input,27,FOLLOW_27_in_defaultValuePair653); 
            match(input,16,FOLLOW_16_in_defaultValuePair655); 
            pushFollow(FOLLOW_keyValue_in_defaultValuePair657);
            keyValue9=keyValue();

            state._fsp--;

            mapping.put(STGroup.DEFAULT_KEY, keyValue9);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "defaultValuePair"


    // $ANTLR start "keyValuePair"
    // org/stringtemplate/v4/compiler/Group.g:284:1: keyValuePair[Map<String,Object> mapping] : STRING ':' keyValue ;
    public final void keyValuePair(Map<String,Object> mapping) throws RecognitionException {
        Token STRING10=null;
        Object keyValue11 = null;


        try {
            // org/stringtemplate/v4/compiler/Group.g:285:2: ( STRING ':' keyValue )
            // org/stringtemplate/v4/compiler/Group.g:285:4: STRING ':' keyValue
            {
            STRING10=(Token)match(input,STRING,FOLLOW_STRING_in_keyValuePair671); 
            match(input,16,FOLLOW_16_in_keyValuePair673); 
            pushFollow(FOLLOW_keyValue_in_keyValuePair675);
            keyValue11=keyValue();

            state._fsp--;

            mapping.put(Misc.replaceEscapes(Misc.strip((STRING10!=null?STRING10.getText():null), 1)), keyValue11);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "keyValuePair"


    // $ANTLR start "keyValue"
    // org/stringtemplate/v4/compiler/Group.g:288:1: keyValue returns [Object value] : ( BIGSTRING | ANONYMOUS_TEMPLATE | STRING | TRUE | FALSE | {...}? => ID );
    public final Object keyValue() throws RecognitionException {
        Object value = null;

        Token BIGSTRING12=null;
        Token ANONYMOUS_TEMPLATE13=null;
        Token STRING14=null;

        try {
            // org/stringtemplate/v4/compiler/Group.g:289:2: ( BIGSTRING | ANONYMOUS_TEMPLATE | STRING | TRUE | FALSE | {...}? => ID )
            int alt21=6;
            int LA21_0 = input.LA(1);

            if ( (LA21_0==BIGSTRING) ) {
                alt21=1;
            }
            else if ( (LA21_0==ANONYMOUS_TEMPLATE) ) {
                alt21=2;
            }
            else if ( (LA21_0==STRING) ) {
                alt21=3;
            }
            else if ( (LA21_0==TRUE) ) {
                alt21=4;
            }
            else if ( (LA21_0==FALSE) ) {
                alt21=5;
            }
            else if ( (LA21_0==ID) && ((input.LT(1).getText().equals("key")))) {
                alt21=6;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 21, 0, input);

                throw nvae;
            }
            switch (alt21) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:289:4: BIGSTRING
                    {
                    BIGSTRING12=(Token)match(input,BIGSTRING,FOLLOW_BIGSTRING_in_keyValue692); 
                    value = group.createSingleton(BIGSTRING12);

                    }
                    break;
                case 2 :
                    // org/stringtemplate/v4/compiler/Group.g:290:4: ANONYMOUS_TEMPLATE
                    {
                    ANONYMOUS_TEMPLATE13=(Token)match(input,ANONYMOUS_TEMPLATE,FOLLOW_ANONYMOUS_TEMPLATE_in_keyValue701); 
                    value = group.createSingleton(ANONYMOUS_TEMPLATE13);

                    }
                    break;
                case 3 :
                    // org/stringtemplate/v4/compiler/Group.g:291:4: STRING
                    {
                    STRING14=(Token)match(input,STRING,FOLLOW_STRING_in_keyValue708); 
                    value = Misc.replaceEscapes(Misc.strip((STRING14!=null?STRING14.getText():null), 1));

                    }
                    break;
                case 4 :
                    // org/stringtemplate/v4/compiler/Group.g:292:4: TRUE
                    {
                    match(input,TRUE,FOLLOW_TRUE_in_keyValue718); 
                    value = true;

                    }
                    break;
                case 5 :
                    // org/stringtemplate/v4/compiler/Group.g:293:4: FALSE
                    {
                    match(input,FALSE,FOLLOW_FALSE_in_keyValue728); 
                    value = false;

                    }
                    break;
                case 6 :
                    // org/stringtemplate/v4/compiler/Group.g:294:4: {...}? => ID
                    {
                    if ( !((input.LT(1).getText().equals("key"))) ) {
                        throw new FailedPredicateException(input, "keyValue", "input.LT(1).getText().equals(\"key\")");
                    }
                    match(input,ID,FOLLOW_ID_in_keyValue741); 
                    value = STGroup.DICT_KEY;

                    }
                    break;

            }
        }
        catch (RecognitionException re) {

            		error("missing value for key at '"+input.LT(1).getText()+"'");
            	
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "keyValue"

    // Delegated rules


 

    public static final BitSet FOLLOW_oldStyleHeader_in_group64 = new BitSet(new long[]{0x0000000000102080L});
    public static final BitSet FOLLOW_13_in_group74 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_STRING_in_group76 = new BitSet(new long[]{0x0000000000102080L});
    public static final BitSet FOLLOW_13_in_group84 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_group95 = new BitSet(new long[]{0x0000000000106080L});
    public static final BitSet FOLLOW_14_in_group98 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_group100 = new BitSet(new long[]{0x0000000000106080L});
    public static final BitSet FOLLOW_def_in_group118 = new BitSet(new long[]{0x0000000000102082L});
    public static final BitSet FOLLOW_15_in_oldStyleHeader140 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_oldStyleHeader142 = new BitSet(new long[]{0x00000000000B0000L});
    public static final BitSet FOLLOW_16_in_oldStyleHeader146 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_oldStyleHeader148 = new BitSet(new long[]{0x00000000000A0000L});
    public static final BitSet FOLLOW_17_in_oldStyleHeader160 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_oldStyleHeader162 = new BitSet(new long[]{0x00000000000C0000L});
    public static final BitSet FOLLOW_18_in_oldStyleHeader165 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_oldStyleHeader167 = new BitSet(new long[]{0x00000000000C0000L});
    public static final BitSet FOLLOW_19_in_oldStyleHeader179 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_groupName201 = new BitSet(new long[]{0x0000000000004002L});
    public static final BitSet FOLLOW_14_in_groupName206 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_groupName210 = new BitSet(new long[]{0x0000000000004002L});
    public static final BitSet FOLLOW_templateDef_in_def227 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dictDef_in_def232 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_20_in_templateDef256 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_templateDef260 = new BitSet(new long[]{0x0000000000004000L});
    public static final BitSet FOLLOW_14_in_templateDef262 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_templateDef266 = new BitSet(new long[]{0x0000000000200000L});
    public static final BitSet FOLLOW_21_in_templateDef268 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_22_in_templateDef270 = new BitSet(new long[]{0x0000000000800000L});
    public static final BitSet FOLLOW_ID_in_templateDef278 = new BitSet(new long[]{0x0000000000200000L});
    public static final BitSet FOLLOW_21_in_templateDef280 = new BitSet(new long[]{0x0000000000400080L});
    public static final BitSet FOLLOW_formalArgs_in_templateDef282 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_22_in_templateDef284 = new BitSet(new long[]{0x0000000000800000L});
    public static final BitSet FOLLOW_23_in_templateDef295 = new BitSet(new long[]{0x0000000000000142L});
    public static final BitSet FOLLOW_STRING_in_templateDef311 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BIGSTRING_in_templateDef326 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_templateDef361 = new BitSet(new long[]{0x0000000000800000L});
    public static final BitSet FOLLOW_23_in_templateDef363 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_ID_in_templateDef367 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_formalArg_in_formalArgs392 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_18_in_formalArgs402 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_formalArg_in_formalArgs404 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_18_in_formalArgs417 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_formalArgWithDefaultValue_in_formalArgs419 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_formalArgWithDefaultValue_in_formalArgs431 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_18_in_formalArgs436 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_formalArgWithDefaultValue_in_formalArgs438 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_ID_in_formalArg460 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_formalArgWithDefaultValue479 = new BitSet(new long[]{0x0000000001000000L});
    public static final BitSet FOLLOW_24_in_formalArgWithDefaultValue485 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_STRING_in_formalArgWithDefaultValue489 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_24_in_formalArgWithDefaultValue495 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_ANONYMOUS_TEMPLATE_in_formalArgWithDefaultValue499 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_24_in_formalArgWithDefaultValue505 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_TRUE_in_formalArgWithDefaultValue509 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_24_in_formalArgWithDefaultValue515 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_FALSE_in_formalArgWithDefaultValue519 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_dictDef544 = new BitSet(new long[]{0x0000000000800000L});
    public static final BitSet FOLLOW_23_in_dictDef546 = new BitSet(new long[]{0x0000000002000000L});
    public static final BitSet FOLLOW_dict_in_dictDef548 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_25_in_dict580 = new BitSet(new long[]{0x0000000008000040L});
    public static final BitSet FOLLOW_dictPairs_in_dict582 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_26_in_dict585 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_keyValuePair_in_dictPairs600 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_18_in_dictPairs609 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_keyValuePair_in_dictPairs611 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_18_in_dictPairs617 = new BitSet(new long[]{0x0000000008000040L});
    public static final BitSet FOLLOW_defaultValuePair_in_dictPairs619 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_defaultValuePair_in_dictPairs630 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_27_in_defaultValuePair653 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_16_in_defaultValuePair655 = new BitSet(new long[]{0x00000000000003F0L});
    public static final BitSet FOLLOW_keyValue_in_defaultValuePair657 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_keyValuePair671 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_16_in_keyValuePair673 = new BitSet(new long[]{0x00000000000003F0L});
    public static final BitSet FOLLOW_keyValue_in_keyValuePair675 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BIGSTRING_in_keyValue692 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ANONYMOUS_TEMPLATE_in_keyValue701 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_keyValue708 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_keyValue718 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_keyValue728 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_keyValue741 = new BitSet(new long[]{0x0000000000000002L});

}