/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import antlr.CharScanner;
import antlr.CommonAST;
import antlr.CommonToken;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import antlr.collections.ASTEnumeration;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.ASTExpr;
import org.antlr.stringtemplate.language.ActionLexer;
import org.antlr.stringtemplate.language.ActionParser;
import org.antlr.stringtemplate.language.ConditionalExpr;
import org.antlr.stringtemplate.language.Expr;
import org.antlr.stringtemplate.language.FormalArgument;
import org.antlr.stringtemplate.language.NewlineRef;
import org.antlr.stringtemplate.language.StringTemplateAST;
import org.antlr.stringtemplate.language.TemplateParser;

public class StringTemplate {
    public static final String VERSION = "2.3b10";
    public static final int REGION_IMPLICIT = 1;
    public static final int REGION_EMBEDDED = 2;
    public static final int REGION_EXPLICIT = 3;
    public static final String ANONYMOUS_ST_NAME = "anonymous";
    static boolean lintMode = false;
    protected List referencedAttributes = null;
    protected String name = "anonymous";
    private static int templateCounter = 0;
    protected int templateID = StringTemplate.getNextTemplateCounter();
    protected StringTemplate enclosingInstance = null;
    protected List embeddedInstances = null;
    protected Map argumentContext = null;
    protected StringTemplateAST argumentsAST = null;
    protected LinkedHashMap formalArguments = FormalArgument.UNKNOWN;
    protected int numberOfDefaultArgumentValues = 0;
    protected boolean passThroughAttributes = false;
    protected StringTemplateGroup nativeGroup;
    protected StringTemplateGroup group = defaultGroup;
    protected int groupFileLine;
    StringTemplateErrorListener listener = null;
    protected String pattern;
    protected Map attributes;
    protected Map attributeRenderers;
    protected List chunks;
    protected int regionDefType;
    protected boolean isRegion;
    protected Set regions;
    public static StringTemplateGroup defaultGroup = new StringTemplateGroup("defaultGroup", ".");

    private static synchronized int getNextTemplateCounter() {
        return ++templateCounter;
    }

    public static void resetTemplateCounter() {
        templateCounter = 0;
    }

    public StringTemplate() {
    }

    public StringTemplate(String string) {
        this(null, string);
    }

    public StringTemplate(String string, Class clazz) {
        this();
        this.setGroup(new StringTemplateGroup("defaultGroup", clazz));
        this.setTemplate(string);
    }

    public StringTemplate(StringTemplateGroup stringTemplateGroup, String string) {
        this();
        if (stringTemplateGroup != null) {
            this.setGroup(stringTemplateGroup);
        }
        this.setTemplate(string);
    }

    public StringTemplate(StringTemplateGroup stringTemplateGroup, String string, HashMap hashMap) {
        this(stringTemplateGroup, string);
        this.attributes = hashMap;
    }

    protected void dup(StringTemplate stringTemplate, StringTemplate stringTemplate2) {
        stringTemplate2.pattern = stringTemplate.pattern;
        stringTemplate2.chunks = stringTemplate.chunks;
        stringTemplate2.formalArguments = stringTemplate.formalArguments;
        stringTemplate2.numberOfDefaultArgumentValues = stringTemplate.numberOfDefaultArgumentValues;
        stringTemplate2.name = stringTemplate.name;
        stringTemplate2.group = stringTemplate.group;
        stringTemplate2.nativeGroup = stringTemplate.nativeGroup;
        stringTemplate2.listener = stringTemplate.listener;
        stringTemplate2.regions = stringTemplate.regions;
        stringTemplate2.isRegion = stringTemplate.isRegion;
        stringTemplate2.regionDefType = stringTemplate.regionDefType;
    }

    public StringTemplate getInstanceOf() {
        StringTemplate stringTemplate = null;
        stringTemplate = this.nativeGroup != null ? this.nativeGroup.createStringTemplate() : this.group.createStringTemplate();
        this.dup(this, stringTemplate);
        return stringTemplate;
    }

    public StringTemplate getEnclosingInstance() {
        return this.enclosingInstance;
    }

    public StringTemplate getOutermostEnclosingInstance() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getOutermostEnclosingInstance();
        }
        return this;
    }

    public void setEnclosingInstance(StringTemplate stringTemplate) {
        if (this == stringTemplate) {
            throw new IllegalArgumentException("cannot embed template " + this.getName() + " in itself");
        }
        this.enclosingInstance = stringTemplate;
        if (stringTemplate != null) {
            this.enclosingInstance.addEmbeddedInstance(this);
        }
    }

    public void addEmbeddedInstance(StringTemplate stringTemplate) {
        if (this.embeddedInstances == null) {
            this.embeddedInstances = new LinkedList();
        }
        this.embeddedInstances.add(stringTemplate);
    }

    public Map getArgumentContext() {
        return this.argumentContext;
    }

    public void setArgumentContext(Map map) {
        this.argumentContext = map;
    }

    public StringTemplateAST getArgumentsAST() {
        return this.argumentsAST;
    }

    public void setArgumentsAST(StringTemplateAST stringTemplateAST) {
        this.argumentsAST = stringTemplateAST;
    }

    public String getName() {
        return this.name;
    }

    public String getOutermostName() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getOutermostName();
        }
        return this.getName();
    }

    public void setName(String string) {
        this.name = string;
    }

    public StringTemplateGroup getGroup() {
        return this.group;
    }

    public void setGroup(StringTemplateGroup stringTemplateGroup) {
        this.group = stringTemplateGroup;
    }

    public StringTemplateGroup getNativeGroup() {
        return this.nativeGroup;
    }

    public void setNativeGroup(StringTemplateGroup stringTemplateGroup) {
        this.nativeGroup = stringTemplateGroup;
    }

    public int getGroupFileLine() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getGroupFileLine();
        }
        return this.groupFileLine;
    }

    public void setGroupFileLine(int n) {
        this.groupFileLine = n;
    }

    public void setTemplate(String string) {
        this.pattern = string;
        this.breakTemplateIntoChunks();
    }

    public String getTemplate() {
        return this.pattern;
    }

    public void setErrorListener(StringTemplateErrorListener stringTemplateErrorListener) {
        this.listener = stringTemplateErrorListener;
    }

    public StringTemplateErrorListener getErrorListener() {
        if (this.listener == null) {
            return this.group.getErrorListener();
        }
        return this.listener;
    }

    public void reset() {
        this.attributes = new HashMap();
    }

    public void setPredefinedAttributes() {
        if (!StringTemplate.inLintMode()) {
            return;
        }
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (object == null || string == null) {
            return;
        }
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in attribute names");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (object instanceof StringTemplate) {
            ((StringTemplate)object).setEnclosingInstance(this);
        } else {
            object = ASTExpr.convertArrayToList(object);
        }
        Object v = this.attributes.get(string);
        if (v == null) {
            this.rawSetAttribute(this.attributes, string, object);
            return;
        }
        STAttributeList sTAttributeList = null;
        if (v.getClass() == STAttributeList.class) {
            sTAttributeList = (STAttributeList)v;
        } else if (v instanceof List) {
            List list = (List)v;
            sTAttributeList = new STAttributeList(list.size());
            sTAttributeList.addAll(list);
            this.rawSetAttribute(this.attributes, string, sTAttributeList);
        } else {
            sTAttributeList = new STAttributeList();
            this.rawSetAttribute(this.attributes, string, sTAttributeList);
            sTAttributeList.add(v);
        }
        if (object instanceof List) {
            if (sTAttributeList != object) {
                sTAttributeList.addAll((List)object);
            }
        } else {
            sTAttributeList.add(object);
        }
    }

    public void setAttribute(String string, int n) {
        this.setAttribute(string, new Integer(n));
    }

    public void setAttribute(String string, Object object, Object object2) {
        this.setAttribute(string, new Object[]{object, object2});
    }

    public void setAttribute(String string, Object object, Object object2, Object object3) {
        this.setAttribute(string, new Object[]{object, object2, object3});
    }

    public void setAttribute(String string, Object object, Object object2, Object object3, Object object4) {
        this.setAttribute(string, new Object[]{object, object2, object3, object4});
    }

    public void setAttribute(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        this.setAttribute(string, new Object[]{object, object2, object3, object4, object5});
    }

    protected void setAttribute(String string, Object[] objectArray) {
        ArrayList arrayList = new ArrayList();
        String string2 = this.parseAggregateAttributeSpec(string, arrayList);
        if (objectArray == null || arrayList.size() == 0) {
            throw new IllegalArgumentException("missing properties or values for '" + string + "'");
        }
        if (objectArray.length != arrayList.size()) {
            throw new IllegalArgumentException("number of properties in '" + string + "' != number of values");
        }
        Aggregate aggregate = new Aggregate();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof StringTemplate) {
                ((StringTemplate)object).setEnclosingInstance(this);
            } else {
                object = ASTExpr.convertArrayToList(object);
            }
            aggregate.put((String)arrayList.get(i), object);
        }
        this.setAttribute(string2, aggregate);
    }

    protected String parseAggregateAttributeSpec(String string, List list) {
        int n = string.indexOf(46);
        if (n <= 0) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "{,}", true);
        if (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if ((string4 = string4.trim()).equals("{")) {
                string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                list.add(string4);
                string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                while (string4.equals(",")) {
                    string4 = stringTokenizer.nextToken();
                    string4 = string4.trim();
                    list.add(string4);
                    string4 = stringTokenizer.nextToken();
                    string4 = string4.trim();
                }
                if (string4.equals("}")) {
                    bl = false;
                }
            }
        }
        if (bl) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + string);
        }
        return string2;
    }

    protected void rawSetAttribute(Map map, String string, Object object) {
        if (this.formalArguments != FormalArgument.UNKNOWN && this.getFormalArgument(string) == null) {
            throw new NoSuchElementException("no such attribute: " + string + " in template context " + this.getEnclosingInstanceStackString());
        }
        if (object == null) {
            return;
        }
        map.put(string, object);
    }

    public void rawSetArgumentAttribute(StringTemplate stringTemplate, Map map, String string, Object object) {
        if (stringTemplate.formalArguments != FormalArgument.UNKNOWN && stringTemplate.getFormalArgument(string) == null) {
            throw new NoSuchElementException("template " + stringTemplate.getName() + " has no such attribute: " + string + " in template context " + this.getEnclosingInstanceStackString());
        }
        if (object == null) {
            return;
        }
        map.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.get(this, string);
    }

    public int write(StringTemplateWriter stringTemplateWriter) throws IOException {
        if (this.group.debugTemplateOutput) {
            this.group.emitTemplateStartDebugString(this, stringTemplateWriter);
        }
        int n = 0;
        this.setPredefinedAttributes();
        this.setDefaultArgumentValues();
        for (int i = 0; this.chunks != null && i < this.chunks.size(); ++i) {
            Expr expr = (Expr)this.chunks.get(i);
            int n2 = expr.write(this, stringTemplateWriter);
            if (n2 == 0 && i == 0 && i + 1 < this.chunks.size() && this.chunks.get(i + 1) instanceof NewlineRef) {
                ++i;
                continue;
            }
            if (n2 == 0 && i - 1 >= 0 && this.chunks.get(i - 1) instanceof NewlineRef && i + 1 < this.chunks.size() && this.chunks.get(i + 1) instanceof NewlineRef) {
                ++i;
            }
            n += n2;
        }
        if (this.group.debugTemplateOutput) {
            this.group.emitTemplateStopDebugString(this, stringTemplateWriter);
        }
        if (lintMode) {
            this.checkForTrouble();
        }
        return n;
    }

    public Object get(StringTemplate stringTemplate, String string) {
        Object object;
        if (stringTemplate == null) {
            return null;
        }
        if (lintMode) {
            stringTemplate.trackAttributeReference(string);
        }
        Object object2 = null;
        if (stringTemplate.attributes != null) {
            object2 = stringTemplate.attributes.get(string);
        }
        if (object2 == null && (object = stringTemplate.getArgumentContext()) != null) {
            object2 = object.get(string);
        }
        if (object2 == null && !stringTemplate.passThroughAttributes && stringTemplate.getFormalArgument(string) != null) {
            return null;
        }
        if (object2 == null && stringTemplate.enclosingInstance != null) {
            object = this.get(stringTemplate.enclosingInstance, string);
            if (object == null) {
                this.checkNullAttributeAgainstFormalArguments(stringTemplate, string);
            }
            object2 = object;
        } else if (object2 == null && stringTemplate.enclosingInstance == null) {
            object2 = stringTemplate.group.getMap(string);
        }
        return object2;
    }

    protected void breakTemplateIntoChunks() {
        if (this.pattern == null) {
            return;
        }
        try {
            Class clazz = this.group.getTemplateLexerClass();
            Constructor constructor = clazz.getConstructor(StringTemplate.class, Reader.class);
            CharScanner charScanner = (CharScanner)constructor.newInstance(this, new StringReader(this.pattern));
            charScanner.setTokenObjectClass("org.antlr.stringtemplate.language.ChunkToken");
            TemplateParser templateParser = new TemplateParser((TokenStream)charScanner);
            templateParser.template(this);
        }
        catch (Exception exception) {
            String string = "<unknown>";
            String string2 = this.getOutermostName();
            if (this.getName() != null) {
                string = this.getName();
            }
            if (string2 != null && !string.equals(string2)) {
                string = string + " nested in " + string2;
            }
            this.error("problem parsing template '" + string + "'", exception);
        }
    }

    public ASTExpr parseAction(String string) {
        ActionLexer actionLexer = new ActionLexer(new StringReader(string.toString()));
        ActionParser actionParser = new ActionParser((TokenStream)actionLexer, this);
        actionParser.setASTNodeClass("org.antlr.stringtemplate.language.StringTemplateAST");
        actionLexer.setTokenObjectClass("org.antlr.stringtemplate.language.StringTemplateToken");
        ASTExpr aSTExpr = null;
        try {
            Map map = actionParser.action();
            AST aST = actionParser.getAST();
            if (aST != null) {
                aSTExpr = aST.getType() == 8 ? new ConditionalExpr(this, aST) : new ASTExpr(this, aST, map);
            }
        }
        catch (RecognitionException recognitionException) {
            this.error("Can't parse chunk: " + string.toString(), recognitionException);
        }
        catch (TokenStreamException tokenStreamException) {
            this.error("Can't parse chunk: " + string.toString(), tokenStreamException);
        }
        return aSTExpr;
    }

    public int getTemplateID() {
        return this.templateID;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public List getChunks() {
        return this.chunks;
    }

    public void addChunk(Expr expr) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        this.chunks.add(expr);
    }

    public void setAttributes(Map map) {
        this.attributes = map;
    }

    public Map getFormalArguments() {
        return this.formalArguments;
    }

    public void setFormalArguments(LinkedHashMap linkedHashMap) {
        this.formalArguments = linkedHashMap;
    }

    public void setDefaultArgumentValues() {
        if (this.numberOfDefaultArgumentValues == 0) {
            return;
        }
        if (this.argumentContext == null) {
            this.argumentContext = new HashMap();
        }
        if (this.formalArguments != FormalArgument.UNKNOWN) {
            Set set = this.formalArguments.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                FormalArgument formalArgument = (FormalArgument)this.formalArguments.get(string);
                if (formalArgument.defaultValueST == null || (object = this.getAttribute(string)) != null) continue;
                this.argumentContext.put(string, formalArgument.defaultValueST);
            }
        }
    }

    public FormalArgument lookupFormalArgument(String string) {
        FormalArgument formalArgument = this.getFormalArgument(string);
        if (formalArgument == null && this.enclosingInstance != null) {
            formalArgument = this.enclosingInstance.lookupFormalArgument(string);
        }
        return formalArgument;
    }

    public FormalArgument getFormalArgument(String string) {
        return (FormalArgument)this.formalArguments.get(string);
    }

    public void defineEmptyFormalArgumentList() {
        this.setFormalArguments(new LinkedHashMap());
    }

    public void defineFormalArgument(String string) {
        this.defineFormalArgument(string, null);
    }

    public void defineFormalArguments(List list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            this.defineFormalArgument(string);
        }
    }

    public void defineFormalArgument(String string, StringTemplate stringTemplate) {
        if (stringTemplate != null) {
            ++this.numberOfDefaultArgumentValues;
        }
        FormalArgument formalArgument = new FormalArgument(string, stringTemplate);
        if (this.formalArguments == FormalArgument.UNKNOWN) {
            this.formalArguments = new LinkedHashMap();
        }
        this.formalArguments.put(string, formalArgument);
    }

    public void setPassThroughAttributes(boolean bl) {
        this.passThroughAttributes = bl;
    }

    public void setAttributeRenderers(Map map) {
        this.attributeRenderers = map;
    }

    public void registerRenderer(Class clazz, AttributeRenderer attributeRenderer) {
        if (this.attributeRenderers == null) {
            this.attributeRenderers = new HashMap();
        }
        this.attributeRenderers.put(clazz, attributeRenderer);
    }

    public AttributeRenderer getAttributeRenderer(Class clazz) {
        AttributeRenderer attributeRenderer = null;
        if (this.attributeRenderers != null) {
            attributeRenderer = (AttributeRenderer)this.attributeRenderers.get(clazz);
        }
        if (attributeRenderer != null) {
            return attributeRenderer;
        }
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getAttributeRenderer(clazz);
        }
        return this.group.getAttributeRenderer(clazz);
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void warning(String string) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().warning(string);
        } else {
            System.err.println("StringTemplate: warning: " + string);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().error(string, throwable);
        } else if (throwable != null) {
            System.err.println("StringTemplate: error: " + string + ": " + throwable.toString());
            if (throwable instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)throwable).getTargetException();
            }
            throwable.printStackTrace(System.err);
        } else {
            System.err.println("StringTemplate: error: " + string);
        }
    }

    public static void setLintMode(boolean bl) {
        lintMode = bl;
    }

    public static boolean inLintMode() {
        return lintMode;
    }

    protected void trackAttributeReference(String string) {
        if (this.referencedAttributes == null) {
            this.referencedAttributes = new ArrayList();
        }
        this.referencedAttributes.add(string);
    }

    public static boolean isRecursiveEnclosingInstance(StringTemplate stringTemplate) {
        if (stringTemplate == null) {
            return false;
        }
        StringTemplate stringTemplate2 = stringTemplate.enclosingInstance;
        if (stringTemplate2 == stringTemplate) {
            return true;
        }
        while (stringTemplate2 != null) {
            if (stringTemplate2 == stringTemplate) {
                return true;
            }
            stringTemplate2 = stringTemplate2.enclosingInstance;
        }
        return false;
    }

    public String getEnclosingInstanceStackTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<StringTemplate> hashSet = new HashSet<StringTemplate>();
        StringTemplate stringTemplate = this;
        while (stringTemplate != null) {
            if (hashSet.contains(stringTemplate)) {
                stringBuffer.append(stringTemplate.getTemplateDeclaratorString());
                stringBuffer.append(" (start of recursive cycle)");
                stringBuffer.append("\n");
                stringBuffer.append("...");
                break;
            }
            hashSet.add(stringTemplate);
            stringBuffer.append(stringTemplate.getTemplateDeclaratorString());
            if (stringTemplate.attributes != null) {
                stringBuffer.append(", attributes=[");
                int n = 0;
                Iterator iterator = stringTemplate.attributes.keySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String string = (String)iterator.next();
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    ++n;
                    stringBuffer.append(string);
                    Object v = stringTemplate.attributes.get(string);
                    if (v instanceof StringTemplate) {
                        object = (StringTemplate)v;
                        stringBuffer.append("=");
                        stringBuffer.append("<");
                        stringBuffer.append(((StringTemplate)object).getName());
                        stringBuffer.append("()@");
                        stringBuffer.append(String.valueOf(((StringTemplate)object).getTemplateID()));
                        stringBuffer.append(">");
                        continue;
                    }
                    if (!(v instanceof List)) continue;
                    stringBuffer.append("=List[..");
                    object = (List)v;
                    int n2 = 0;
                    for (int i = 0; i < object.size(); ++i) {
                        Object e = object.get(i);
                        if (!(e instanceof StringTemplate)) continue;
                        if (n2 > 0) {
                            stringBuffer.append(", ");
                        }
                        ++n2;
                        StringTemplate stringTemplate2 = (StringTemplate)e;
                        stringBuffer.append("<");
                        stringBuffer.append(stringTemplate2.getName());
                        stringBuffer.append("()@");
                        stringBuffer.append(String.valueOf(stringTemplate2.getTemplateID()));
                        stringBuffer.append(">");
                    }
                    stringBuffer.append("..]");
                }
                stringBuffer.append("]");
            }
            if (stringTemplate.referencedAttributes != null) {
                stringBuffer.append(", references=");
                stringBuffer.append(stringTemplate.referencedAttributes);
            }
            stringBuffer.append(">\n");
            stringTemplate = stringTemplate.enclosingInstance;
        }
        return stringBuffer.toString();
    }

    public String getTemplateDeclaratorString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        stringBuffer.append(this.formalArguments.keySet());
        stringBuffer.append(")@");
        stringBuffer.append(String.valueOf(this.getTemplateID()));
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    protected String getTemplateHeaderString(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getName());
            if (this.attributes != null) {
                stringBuffer.append(this.attributes.keySet());
            }
            return stringBuffer.toString();
        }
        return this.getName();
    }

    protected void checkNullAttributeAgainstFormalArguments(StringTemplate stringTemplate, String string) {
        if (stringTemplate.getFormalArguments() == FormalArgument.UNKNOWN) {
            if (stringTemplate.enclosingInstance != null) {
                this.checkNullAttributeAgainstFormalArguments(stringTemplate.enclosingInstance, string);
            }
            return;
        }
        FormalArgument formalArgument = stringTemplate.lookupFormalArgument(string);
        if (formalArgument == null) {
            throw new NoSuchElementException("no such attribute: " + string + " in template context " + this.getEnclosingInstanceStackString());
        }
    }

    protected void checkForTrouble() {
        if (this.attributes == null) {
            return;
        }
        Set set = this.attributes.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.referencedAttributes == null || this.referencedAttributes.contains(string)) continue;
            this.warning(this.getName() + ": set but not used: " + string);
        }
    }

    public String getEnclosingInstanceStackString() {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringTemplate stringTemplate = this;
        while (stringTemplate != null) {
            String string = stringTemplate.getName();
            linkedList.add(0, string + (stringTemplate.passThroughAttributes ? "(...)" : ""));
            stringTemplate = stringTemplate.enclosingInstance;
        }
        return ((Object)linkedList).toString().replaceAll(",", "");
    }

    public boolean isRegion() {
        return this.isRegion;
    }

    public void setIsRegion(boolean bl) {
        this.isRegion = bl;
    }

    public void addRegionName(String string) {
        if (this.regions == null) {
            this.regions = new HashSet();
        }
        this.regions.add(string);
    }

    public boolean containsRegionName(String string) {
        if (this.regions == null) {
            return false;
        }
        return this.regions.contains(string);
    }

    public int getRegionDefType() {
        return this.regionDefType;
    }

    public void setRegionDefType(int n) {
        this.regionDefType = n;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template-" + this.getTemplateDeclaratorString() + ":");
        stringBuffer.append("chunks=");
        if (this.chunks != null) {
            stringBuffer.append(this.chunks.toString());
        }
        stringBuffer.append("attributes=[");
        if (this.attributes != null) {
            Set set = this.attributes.keySet();
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                String string = (String)iterator.next();
                stringBuffer.append(string + "=");
                Object v = this.attributes.get(string);
                if (v instanceof StringTemplate) {
                    stringBuffer.append(((StringTemplate)v).toDebugString());
                } else {
                    stringBuffer.append(v);
                }
                ++n;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String toStructureString() {
        return this.toStructureString(0);
    }

    public String toStructureString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(this.getName());
        stringBuffer.append(this.attributes.keySet());
        stringBuffer.append(":\n");
        if (this.attributes != null) {
            Set set = this.attributes.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Iterator<Object> iterator2;
                Object object;
                String string = (String)iterator.next();
                Object v = this.attributes.get(string);
                if (v instanceof StringTemplate) {
                    stringBuffer.append(((StringTemplate)v).toStructureString(n + 1));
                    continue;
                }
                if (v instanceof List) {
                    object = (List)v;
                    for (int i = 0; i < object.size(); ++i) {
                        iterator2 = object.get(i);
                        if (!(iterator2 instanceof StringTemplate)) continue;
                        stringBuffer.append(((StringTemplate)((Object)iterator2)).toStructureString(n + 1));
                    }
                    continue;
                }
                if (!(v instanceof Map)) continue;
                object = (Map)v;
                Collection collection = object.values();
                iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Object object2 = iterator2.next();
                    if (!(object2 instanceof StringTemplate)) continue;
                    stringBuffer.append(((StringTemplate)object2).toStructureString(n + 1));
                }
            }
        }
        return stringBuffer.toString();
    }

    public StringTemplate getDOTForDependencyGraph(boolean bl) {
        String string = "digraph StringTemplateDependencyGraph {\nnode [shape=$shape$, $if(width)$width=$width$,$endif$      $if(height)$height=$height$,$endif$ fontsize=$fontsize$];\n$edges:{e|\"$e.src$\" -> \"$e.trg$\"\n}$}\n";
        StringTemplate stringTemplate = new StringTemplate(string);
        HashMap hashMap = new HashMap();
        this.getDependencyGraph(hashMap, bl);
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Set set2 = (Set)hashMap.get(string2);
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                stringTemplate.setAttribute("edges.{src,trg}", string2, string3);
            }
        }
        stringTemplate.setAttribute("shape", "none");
        stringTemplate.setAttribute("fontsize", "11");
        stringTemplate.setAttribute("height", "0");
        return stringTemplate;
    }

    public void getDependencyGraph(Map map, boolean bl) {
        Object object;
        Object object2;
        Iterator<Object> iterator;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string = this.getTemplateHeaderString(bl);
        if (this.attributes != null) {
            Set set = this.attributes.keySet();
            object6 = set.iterator();
            while (object6.hasNext()) {
                object5 = (String)object6.next();
                object4 = this.attributes.get(object5);
                if (object4 instanceof StringTemplate) {
                    object3 = ((StringTemplate)object4).getTemplateHeaderString(bl);
                    this.putToMultiValuedMap(map, string, object3);
                    ((StringTemplate)object4).getDependencyGraph(map, bl);
                    continue;
                }
                if (object4 instanceof List) {
                    object3 = (List)object4;
                    for (int i = 0; i < object3.size(); ++i) {
                        iterator = object3.get(i);
                        if (!(iterator instanceof StringTemplate)) continue;
                        object2 = ((StringTemplate)((Object)iterator)).getTemplateHeaderString(bl);
                        this.putToMultiValuedMap(map, string, object2);
                        ((StringTemplate)((Object)iterator)).getDependencyGraph(map, bl);
                    }
                    continue;
                }
                if (!(object4 instanceof Map)) continue;
                object3 = (Map)object4;
                Collection collection = object3.values();
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    if (!(object2 instanceof StringTemplate)) continue;
                    object = ((StringTemplate)object2).getTemplateHeaderString(bl);
                    this.putToMultiValuedMap(map, string, object);
                    ((StringTemplate)object2).getDependencyGraph(map, bl);
                }
            }
        }
        for (int i = 0; this.chunks != null && i < this.chunks.size(); ++i) {
            object6 = (Expr)this.chunks.get(i);
            if (!(object6 instanceof ASTExpr)) continue;
            object5 = (ASTExpr)object6;
            object4 = ((ASTExpr)object5).getAST();
            object3 = new CommonAST((Token)new CommonToken(7, "include"));
            ASTEnumeration aSTEnumeration = object4.findAllPartial((AST)object3);
            while (aSTEnumeration.hasMoreNodes()) {
                iterator = aSTEnumeration.nextNode();
                object2 = iterator.getFirstChild().getText();
                System.out.println("found include " + (String)object2);
                this.putToMultiValuedMap(map, string, object2);
                object = this.getGroup();
                if (object == null) continue;
                StringTemplate stringTemplate = ((StringTemplateGroup)object).getInstanceOf((String)object2);
                stringTemplate.getDependencyGraph(map, bl);
            }
        }
    }

    protected void putToMultiValuedMap(Map map, Object object, Object object2) {
        HashSet<Object> hashSet = (HashSet<Object>)map.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            map.put(object, hashSet);
        }
        hashSet.add(object2);
    }

    public void printDebugString() {
        System.out.println("template-" + this.getName() + ":");
        System.out.print("chunks=");
        System.out.println(this.chunks.toString());
        if (this.attributes == null) {
            return;
        }
        System.out.print("attributes=[");
        Set set = this.attributes.keySet();
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            Object v;
            if (n > 0) {
                System.out.print(',');
            }
            if ((v = this.attributes.get(string = (String)iterator.next())) instanceof StringTemplate) {
                System.out.print(string + "=");
                ((StringTemplate)v).printDebugString();
            } else if (v instanceof List) {
                ArrayList arrayList = (ArrayList)v;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e = arrayList.get(i);
                    System.out.print(string + "[" + i + "] is " + e.getClass().getName() + "=");
                    if (e instanceof StringTemplate) {
                        ((StringTemplate)e).printDebugString();
                        continue;
                    }
                    System.out.println(e);
                }
            } else {
                System.out.print(string + "=");
                System.out.println(v);
            }
            ++n;
        }
        System.out.print("]\n");
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int n) {
        StringWriter stringWriter = new StringWriter();
        StringTemplateWriter stringTemplateWriter = this.group.getStringTemplateWriter(stringWriter);
        stringTemplateWriter.setLineWidth(n);
        try {
            this.write(stringTemplateWriter);
        }
        catch (IOException iOException) {
            this.error("Got IOException writing to writer " + stringTemplateWriter.getClass().getName());
        }
        stringTemplateWriter.setLineWidth(-1);
        return stringWriter.toString();
    }

    public static final class STAttributeList
    extends ArrayList {
        public STAttributeList(int n) {
            super(n);
        }

        public STAttributeList() {
        }
    }

    public static final class Aggregate {
        protected HashMap properties = new HashMap();

        protected void put(String string, Object object) {
            this.properties.put(string, object);
        }

        public Object get(String string) {
            return this.properties.get(string);
        }

        public String toString() {
            return this.properties.toString();
        }
    }
}

