// $ANTLR 3.5-rc-2 org\\antlr\\v4\\parse\\ANTLRParser.g 2012-12-16 17:30:45

/*
 [The "BSD licence"]
 Copyright (c) 2005-20012 Terence Parr
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package org.antlr.v4.parse;

import org.antlr.v4.tool.*;
import org.antlr.v4.tool.ast.*;

import java.util.ArrayDeque;
import java.util.Deque;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/** The definitive ANTLR v3 grammar to parse ANTLR v4 grammars.
 *  The grammar builds ASTs that are sniffed by subsequent stages.
 */
@SuppressWarnings("all")
public class ANTLRParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTION", "ACTION_CHAR_LITERAL", 
		"ACTION_ESC", "ACTION_STRING_LITERAL", "ARG_ACTION", "ARG_OR_CHARSET", 
		"ASSIGN", "AT", "CATCH", "COLON", "COLONCOLON", "COMMA", "COMMENT", "DOC_COMMENT", 
		"DOLLAR", "DOT", "ERRCHAR", "ESC_SEQ", "FINALLY", "FRAGMENT", "GRAMMAR", 
		"GT", "HEX_DIGIT", "ID", "IMPORT", "INT", "LEXER", "LEXER_CHAR_SET", "LOCALS", 
		"LPAREN", "LT", "MODE", "NESTED_ACTION", "NLCHARS", "NOT", "NameChar", 
		"NameStartChar", "OPTIONS", "OR", "PARSER", "PLUS", "PLUS_ASSIGN", "POUND", 
		"PRIVATE", "PROTECTED", "PUBLIC", "QUESTION", "RANGE", "RARROW", "RBRACE", 
		"RETURNS", "RPAREN", "RULE_REF", "SEMI", "SEMPRED", "SRC", "STAR", "STRING_LITERAL", 
		"SYNPRED", "THROWS", "TOKENS_SPEC", "TOKEN_REF", "TREE_GRAMMAR", "UNICODE_ESC", 
		"WS", "WSCHARS", "WSNLCHARS", "ALT", "ALTLIST", "ARG", "ARGLIST", "BLOCK", 
		"CHAR_RANGE", "CLOSURE", "COMBINED", "ELEMENT_OPTIONS", "EPSILON", "INITACTION", 
		"LABEL", "LEXER_ACTION_CALL", "LEXER_ALT_ACTION", "LIST", "OPTIONAL", 
		"POSITIVE_CLOSURE", "PREC_RULE", "RESULT", "RET", "RULE", "RULEACTIONS", 
		"RULEMODIFIERS", "RULES", "SET", "TEMPLATE", "WILDCARD"
	};
	public static final int EOF=-1;
	public static final int ACTION=4;
	public static final int ACTION_CHAR_LITERAL=5;
	public static final int ACTION_ESC=6;
	public static final int ACTION_STRING_LITERAL=7;
	public static final int ARG_ACTION=8;
	public static final int ARG_OR_CHARSET=9;
	public static final int ASSIGN=10;
	public static final int AT=11;
	public static final int CATCH=12;
	public static final int COLON=13;
	public static final int COLONCOLON=14;
	public static final int COMMA=15;
	public static final int COMMENT=16;
	public static final int DOC_COMMENT=17;
	public static final int DOLLAR=18;
	public static final int DOT=19;
	public static final int ERRCHAR=20;
	public static final int ESC_SEQ=21;
	public static final int FINALLY=22;
	public static final int FRAGMENT=23;
	public static final int GRAMMAR=24;
	public static final int GT=25;
	public static final int HEX_DIGIT=26;
	public static final int ID=27;
	public static final int IMPORT=28;
	public static final int INT=29;
	public static final int LEXER=30;
	public static final int LEXER_CHAR_SET=31;
	public static final int LOCALS=32;
	public static final int LPAREN=33;
	public static final int LT=34;
	public static final int MODE=35;
	public static final int NESTED_ACTION=36;
	public static final int NLCHARS=37;
	public static final int NOT=38;
	public static final int NameChar=39;
	public static final int NameStartChar=40;
	public static final int OPTIONS=41;
	public static final int OR=42;
	public static final int PARSER=43;
	public static final int PLUS=44;
	public static final int PLUS_ASSIGN=45;
	public static final int POUND=46;
	public static final int PRIVATE=47;
	public static final int PROTECTED=48;
	public static final int PUBLIC=49;
	public static final int QUESTION=50;
	public static final int RANGE=51;
	public static final int RARROW=52;
	public static final int RBRACE=53;
	public static final int RETURNS=54;
	public static final int RPAREN=55;
	public static final int RULE_REF=56;
	public static final int SEMI=57;
	public static final int SEMPRED=58;
	public static final int SRC=59;
	public static final int STAR=60;
	public static final int STRING_LITERAL=61;
	public static final int SYNPRED=62;
	public static final int THROWS=63;
	public static final int TOKENS_SPEC=64;
	public static final int TOKEN_REF=65;
	public static final int TREE_GRAMMAR=66;
	public static final int UNICODE_ESC=67;
	public static final int WS=68;
	public static final int WSCHARS=69;
	public static final int WSNLCHARS=70;
	public static final int ALT=71;
	public static final int ALTLIST=72;
	public static final int ARG=73;
	public static final int ARGLIST=74;
	public static final int BLOCK=75;
	public static final int CHAR_RANGE=76;
	public static final int CLOSURE=77;
	public static final int COMBINED=78;
	public static final int ELEMENT_OPTIONS=79;
	public static final int EPSILON=80;
	public static final int INITACTION=81;
	public static final int LABEL=82;
	public static final int LEXER_ACTION_CALL=83;
	public static final int LEXER_ALT_ACTION=84;
	public static final int LIST=85;
	public static final int OPTIONAL=86;
	public static final int POSITIVE_CLOSURE=87;
	public static final int PREC_RULE=88;
	public static final int RESULT=89;
	public static final int RET=90;
	public static final int RULE=91;
	public static final int RULEACTIONS=92;
	public static final int RULEMODIFIERS=93;
	public static final int RULES=94;
	public static final int SET=95;
	public static final int TEMPLATE=96;
	public static final int WILDCARD=97;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public ANTLRParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public ANTLRParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}
	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}
	@Override public String[] getTokenNames() { return ANTLRParser.tokenNames; }
	@Override public String getGrammarFileName() { return "org\\antlr\\v4\\parse\\ANTLRParser.g"; }


	Deque<String> paraphrases = new ArrayDeque<String>();
	public void grammarError(ErrorType etype, org.antlr.runtime.Token token, Object... args) { }


	public static class grammarSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "grammarSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:146:1: grammarSpec : ( DOC_COMMENT )? grammarType id SEMI sync ( prequelConstruct sync )* rules ( modeSpec )* EOF -> ^( grammarType id ( DOC_COMMENT )? ( prequelConstruct )* rules ( modeSpec )* ) ;
	public final ANTLRParser.grammarSpec_return grammarSpec() throws RecognitionException {
		ANTLRParser.grammarSpec_return retval = new ANTLRParser.grammarSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOC_COMMENT1=null;
		Token SEMI4=null;
		Token EOF10=null;
		ParserRuleReturnScope grammarType2 =null;
		ParserRuleReturnScope id3 =null;
		ParserRuleReturnScope sync5 =null;
		ParserRuleReturnScope prequelConstruct6 =null;
		ParserRuleReturnScope sync7 =null;
		ParserRuleReturnScope rules8 =null;
		ParserRuleReturnScope modeSpec9 =null;

		GrammarAST DOC_COMMENT1_tree=null;
		GrammarAST SEMI4_tree=null;
		GrammarAST EOF10_tree=null;
		RewriteRuleTokenStream stream_DOC_COMMENT=new RewriteRuleTokenStream(adaptor,"token DOC_COMMENT");
		RewriteRuleTokenStream stream_EOF=new RewriteRuleTokenStream(adaptor,"token EOF");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_sync=new RewriteRuleSubtreeStream(adaptor,"rule sync");
		RewriteRuleSubtreeStream stream_modeSpec=new RewriteRuleSubtreeStream(adaptor,"rule modeSpec");
		RewriteRuleSubtreeStream stream_prequelConstruct=new RewriteRuleSubtreeStream(adaptor,"rule prequelConstruct");
		RewriteRuleSubtreeStream stream_grammarType=new RewriteRuleSubtreeStream(adaptor,"rule grammarType");
		RewriteRuleSubtreeStream stream_rules=new RewriteRuleSubtreeStream(adaptor,"rule rules");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:153:5: ( ( DOC_COMMENT )? grammarType id SEMI sync ( prequelConstruct sync )* rules ( modeSpec )* EOF -> ^( grammarType id ( DOC_COMMENT )? ( prequelConstruct )* rules ( modeSpec )* ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:157:7: ( DOC_COMMENT )? grammarType id SEMI sync ( prequelConstruct sync )* rules ( modeSpec )* EOF
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:157:7: ( DOC_COMMENT )?
			int alt1=2;
			switch ( input.LA(1) ) {
				case DOC_COMMENT:
					{
					alt1=1;
					}
					break;
			}
			switch (alt1) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:157:7: DOC_COMMENT
					{
					DOC_COMMENT1=(Token)match(input,DOC_COMMENT,FOLLOW_DOC_COMMENT_in_grammarSpec402);  
					stream_DOC_COMMENT.add(DOC_COMMENT1);

					}
					break;

			}

			pushFollow(FOLLOW_grammarType_in_grammarSpec433);
			grammarType2=grammarType();
			state._fsp--;

			stream_grammarType.add(grammarType2.getTree());
			pushFollow(FOLLOW_id_in_grammarSpec435);
			id3=id();
			state._fsp--;

			stream_id.add(id3.getTree());
			SEMI4=(Token)match(input,SEMI,FOLLOW_SEMI_in_grammarSpec437);  
			stream_SEMI.add(SEMI4);

			pushFollow(FOLLOW_sync_in_grammarSpec475);
			sync5=sync();
			state._fsp--;

			stream_sync.add(sync5.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:175:12: ( prequelConstruct sync )*
			loop2:
			while (true) {
				int alt2=2;
				switch ( input.LA(1) ) {
				case AT:
				case IMPORT:
				case OPTIONS:
				case TOKENS_SPEC:
					{
					alt2=1;
					}
					break;
				}
				switch (alt2) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:175:14: prequelConstruct sync
					{
					pushFollow(FOLLOW_prequelConstruct_in_grammarSpec479);
					prequelConstruct6=prequelConstruct();
					state._fsp--;

					stream_prequelConstruct.add(prequelConstruct6.getTree());
					pushFollow(FOLLOW_sync_in_grammarSpec481);
					sync7=sync();
					state._fsp--;

					stream_sync.add(sync7.getTree());
					}
					break;

				default :
					break loop2;
				}
			}

			pushFollow(FOLLOW_rules_in_grammarSpec506);
			rules8=rules();
			state._fsp--;

			stream_rules.add(rules8.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:183:4: ( modeSpec )*
			loop3:
			while (true) {
				int alt3=2;
				switch ( input.LA(1) ) {
				case MODE:
					{
					alt3=1;
					}
					break;
				}
				switch (alt3) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:183:4: modeSpec
					{
					pushFollow(FOLLOW_modeSpec_in_grammarSpec512);
					modeSpec9=modeSpec();
					state._fsp--;

					stream_modeSpec.add(modeSpec9.getTree());
					}
					break;

				default :
					break loop3;
				}
			}

			EOF10=(Token)match(input,EOF,FOLLOW_EOF_in_grammarSpec550);  
			stream_EOF.add(EOF10);

			// AST REWRITE
			// elements: grammarType, rules, id, DOC_COMMENT, prequelConstruct, modeSpec
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 196:7: -> ^( grammarType id ( DOC_COMMENT )? ( prequelConstruct )* rules ( modeSpec )* )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:196:10: ^( grammarType id ( DOC_COMMENT )? ( prequelConstruct )* rules ( modeSpec )* )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_grammarType.nextNode(), root_1);
				adaptor.addChild(root_1, stream_id.nextTree());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:198:14: ( DOC_COMMENT )?
				if ( stream_DOC_COMMENT.hasNext() ) {
					adaptor.addChild(root_1, stream_DOC_COMMENT.nextNode());
				}
				stream_DOC_COMMENT.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:199:14: ( prequelConstruct )*
				while ( stream_prequelConstruct.hasNext() ) {
					adaptor.addChild(root_1, stream_prequelConstruct.nextTree());
				}
				stream_prequelConstruct.reset();

				adaptor.addChild(root_1, stream_rules.nextTree());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:201:14: ( modeSpec )*
				while ( stream_modeSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_modeSpec.nextTree());
				}
				stream_modeSpec.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.OPTIONS);
			if ( options!=null ) {
				Grammar.setNodeOptions(retval.tree, options);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "grammarSpec"


	public static class grammarType_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "grammarType"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:205:1: grammarType : (t= LEXER g= GRAMMAR -> GRAMMAR[$g, \"LEXER_GRAMMAR\"] |t= PARSER g= GRAMMAR -> GRAMMAR[$g, \"PARSER_GRAMMAR\"] |g= GRAMMAR -> GRAMMAR[$g, \"COMBINED_GRAMMAR\"] |tg= TREE_GRAMMAR ) ;
	public final ANTLRParser.grammarType_return grammarType() throws RecognitionException {
		ANTLRParser.grammarType_return retval = new ANTLRParser.grammarType_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token t=null;
		Token g=null;
		Token tg=null;

		GrammarAST t_tree=null;
		GrammarAST g_tree=null;
		GrammarAST tg_tree=null;
		RewriteRuleTokenStream stream_TREE_GRAMMAR=new RewriteRuleTokenStream(adaptor,"token TREE_GRAMMAR");
		RewriteRuleTokenStream stream_PARSER=new RewriteRuleTokenStream(adaptor,"token PARSER");
		RewriteRuleTokenStream stream_LEXER=new RewriteRuleTokenStream(adaptor,"token LEXER");
		RewriteRuleTokenStream stream_GRAMMAR=new RewriteRuleTokenStream(adaptor,"token GRAMMAR");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:211:5: ( (t= LEXER g= GRAMMAR -> GRAMMAR[$g, \"LEXER_GRAMMAR\"] |t= PARSER g= GRAMMAR -> GRAMMAR[$g, \"PARSER_GRAMMAR\"] |g= GRAMMAR -> GRAMMAR[$g, \"COMBINED_GRAMMAR\"] |tg= TREE_GRAMMAR ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:211:7: (t= LEXER g= GRAMMAR -> GRAMMAR[$g, \"LEXER_GRAMMAR\"] |t= PARSER g= GRAMMAR -> GRAMMAR[$g, \"PARSER_GRAMMAR\"] |g= GRAMMAR -> GRAMMAR[$g, \"COMBINED_GRAMMAR\"] |tg= TREE_GRAMMAR )
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:211:7: (t= LEXER g= GRAMMAR -> GRAMMAR[$g, \"LEXER_GRAMMAR\"] |t= PARSER g= GRAMMAR -> GRAMMAR[$g, \"PARSER_GRAMMAR\"] |g= GRAMMAR -> GRAMMAR[$g, \"COMBINED_GRAMMAR\"] |tg= TREE_GRAMMAR )
			int alt4=4;
			switch ( input.LA(1) ) {
			case LEXER:
				{
				alt4=1;
				}
				break;
			case PARSER:
				{
				alt4=2;
				}
				break;
			case GRAMMAR:
				{
				alt4=3;
				}
				break;
			case TREE_GRAMMAR:
				{
				alt4=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}
			switch (alt4) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:211:9: t= LEXER g= GRAMMAR
					{
					t=(Token)match(input,LEXER,FOLLOW_LEXER_in_grammarType740);  
					stream_LEXER.add(t);

					g=(Token)match(input,GRAMMAR,FOLLOW_GRAMMAR_in_grammarType744);  
					stream_GRAMMAR.add(g);

					// AST REWRITE
					// elements: GRAMMAR
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 211:28: -> GRAMMAR[$g, \"LEXER_GRAMMAR\"]
					{
						adaptor.addChild(root_0, new GrammarRootAST(GRAMMAR, g, "LEXER_GRAMMAR"));
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:213:6: t= PARSER g= GRAMMAR
					{
					t=(Token)match(input,PARSER,FOLLOW_PARSER_in_grammarType767);  
					stream_PARSER.add(t);

					g=(Token)match(input,GRAMMAR,FOLLOW_GRAMMAR_in_grammarType771);  
					stream_GRAMMAR.add(g);

					// AST REWRITE
					// elements: GRAMMAR
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 213:25: -> GRAMMAR[$g, \"PARSER_GRAMMAR\"]
					{
						adaptor.addChild(root_0, new GrammarRootAST(GRAMMAR, g, "PARSER_GRAMMAR"));
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:216:6: g= GRAMMAR
					{
					g=(Token)match(input,GRAMMAR,FOLLOW_GRAMMAR_in_grammarType792);  
					stream_GRAMMAR.add(g);

					// AST REWRITE
					// elements: GRAMMAR
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 216:25: -> GRAMMAR[$g, \"COMBINED_GRAMMAR\"]
					{
						adaptor.addChild(root_0, new GrammarRootAST(GRAMMAR, g, "COMBINED_GRAMMAR"));
					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:217:7: tg= TREE_GRAMMAR
					{
					tg=(Token)match(input,TREE_GRAMMAR,FOLLOW_TREE_GRAMMAR_in_grammarType819);  
					stream_TREE_GRAMMAR.add(tg);

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				if ( tg!=null ) throw new v3TreeGrammarException(tg);
				if ( t!=null ) ((GrammarRootAST)retval.tree).grammarType = (t!=null?t.getType():0);
				else ((GrammarRootAST)retval.tree).grammarType=COMBINED;

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "grammarType"


	public static class prequelConstruct_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "prequelConstruct"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:225:1: prequelConstruct : ( optionsSpec | delegateGrammars | tokensSpec | action );
	public final ANTLRParser.prequelConstruct_return prequelConstruct() throws RecognitionException {
		ANTLRParser.prequelConstruct_return retval = new ANTLRParser.prequelConstruct_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope optionsSpec11 =null;
		ParserRuleReturnScope delegateGrammars12 =null;
		ParserRuleReturnScope tokensSpec13 =null;
		ParserRuleReturnScope action14 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:226:2: ( optionsSpec | delegateGrammars | tokensSpec | action )
			int alt5=4;
			switch ( input.LA(1) ) {
			case OPTIONS:
				{
				alt5=1;
				}
				break;
			case IMPORT:
				{
				alt5=2;
				}
				break;
			case TOKENS_SPEC:
				{
				alt5=3;
				}
				break;
			case AT:
				{
				alt5=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}
			switch (alt5) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:227:4: optionsSpec
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_optionsSpec_in_prequelConstruct845);
					optionsSpec11=optionsSpec();
					state._fsp--;

					adaptor.addChild(root_0, optionsSpec11.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:231:7: delegateGrammars
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_delegateGrammars_in_prequelConstruct868);
					delegateGrammars12=delegateGrammars();
					state._fsp--;

					adaptor.addChild(root_0, delegateGrammars12.getTree());

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:238:7: tokensSpec
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_tokensSpec_in_prequelConstruct912);
					tokensSpec13=tokensSpec();
					state._fsp--;

					adaptor.addChild(root_0, tokensSpec13.getTree());

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:244:7: action
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_action_in_prequelConstruct949);
					action14=action();
					state._fsp--;

					adaptor.addChild(root_0, action14.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prequelConstruct"


	public static class optionsSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "optionsSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:248:1: optionsSpec : OPTIONS ( option SEMI )* RBRACE -> ^( OPTIONS[$OPTIONS, \"OPTIONS\"] ( option )+ ) ;
	public final ANTLRParser.optionsSpec_return optionsSpec() throws RecognitionException {
		ANTLRParser.optionsSpec_return retval = new ANTLRParser.optionsSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token OPTIONS15=null;
		Token SEMI17=null;
		Token RBRACE18=null;
		ParserRuleReturnScope option16 =null;

		GrammarAST OPTIONS15_tree=null;
		GrammarAST SEMI17_tree=null;
		GrammarAST RBRACE18_tree=null;
		RewriteRuleTokenStream stream_RBRACE=new RewriteRuleTokenStream(adaptor,"token RBRACE");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_OPTIONS=new RewriteRuleTokenStream(adaptor,"token OPTIONS");
		RewriteRuleSubtreeStream stream_option=new RewriteRuleSubtreeStream(adaptor,"rule option");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:249:2: ( OPTIONS ( option SEMI )* RBRACE -> ^( OPTIONS[$OPTIONS, \"OPTIONS\"] ( option )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:249:4: OPTIONS ( option SEMI )* RBRACE
			{
			OPTIONS15=(Token)match(input,OPTIONS,FOLLOW_OPTIONS_in_optionsSpec964);  
			stream_OPTIONS.add(OPTIONS15);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:249:12: ( option SEMI )*
			loop6:
			while (true) {
				int alt6=2;
				switch ( input.LA(1) ) {
				case RULE_REF:
				case TOKEN_REF:
					{
					alt6=1;
					}
					break;
				}
				switch (alt6) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:249:13: option SEMI
					{
					pushFollow(FOLLOW_option_in_optionsSpec967);
					option16=option();
					state._fsp--;

					stream_option.add(option16.getTree());
					SEMI17=(Token)match(input,SEMI,FOLLOW_SEMI_in_optionsSpec969);  
					stream_SEMI.add(SEMI17);

					}
					break;

				default :
					break loop6;
				}
			}

			RBRACE18=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_optionsSpec973);  
			stream_RBRACE.add(RBRACE18);

			// AST REWRITE
			// elements: OPTIONS, option
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 249:34: -> ^( OPTIONS[$OPTIONS, \"OPTIONS\"] ( option )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:249:37: ^( OPTIONS[$OPTIONS, \"OPTIONS\"] ( option )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(OPTIONS, OPTIONS15, "OPTIONS"), root_1);
				if ( !(stream_option.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_option.hasNext() ) {
					adaptor.addChild(root_1, stream_option.nextTree());
				}
				stream_option.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "optionsSpec"


	public static class option_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "option"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:252:1: option : id ASSIGN ^ optionValue ;
	public final ANTLRParser.option_return option() throws RecognitionException {
		ANTLRParser.option_return retval = new ANTLRParser.option_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ASSIGN20=null;
		ParserRuleReturnScope id19 =null;
		ParserRuleReturnScope optionValue21 =null;

		GrammarAST ASSIGN20_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:253:5: ( id ASSIGN ^ optionValue )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:253:9: id ASSIGN ^ optionValue
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_id_in_option1002);
			id19=id();
			state._fsp--;

			adaptor.addChild(root_0, id19.getTree());

			ASSIGN20=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_option1004); 
			ASSIGN20_tree = (GrammarAST)adaptor.create(ASSIGN20);
			root_0 = (GrammarAST)adaptor.becomeRoot(ASSIGN20_tree, root_0);

			pushFollow(FOLLOW_optionValue_in_option1007);
			optionValue21=optionValue();
			state._fsp--;

			adaptor.addChild(root_0, optionValue21.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "option"


	public static class optionValue_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "optionValue"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:261:1: optionValue : ( qid | STRING_LITERAL | ACTION | INT );
	public final ANTLRParser.optionValue_return optionValue() throws RecognitionException {
		ANTLRParser.optionValue_return retval = new ANTLRParser.optionValue_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token STRING_LITERAL23=null;
		Token ACTION24=null;
		Token INT25=null;
		ParserRuleReturnScope qid22 =null;

		GrammarAST STRING_LITERAL23_tree=null;
		GrammarAST ACTION24_tree=null;
		GrammarAST INT25_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:262:5: ( qid | STRING_LITERAL | ACTION | INT )
			int alt7=4;
			switch ( input.LA(1) ) {
			case RULE_REF:
			case TOKEN_REF:
				{
				alt7=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt7=2;
				}
				break;
			case ACTION:
				{
				alt7=3;
				}
				break;
			case INT:
				{
				alt7=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 7, 0, input);
				throw nvae;
			}
			switch (alt7) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:265:7: qid
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_qid_in_optionValue1050);
					qid22=qid();
					state._fsp--;

					adaptor.addChild(root_0, qid22.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:266:7: STRING_LITERAL
					{
					root_0 = (GrammarAST)adaptor.nil();


					STRING_LITERAL23=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_optionValue1058); 
					STRING_LITERAL23_tree = (GrammarAST)adaptor.create(STRING_LITERAL23);
					adaptor.addChild(root_0, STRING_LITERAL23_tree);

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:267:4: ACTION
					{
					root_0 = (GrammarAST)adaptor.nil();


					ACTION24=(Token)match(input,ACTION,FOLLOW_ACTION_in_optionValue1063); 
					ACTION24_tree = new ActionAST(ACTION24) ;
					adaptor.addChild(root_0, ACTION24_tree);

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:268:7: INT
					{
					root_0 = (GrammarAST)adaptor.nil();


					INT25=(Token)match(input,INT,FOLLOW_INT_in_optionValue1074); 
					INT25_tree = (GrammarAST)adaptor.create(INT25);
					adaptor.addChild(root_0, INT25_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "optionValue"


	public static class delegateGrammars_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "delegateGrammars"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:273:1: delegateGrammars : IMPORT delegateGrammar ( COMMA delegateGrammar )* SEMI -> ^( IMPORT ( delegateGrammar )+ ) ;
	public final ANTLRParser.delegateGrammars_return delegateGrammars() throws RecognitionException {
		ANTLRParser.delegateGrammars_return retval = new ANTLRParser.delegateGrammars_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token IMPORT26=null;
		Token COMMA28=null;
		Token SEMI30=null;
		ParserRuleReturnScope delegateGrammar27 =null;
		ParserRuleReturnScope delegateGrammar29 =null;

		GrammarAST IMPORT26_tree=null;
		GrammarAST COMMA28_tree=null;
		GrammarAST SEMI30_tree=null;
		RewriteRuleTokenStream stream_IMPORT=new RewriteRuleTokenStream(adaptor,"token IMPORT");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleSubtreeStream stream_delegateGrammar=new RewriteRuleSubtreeStream(adaptor,"rule delegateGrammar");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:274:2: ( IMPORT delegateGrammar ( COMMA delegateGrammar )* SEMI -> ^( IMPORT ( delegateGrammar )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:274:4: IMPORT delegateGrammar ( COMMA delegateGrammar )* SEMI
			{
			IMPORT26=(Token)match(input,IMPORT,FOLLOW_IMPORT_in_delegateGrammars1090);  
			stream_IMPORT.add(IMPORT26);

			pushFollow(FOLLOW_delegateGrammar_in_delegateGrammars1092);
			delegateGrammar27=delegateGrammar();
			state._fsp--;

			stream_delegateGrammar.add(delegateGrammar27.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:274:27: ( COMMA delegateGrammar )*
			loop8:
			while (true) {
				int alt8=2;
				switch ( input.LA(1) ) {
				case COMMA:
					{
					alt8=1;
					}
					break;
				}
				switch (alt8) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:274:28: COMMA delegateGrammar
					{
					COMMA28=(Token)match(input,COMMA,FOLLOW_COMMA_in_delegateGrammars1095);  
					stream_COMMA.add(COMMA28);

					pushFollow(FOLLOW_delegateGrammar_in_delegateGrammars1097);
					delegateGrammar29=delegateGrammar();
					state._fsp--;

					stream_delegateGrammar.add(delegateGrammar29.getTree());
					}
					break;

				default :
					break loop8;
				}
			}

			SEMI30=(Token)match(input,SEMI,FOLLOW_SEMI_in_delegateGrammars1101);  
			stream_SEMI.add(SEMI30);

			// AST REWRITE
			// elements: delegateGrammar, IMPORT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 274:57: -> ^( IMPORT ( delegateGrammar )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:274:60: ^( IMPORT ( delegateGrammar )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_IMPORT.nextNode(), root_1);
				if ( !(stream_delegateGrammar.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_delegateGrammar.hasNext() ) {
					adaptor.addChild(root_1, stream_delegateGrammar.nextTree());
				}
				stream_delegateGrammar.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "delegateGrammars"


	public static class delegateGrammar_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "delegateGrammar"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:279:1: delegateGrammar : ( id ASSIGN ^ id | id );
	public final ANTLRParser.delegateGrammar_return delegateGrammar() throws RecognitionException {
		ANTLRParser.delegateGrammar_return retval = new ANTLRParser.delegateGrammar_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ASSIGN32=null;
		ParserRuleReturnScope id31 =null;
		ParserRuleReturnScope id33 =null;
		ParserRuleReturnScope id34 =null;

		GrammarAST ASSIGN32_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:280:5: ( id ASSIGN ^ id | id )
			int alt9=2;
			switch ( input.LA(1) ) {
			case RULE_REF:
				{
				switch ( input.LA(2) ) {
				case ASSIGN:
					{
					alt9=1;
					}
					break;
				case COMMA:
				case SEMI:
					{
					alt9=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 9, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TOKEN_REF:
				{
				switch ( input.LA(2) ) {
				case ASSIGN:
					{
					alt9=1;
					}
					break;
				case COMMA:
				case SEMI:
					{
					alt9=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 9, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 9, 0, input);
				throw nvae;
			}
			switch (alt9) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:280:9: id ASSIGN ^ id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_delegateGrammar1128);
					id31=id();
					state._fsp--;

					adaptor.addChild(root_0, id31.getTree());

					ASSIGN32=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_delegateGrammar1130); 
					ASSIGN32_tree = (GrammarAST)adaptor.create(ASSIGN32);
					root_0 = (GrammarAST)adaptor.becomeRoot(ASSIGN32_tree, root_0);

					pushFollow(FOLLOW_id_in_delegateGrammar1133);
					id33=id();
					state._fsp--;

					adaptor.addChild(root_0, id33.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:281:9: id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_delegateGrammar1143);
					id34=id();
					state._fsp--;

					adaptor.addChild(root_0, id34.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "delegateGrammar"


	public static class tokensSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "tokensSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:284:1: tokensSpec : ( TOKENS_SPEC id ( COMMA id )* RBRACE -> ^( TOKENS_SPEC ( id )+ ) | TOKENS_SPEC RBRACE ->| TOKENS_SPEC ^ ( v3tokenSpec )+ RBRACE !);
	public final ANTLRParser.tokensSpec_return tokensSpec() throws RecognitionException {
		ANTLRParser.tokensSpec_return retval = new ANTLRParser.tokensSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token TOKENS_SPEC35=null;
		Token COMMA37=null;
		Token RBRACE39=null;
		Token TOKENS_SPEC40=null;
		Token RBRACE41=null;
		Token TOKENS_SPEC42=null;
		Token RBRACE44=null;
		ParserRuleReturnScope id36 =null;
		ParserRuleReturnScope id38 =null;
		ParserRuleReturnScope v3tokenSpec43 =null;

		GrammarAST TOKENS_SPEC35_tree=null;
		GrammarAST COMMA37_tree=null;
		GrammarAST RBRACE39_tree=null;
		GrammarAST TOKENS_SPEC40_tree=null;
		GrammarAST RBRACE41_tree=null;
		GrammarAST TOKENS_SPEC42_tree=null;
		GrammarAST RBRACE44_tree=null;
		RewriteRuleTokenStream stream_RBRACE=new RewriteRuleTokenStream(adaptor,"token RBRACE");
		RewriteRuleTokenStream stream_TOKENS_SPEC=new RewriteRuleTokenStream(adaptor,"token TOKENS_SPEC");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:285:2: ( TOKENS_SPEC id ( COMMA id )* RBRACE -> ^( TOKENS_SPEC ( id )+ ) | TOKENS_SPEC RBRACE ->| TOKENS_SPEC ^ ( v3tokenSpec )+ RBRACE !)
			int alt12=3;
			switch ( input.LA(1) ) {
			case TOKENS_SPEC:
				{
				switch ( input.LA(2) ) {
				case RBRACE:
					{
					alt12=2;
					}
					break;
				case RULE_REF:
					{
					switch ( input.LA(3) ) {
					case COMMA:
					case RBRACE:
						{
						alt12=1;
						}
						break;
					case ASSIGN:
					case SEMI:
						{
						alt12=3;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 12, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				case TOKEN_REF:
					{
					switch ( input.LA(3) ) {
					case COMMA:
					case RBRACE:
						{
						alt12=1;
						}
						break;
					case ASSIGN:
					case SEMI:
						{
						alt12=3;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 12, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 12, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}
			switch (alt12) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:285:4: TOKENS_SPEC id ( COMMA id )* RBRACE
					{
					TOKENS_SPEC35=(Token)match(input,TOKENS_SPEC,FOLLOW_TOKENS_SPEC_in_tokensSpec1157);  
					stream_TOKENS_SPEC.add(TOKENS_SPEC35);

					pushFollow(FOLLOW_id_in_tokensSpec1159);
					id36=id();
					state._fsp--;

					stream_id.add(id36.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:285:19: ( COMMA id )*
					loop10:
					while (true) {
						int alt10=2;
						switch ( input.LA(1) ) {
						case COMMA:
							{
							alt10=1;
							}
							break;
						}
						switch (alt10) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:285:20: COMMA id
							{
							COMMA37=(Token)match(input,COMMA,FOLLOW_COMMA_in_tokensSpec1162);  
							stream_COMMA.add(COMMA37);

							pushFollow(FOLLOW_id_in_tokensSpec1164);
							id38=id();
							state._fsp--;

							stream_id.add(id38.getTree());
							}
							break;

						default :
							break loop10;
						}
					}

					RBRACE39=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_tokensSpec1168);  
					stream_RBRACE.add(RBRACE39);

					// AST REWRITE
					// elements: id, TOKENS_SPEC
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 285:38: -> ^( TOKENS_SPEC ( id )+ )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:285:41: ^( TOKENS_SPEC ( id )+ )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_TOKENS_SPEC.nextNode(), root_1);
						if ( !(stream_id.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_id.hasNext() ) {
							adaptor.addChild(root_1, stream_id.nextTree());
						}
						stream_id.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:286:7: TOKENS_SPEC RBRACE
					{
					TOKENS_SPEC40=(Token)match(input,TOKENS_SPEC,FOLLOW_TOKENS_SPEC_in_tokensSpec1185);  
					stream_TOKENS_SPEC.add(TOKENS_SPEC40);

					RBRACE41=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_tokensSpec1187);  
					stream_RBRACE.add(RBRACE41);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 286:26: ->
					{
						root_0 = null;
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:287:7: TOKENS_SPEC ^ ( v3tokenSpec )+ RBRACE !
					{
					root_0 = (GrammarAST)adaptor.nil();


					TOKENS_SPEC42=(Token)match(input,TOKENS_SPEC,FOLLOW_TOKENS_SPEC_in_tokensSpec1197); 
					TOKENS_SPEC42_tree = (GrammarAST)adaptor.create(TOKENS_SPEC42);
					root_0 = (GrammarAST)adaptor.becomeRoot(TOKENS_SPEC42_tree, root_0);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:287:20: ( v3tokenSpec )+
					int cnt11=0;
					loop11:
					while (true) {
						int alt11=2;
						switch ( input.LA(1) ) {
						case RULE_REF:
						case TOKEN_REF:
							{
							alt11=1;
							}
							break;
						}
						switch (alt11) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:287:20: v3tokenSpec
							{
							pushFollow(FOLLOW_v3tokenSpec_in_tokensSpec1200);
							v3tokenSpec43=v3tokenSpec();
							state._fsp--;

							adaptor.addChild(root_0, v3tokenSpec43.getTree());

							}
							break;

						default :
							if ( cnt11 >= 1 ) break loop11;
							EarlyExitException eee = new EarlyExitException(11, input);
							throw eee;
						}
						cnt11++;
					}

					RBRACE44=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_tokensSpec1203); 
					grammarError(ErrorType.V3_TOKENS_SYNTAX, TOKENS_SPEC42);
					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "tokensSpec"


	public static class v3tokenSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "v3tokenSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:291:1: v3tokenSpec : id ( ASSIGN lit= STRING_LITERAL -> id | -> id ) SEMI ;
	public final ANTLRParser.v3tokenSpec_return v3tokenSpec() throws RecognitionException {
		ANTLRParser.v3tokenSpec_return retval = new ANTLRParser.v3tokenSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token lit=null;
		Token ASSIGN46=null;
		Token SEMI47=null;
		ParserRuleReturnScope id45 =null;

		GrammarAST lit_tree=null;
		GrammarAST ASSIGN46_tree=null;
		GrammarAST SEMI47_tree=null;
		RewriteRuleTokenStream stream_STRING_LITERAL=new RewriteRuleTokenStream(adaptor,"token STRING_LITERAL");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_ASSIGN=new RewriteRuleTokenStream(adaptor,"token ASSIGN");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:292:2: ( id ( ASSIGN lit= STRING_LITERAL -> id | -> id ) SEMI )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:292:4: id ( ASSIGN lit= STRING_LITERAL -> id | -> id ) SEMI
			{
			pushFollow(FOLLOW_id_in_v3tokenSpec1223);
			id45=id();
			state._fsp--;

			stream_id.add(id45.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:293:3: ( ASSIGN lit= STRING_LITERAL -> id | -> id )
			int alt13=2;
			switch ( input.LA(1) ) {
			case ASSIGN:
				{
				alt13=1;
				}
				break;
			case SEMI:
				{
				alt13=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}
			switch (alt13) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:293:5: ASSIGN lit= STRING_LITERAL
					{
					ASSIGN46=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_v3tokenSpec1229);  
					stream_ASSIGN.add(ASSIGN46);

					lit=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_v3tokenSpec1233);  
					stream_STRING_LITERAL.add(lit);


					            grammarError(ErrorType.V3_ASSIGN_IN_TOKENS, (id45!=null?(id45.start):null),
					                         (id45!=null?input.toString(id45.start,id45.stop):null), lit.getText());
					            
					// AST REWRITE
					// elements: id
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 298:20: -> id
					{
						adaptor.addChild(root_0, stream_id.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:299:12: 
					{
					// AST REWRITE
					// elements: id
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 299:12: -> id
					{
						adaptor.addChild(root_0, stream_id.nextTree());
					}


					retval.tree = root_0;

					}
					break;

			}

			SEMI47=(Token)match(input,SEMI,FOLLOW_SEMI_in_v3tokenSpec1294);  
			stream_SEMI.add(SEMI47);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "v3tokenSpec"


	public static class action_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "action"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:308:1: action : AT ( actionScopeName COLONCOLON )? id ACTION -> ^( AT ( actionScopeName )? id ACTION ) ;
	public final ANTLRParser.action_return action() throws RecognitionException {
		ANTLRParser.action_return retval = new ANTLRParser.action_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token AT48=null;
		Token COLONCOLON50=null;
		Token ACTION52=null;
		ParserRuleReturnScope actionScopeName49 =null;
		ParserRuleReturnScope id51 =null;

		GrammarAST AT48_tree=null;
		GrammarAST COLONCOLON50_tree=null;
		GrammarAST ACTION52_tree=null;
		RewriteRuleTokenStream stream_AT=new RewriteRuleTokenStream(adaptor,"token AT");
		RewriteRuleTokenStream stream_COLONCOLON=new RewriteRuleTokenStream(adaptor,"token COLONCOLON");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_actionScopeName=new RewriteRuleSubtreeStream(adaptor,"rule actionScopeName");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:309:2: ( AT ( actionScopeName COLONCOLON )? id ACTION -> ^( AT ( actionScopeName )? id ACTION ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:309:4: AT ( actionScopeName COLONCOLON )? id ACTION
			{
			AT48=(Token)match(input,AT,FOLLOW_AT_in_action1310);  
			stream_AT.add(AT48);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:309:7: ( actionScopeName COLONCOLON )?
			int alt14=2;
			switch ( input.LA(1) ) {
				case RULE_REF:
					{
					switch ( input.LA(2) ) {
						case COLONCOLON:
							{
							alt14=1;
							}
							break;
					}
					}
					break;
				case TOKEN_REF:
					{
					switch ( input.LA(2) ) {
						case COLONCOLON:
							{
							alt14=1;
							}
							break;
					}
					}
					break;
				case LEXER:
				case PARSER:
					{
					alt14=1;
					}
					break;
			}
			switch (alt14) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:309:8: actionScopeName COLONCOLON
					{
					pushFollow(FOLLOW_actionScopeName_in_action1313);
					actionScopeName49=actionScopeName();
					state._fsp--;

					stream_actionScopeName.add(actionScopeName49.getTree());
					COLONCOLON50=(Token)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_action1315);  
					stream_COLONCOLON.add(COLONCOLON50);

					}
					break;

			}

			pushFollow(FOLLOW_id_in_action1319);
			id51=id();
			state._fsp--;

			stream_id.add(id51.getTree());
			ACTION52=(Token)match(input,ACTION,FOLLOW_ACTION_in_action1321);  
			stream_ACTION.add(ACTION52);

			// AST REWRITE
			// elements: actionScopeName, id, ACTION, AT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 309:47: -> ^( AT ( actionScopeName )? id ACTION )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:309:50: ^( AT ( actionScopeName )? id ACTION )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_AT.nextNode(), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:309:55: ( actionScopeName )?
				if ( stream_actionScopeName.hasNext() ) {
					adaptor.addChild(root_1, stream_actionScopeName.nextTree());
				}
				stream_actionScopeName.reset();

				adaptor.addChild(root_1, stream_id.nextTree());
				adaptor.addChild(root_1, new ActionAST(stream_ACTION.nextToken()));
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "action"


	public static class actionScopeName_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "actionScopeName"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:315:1: actionScopeName : ( id | LEXER -> ID[$LEXER] | PARSER -> ID[$PARSER] );
	public final ANTLRParser.actionScopeName_return actionScopeName() throws RecognitionException {
		ANTLRParser.actionScopeName_return retval = new ANTLRParser.actionScopeName_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LEXER54=null;
		Token PARSER55=null;
		ParserRuleReturnScope id53 =null;

		GrammarAST LEXER54_tree=null;
		GrammarAST PARSER55_tree=null;
		RewriteRuleTokenStream stream_PARSER=new RewriteRuleTokenStream(adaptor,"token PARSER");
		RewriteRuleTokenStream stream_LEXER=new RewriteRuleTokenStream(adaptor,"token LEXER");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:316:2: ( id | LEXER -> ID[$LEXER] | PARSER -> ID[$PARSER] )
			int alt15=3;
			switch ( input.LA(1) ) {
			case RULE_REF:
			case TOKEN_REF:
				{
				alt15=1;
				}
				break;
			case LEXER:
				{
				alt15=2;
				}
				break;
			case PARSER:
				{
				alt15=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 15, 0, input);
				throw nvae;
			}
			switch (alt15) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:316:4: id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_actionScopeName1350);
					id53=id();
					state._fsp--;

					adaptor.addChild(root_0, id53.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:317:4: LEXER
					{
					LEXER54=(Token)match(input,LEXER,FOLLOW_LEXER_in_actionScopeName1355);  
					stream_LEXER.add(LEXER54);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 317:10: -> ID[$LEXER]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, LEXER54));
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:318:9: PARSER
					{
					PARSER55=(Token)match(input,PARSER,FOLLOW_PARSER_in_actionScopeName1370);  
					stream_PARSER.add(PARSER55);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 318:16: -> ID[$PARSER]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, PARSER55));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "actionScopeName"


	public static class modeSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "modeSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:321:1: modeSpec : MODE id SEMI sync ( lexerRule sync )+ -> ^( MODE id ( lexerRule )+ ) ;
	public final ANTLRParser.modeSpec_return modeSpec() throws RecognitionException {
		ANTLRParser.modeSpec_return retval = new ANTLRParser.modeSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token MODE56=null;
		Token SEMI58=null;
		ParserRuleReturnScope id57 =null;
		ParserRuleReturnScope sync59 =null;
		ParserRuleReturnScope lexerRule60 =null;
		ParserRuleReturnScope sync61 =null;

		GrammarAST MODE56_tree=null;
		GrammarAST SEMI58_tree=null;
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_MODE=new RewriteRuleTokenStream(adaptor,"token MODE");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_sync=new RewriteRuleSubtreeStream(adaptor,"rule sync");
		RewriteRuleSubtreeStream stream_lexerRule=new RewriteRuleSubtreeStream(adaptor,"rule lexerRule");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:322:5: ( MODE id SEMI sync ( lexerRule sync )+ -> ^( MODE id ( lexerRule )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:322:7: MODE id SEMI sync ( lexerRule sync )+
			{
			MODE56=(Token)match(input,MODE,FOLLOW_MODE_in_modeSpec1389);  
			stream_MODE.add(MODE56);

			pushFollow(FOLLOW_id_in_modeSpec1391);
			id57=id();
			state._fsp--;

			stream_id.add(id57.getTree());
			SEMI58=(Token)match(input,SEMI,FOLLOW_SEMI_in_modeSpec1393);  
			stream_SEMI.add(SEMI58);

			pushFollow(FOLLOW_sync_in_modeSpec1395);
			sync59=sync();
			state._fsp--;

			stream_sync.add(sync59.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:322:25: ( lexerRule sync )+
			int cnt16=0;
			loop16:
			while (true) {
				int alt16=2;
				switch ( input.LA(1) ) {
				case DOC_COMMENT:
				case FRAGMENT:
				case TOKEN_REF:
					{
					alt16=1;
					}
					break;
				}
				switch (alt16) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:322:26: lexerRule sync
					{
					pushFollow(FOLLOW_lexerRule_in_modeSpec1398);
					lexerRule60=lexerRule();
					state._fsp--;

					stream_lexerRule.add(lexerRule60.getTree());
					pushFollow(FOLLOW_sync_in_modeSpec1400);
					sync61=sync();
					state._fsp--;

					stream_sync.add(sync61.getTree());
					}
					break;

				default :
					if ( cnt16 >= 1 ) break loop16;
					EarlyExitException eee = new EarlyExitException(16, input);
					throw eee;
				}
				cnt16++;
			}

			// AST REWRITE
			// elements: MODE, lexerRule, id
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 322:44: -> ^( MODE id ( lexerRule )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:322:47: ^( MODE id ( lexerRule )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_MODE.nextNode(), root_1);
				adaptor.addChild(root_1, stream_id.nextTree());
				if ( !(stream_lexerRule.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_lexerRule.hasNext() ) {
					adaptor.addChild(root_1, stream_lexerRule.nextTree());
				}
				stream_lexerRule.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "modeSpec"


	public static class rules_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "rules"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:325:1: rules : sync ( rule sync )* -> ^( RULES ( rule )* ) ;
	public final ANTLRParser.rules_return rules() throws RecognitionException {
		ANTLRParser.rules_return retval = new ANTLRParser.rules_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope sync62 =null;
		ParserRuleReturnScope rule63 =null;
		ParserRuleReturnScope sync64 =null;

		RewriteRuleSubtreeStream stream_sync=new RewriteRuleSubtreeStream(adaptor,"rule sync");
		RewriteRuleSubtreeStream stream_rule=new RewriteRuleSubtreeStream(adaptor,"rule rule");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:326:5: ( sync ( rule sync )* -> ^( RULES ( rule )* ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:326:7: sync ( rule sync )*
			{
			pushFollow(FOLLOW_sync_in_rules1431);
			sync62=sync();
			state._fsp--;

			stream_sync.add(sync62.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:326:12: ( rule sync )*
			loop17:
			while (true) {
				int alt17=2;
				switch ( input.LA(1) ) {
				case DOC_COMMENT:
				case FRAGMENT:
				case RULE_REF:
				case TOKEN_REF:
					{
					alt17=1;
					}
					break;
				}
				switch (alt17) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:326:13: rule sync
					{
					pushFollow(FOLLOW_rule_in_rules1434);
					rule63=rule();
					state._fsp--;

					stream_rule.add(rule63.getTree());
					pushFollow(FOLLOW_sync_in_rules1436);
					sync64=sync();
					state._fsp--;

					stream_sync.add(sync64.getTree());
					}
					break;

				default :
					break loop17;
				}
			}

			// AST REWRITE
			// elements: rule
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 330:7: -> ^( RULES ( rule )* )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:330:9: ^( RULES ( rule )* )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(RULES, "RULES"), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:330:17: ( rule )*
				while ( stream_rule.hasNext() ) {
					adaptor.addChild(root_1, stream_rule.nextTree());
				}
				stream_rule.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rules"


	public static class sync_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "sync"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:333:1: sync :;
	public final ANTLRParser.sync_return sync() throws RecognitionException {
		ANTLRParser.sync_return retval = new ANTLRParser.sync_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;


			BitSet followSet = computeErrorRecoverySet();
			if ( input.LA(1)!=Token.EOF && !followSet.member(input.LA(1)) ) {
				reportError(new NoViableAltException("",0,0,input));
		       	beginResync();
		       	consumeUntil(input, followSet);
		       	endResync();
			}

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:342:3: ()
			// org\\antlr\\v4\\parse\\ANTLRParser.g:343:2: 
			{
			root_0 = (GrammarAST)adaptor.nil();


			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sync"


	public static class rule_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "rule"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:345:1: rule : ( parserRule | lexerRule );
	public final ANTLRParser.rule_return rule() throws RecognitionException {
		ANTLRParser.rule_return retval = new ANTLRParser.rule_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope parserRule65 =null;
		ParserRuleReturnScope lexerRule66 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:345:5: ( parserRule | lexerRule )
			int alt18=2;
			switch ( input.LA(1) ) {
			case DOC_COMMENT:
				{
				switch ( input.LA(2) ) {
				case RULE_REF:
					{
					alt18=1;
					}
					break;
				case FRAGMENT:
				case TOKEN_REF:
					{
					alt18=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 18, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case RULE_REF:
				{
				alt18=1;
				}
				break;
			case FRAGMENT:
			case TOKEN_REF:
				{
				alt18=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}
			switch (alt18) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:345:7: parserRule
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_parserRule_in_rule1498);
					parserRule65=parserRule();
					state._fsp--;

					adaptor.addChild(root_0, parserRule65.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:346:4: lexerRule
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_lexerRule_in_rule1503);
					lexerRule66=lexerRule();
					state._fsp--;

					adaptor.addChild(root_0, lexerRule66.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rule"


	public static class parserRule_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "parserRule"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:358:1: parserRule : ( DOC_COMMENT )? RULE_REF ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? rulePrequels COLON ruleBlock SEMI exceptionGroup -> ^( RULE RULE_REF ( DOC_COMMENT )? ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? ( rulePrequels )? ruleBlock ( exceptionGroup )* ) ;
	public final ANTLRParser.parserRule_return parserRule() throws RecognitionException {
		ANTLRParser.parserRule_return retval = new ANTLRParser.parserRule_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOC_COMMENT67=null;
		Token RULE_REF68=null;
		Token ARG_ACTION69=null;
		Token COLON74=null;
		Token SEMI76=null;
		ParserRuleReturnScope ruleReturns70 =null;
		ParserRuleReturnScope throwsSpec71 =null;
		ParserRuleReturnScope localsSpec72 =null;
		ParserRuleReturnScope rulePrequels73 =null;
		ParserRuleReturnScope ruleBlock75 =null;
		ParserRuleReturnScope exceptionGroup77 =null;

		GrammarAST DOC_COMMENT67_tree=null;
		GrammarAST RULE_REF68_tree=null;
		GrammarAST ARG_ACTION69_tree=null;
		GrammarAST COLON74_tree=null;
		GrammarAST SEMI76_tree=null;
		RewriteRuleTokenStream stream_DOC_COMMENT=new RewriteRuleTokenStream(adaptor,"token DOC_COMMENT");
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_RULE_REF=new RewriteRuleTokenStream(adaptor,"token RULE_REF");
		RewriteRuleTokenStream stream_ARG_ACTION=new RewriteRuleTokenStream(adaptor,"token ARG_ACTION");
		RewriteRuleSubtreeStream stream_rulePrequels=new RewriteRuleSubtreeStream(adaptor,"rule rulePrequels");
		RewriteRuleSubtreeStream stream_exceptionGroup=new RewriteRuleSubtreeStream(adaptor,"rule exceptionGroup");
		RewriteRuleSubtreeStream stream_ruleReturns=new RewriteRuleSubtreeStream(adaptor,"rule ruleReturns");
		RewriteRuleSubtreeStream stream_throwsSpec=new RewriteRuleSubtreeStream(adaptor,"rule throwsSpec");
		RewriteRuleSubtreeStream stream_ruleBlock=new RewriteRuleSubtreeStream(adaptor,"rule ruleBlock");
		RewriteRuleSubtreeStream stream_localsSpec=new RewriteRuleSubtreeStream(adaptor,"rule localsSpec");

		 paraphrases.push("matching a rule"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:367:5: ( ( DOC_COMMENT )? RULE_REF ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? rulePrequels COLON ruleBlock SEMI exceptionGroup -> ^( RULE RULE_REF ( DOC_COMMENT )? ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? ( rulePrequels )? ruleBlock ( exceptionGroup )* ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:368:7: ( DOC_COMMENT )? RULE_REF ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? rulePrequels COLON ruleBlock SEMI exceptionGroup
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:368:7: ( DOC_COMMENT )?
			int alt19=2;
			switch ( input.LA(1) ) {
				case DOC_COMMENT:
					{
					alt19=1;
					}
					break;
			}
			switch (alt19) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:368:7: DOC_COMMENT
					{
					DOC_COMMENT67=(Token)match(input,DOC_COMMENT,FOLLOW_DOC_COMMENT_in_parserRule1543);  
					stream_DOC_COMMENT.add(DOC_COMMENT67);

					}
					break;

			}

			RULE_REF68=(Token)match(input,RULE_REF,FOLLOW_RULE_REF_in_parserRule1566);  
			stream_RULE_REF.add(RULE_REF68);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:382:4: ( ARG_ACTION )?
			int alt20=2;
			switch ( input.LA(1) ) {
				case ARG_ACTION:
					{
					alt20=1;
					}
					break;
			}
			switch (alt20) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:382:4: ARG_ACTION
					{
					ARG_ACTION69=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_parserRule1596);  
					stream_ARG_ACTION.add(ARG_ACTION69);

					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:384:4: ( ruleReturns )?
			int alt21=2;
			switch ( input.LA(1) ) {
				case RETURNS:
					{
					alt21=1;
					}
					break;
			}
			switch (alt21) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:384:4: ruleReturns
					{
					pushFollow(FOLLOW_ruleReturns_in_parserRule1603);
					ruleReturns70=ruleReturns();
					state._fsp--;

					stream_ruleReturns.add(ruleReturns70.getTree());
					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:386:4: ( throwsSpec )?
			int alt22=2;
			switch ( input.LA(1) ) {
				case THROWS:
					{
					alt22=1;
					}
					break;
			}
			switch (alt22) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:386:4: throwsSpec
					{
					pushFollow(FOLLOW_throwsSpec_in_parserRule1610);
					throwsSpec71=throwsSpec();
					state._fsp--;

					stream_throwsSpec.add(throwsSpec71.getTree());
					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:388:4: ( localsSpec )?
			int alt23=2;
			switch ( input.LA(1) ) {
				case LOCALS:
					{
					alt23=1;
					}
					break;
			}
			switch (alt23) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:388:4: localsSpec
					{
					pushFollow(FOLLOW_localsSpec_in_parserRule1617);
					localsSpec72=localsSpec();
					state._fsp--;

					stream_localsSpec.add(localsSpec72.getTree());
					}
					break;

			}

			pushFollow(FOLLOW_rulePrequels_in_parserRule1655);
			rulePrequels73=rulePrequels();
			state._fsp--;

			stream_rulePrequels.add(rulePrequels73.getTree());
			COLON74=(Token)match(input,COLON,FOLLOW_COLON_in_parserRule1664);  
			stream_COLON.add(COLON74);

			pushFollow(FOLLOW_ruleBlock_in_parserRule1687);
			ruleBlock75=ruleBlock();
			state._fsp--;

			stream_ruleBlock.add(ruleBlock75.getTree());
			SEMI76=(Token)match(input,SEMI,FOLLOW_SEMI_in_parserRule1696);  
			stream_SEMI.add(SEMI76);

			pushFollow(FOLLOW_exceptionGroup_in_parserRule1705);
			exceptionGroup77=exceptionGroup();
			state._fsp--;

			stream_exceptionGroup.add(exceptionGroup77.getTree());
			// AST REWRITE
			// elements: localsSpec, ruleReturns, RULE_REF, rulePrequels, ruleBlock, throwsSpec, ARG_ACTION, DOC_COMMENT, exceptionGroup
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 415:7: -> ^( RULE RULE_REF ( DOC_COMMENT )? ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? ( rulePrequels )? ruleBlock ( exceptionGroup )* )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:415:10: ^( RULE RULE_REF ( DOC_COMMENT )? ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? ( rulePrequels )? ruleBlock ( exceptionGroup )* )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new RuleAST(RULE), root_1);
				adaptor.addChild(root_1, stream_RULE_REF.nextNode());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:415:36: ( DOC_COMMENT )?
				if ( stream_DOC_COMMENT.hasNext() ) {
					adaptor.addChild(root_1, stream_DOC_COMMENT.nextNode());
				}
				stream_DOC_COMMENT.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:415:49: ( ARG_ACTION )?
				if ( stream_ARG_ACTION.hasNext() ) {
					adaptor.addChild(root_1, new ActionAST(stream_ARG_ACTION.nextToken()));
				}
				stream_ARG_ACTION.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:9: ( ruleReturns )?
				if ( stream_ruleReturns.hasNext() ) {
					adaptor.addChild(root_1, stream_ruleReturns.nextTree());
				}
				stream_ruleReturns.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:22: ( throwsSpec )?
				if ( stream_throwsSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_throwsSpec.nextTree());
				}
				stream_throwsSpec.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:34: ( localsSpec )?
				if ( stream_localsSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_localsSpec.nextTree());
				}
				stream_localsSpec.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:46: ( rulePrequels )?
				if ( stream_rulePrequels.hasNext() ) {
					adaptor.addChild(root_1, stream_rulePrequels.nextTree());
				}
				stream_rulePrequels.reset();

				adaptor.addChild(root_1, stream_ruleBlock.nextTree());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:70: ( exceptionGroup )*
				while ( stream_exceptionGroup.hasNext() ) {
					adaptor.addChild(root_1, stream_exceptionGroup.nextTree());
				}
				stream_exceptionGroup.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				paraphrases.pop();
				GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.OPTIONS);
				if ( options!=null ) {
					Grammar.setNodeOptions(retval.tree, options);
				}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "parserRule"


	public static class exceptionGroup_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "exceptionGroup"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:426:1: exceptionGroup : ( exceptionHandler )* ( finallyClause )? ;
	public final ANTLRParser.exceptionGroup_return exceptionGroup() throws RecognitionException {
		ANTLRParser.exceptionGroup_return retval = new ANTLRParser.exceptionGroup_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope exceptionHandler78 =null;
		ParserRuleReturnScope finallyClause79 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:427:5: ( ( exceptionHandler )* ( finallyClause )? )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:427:7: ( exceptionHandler )* ( finallyClause )?
			{
			root_0 = (GrammarAST)adaptor.nil();


			// org\\antlr\\v4\\parse\\ANTLRParser.g:427:7: ( exceptionHandler )*
			loop24:
			while (true) {
				int alt24=2;
				switch ( input.LA(1) ) {
				case CATCH:
					{
					alt24=1;
					}
					break;
				}
				switch (alt24) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:427:7: exceptionHandler
					{
					pushFollow(FOLLOW_exceptionHandler_in_exceptionGroup1791);
					exceptionHandler78=exceptionHandler();
					state._fsp--;

					adaptor.addChild(root_0, exceptionHandler78.getTree());

					}
					break;

				default :
					break loop24;
				}
			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:427:25: ( finallyClause )?
			int alt25=2;
			switch ( input.LA(1) ) {
				case FINALLY:
					{
					alt25=1;
					}
					break;
			}
			switch (alt25) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:427:25: finallyClause
					{
					pushFollow(FOLLOW_finallyClause_in_exceptionGroup1794);
					finallyClause79=finallyClause();
					state._fsp--;

					adaptor.addChild(root_0, finallyClause79.getTree());

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "exceptionGroup"


	public static class exceptionHandler_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "exceptionHandler"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:432:1: exceptionHandler : CATCH ARG_ACTION ACTION -> ^( CATCH ARG_ACTION ACTION ) ;
	public final ANTLRParser.exceptionHandler_return exceptionHandler() throws RecognitionException {
		ANTLRParser.exceptionHandler_return retval = new ANTLRParser.exceptionHandler_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token CATCH80=null;
		Token ARG_ACTION81=null;
		Token ACTION82=null;

		GrammarAST CATCH80_tree=null;
		GrammarAST ARG_ACTION81_tree=null;
		GrammarAST ACTION82_tree=null;
		RewriteRuleTokenStream stream_CATCH=new RewriteRuleTokenStream(adaptor,"token CATCH");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");
		RewriteRuleTokenStream stream_ARG_ACTION=new RewriteRuleTokenStream(adaptor,"token ARG_ACTION");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:433:2: ( CATCH ARG_ACTION ACTION -> ^( CATCH ARG_ACTION ACTION ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:433:4: CATCH ARG_ACTION ACTION
			{
			CATCH80=(Token)match(input,CATCH,FOLLOW_CATCH_in_exceptionHandler1811);  
			stream_CATCH.add(CATCH80);

			ARG_ACTION81=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_exceptionHandler1813);  
			stream_ARG_ACTION.add(ARG_ACTION81);

			ACTION82=(Token)match(input,ACTION,FOLLOW_ACTION_in_exceptionHandler1815);  
			stream_ACTION.add(ACTION82);

			// AST REWRITE
			// elements: CATCH, ACTION, ARG_ACTION
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 433:28: -> ^( CATCH ARG_ACTION ACTION )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:433:31: ^( CATCH ARG_ACTION ACTION )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_CATCH.nextNode(), root_1);
				adaptor.addChild(root_1, new ActionAST(stream_ARG_ACTION.nextToken()));
				adaptor.addChild(root_1, new ActionAST(stream_ACTION.nextToken()));
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "exceptionHandler"


	public static class finallyClause_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "finallyClause"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:436:1: finallyClause : FINALLY ACTION -> ^( FINALLY ACTION ) ;
	public final ANTLRParser.finallyClause_return finallyClause() throws RecognitionException {
		ANTLRParser.finallyClause_return retval = new ANTLRParser.finallyClause_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token FINALLY83=null;
		Token ACTION84=null;

		GrammarAST FINALLY83_tree=null;
		GrammarAST ACTION84_tree=null;
		RewriteRuleTokenStream stream_FINALLY=new RewriteRuleTokenStream(adaptor,"token FINALLY");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:437:2: ( FINALLY ACTION -> ^( FINALLY ACTION ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:437:4: FINALLY ACTION
			{
			FINALLY83=(Token)match(input,FINALLY,FOLLOW_FINALLY_in_finallyClause1842);  
			stream_FINALLY.add(FINALLY83);

			ACTION84=(Token)match(input,ACTION,FOLLOW_ACTION_in_finallyClause1844);  
			stream_ACTION.add(ACTION84);

			// AST REWRITE
			// elements: FINALLY, ACTION
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 437:19: -> ^( FINALLY ACTION )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:437:22: ^( FINALLY ACTION )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_FINALLY.nextNode(), root_1);
				adaptor.addChild(root_1, new ActionAST(stream_ACTION.nextToken()));
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "finallyClause"


	public static class rulePrequels_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "rulePrequels"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:440:1: rulePrequels : sync ( rulePrequel sync )* -> ( rulePrequel )* ;
	public final ANTLRParser.rulePrequels_return rulePrequels() throws RecognitionException {
		ANTLRParser.rulePrequels_return retval = new ANTLRParser.rulePrequels_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope sync85 =null;
		ParserRuleReturnScope rulePrequel86 =null;
		ParserRuleReturnScope sync87 =null;

		RewriteRuleSubtreeStream stream_rulePrequel=new RewriteRuleSubtreeStream(adaptor,"rule rulePrequel");
		RewriteRuleSubtreeStream stream_sync=new RewriteRuleSubtreeStream(adaptor,"rule sync");

		 paraphrases.push("matching rule preamble"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:443:2: ( sync ( rulePrequel sync )* -> ( rulePrequel )* )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:443:4: sync ( rulePrequel sync )*
			{
			pushFollow(FOLLOW_sync_in_rulePrequels1876);
			sync85=sync();
			state._fsp--;

			stream_sync.add(sync85.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:443:9: ( rulePrequel sync )*
			loop26:
			while (true) {
				int alt26=2;
				switch ( input.LA(1) ) {
				case AT:
				case OPTIONS:
					{
					alt26=1;
					}
					break;
				}
				switch (alt26) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:443:10: rulePrequel sync
					{
					pushFollow(FOLLOW_rulePrequel_in_rulePrequels1879);
					rulePrequel86=rulePrequel();
					state._fsp--;

					stream_rulePrequel.add(rulePrequel86.getTree());
					pushFollow(FOLLOW_sync_in_rulePrequels1881);
					sync87=sync();
					state._fsp--;

					stream_sync.add(sync87.getTree());
					}
					break;

				default :
					break loop26;
				}
			}

			// AST REWRITE
			// elements: rulePrequel
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 443:29: -> ( rulePrequel )*
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:443:32: ( rulePrequel )*
				while ( stream_rulePrequel.hasNext() ) {
					adaptor.addChild(root_0, stream_rulePrequel.nextTree());
				}
				stream_rulePrequel.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rulePrequels"


	public static class rulePrequel_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "rulePrequel"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:449:1: rulePrequel : ( optionsSpec | ruleAction );
	public final ANTLRParser.rulePrequel_return rulePrequel() throws RecognitionException {
		ANTLRParser.rulePrequel_return retval = new ANTLRParser.rulePrequel_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope optionsSpec88 =null;
		ParserRuleReturnScope ruleAction89 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:450:5: ( optionsSpec | ruleAction )
			int alt27=2;
			switch ( input.LA(1) ) {
			case OPTIONS:
				{
				alt27=1;
				}
				break;
			case AT:
				{
				alt27=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 27, 0, input);
				throw nvae;
			}
			switch (alt27) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:450:7: optionsSpec
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_optionsSpec_in_rulePrequel1905);
					optionsSpec88=optionsSpec();
					state._fsp--;

					adaptor.addChild(root_0, optionsSpec88.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:451:7: ruleAction
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_ruleAction_in_rulePrequel1913);
					ruleAction89=ruleAction();
					state._fsp--;

					adaptor.addChild(root_0, ruleAction89.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rulePrequel"


	public static class ruleReturns_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleReturns"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:460:1: ruleReturns : RETURNS ^ ARG_ACTION ;
	public final ANTLRParser.ruleReturns_return ruleReturns() throws RecognitionException {
		ANTLRParser.ruleReturns_return retval = new ANTLRParser.ruleReturns_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RETURNS90=null;
		Token ARG_ACTION91=null;

		GrammarAST RETURNS90_tree=null;
		GrammarAST ARG_ACTION91_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:461:2: ( RETURNS ^ ARG_ACTION )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:461:4: RETURNS ^ ARG_ACTION
			{
			root_0 = (GrammarAST)adaptor.nil();


			RETURNS90=(Token)match(input,RETURNS,FOLLOW_RETURNS_in_ruleReturns1933); 
			RETURNS90_tree = (GrammarAST)adaptor.create(RETURNS90);
			root_0 = (GrammarAST)adaptor.becomeRoot(RETURNS90_tree, root_0);

			ARG_ACTION91=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_ruleReturns1936); 
			ARG_ACTION91_tree = new ActionAST(ARG_ACTION91) ;
			adaptor.addChild(root_0, ARG_ACTION91_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleReturns"


	public static class throwsSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "throwsSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:475:1: throwsSpec : THROWS qid ( COMMA qid )* -> ^( THROWS ( qid )+ ) ;
	public final ANTLRParser.throwsSpec_return throwsSpec() throws RecognitionException {
		ANTLRParser.throwsSpec_return retval = new ANTLRParser.throwsSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token THROWS92=null;
		Token COMMA94=null;
		ParserRuleReturnScope qid93 =null;
		ParserRuleReturnScope qid95 =null;

		GrammarAST THROWS92_tree=null;
		GrammarAST COMMA94_tree=null;
		RewriteRuleTokenStream stream_THROWS=new RewriteRuleTokenStream(adaptor,"token THROWS");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_qid=new RewriteRuleSubtreeStream(adaptor,"rule qid");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:476:5: ( THROWS qid ( COMMA qid )* -> ^( THROWS ( qid )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:476:7: THROWS qid ( COMMA qid )*
			{
			THROWS92=(Token)match(input,THROWS,FOLLOW_THROWS_in_throwsSpec1964);  
			stream_THROWS.add(THROWS92);

			pushFollow(FOLLOW_qid_in_throwsSpec1966);
			qid93=qid();
			state._fsp--;

			stream_qid.add(qid93.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:476:18: ( COMMA qid )*
			loop28:
			while (true) {
				int alt28=2;
				switch ( input.LA(1) ) {
				case COMMA:
					{
					alt28=1;
					}
					break;
				}
				switch (alt28) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:476:19: COMMA qid
					{
					COMMA94=(Token)match(input,COMMA,FOLLOW_COMMA_in_throwsSpec1969);  
					stream_COMMA.add(COMMA94);

					pushFollow(FOLLOW_qid_in_throwsSpec1971);
					qid95=qid();
					state._fsp--;

					stream_qid.add(qid95.getTree());
					}
					break;

				default :
					break loop28;
				}
			}

			// AST REWRITE
			// elements: qid, THROWS
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 476:31: -> ^( THROWS ( qid )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:476:34: ^( THROWS ( qid )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_THROWS.nextNode(), root_1);
				if ( !(stream_qid.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_qid.hasNext() ) {
					adaptor.addChild(root_1, stream_qid.nextTree());
				}
				stream_qid.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "throwsSpec"


	public static class localsSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "localsSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:480:1: localsSpec : LOCALS ^ ARG_ACTION ;
	public final ANTLRParser.localsSpec_return localsSpec() throws RecognitionException {
		ANTLRParser.localsSpec_return retval = new ANTLRParser.localsSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LOCALS96=null;
		Token ARG_ACTION97=null;

		GrammarAST LOCALS96_tree=null;
		GrammarAST ARG_ACTION97_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:480:12: ( LOCALS ^ ARG_ACTION )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:480:14: LOCALS ^ ARG_ACTION
			{
			root_0 = (GrammarAST)adaptor.nil();


			LOCALS96=(Token)match(input,LOCALS,FOLLOW_LOCALS_in_localsSpec1996); 
			LOCALS96_tree = (GrammarAST)adaptor.create(LOCALS96);
			root_0 = (GrammarAST)adaptor.becomeRoot(LOCALS96_tree, root_0);

			ARG_ACTION97=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_localsSpec1999); 
			ARG_ACTION97_tree = new ActionAST(ARG_ACTION97) ;
			adaptor.addChild(root_0, ARG_ACTION97_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "localsSpec"


	public static class ruleAction_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleAction"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:491:1: ruleAction : AT id ACTION -> ^( AT id ACTION ) ;
	public final ANTLRParser.ruleAction_return ruleAction() throws RecognitionException {
		ANTLRParser.ruleAction_return retval = new ANTLRParser.ruleAction_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token AT98=null;
		Token ACTION100=null;
		ParserRuleReturnScope id99 =null;

		GrammarAST AT98_tree=null;
		GrammarAST ACTION100_tree=null;
		RewriteRuleTokenStream stream_AT=new RewriteRuleTokenStream(adaptor,"token AT");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:492:2: ( AT id ACTION -> ^( AT id ACTION ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:492:4: AT id ACTION
			{
			AT98=(Token)match(input,AT,FOLLOW_AT_in_ruleAction2022);  
			stream_AT.add(AT98);

			pushFollow(FOLLOW_id_in_ruleAction2024);
			id99=id();
			state._fsp--;

			stream_id.add(id99.getTree());
			ACTION100=(Token)match(input,ACTION,FOLLOW_ACTION_in_ruleAction2026);  
			stream_ACTION.add(ACTION100);

			// AST REWRITE
			// elements: ACTION, id, AT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 492:17: -> ^( AT id ACTION )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:492:20: ^( AT id ACTION )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_AT.nextNode(), root_1);
				adaptor.addChild(root_1, stream_id.nextTree());
				adaptor.addChild(root_1, new ActionAST(stream_ACTION.nextToken()));
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleAction"


	public static class ruleBlock_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleBlock"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:501:1: ruleBlock : ruleAltList -> ^( BLOCK[colon,\"BLOCK\"] ruleAltList ) ;
	public final ANTLRParser.ruleBlock_return ruleBlock() throws RecognitionException {
		ANTLRParser.ruleBlock_return retval = new ANTLRParser.ruleBlock_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope ruleAltList101 =null;

		RewriteRuleSubtreeStream stream_ruleAltList=new RewriteRuleSubtreeStream(adaptor,"rule ruleAltList");

		Token colon = input.LT(-1);
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:503:5: ( ruleAltList -> ^( BLOCK[colon,\"BLOCK\"] ruleAltList ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:503:7: ruleAltList
			{
			pushFollow(FOLLOW_ruleAltList_in_ruleBlock2064);
			ruleAltList101=ruleAltList();
			state._fsp--;

			stream_ruleAltList.add(ruleAltList101.getTree());
			// AST REWRITE
			// elements: ruleAltList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 503:19: -> ^( BLOCK[colon,\"BLOCK\"] ruleAltList )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:503:22: ^( BLOCK[colon,\"BLOCK\"] ruleAltList )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, colon, "BLOCK"), root_1);
				adaptor.addChild(root_1, stream_ruleAltList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (ResyncToEndOfRuleBlock e) {

			    	// just resyncing; ignore error
					retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), null);
			    
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleBlock"


	public static class ruleAltList_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleAltList"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:510:1: ruleAltList : labeledAlt ( OR labeledAlt )* -> ( labeledAlt )+ ;
	public final ANTLRParser.ruleAltList_return ruleAltList() throws RecognitionException {
		ANTLRParser.ruleAltList_return retval = new ANTLRParser.ruleAltList_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token OR103=null;
		ParserRuleReturnScope labeledAlt102 =null;
		ParserRuleReturnScope labeledAlt104 =null;

		GrammarAST OR103_tree=null;
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_labeledAlt=new RewriteRuleSubtreeStream(adaptor,"rule labeledAlt");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:511:2: ( labeledAlt ( OR labeledAlt )* -> ( labeledAlt )+ )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:511:4: labeledAlt ( OR labeledAlt )*
			{
			pushFollow(FOLLOW_labeledAlt_in_ruleAltList2100);
			labeledAlt102=labeledAlt();
			state._fsp--;

			stream_labeledAlt.add(labeledAlt102.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:511:15: ( OR labeledAlt )*
			loop29:
			while (true) {
				int alt29=2;
				switch ( input.LA(1) ) {
				case OR:
					{
					alt29=1;
					}
					break;
				}
				switch (alt29) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:511:16: OR labeledAlt
					{
					OR103=(Token)match(input,OR,FOLLOW_OR_in_ruleAltList2103);  
					stream_OR.add(OR103);

					pushFollow(FOLLOW_labeledAlt_in_ruleAltList2105);
					labeledAlt104=labeledAlt();
					state._fsp--;

					stream_labeledAlt.add(labeledAlt104.getTree());
					}
					break;

				default :
					break loop29;
				}
			}

			// AST REWRITE
			// elements: labeledAlt
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 511:32: -> ( labeledAlt )+
			{
				if ( !(stream_labeledAlt.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_labeledAlt.hasNext() ) {
					adaptor.addChild(root_0, stream_labeledAlt.nextTree());
				}
				stream_labeledAlt.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleAltList"


	public static class labeledAlt_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "labeledAlt"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:514:1: labeledAlt : alternative ( POUND ! id !)? ;
	public final ANTLRParser.labeledAlt_return labeledAlt() throws RecognitionException {
		ANTLRParser.labeledAlt_return retval = new ANTLRParser.labeledAlt_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token POUND106=null;
		ParserRuleReturnScope alternative105 =null;
		ParserRuleReturnScope id107 =null;

		GrammarAST POUND106_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:515:2: ( alternative ( POUND ! id !)? )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:515:4: alternative ( POUND ! id !)?
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_alternative_in_labeledAlt2123);
			alternative105=alternative();
			state._fsp--;

			adaptor.addChild(root_0, alternative105.getTree());

			// org\\antlr\\v4\\parse\\ANTLRParser.g:516:3: ( POUND ! id !)?
			int alt30=2;
			switch ( input.LA(1) ) {
				case POUND:
					{
					alt30=1;
					}
					break;
			}
			switch (alt30) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:516:5: POUND ! id !
					{
					POUND106=(Token)match(input,POUND,FOLLOW_POUND_in_labeledAlt2129); 
					pushFollow(FOLLOW_id_in_labeledAlt2132);
					id107=id();
					state._fsp--;

					((AltAST)(alternative105!=null?((GrammarAST)alternative105.getTree()):null)).altLabel=(id107!=null?((GrammarAST)id107.getTree()):null);
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "labeledAlt"


	public static class lexerRule_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerRule"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:520:1: lexerRule : ( DOC_COMMENT )? ( FRAGMENT )? TOKEN_REF COLON lexerRuleBlock SEMI -> ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS FRAGMENT ) )? lexerRuleBlock ) ;
	public final ANTLRParser.lexerRule_return lexerRule() throws RecognitionException {
		ANTLRParser.lexerRule_return retval = new ANTLRParser.lexerRule_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOC_COMMENT108=null;
		Token FRAGMENT109=null;
		Token TOKEN_REF110=null;
		Token COLON111=null;
		Token SEMI113=null;
		ParserRuleReturnScope lexerRuleBlock112 =null;

		GrammarAST DOC_COMMENT108_tree=null;
		GrammarAST FRAGMENT109_tree=null;
		GrammarAST TOKEN_REF110_tree=null;
		GrammarAST COLON111_tree=null;
		GrammarAST SEMI113_tree=null;
		RewriteRuleTokenStream stream_DOC_COMMENT=new RewriteRuleTokenStream(adaptor,"token DOC_COMMENT");
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_FRAGMENT=new RewriteRuleTokenStream(adaptor,"token FRAGMENT");
		RewriteRuleTokenStream stream_TOKEN_REF=new RewriteRuleTokenStream(adaptor,"token TOKEN_REF");
		RewriteRuleSubtreeStream stream_lexerRuleBlock=new RewriteRuleSubtreeStream(adaptor,"rule lexerRuleBlock");

		 paraphrases.push("matching a lexer rule"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:525:5: ( ( DOC_COMMENT )? ( FRAGMENT )? TOKEN_REF COLON lexerRuleBlock SEMI -> ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS FRAGMENT ) )? lexerRuleBlock ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:525:7: ( DOC_COMMENT )? ( FRAGMENT )? TOKEN_REF COLON lexerRuleBlock SEMI
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:525:7: ( DOC_COMMENT )?
			int alt31=2;
			switch ( input.LA(1) ) {
				case DOC_COMMENT:
					{
					alt31=1;
					}
					break;
			}
			switch (alt31) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:525:7: DOC_COMMENT
					{
					DOC_COMMENT108=(Token)match(input,DOC_COMMENT,FOLLOW_DOC_COMMENT_in_lexerRule2164);  
					stream_DOC_COMMENT.add(DOC_COMMENT108);

					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:525:20: ( FRAGMENT )?
			int alt32=2;
			switch ( input.LA(1) ) {
				case FRAGMENT:
					{
					alt32=1;
					}
					break;
			}
			switch (alt32) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:525:20: FRAGMENT
					{
					FRAGMENT109=(Token)match(input,FRAGMENT,FOLLOW_FRAGMENT_in_lexerRule2167);  
					stream_FRAGMENT.add(FRAGMENT109);

					}
					break;

			}

			TOKEN_REF110=(Token)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_lexerRule2173);  
			stream_TOKEN_REF.add(TOKEN_REF110);

			COLON111=(Token)match(input,COLON,FOLLOW_COLON_in_lexerRule2175);  
			stream_COLON.add(COLON111);

			pushFollow(FOLLOW_lexerRuleBlock_in_lexerRule2177);
			lexerRuleBlock112=lexerRuleBlock();
			state._fsp--;

			stream_lexerRuleBlock.add(lexerRuleBlock112.getTree());
			SEMI113=(Token)match(input,SEMI,FOLLOW_SEMI_in_lexerRule2179);  
			stream_SEMI.add(SEMI113);

			// AST REWRITE
			// elements: lexerRuleBlock, TOKEN_REF, DOC_COMMENT, FRAGMENT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 527:7: -> ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS FRAGMENT ) )? lexerRuleBlock )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:527:10: ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS FRAGMENT ) )? lexerRuleBlock )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new RuleAST(RULE), root_1);
				adaptor.addChild(root_1, stream_TOKEN_REF.nextNode());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:527:37: ( DOC_COMMENT )?
				if ( stream_DOC_COMMENT.hasNext() ) {
					adaptor.addChild(root_1, stream_DOC_COMMENT.nextNode());
				}
				stream_DOC_COMMENT.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:528:9: ( ^( RULEMODIFIERS FRAGMENT ) )?
				if ( stream_FRAGMENT.hasNext() ) {
					// org\\antlr\\v4\\parse\\ANTLRParser.g:528:9: ^( RULEMODIFIERS FRAGMENT )
					{
					GrammarAST root_2 = (GrammarAST)adaptor.nil();
					root_2 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(RULEMODIFIERS, "RULEMODIFIERS"), root_2);
					adaptor.addChild(root_2, stream_FRAGMENT.nextNode());
					adaptor.addChild(root_1, root_2);
					}

				}
				stream_FRAGMENT.reset();

				adaptor.addChild(root_1, stream_lexerRuleBlock.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				paraphrases.pop();

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerRule"


	public static class lexerRuleBlock_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerRuleBlock"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:532:1: lexerRuleBlock : lexerAltList -> ^( BLOCK[colon,\"BLOCK\"] lexerAltList ) ;
	public final ANTLRParser.lexerRuleBlock_return lexerRuleBlock() throws RecognitionException {
		ANTLRParser.lexerRuleBlock_return retval = new ANTLRParser.lexerRuleBlock_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope lexerAltList114 =null;

		RewriteRuleSubtreeStream stream_lexerAltList=new RewriteRuleSubtreeStream(adaptor,"rule lexerAltList");

		Token colon = input.LT(-1);
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:534:5: ( lexerAltList -> ^( BLOCK[colon,\"BLOCK\"] lexerAltList ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:534:7: lexerAltList
			{
			pushFollow(FOLLOW_lexerAltList_in_lexerRuleBlock2246);
			lexerAltList114=lexerAltList();
			state._fsp--;

			stream_lexerAltList.add(lexerAltList114.getTree());
			// AST REWRITE
			// elements: lexerAltList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 534:20: -> ^( BLOCK[colon,\"BLOCK\"] lexerAltList )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:534:23: ^( BLOCK[colon,\"BLOCK\"] lexerAltList )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, colon, "BLOCK"), root_1);
				adaptor.addChild(root_1, stream_lexerAltList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (ResyncToEndOfRuleBlock e) {

			    	// just resyncing; ignore error
					retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), null);
			    
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerRuleBlock"


	public static class lexerAltList_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerAltList"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:541:1: lexerAltList : lexerAlt ( OR lexerAlt )* -> ( lexerAlt )+ ;
	public final ANTLRParser.lexerAltList_return lexerAltList() throws RecognitionException {
		ANTLRParser.lexerAltList_return retval = new ANTLRParser.lexerAltList_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token OR116=null;
		ParserRuleReturnScope lexerAlt115 =null;
		ParserRuleReturnScope lexerAlt117 =null;

		GrammarAST OR116_tree=null;
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_lexerAlt=new RewriteRuleSubtreeStream(adaptor,"rule lexerAlt");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:542:2: ( lexerAlt ( OR lexerAlt )* -> ( lexerAlt )+ )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:542:4: lexerAlt ( OR lexerAlt )*
			{
			pushFollow(FOLLOW_lexerAlt_in_lexerAltList2282);
			lexerAlt115=lexerAlt();
			state._fsp--;

			stream_lexerAlt.add(lexerAlt115.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:542:13: ( OR lexerAlt )*
			loop33:
			while (true) {
				int alt33=2;
				switch ( input.LA(1) ) {
				case OR:
					{
					alt33=1;
					}
					break;
				}
				switch (alt33) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:542:14: OR lexerAlt
					{
					OR116=(Token)match(input,OR,FOLLOW_OR_in_lexerAltList2285);  
					stream_OR.add(OR116);

					pushFollow(FOLLOW_lexerAlt_in_lexerAltList2287);
					lexerAlt117=lexerAlt();
					state._fsp--;

					stream_lexerAlt.add(lexerAlt117.getTree());
					}
					break;

				default :
					break loop33;
				}
			}

			// AST REWRITE
			// elements: lexerAlt
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 542:28: -> ( lexerAlt )+
			{
				if ( !(stream_lexerAlt.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_lexerAlt.hasNext() ) {
					adaptor.addChild(root_0, stream_lexerAlt.nextTree());
				}
				stream_lexerAlt.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerAltList"


	public static class lexerAlt_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerAlt"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:545:1: lexerAlt : lexerElements ( lexerCommands -> ^( LEXER_ALT_ACTION lexerElements lexerCommands ) | -> lexerElements ) ;
	public final ANTLRParser.lexerAlt_return lexerAlt() throws RecognitionException {
		ANTLRParser.lexerAlt_return retval = new ANTLRParser.lexerAlt_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope lexerElements118 =null;
		ParserRuleReturnScope lexerCommands119 =null;

		RewriteRuleSubtreeStream stream_lexerElements=new RewriteRuleSubtreeStream(adaptor,"rule lexerElements");
		RewriteRuleSubtreeStream stream_lexerCommands=new RewriteRuleSubtreeStream(adaptor,"rule lexerCommands");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:546:2: ( lexerElements ( lexerCommands -> ^( LEXER_ALT_ACTION lexerElements lexerCommands ) | -> lexerElements ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:546:4: lexerElements ( lexerCommands -> ^( LEXER_ALT_ACTION lexerElements lexerCommands ) | -> lexerElements )
			{
			pushFollow(FOLLOW_lexerElements_in_lexerAlt2305);
			lexerElements118=lexerElements();
			state._fsp--;

			stream_lexerElements.add(lexerElements118.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:547:3: ( lexerCommands -> ^( LEXER_ALT_ACTION lexerElements lexerCommands ) | -> lexerElements )
			int alt34=2;
			switch ( input.LA(1) ) {
			case RARROW:
				{
				alt34=1;
				}
				break;
			case OR:
			case RPAREN:
			case SEMI:
				{
				alt34=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 34, 0, input);
				throw nvae;
			}
			switch (alt34) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:547:5: lexerCommands
					{
					pushFollow(FOLLOW_lexerCommands_in_lexerAlt2311);
					lexerCommands119=lexerCommands();
					state._fsp--;

					stream_lexerCommands.add(lexerCommands119.getTree());
					// AST REWRITE
					// elements: lexerCommands, lexerElements
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 547:19: -> ^( LEXER_ALT_ACTION lexerElements lexerCommands )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:547:22: ^( LEXER_ALT_ACTION lexerElements lexerCommands )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new AltAST(LEXER_ALT_ACTION), root_1);
						adaptor.addChild(root_1, stream_lexerElements.nextTree());
						adaptor.addChild(root_1, stream_lexerCommands.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:548:9: 
					{
					// AST REWRITE
					// elements: lexerElements
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 548:9: -> lexerElements
					{
						adaptor.addChild(root_0, stream_lexerElements.nextTree());
					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerAlt"


	public static class lexerElements_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerElements"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:552:1: lexerElements : ( lexerElement )+ -> ^( ALT ( lexerElement )+ ) ;
	public final ANTLRParser.lexerElements_return lexerElements() throws RecognitionException {
		ANTLRParser.lexerElements_return retval = new ANTLRParser.lexerElements_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope lexerElement120 =null;

		RewriteRuleSubtreeStream stream_lexerElement=new RewriteRuleSubtreeStream(adaptor,"rule lexerElement");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:553:5: ( ( lexerElement )+ -> ^( ALT ( lexerElement )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:553:7: ( lexerElement )+
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:553:7: ( lexerElement )+
			int cnt35=0;
			loop35:
			while (true) {
				int alt35=2;
				switch ( input.LA(1) ) {
				case ACTION:
				case DOT:
				case LEXER_CHAR_SET:
				case LPAREN:
				case NOT:
				case RULE_REF:
				case SEMPRED:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt35=1;
					}
					break;
				}
				switch (alt35) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:553:7: lexerElement
					{
					pushFollow(FOLLOW_lexerElement_in_lexerElements2354);
					lexerElement120=lexerElement();
					state._fsp--;

					stream_lexerElement.add(lexerElement120.getTree());
					}
					break;

				default :
					if ( cnt35 >= 1 ) break loop35;
					EarlyExitException eee = new EarlyExitException(35, input);
					throw eee;
				}
				cnt35++;
			}

			// AST REWRITE
			// elements: lexerElement
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 553:21: -> ^( ALT ( lexerElement )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:553:24: ^( ALT ( lexerElement )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_1);
				if ( !(stream_lexerElement.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_lexerElement.hasNext() ) {
					adaptor.addChild(root_1, stream_lexerElement.nextTree());
				}
				stream_lexerElement.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerElements"


	public static class lexerElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:556:1: lexerElement : ( labeledLexerElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) ) | -> labeledLexerElement ) | lexerAtom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) ) | -> lexerAtom ) | lexerBlock ( ebnfSuffix -> ^( ebnfSuffix lexerBlock ) | -> lexerBlock ) | actionElement );
	public final ANTLRParser.lexerElement_return lexerElement() throws RecognitionException {
		ANTLRParser.lexerElement_return retval = new ANTLRParser.lexerElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope labeledLexerElement121 =null;
		ParserRuleReturnScope ebnfSuffix122 =null;
		ParserRuleReturnScope lexerAtom123 =null;
		ParserRuleReturnScope ebnfSuffix124 =null;
		ParserRuleReturnScope lexerBlock125 =null;
		ParserRuleReturnScope ebnfSuffix126 =null;
		ParserRuleReturnScope actionElement127 =null;

		RewriteRuleSubtreeStream stream_ebnfSuffix=new RewriteRuleSubtreeStream(adaptor,"rule ebnfSuffix");
		RewriteRuleSubtreeStream stream_lexerBlock=new RewriteRuleSubtreeStream(adaptor,"rule lexerBlock");
		RewriteRuleSubtreeStream stream_labeledLexerElement=new RewriteRuleSubtreeStream(adaptor,"rule labeledLexerElement");
		RewriteRuleSubtreeStream stream_lexerAtom=new RewriteRuleSubtreeStream(adaptor,"rule lexerAtom");


			paraphrases.push("looking for lexer rule element");
			int m = input.mark();

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:562:2: ( labeledLexerElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) ) | -> labeledLexerElement ) | lexerAtom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) ) | -> lexerAtom ) | lexerBlock ( ebnfSuffix -> ^( ebnfSuffix lexerBlock ) | -> lexerBlock ) | actionElement )
			int alt39=4;
			switch ( input.LA(1) ) {
			case RULE_REF:
				{
				switch ( input.LA(2) ) {
				case ASSIGN:
				case PLUS_ASSIGN:
					{
					alt39=1;
					}
					break;
				case ACTION:
				case DOT:
				case LEXER_CHAR_SET:
				case LPAREN:
				case NOT:
				case OR:
				case PLUS:
				case QUESTION:
				case RARROW:
				case RPAREN:
				case RULE_REF:
				case SEMI:
				case SEMPRED:
				case STAR:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt39=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 39, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TOKEN_REF:
				{
				switch ( input.LA(2) ) {
				case ASSIGN:
				case PLUS_ASSIGN:
					{
					alt39=1;
					}
					break;
				case ACTION:
				case DOT:
				case LEXER_CHAR_SET:
				case LPAREN:
				case LT:
				case NOT:
				case OR:
				case PLUS:
				case QUESTION:
				case RARROW:
				case RPAREN:
				case RULE_REF:
				case SEMI:
				case SEMPRED:
				case STAR:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt39=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 39, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case DOT:
			case LEXER_CHAR_SET:
			case NOT:
			case STRING_LITERAL:
				{
				alt39=2;
				}
				break;
			case LPAREN:
				{
				alt39=3;
				}
				break;
			case ACTION:
			case SEMPRED:
				{
				alt39=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}
			switch (alt39) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:562:4: labeledLexerElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) ) | -> labeledLexerElement )
					{
					pushFollow(FOLLOW_labeledLexerElement_in_lexerElement2391);
					labeledLexerElement121=labeledLexerElement();
					state._fsp--;

					stream_labeledLexerElement.add(labeledLexerElement121.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:563:3: ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) ) | -> labeledLexerElement )
					int alt36=2;
					switch ( input.LA(1) ) {
					case PLUS:
					case QUESTION:
					case STAR:
						{
						alt36=1;
						}
						break;
					case ACTION:
					case DOT:
					case LEXER_CHAR_SET:
					case LPAREN:
					case NOT:
					case OR:
					case RARROW:
					case RPAREN:
					case RULE_REF:
					case SEMI:
					case SEMPRED:
					case STRING_LITERAL:
					case TOKEN_REF:
						{
						alt36=2;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 36, 0, input);
						throw nvae;
					}
					switch (alt36) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:563:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_lexerElement2397);
							ebnfSuffix122=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix122.getTree());
							// AST REWRITE
							// elements: labeledLexerElement, ebnfSuffix
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 563:16: -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:563:19: ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:563:33: ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) )
								{
								GrammarAST root_2 = (GrammarAST)adaptor.nil();
								root_2 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, (labeledLexerElement121!=null?(labeledLexerElement121.start):null), "BLOCK"), root_2);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:563:87: ^( ALT labeledLexerElement )
								{
								GrammarAST root_3 = (GrammarAST)adaptor.nil();
								root_3 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_3);
								adaptor.addChild(root_3, stream_labeledLexerElement.nextTree());
								adaptor.addChild(root_2, root_3);
								}

								adaptor.addChild(root_1, root_2);
								}

								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:564:8: 
							{
							// AST REWRITE
							// elements: labeledLexerElement
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 564:8: -> labeledLexerElement
							{
								adaptor.addChild(root_0, stream_labeledLexerElement.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:566:4: lexerAtom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) ) | -> lexerAtom )
					{
					pushFollow(FOLLOW_lexerAtom_in_lexerElement2443);
					lexerAtom123=lexerAtom();
					state._fsp--;

					stream_lexerAtom.add(lexerAtom123.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:567:3: ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) ) | -> lexerAtom )
					int alt37=2;
					switch ( input.LA(1) ) {
					case PLUS:
					case QUESTION:
					case STAR:
						{
						alt37=1;
						}
						break;
					case ACTION:
					case DOT:
					case LEXER_CHAR_SET:
					case LPAREN:
					case NOT:
					case OR:
					case RARROW:
					case RPAREN:
					case RULE_REF:
					case SEMI:
					case SEMPRED:
					case STRING_LITERAL:
					case TOKEN_REF:
						{
						alt37=2;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 37, 0, input);
						throw nvae;
					}
					switch (alt37) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:567:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_lexerElement2449);
							ebnfSuffix124=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix124.getTree());
							// AST REWRITE
							// elements: lexerAtom, ebnfSuffix
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 567:16: -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:567:19: ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:567:33: ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) )
								{
								GrammarAST root_2 = (GrammarAST)adaptor.nil();
								root_2 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, (lexerAtom123!=null?(lexerAtom123.start):null), "BLOCK"), root_2);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:567:77: ^( ALT lexerAtom )
								{
								GrammarAST root_3 = (GrammarAST)adaptor.nil();
								root_3 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_3);
								adaptor.addChild(root_3, stream_lexerAtom.nextTree());
								adaptor.addChild(root_2, root_3);
								}

								adaptor.addChild(root_1, root_2);
								}

								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:568:8: 
							{
							// AST REWRITE
							// elements: lexerAtom
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 568:8: -> lexerAtom
							{
								adaptor.addChild(root_0, stream_lexerAtom.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:570:4: lexerBlock ( ebnfSuffix -> ^( ebnfSuffix lexerBlock ) | -> lexerBlock )
					{
					pushFollow(FOLLOW_lexerBlock_in_lexerElement2495);
					lexerBlock125=lexerBlock();
					state._fsp--;

					stream_lexerBlock.add(lexerBlock125.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:571:3: ( ebnfSuffix -> ^( ebnfSuffix lexerBlock ) | -> lexerBlock )
					int alt38=2;
					switch ( input.LA(1) ) {
					case PLUS:
					case QUESTION:
					case STAR:
						{
						alt38=1;
						}
						break;
					case ACTION:
					case DOT:
					case LEXER_CHAR_SET:
					case LPAREN:
					case NOT:
					case OR:
					case RARROW:
					case RPAREN:
					case RULE_REF:
					case SEMI:
					case SEMPRED:
					case STRING_LITERAL:
					case TOKEN_REF:
						{
						alt38=2;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 38, 0, input);
						throw nvae;
					}
					switch (alt38) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:571:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_lexerElement2501);
							ebnfSuffix126=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix126.getTree());
							// AST REWRITE
							// elements: ebnfSuffix, lexerBlock
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 571:16: -> ^( ebnfSuffix lexerBlock )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:571:19: ^( ebnfSuffix lexerBlock )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								adaptor.addChild(root_1, stream_lexerBlock.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:572:8: 
							{
							// AST REWRITE
							// elements: lexerBlock
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 572:8: -> lexerBlock
							{
								adaptor.addChild(root_0, stream_lexerBlock.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:574:4: actionElement
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_actionElement_in_lexerElement2529);
					actionElement127=actionElement();
					state._fsp--;

					adaptor.addChild(root_0, actionElement127.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {

			    	retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
			    	int ttype = input.get(input.range()).getType(); // seems to be next token
				    // look for anything that really belongs at the start of the rule minus the initial ID
			    	if ( ttype==COLON || ttype==RETURNS || ttype==CATCH || ttype==FINALLY || ttype==AT || ttype==EOF ) {
						RecognitionException missingSemi =
							new v4ParserException("unterminated rule (missing ';') detected at '"+
												  input.LT(1).getText()+" "+input.LT(2).getText()+"'", input);
						reportError(missingSemi);
						if ( ttype==EOF ) {
							input.seek(input.index()+1);
						}
						else if ( ttype==CATCH || ttype==FINALLY ) {
							input.seek(input.range()); // ignore what's before rule trailer stuff
						}
						else if ( ttype==RETURNS || ttype==AT ) { // scan back looking for ID of rule header
							int p = input.index();
							Token t = input.get(p);
							while ( t.getType()!=RULE_REF && t.getType()!=TOKEN_REF ) {
								p--;
								t = input.get(p);
							}
							input.seek(p);
						}
						throw new ResyncToEndOfRuleBlock(); // make sure it goes back to rule block level to recover
					}
			        reportError(re);
			        recover(input,re);
				
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerElement"


	public static class labeledLexerElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "labeledLexerElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:607:1: labeledLexerElement : id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( lexerAtom -> ^( $ass id lexerAtom ) | lexerBlock -> ^( $ass id lexerBlock ) ) ;
	public final ANTLRParser.labeledLexerElement_return labeledLexerElement() throws RecognitionException {
		ANTLRParser.labeledLexerElement_return retval = new ANTLRParser.labeledLexerElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ass=null;
		ParserRuleReturnScope id128 =null;
		ParserRuleReturnScope lexerAtom129 =null;
		ParserRuleReturnScope lexerBlock130 =null;

		GrammarAST ass_tree=null;
		RewriteRuleTokenStream stream_ASSIGN=new RewriteRuleTokenStream(adaptor,"token ASSIGN");
		RewriteRuleTokenStream stream_PLUS_ASSIGN=new RewriteRuleTokenStream(adaptor,"token PLUS_ASSIGN");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_lexerBlock=new RewriteRuleSubtreeStream(adaptor,"rule lexerBlock");
		RewriteRuleSubtreeStream stream_lexerAtom=new RewriteRuleSubtreeStream(adaptor,"rule lexerAtom");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:608:2: ( id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( lexerAtom -> ^( $ass id lexerAtom ) | lexerBlock -> ^( $ass id lexerBlock ) ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:608:4: id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( lexerAtom -> ^( $ass id lexerAtom ) | lexerBlock -> ^( $ass id lexerBlock ) )
			{
			pushFollow(FOLLOW_id_in_labeledLexerElement2559);
			id128=id();
			state._fsp--;

			stream_id.add(id128.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:608:7: (ass= ASSIGN |ass= PLUS_ASSIGN )
			int alt40=2;
			switch ( input.LA(1) ) {
			case ASSIGN:
				{
				alt40=1;
				}
				break;
			case PLUS_ASSIGN:
				{
				alt40=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}
			switch (alt40) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:608:8: ass= ASSIGN
					{
					ass=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_labeledLexerElement2564);  
					stream_ASSIGN.add(ass);

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:608:19: ass= PLUS_ASSIGN
					{
					ass=(Token)match(input,PLUS_ASSIGN,FOLLOW_PLUS_ASSIGN_in_labeledLexerElement2568);  
					stream_PLUS_ASSIGN.add(ass);

					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:609:3: ( lexerAtom -> ^( $ass id lexerAtom ) | lexerBlock -> ^( $ass id lexerBlock ) )
			int alt41=2;
			switch ( input.LA(1) ) {
			case DOT:
			case LEXER_CHAR_SET:
			case NOT:
			case RULE_REF:
			case STRING_LITERAL:
			case TOKEN_REF:
				{
				alt41=1;
				}
				break;
			case LPAREN:
				{
				alt41=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 41, 0, input);
				throw nvae;
			}
			switch (alt41) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:609:5: lexerAtom
					{
					pushFollow(FOLLOW_lexerAtom_in_labeledLexerElement2575);
					lexerAtom129=lexerAtom();
					state._fsp--;

					stream_lexerAtom.add(lexerAtom129.getTree());
					// AST REWRITE
					// elements: ass, id, lexerAtom
					// token labels: ass
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleTokenStream stream_ass=new RewriteRuleTokenStream(adaptor,"token ass",ass);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 609:15: -> ^( $ass id lexerAtom )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:609:18: ^( $ass id lexerAtom )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_ass.nextNode(), root_1);
						adaptor.addChild(root_1, stream_id.nextTree());
						adaptor.addChild(root_1, stream_lexerAtom.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:610:5: lexerBlock
					{
					pushFollow(FOLLOW_lexerBlock_in_labeledLexerElement2592);
					lexerBlock130=lexerBlock();
					state._fsp--;

					stream_lexerBlock.add(lexerBlock130.getTree());
					// AST REWRITE
					// elements: lexerBlock, ass, id
					// token labels: ass
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleTokenStream stream_ass=new RewriteRuleTokenStream(adaptor,"token ass",ass);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 610:16: -> ^( $ass id lexerBlock )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:610:19: ^( $ass id lexerBlock )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_ass.nextNode(), root_1);
						adaptor.addChild(root_1, stream_id.nextTree());
						adaptor.addChild(root_1, stream_lexerBlock.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "labeledLexerElement"


	public static class lexerBlock_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerBlock"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:615:1: lexerBlock : LPAREN ( optionsSpec COLON )? lexerAltList RPAREN -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? lexerAltList ) ;
	public final ANTLRParser.lexerBlock_return lexerBlock() throws RecognitionException {
		ANTLRParser.lexerBlock_return retval = new ANTLRParser.lexerBlock_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LPAREN131=null;
		Token COLON133=null;
		Token RPAREN135=null;
		ParserRuleReturnScope optionsSpec132 =null;
		ParserRuleReturnScope lexerAltList134 =null;

		GrammarAST LPAREN131_tree=null;
		GrammarAST COLON133_tree=null;
		GrammarAST RPAREN135_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleSubtreeStream stream_optionsSpec=new RewriteRuleSubtreeStream(adaptor,"rule optionsSpec");
		RewriteRuleSubtreeStream stream_lexerAltList=new RewriteRuleSubtreeStream(adaptor,"rule lexerAltList");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:622:3: ( LPAREN ( optionsSpec COLON )? lexerAltList RPAREN -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? lexerAltList ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:622:5: LPAREN ( optionsSpec COLON )? lexerAltList RPAREN
			{
			LPAREN131=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_lexerBlock2625);  
			stream_LPAREN.add(LPAREN131);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:623:9: ( optionsSpec COLON )?
			int alt42=2;
			switch ( input.LA(1) ) {
				case OPTIONS:
					{
					alt42=1;
					}
					break;
			}
			switch (alt42) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:623:11: optionsSpec COLON
					{
					pushFollow(FOLLOW_optionsSpec_in_lexerBlock2637);
					optionsSpec132=optionsSpec();
					state._fsp--;

					stream_optionsSpec.add(optionsSpec132.getTree());
					COLON133=(Token)match(input,COLON,FOLLOW_COLON_in_lexerBlock2639);  
					stream_COLON.add(COLON133);

					}
					break;

			}

			pushFollow(FOLLOW_lexerAltList_in_lexerBlock2652);
			lexerAltList134=lexerAltList();
			state._fsp--;

			stream_lexerAltList.add(lexerAltList134.getTree());
			RPAREN135=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_lexerBlock2662);  
			stream_RPAREN.add(RPAREN135);

			// AST REWRITE
			// elements: lexerAltList, optionsSpec
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 626:7: -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? lexerAltList )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:626:10: ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? lexerAltList )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, LPAREN131, "BLOCK"), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:626:45: ( optionsSpec )?
				if ( stream_optionsSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_optionsSpec.nextTree());
				}
				stream_optionsSpec.reset();

				adaptor.addChild(root_1, stream_lexerAltList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.OPTIONS);
			if ( options!=null ) {
				Grammar.setNodeOptions(retval.tree, options);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerBlock"


	public static class lexerCommands_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerCommands"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:630:1: lexerCommands : RARROW lexerCommand ( COMMA lexerCommand )* -> ( lexerCommand )+ ;
	public final ANTLRParser.lexerCommands_return lexerCommands() throws RecognitionException {
		ANTLRParser.lexerCommands_return retval = new ANTLRParser.lexerCommands_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RARROW136=null;
		Token COMMA138=null;
		ParserRuleReturnScope lexerCommand137 =null;
		ParserRuleReturnScope lexerCommand139 =null;

		GrammarAST RARROW136_tree=null;
		GrammarAST COMMA138_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_RARROW=new RewriteRuleTokenStream(adaptor,"token RARROW");
		RewriteRuleSubtreeStream stream_lexerCommand=new RewriteRuleSubtreeStream(adaptor,"rule lexerCommand");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:631:2: ( RARROW lexerCommand ( COMMA lexerCommand )* -> ( lexerCommand )+ )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:631:4: RARROW lexerCommand ( COMMA lexerCommand )*
			{
			RARROW136=(Token)match(input,RARROW,FOLLOW_RARROW_in_lexerCommands2699);  
			stream_RARROW.add(RARROW136);

			pushFollow(FOLLOW_lexerCommand_in_lexerCommands2701);
			lexerCommand137=lexerCommand();
			state._fsp--;

			stream_lexerCommand.add(lexerCommand137.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:631:24: ( COMMA lexerCommand )*
			loop43:
			while (true) {
				int alt43=2;
				switch ( input.LA(1) ) {
				case COMMA:
					{
					alt43=1;
					}
					break;
				}
				switch (alt43) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:631:25: COMMA lexerCommand
					{
					COMMA138=(Token)match(input,COMMA,FOLLOW_COMMA_in_lexerCommands2704);  
					stream_COMMA.add(COMMA138);

					pushFollow(FOLLOW_lexerCommand_in_lexerCommands2706);
					lexerCommand139=lexerCommand();
					state._fsp--;

					stream_lexerCommand.add(lexerCommand139.getTree());
					}
					break;

				default :
					break loop43;
				}
			}

			// AST REWRITE
			// elements: lexerCommand
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 631:46: -> ( lexerCommand )+
			{
				if ( !(stream_lexerCommand.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_lexerCommand.hasNext() ) {
					adaptor.addChild(root_0, stream_lexerCommand.nextTree());
				}
				stream_lexerCommand.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommands"


	public static class lexerCommand_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerCommand"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:634:1: lexerCommand : ( lexerCommandName LPAREN lexerCommandExpr RPAREN -> ^( LEXER_ACTION_CALL lexerCommandName lexerCommandExpr ) | lexerCommandName );
	public final ANTLRParser.lexerCommand_return lexerCommand() throws RecognitionException {
		ANTLRParser.lexerCommand_return retval = new ANTLRParser.lexerCommand_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LPAREN141=null;
		Token RPAREN143=null;
		ParserRuleReturnScope lexerCommandName140 =null;
		ParserRuleReturnScope lexerCommandExpr142 =null;
		ParserRuleReturnScope lexerCommandName144 =null;

		GrammarAST LPAREN141_tree=null;
		GrammarAST RPAREN143_tree=null;
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleSubtreeStream stream_lexerCommandName=new RewriteRuleSubtreeStream(adaptor,"rule lexerCommandName");
		RewriteRuleSubtreeStream stream_lexerCommandExpr=new RewriteRuleSubtreeStream(adaptor,"rule lexerCommandExpr");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:635:2: ( lexerCommandName LPAREN lexerCommandExpr RPAREN -> ^( LEXER_ACTION_CALL lexerCommandName lexerCommandExpr ) | lexerCommandName )
			int alt44=2;
			switch ( input.LA(1) ) {
			case RULE_REF:
				{
				switch ( input.LA(2) ) {
				case LPAREN:
					{
					alt44=1;
					}
					break;
				case COMMA:
				case OR:
				case RPAREN:
				case SEMI:
					{
					alt44=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 44, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TOKEN_REF:
				{
				switch ( input.LA(2) ) {
				case LPAREN:
					{
					alt44=1;
					}
					break;
				case COMMA:
				case OR:
				case RPAREN:
				case SEMI:
					{
					alt44=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 44, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case MODE:
				{
				switch ( input.LA(2) ) {
				case LPAREN:
					{
					alt44=1;
					}
					break;
				case COMMA:
				case OR:
				case RPAREN:
				case SEMI:
					{
					alt44=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 44, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 44, 0, input);
				throw nvae;
			}
			switch (alt44) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:635:4: lexerCommandName LPAREN lexerCommandExpr RPAREN
					{
					pushFollow(FOLLOW_lexerCommandName_in_lexerCommand2724);
					lexerCommandName140=lexerCommandName();
					state._fsp--;

					stream_lexerCommandName.add(lexerCommandName140.getTree());
					LPAREN141=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_lexerCommand2726);  
					stream_LPAREN.add(LPAREN141);

					pushFollow(FOLLOW_lexerCommandExpr_in_lexerCommand2728);
					lexerCommandExpr142=lexerCommandExpr();
					state._fsp--;

					stream_lexerCommandExpr.add(lexerCommandExpr142.getTree());
					RPAREN143=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_lexerCommand2730);  
					stream_RPAREN.add(RPAREN143);

					// AST REWRITE
					// elements: lexerCommandName, lexerCommandExpr
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 635:52: -> ^( LEXER_ACTION_CALL lexerCommandName lexerCommandExpr )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:635:55: ^( LEXER_ACTION_CALL lexerCommandName lexerCommandExpr )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(LEXER_ACTION_CALL, "LEXER_ACTION_CALL"), root_1);
						adaptor.addChild(root_1, stream_lexerCommandName.nextTree());
						adaptor.addChild(root_1, stream_lexerCommandExpr.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:636:4: lexerCommandName
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_lexerCommandName_in_lexerCommand2745);
					lexerCommandName144=lexerCommandName();
					state._fsp--;

					adaptor.addChild(root_0, lexerCommandName144.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommand"


	public static class lexerCommandExpr_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerCommandExpr"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:639:1: lexerCommandExpr : ( id | INT );
	public final ANTLRParser.lexerCommandExpr_return lexerCommandExpr() throws RecognitionException {
		ANTLRParser.lexerCommandExpr_return retval = new ANTLRParser.lexerCommandExpr_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token INT146=null;
		ParserRuleReturnScope id145 =null;

		GrammarAST INT146_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:640:2: ( id | INT )
			int alt45=2;
			switch ( input.LA(1) ) {
			case RULE_REF:
			case TOKEN_REF:
				{
				alt45=1;
				}
				break;
			case INT:
				{
				alt45=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 45, 0, input);
				throw nvae;
			}
			switch (alt45) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:640:4: id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_lexerCommandExpr2756);
					id145=id();
					state._fsp--;

					adaptor.addChild(root_0, id145.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:641:4: INT
					{
					root_0 = (GrammarAST)adaptor.nil();


					INT146=(Token)match(input,INT,FOLLOW_INT_in_lexerCommandExpr2761); 
					INT146_tree = (GrammarAST)adaptor.create(INT146);
					adaptor.addChild(root_0, INT146_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommandExpr"


	public static class lexerCommandName_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerCommandName"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:644:1: lexerCommandName : ( id | MODE -> ID[$MODE] );
	public final ANTLRParser.lexerCommandName_return lexerCommandName() throws RecognitionException {
		ANTLRParser.lexerCommandName_return retval = new ANTLRParser.lexerCommandName_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token MODE148=null;
		ParserRuleReturnScope id147 =null;

		GrammarAST MODE148_tree=null;
		RewriteRuleTokenStream stream_MODE=new RewriteRuleTokenStream(adaptor,"token MODE");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:645:9: ( id | MODE -> ID[$MODE] )
			int alt46=2;
			switch ( input.LA(1) ) {
			case RULE_REF:
			case TOKEN_REF:
				{
				alt46=1;
				}
				break;
			case MODE:
				{
				alt46=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 46, 0, input);
				throw nvae;
			}
			switch (alt46) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:645:17: id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_lexerCommandName2785);
					id147=id();
					state._fsp--;

					adaptor.addChild(root_0, id147.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:646:17: MODE
					{
					MODE148=(Token)match(input,MODE,FOLLOW_MODE_in_lexerCommandName2803);  
					stream_MODE.add(MODE148);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 646:25: -> ID[$MODE]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, MODE148));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommandName"


	public static class altList_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "altList"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:649:1: altList : alternative ( OR alternative )* -> ( alternative )+ ;
	public final ANTLRParser.altList_return altList() throws RecognitionException {
		ANTLRParser.altList_return retval = new ANTLRParser.altList_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token OR150=null;
		ParserRuleReturnScope alternative149 =null;
		ParserRuleReturnScope alternative151 =null;

		GrammarAST OR150_tree=null;
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_alternative=new RewriteRuleSubtreeStream(adaptor,"rule alternative");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:650:5: ( alternative ( OR alternative )* -> ( alternative )+ )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:650:7: alternative ( OR alternative )*
			{
			pushFollow(FOLLOW_alternative_in_altList2831);
			alternative149=alternative();
			state._fsp--;

			stream_alternative.add(alternative149.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:650:19: ( OR alternative )*
			loop47:
			while (true) {
				int alt47=2;
				switch ( input.LA(1) ) {
				case OR:
					{
					alt47=1;
					}
					break;
				}
				switch (alt47) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:650:20: OR alternative
					{
					OR150=(Token)match(input,OR,FOLLOW_OR_in_altList2834);  
					stream_OR.add(OR150);

					pushFollow(FOLLOW_alternative_in_altList2836);
					alternative151=alternative();
					state._fsp--;

					stream_alternative.add(alternative151.getTree());
					}
					break;

				default :
					break loop47;
				}
			}

			// AST REWRITE
			// elements: alternative
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 650:37: -> ( alternative )+
			{
				if ( !(stream_alternative.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_alternative.hasNext() ) {
					adaptor.addChild(root_0, stream_alternative.nextTree());
				}
				stream_alternative.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "altList"


	public static class alternative_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "alternative"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:655:1: alternative : ( elements -> elements | -> ^( ALT EPSILON ) );
	public final ANTLRParser.alternative_return alternative() throws RecognitionException {
		ANTLRParser.alternative_return retval = new ANTLRParser.alternative_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope elements152 =null;

		RewriteRuleSubtreeStream stream_elements=new RewriteRuleSubtreeStream(adaptor,"rule elements");

		 paraphrases.push("matching alternative"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:658:5: ( elements -> elements | -> ^( ALT EPSILON ) )
			int alt48=2;
			switch ( input.LA(1) ) {
			case ACTION:
			case DOT:
			case LPAREN:
			case NOT:
			case RULE_REF:
			case SEMPRED:
			case STRING_LITERAL:
			case TOKEN_REF:
				{
				alt48=1;
				}
				break;
			case EOF:
			case OR:
			case POUND:
			case RPAREN:
			case SEMI:
				{
				alt48=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 48, 0, input);
				throw nvae;
			}
			switch (alt48) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:658:7: elements
					{
					pushFollow(FOLLOW_elements_in_alternative2872);
					elements152=elements();
					state._fsp--;

					stream_elements.add(elements152.getTree());
					// AST REWRITE
					// elements: elements
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 658:16: -> elements
					{
						adaptor.addChild(root_0, stream_elements.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:659:10: 
					{
					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 659:10: -> ^( ALT EPSILON )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:659:13: ^( ALT EPSILON )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_1);
						adaptor.addChild(root_1, (GrammarAST)adaptor.create(EPSILON, "EPSILON"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "alternative"


	public static class elements_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "elements"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:662:1: elements : (e+= element )+ -> ^( ALT ( $e)+ ) ;
	public final ANTLRParser.elements_return elements() throws RecognitionException {
		ANTLRParser.elements_return retval = new ANTLRParser.elements_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		List<Object> list_e=null;
		RuleReturnScope e = null;
		RewriteRuleSubtreeStream stream_element=new RewriteRuleSubtreeStream(adaptor,"rule element");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:663:5: ( (e+= element )+ -> ^( ALT ( $e)+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:663:7: (e+= element )+
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:663:8: (e+= element )+
			int cnt49=0;
			loop49:
			while (true) {
				int alt49=2;
				switch ( input.LA(1) ) {
				case ACTION:
				case DOT:
				case LPAREN:
				case NOT:
				case RULE_REF:
				case SEMPRED:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt49=1;
					}
					break;
				}
				switch (alt49) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:663:8: e+= element
					{
					pushFollow(FOLLOW_element_in_elements2916);
					e=element();
					state._fsp--;

					stream_element.add(e.getTree());
					if (list_e==null) list_e=new ArrayList<Object>();
					list_e.add(e.getTree());
					}
					break;

				default :
					if ( cnt49 >= 1 ) break loop49;
					EarlyExitException eee = new EarlyExitException(49, input);
					throw eee;
				}
				cnt49++;
			}

			// AST REWRITE
			// elements: e
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: e
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_e=new RewriteRuleSubtreeStream(adaptor,"token e",list_e);
			root_0 = (GrammarAST)adaptor.nil();
			// 663:19: -> ^( ALT ( $e)+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:663:22: ^( ALT ( $e)+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_1);
				if ( !(stream_e.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_e.hasNext() ) {
					adaptor.addChild(root_1, stream_e.nextTree());
				}
				stream_e.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elements"


	public static class element_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "element"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:666:1: element : ( labeledElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) ) | -> labeledElement ) | atom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) ) | -> atom ) | ebnf | actionElement );
	public final ANTLRParser.element_return element() throws RecognitionException {
		ANTLRParser.element_return retval = new ANTLRParser.element_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope labeledElement153 =null;
		ParserRuleReturnScope ebnfSuffix154 =null;
		ParserRuleReturnScope atom155 =null;
		ParserRuleReturnScope ebnfSuffix156 =null;
		ParserRuleReturnScope ebnf157 =null;
		ParserRuleReturnScope actionElement158 =null;

		RewriteRuleSubtreeStream stream_atom=new RewriteRuleSubtreeStream(adaptor,"rule atom");
		RewriteRuleSubtreeStream stream_ebnfSuffix=new RewriteRuleSubtreeStream(adaptor,"rule ebnfSuffix");
		RewriteRuleSubtreeStream stream_labeledElement=new RewriteRuleSubtreeStream(adaptor,"rule labeledElement");


			paraphrases.push("looking for rule element");
			int m = input.mark();

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:672:2: ( labeledElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) ) | -> labeledElement ) | atom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) ) | -> atom ) | ebnf | actionElement )
			int alt52=4;
			switch ( input.LA(1) ) {
			case RULE_REF:
				{
				switch ( input.LA(2) ) {
				case ASSIGN:
				case PLUS_ASSIGN:
					{
					alt52=1;
					}
					break;
				case EOF:
				case ACTION:
				case ARG_ACTION:
				case DOT:
				case LPAREN:
				case NOT:
				case OR:
				case PLUS:
				case POUND:
				case QUESTION:
				case RPAREN:
				case RULE_REF:
				case SEMI:
				case SEMPRED:
				case STAR:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt52=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 52, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TOKEN_REF:
				{
				switch ( input.LA(2) ) {
				case ASSIGN:
				case PLUS_ASSIGN:
					{
					alt52=1;
					}
					break;
				case EOF:
				case ACTION:
				case DOT:
				case LPAREN:
				case LT:
				case NOT:
				case OR:
				case PLUS:
				case POUND:
				case QUESTION:
				case RPAREN:
				case RULE_REF:
				case SEMI:
				case SEMPRED:
				case STAR:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt52=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 52, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case DOT:
			case NOT:
			case STRING_LITERAL:
				{
				alt52=2;
				}
				break;
			case LPAREN:
				{
				alt52=3;
				}
				break;
			case ACTION:
			case SEMPRED:
				{
				alt52=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 52, 0, input);
				throw nvae;
			}
			switch (alt52) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:672:4: labeledElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) ) | -> labeledElement )
					{
					pushFollow(FOLLOW_labeledElement_in_element2954);
					labeledElement153=labeledElement();
					state._fsp--;

					stream_labeledElement.add(labeledElement153.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:673:3: ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) ) | -> labeledElement )
					int alt50=2;
					switch ( input.LA(1) ) {
					case PLUS:
					case QUESTION:
					case STAR:
						{
						alt50=1;
						}
						break;
					case EOF:
					case ACTION:
					case DOT:
					case LPAREN:
					case NOT:
					case OR:
					case POUND:
					case RPAREN:
					case RULE_REF:
					case SEMI:
					case SEMPRED:
					case STRING_LITERAL:
					case TOKEN_REF:
						{
						alt50=2;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 50, 0, input);
						throw nvae;
					}
					switch (alt50) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:673:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_element2960);
							ebnfSuffix154=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix154.getTree());
							// AST REWRITE
							// elements: labeledElement, ebnfSuffix
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 673:16: -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:673:19: ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:673:33: ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) )
								{
								GrammarAST root_2 = (GrammarAST)adaptor.nil();
								root_2 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, (labeledElement153!=null?(labeledElement153.start):null), "BLOCK"), root_2);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:673:82: ^( ALT labeledElement )
								{
								GrammarAST root_3 = (GrammarAST)adaptor.nil();
								root_3 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_3);
								adaptor.addChild(root_3, stream_labeledElement.nextTree());
								adaptor.addChild(root_2, root_3);
								}

								adaptor.addChild(root_1, root_2);
								}

								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:674:8: 
							{
							// AST REWRITE
							// elements: labeledElement
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 674:8: -> labeledElement
							{
								adaptor.addChild(root_0, stream_labeledElement.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:676:4: atom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) ) | -> atom )
					{
					pushFollow(FOLLOW_atom_in_element3006);
					atom155=atom();
					state._fsp--;

					stream_atom.add(atom155.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:677:3: ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) ) | -> atom )
					int alt51=2;
					switch ( input.LA(1) ) {
					case PLUS:
					case QUESTION:
					case STAR:
						{
						alt51=1;
						}
						break;
					case EOF:
					case ACTION:
					case DOT:
					case LPAREN:
					case NOT:
					case OR:
					case POUND:
					case RPAREN:
					case RULE_REF:
					case SEMI:
					case SEMPRED:
					case STRING_LITERAL:
					case TOKEN_REF:
						{
						alt51=2;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 51, 0, input);
						throw nvae;
					}
					switch (alt51) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:677:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_element3012);
							ebnfSuffix156=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix156.getTree());
							// AST REWRITE
							// elements: atom, ebnfSuffix
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 677:16: -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:677:19: ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:677:33: ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) )
								{
								GrammarAST root_2 = (GrammarAST)adaptor.nil();
								root_2 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, (atom155!=null?(atom155.start):null), "BLOCK"), root_2);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:677:72: ^( ALT atom )
								{
								GrammarAST root_3 = (GrammarAST)adaptor.nil();
								root_3 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_3);
								adaptor.addChild(root_3, stream_atom.nextTree());
								adaptor.addChild(root_2, root_3);
								}

								adaptor.addChild(root_1, root_2);
								}

								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:678:8: 
							{
							// AST REWRITE
							// elements: atom
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 678:8: -> atom
							{
								adaptor.addChild(root_0, stream_atom.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:680:4: ebnf
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_ebnf_in_element3058);
					ebnf157=ebnf();
					state._fsp--;

					adaptor.addChild(root_0, ebnf157.getTree());

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:681:4: actionElement
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_actionElement_in_element3063);
					actionElement158=actionElement();
					state._fsp--;

					adaptor.addChild(root_0, actionElement158.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {

			    	retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
			    	int ttype = input.get(input.range()).getType();
				    // look for anything that really belongs at the start of the rule minus the initial ID
			    	if ( ttype==COLON || ttype==RETURNS || ttype==CATCH || ttype==FINALLY || ttype==AT ) {
						RecognitionException missingSemi =
							new v4ParserException("unterminated rule (missing ';') detected at '"+
												  input.LT(1).getText()+" "+input.LT(2).getText()+"'", input);
						reportError(missingSemi);
						if ( ttype==CATCH || ttype==FINALLY ) {
							input.seek(input.range()); // ignore what's before rule trailer stuff
						}
						if ( ttype==RETURNS || ttype==AT ) { // scan back looking for ID of rule header
							int p = input.index();
							Token t = input.get(p);
							while ( t.getType()!=RULE_REF && t.getType()!=TOKEN_REF ) {
								p--;
								t = input.get(p);
							}
							input.seek(p);
						}
						throw new ResyncToEndOfRuleBlock(); // make sure it goes back to rule block level to recover
					}
			        reportError(re);
			        recover(input,re);
				
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "element"


	public static class actionElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "actionElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:710:1: actionElement : ( ACTION | ACTION elementOptions -> ^( ACTION elementOptions ) | SEMPRED | SEMPRED elementOptions -> ^( SEMPRED elementOptions ) );
	public final ANTLRParser.actionElement_return actionElement() throws RecognitionException {
		ANTLRParser.actionElement_return retval = new ANTLRParser.actionElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ACTION159=null;
		Token ACTION160=null;
		Token SEMPRED162=null;
		Token SEMPRED163=null;
		ParserRuleReturnScope elementOptions161 =null;
		ParserRuleReturnScope elementOptions164 =null;

		GrammarAST ACTION159_tree=null;
		GrammarAST ACTION160_tree=null;
		GrammarAST SEMPRED162_tree=null;
		GrammarAST SEMPRED163_tree=null;
		RewriteRuleTokenStream stream_SEMPRED=new RewriteRuleTokenStream(adaptor,"token SEMPRED");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");
		RewriteRuleSubtreeStream stream_elementOptions=new RewriteRuleSubtreeStream(adaptor,"rule elementOptions");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:717:2: ( ACTION | ACTION elementOptions -> ^( ACTION elementOptions ) | SEMPRED | SEMPRED elementOptions -> ^( SEMPRED elementOptions ) )
			int alt53=4;
			switch ( input.LA(1) ) {
			case ACTION:
				{
				switch ( input.LA(2) ) {
				case EOF:
				case ACTION:
				case DOT:
				case LEXER_CHAR_SET:
				case LPAREN:
				case NOT:
				case OR:
				case POUND:
				case RARROW:
				case RPAREN:
				case RULE_REF:
				case SEMI:
				case SEMPRED:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt53=1;
					}
					break;
				case LT:
					{
					alt53=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 53, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case SEMPRED:
				{
				switch ( input.LA(2) ) {
				case EOF:
				case ACTION:
				case DOT:
				case LEXER_CHAR_SET:
				case LPAREN:
				case NOT:
				case OR:
				case POUND:
				case RARROW:
				case RPAREN:
				case RULE_REF:
				case SEMI:
				case SEMPRED:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt53=3;
					}
					break;
				case LT:
					{
					alt53=4;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 53, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}
			switch (alt53) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:717:4: ACTION
					{
					root_0 = (GrammarAST)adaptor.nil();


					ACTION159=(Token)match(input,ACTION,FOLLOW_ACTION_in_actionElement3089); 
					ACTION159_tree = new ActionAST(ACTION159) ;
					adaptor.addChild(root_0, ACTION159_tree);

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:718:6: ACTION elementOptions
					{
					ACTION160=(Token)match(input,ACTION,FOLLOW_ACTION_in_actionElement3099);  
					stream_ACTION.add(ACTION160);

					pushFollow(FOLLOW_elementOptions_in_actionElement3101);
					elementOptions161=elementOptions();
					state._fsp--;

					stream_elementOptions.add(elementOptions161.getTree());
					// AST REWRITE
					// elements: ACTION, elementOptions
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 718:28: -> ^( ACTION elementOptions )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:718:31: ^( ACTION elementOptions )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new ActionAST(stream_ACTION.nextToken()), root_1);
						adaptor.addChild(root_1, stream_elementOptions.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:719:6: SEMPRED
					{
					root_0 = (GrammarAST)adaptor.nil();


					SEMPRED162=(Token)match(input,SEMPRED,FOLLOW_SEMPRED_in_actionElement3119); 
					SEMPRED162_tree = new PredAST(SEMPRED162) ;
					adaptor.addChild(root_0, SEMPRED162_tree);

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:720:6: SEMPRED elementOptions
					{
					SEMPRED163=(Token)match(input,SEMPRED,FOLLOW_SEMPRED_in_actionElement3129);  
					stream_SEMPRED.add(SEMPRED163);

					pushFollow(FOLLOW_elementOptions_in_actionElement3131);
					elementOptions164=elementOptions();
					state._fsp--;

					stream_elementOptions.add(elementOptions164.getTree());
					// AST REWRITE
					// elements: elementOptions, SEMPRED
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 720:29: -> ^( SEMPRED elementOptions )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:720:32: ^( SEMPRED elementOptions )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new PredAST(stream_SEMPRED.nextToken()), root_1);
						adaptor.addChild(root_1, stream_elementOptions.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.ELEMENT_OPTIONS);
				if ( options!=null ) {
					Grammar.setNodeOptions(retval.tree, options);
				}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "actionElement"


	public static class labeledElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "labeledElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:723:1: labeledElement : id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( atom -> ^( $ass id atom ) | block -> ^( $ass id block ) ) ;
	public final ANTLRParser.labeledElement_return labeledElement() throws RecognitionException {
		ANTLRParser.labeledElement_return retval = new ANTLRParser.labeledElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ass=null;
		ParserRuleReturnScope id165 =null;
		ParserRuleReturnScope atom166 =null;
		ParserRuleReturnScope block167 =null;

		GrammarAST ass_tree=null;
		RewriteRuleTokenStream stream_ASSIGN=new RewriteRuleTokenStream(adaptor,"token ASSIGN");
		RewriteRuleTokenStream stream_PLUS_ASSIGN=new RewriteRuleTokenStream(adaptor,"token PLUS_ASSIGN");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_atom=new RewriteRuleSubtreeStream(adaptor,"rule atom");
		RewriteRuleSubtreeStream stream_block=new RewriteRuleSubtreeStream(adaptor,"rule block");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:724:2: ( id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( atom -> ^( $ass id atom ) | block -> ^( $ass id block ) ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:724:4: id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( atom -> ^( $ass id atom ) | block -> ^( $ass id block ) )
			{
			pushFollow(FOLLOW_id_in_labeledElement3153);
			id165=id();
			state._fsp--;

			stream_id.add(id165.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:724:7: (ass= ASSIGN |ass= PLUS_ASSIGN )
			int alt54=2;
			switch ( input.LA(1) ) {
			case ASSIGN:
				{
				alt54=1;
				}
				break;
			case PLUS_ASSIGN:
				{
				alt54=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 54, 0, input);
				throw nvae;
			}
			switch (alt54) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:724:8: ass= ASSIGN
					{
					ass=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_labeledElement3158);  
					stream_ASSIGN.add(ass);

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:724:19: ass= PLUS_ASSIGN
					{
					ass=(Token)match(input,PLUS_ASSIGN,FOLLOW_PLUS_ASSIGN_in_labeledElement3162);  
					stream_PLUS_ASSIGN.add(ass);

					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:725:3: ( atom -> ^( $ass id atom ) | block -> ^( $ass id block ) )
			int alt55=2;
			switch ( input.LA(1) ) {
			case DOT:
			case NOT:
			case RULE_REF:
			case STRING_LITERAL:
			case TOKEN_REF:
				{
				alt55=1;
				}
				break;
			case LPAREN:
				{
				alt55=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 55, 0, input);
				throw nvae;
			}
			switch (alt55) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:725:5: atom
					{
					pushFollow(FOLLOW_atom_in_labeledElement3169);
					atom166=atom();
					state._fsp--;

					stream_atom.add(atom166.getTree());
					// AST REWRITE
					// elements: atom, ass, id
					// token labels: ass
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleTokenStream stream_ass=new RewriteRuleTokenStream(adaptor,"token ass",ass);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 725:15: -> ^( $ass id atom )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:725:18: ^( $ass id atom )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_ass.nextNode(), root_1);
						adaptor.addChild(root_1, stream_id.nextTree());
						adaptor.addChild(root_1, stream_atom.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:726:5: block
					{
					pushFollow(FOLLOW_block_in_labeledElement3191);
					block167=block();
					state._fsp--;

					stream_block.add(block167.getTree());
					// AST REWRITE
					// elements: block, ass, id
					// token labels: ass
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleTokenStream stream_ass=new RewriteRuleTokenStream(adaptor,"token ass",ass);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 726:16: -> ^( $ass id block )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:726:19: ^( $ass id block )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_ass.nextNode(), root_1);
						adaptor.addChild(root_1, stream_id.nextTree());
						adaptor.addChild(root_1, stream_block.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "labeledElement"


	public static class ebnf_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ebnf"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:732:1: ebnf : block ( blockSuffix -> ^( blockSuffix block ) | -> block ) ;
	public final ANTLRParser.ebnf_return ebnf() throws RecognitionException {
		ANTLRParser.ebnf_return retval = new ANTLRParser.ebnf_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope block168 =null;
		ParserRuleReturnScope blockSuffix169 =null;

		RewriteRuleSubtreeStream stream_block=new RewriteRuleSubtreeStream(adaptor,"rule block");
		RewriteRuleSubtreeStream stream_blockSuffix=new RewriteRuleSubtreeStream(adaptor,"rule blockSuffix");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:733:5: ( block ( blockSuffix -> ^( blockSuffix block ) | -> block ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:733:7: block ( blockSuffix -> ^( blockSuffix block ) | -> block )
			{
			pushFollow(FOLLOW_block_in_ebnf3227);
			block168=block();
			state._fsp--;

			stream_block.add(block168.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:736:7: ( blockSuffix -> ^( blockSuffix block ) | -> block )
			int alt56=2;
			switch ( input.LA(1) ) {
			case PLUS:
			case QUESTION:
			case STAR:
				{
				alt56=1;
				}
				break;
			case EOF:
			case ACTION:
			case DOT:
			case LPAREN:
			case NOT:
			case OR:
			case POUND:
			case RPAREN:
			case RULE_REF:
			case SEMI:
			case SEMPRED:
			case STRING_LITERAL:
			case TOKEN_REF:
				{
				alt56=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 56, 0, input);
				throw nvae;
			}
			switch (alt56) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:736:9: blockSuffix
					{
					pushFollow(FOLLOW_blockSuffix_in_ebnf3251);
					blockSuffix169=blockSuffix();
					state._fsp--;

					stream_blockSuffix.add(blockSuffix169.getTree());
					// AST REWRITE
					// elements: blockSuffix, block
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 736:21: -> ^( blockSuffix block )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:736:24: ^( blockSuffix block )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_blockSuffix.nextNode(), root_1);
						adaptor.addChild(root_1, stream_block.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:737:12: 
					{
					// AST REWRITE
					// elements: block
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 737:12: -> block
					{
						adaptor.addChild(root_0, stream_block.nextTree());
					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ebnf"


	public static class blockSuffix_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "blockSuffix"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:743:1: blockSuffix : ebnfSuffix ;
	public final ANTLRParser.blockSuffix_return blockSuffix() throws RecognitionException {
		ANTLRParser.blockSuffix_return retval = new ANTLRParser.blockSuffix_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope ebnfSuffix170 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:744:5: ( ebnfSuffix )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:744:7: ebnfSuffix
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_ebnfSuffix_in_blockSuffix3301);
			ebnfSuffix170=ebnfSuffix();
			state._fsp--;

			adaptor.addChild(root_0, ebnfSuffix170.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blockSuffix"


	public static class ebnfSuffix_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ebnfSuffix"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:747:1: ebnfSuffix : ( QUESTION (nongreedy= QUESTION )? -> OPTIONAL[$start, $nongreedy] | STAR (nongreedy= QUESTION )? -> CLOSURE[$start, $nongreedy] | PLUS (nongreedy= QUESTION )? -> POSITIVE_CLOSURE[$start, $nongreedy] );
	public final ANTLRParser.ebnfSuffix_return ebnfSuffix() throws RecognitionException {
		ANTLRParser.ebnfSuffix_return retval = new ANTLRParser.ebnfSuffix_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token nongreedy=null;
		Token QUESTION171=null;
		Token STAR172=null;
		Token PLUS173=null;

		GrammarAST nongreedy_tree=null;
		GrammarAST QUESTION171_tree=null;
		GrammarAST STAR172_tree=null;
		GrammarAST PLUS173_tree=null;
		RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
		RewriteRuleTokenStream stream_STAR=new RewriteRuleTokenStream(adaptor,"token STAR");
		RewriteRuleTokenStream stream_QUESTION=new RewriteRuleTokenStream(adaptor,"token QUESTION");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:748:2: ( QUESTION (nongreedy= QUESTION )? -> OPTIONAL[$start, $nongreedy] | STAR (nongreedy= QUESTION )? -> CLOSURE[$start, $nongreedy] | PLUS (nongreedy= QUESTION )? -> POSITIVE_CLOSURE[$start, $nongreedy] )
			int alt60=3;
			switch ( input.LA(1) ) {
			case QUESTION:
				{
				alt60=1;
				}
				break;
			case STAR:
				{
				alt60=2;
				}
				break;
			case PLUS:
				{
				alt60=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 60, 0, input);
				throw nvae;
			}
			switch (alt60) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:748:4: QUESTION (nongreedy= QUESTION )?
					{
					QUESTION171=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_ebnfSuffix3316);  
					stream_QUESTION.add(QUESTION171);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:748:22: (nongreedy= QUESTION )?
					int alt57=2;
					switch ( input.LA(1) ) {
						case QUESTION:
							{
							alt57=1;
							}
							break;
					}
					switch (alt57) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:748:22: nongreedy= QUESTION
							{
							nongreedy=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_ebnfSuffix3320);  
							stream_QUESTION.add(nongreedy);

							}
							break;

					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 748:33: -> OPTIONAL[$start, $nongreedy]
					{
						adaptor.addChild(root_0, new OptionalBlockAST(OPTIONAL, (retval.start), nongreedy));
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:749:6: STAR (nongreedy= QUESTION )?
					{
					STAR172=(Token)match(input,STAR,FOLLOW_STAR_in_ebnfSuffix3336);  
					stream_STAR.add(STAR172);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:749:20: (nongreedy= QUESTION )?
					int alt58=2;
					switch ( input.LA(1) ) {
						case QUESTION:
							{
							alt58=1;
							}
							break;
					}
					switch (alt58) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:749:20: nongreedy= QUESTION
							{
							nongreedy=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_ebnfSuffix3340);  
							stream_QUESTION.add(nongreedy);

							}
							break;

					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 749:32: -> CLOSURE[$start, $nongreedy]
					{
						adaptor.addChild(root_0, new StarBlockAST(CLOSURE, (retval.start), nongreedy));
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:750:7: PLUS (nongreedy= QUESTION )?
					{
					PLUS173=(Token)match(input,PLUS,FOLLOW_PLUS_in_ebnfSuffix3358);  
					stream_PLUS.add(PLUS173);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:750:21: (nongreedy= QUESTION )?
					int alt59=2;
					switch ( input.LA(1) ) {
						case QUESTION:
							{
							alt59=1;
							}
							break;
					}
					switch (alt59) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:750:21: nongreedy= QUESTION
							{
							nongreedy=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_ebnfSuffix3362);  
							stream_QUESTION.add(nongreedy);

							}
							break;

					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 750:33: -> POSITIVE_CLOSURE[$start, $nongreedy]
					{
						adaptor.addChild(root_0, new PlusBlockAST(POSITIVE_CLOSURE, (retval.start), nongreedy));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ebnfSuffix"


	public static class lexerAtom_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerAtom"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:753:1: lexerAtom : ( range | terminal | RULE_REF | notSet | wildcard | LEXER_CHAR_SET );
	public final ANTLRParser.lexerAtom_return lexerAtom() throws RecognitionException {
		ANTLRParser.lexerAtom_return retval = new ANTLRParser.lexerAtom_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RULE_REF176=null;
		Token LEXER_CHAR_SET179=null;
		ParserRuleReturnScope range174 =null;
		ParserRuleReturnScope terminal175 =null;
		ParserRuleReturnScope notSet177 =null;
		ParserRuleReturnScope wildcard178 =null;

		GrammarAST RULE_REF176_tree=null;
		GrammarAST LEXER_CHAR_SET179_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:754:2: ( range | terminal | RULE_REF | notSet | wildcard | LEXER_CHAR_SET )
			int alt61=6;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				switch ( input.LA(2) ) {
				case RANGE:
					{
					alt61=1;
					}
					break;
				case ACTION:
				case DOT:
				case LEXER_CHAR_SET:
				case LPAREN:
				case LT:
				case NOT:
				case OR:
				case PLUS:
				case QUESTION:
				case RARROW:
				case RPAREN:
				case RULE_REF:
				case SEMI:
				case SEMPRED:
				case STAR:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt61=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 61, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TOKEN_REF:
				{
				alt61=2;
				}
				break;
			case RULE_REF:
				{
				alt61=3;
				}
				break;
			case NOT:
				{
				alt61=4;
				}
				break;
			case DOT:
				{
				alt61=5;
				}
				break;
			case LEXER_CHAR_SET:
				{
				alt61=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 61, 0, input);
				throw nvae;
			}
			switch (alt61) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:754:4: range
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_range_in_lexerAtom3383);
					range174=range();
					state._fsp--;

					adaptor.addChild(root_0, range174.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:755:4: terminal
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_terminal_in_lexerAtom3388);
					terminal175=terminal();
					state._fsp--;

					adaptor.addChild(root_0, terminal175.getTree());

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:756:9: RULE_REF
					{
					root_0 = (GrammarAST)adaptor.nil();


					RULE_REF176=(Token)match(input,RULE_REF,FOLLOW_RULE_REF_in_lexerAtom3398); 
					RULE_REF176_tree = new RuleRefAST(RULE_REF176) ;
					adaptor.addChild(root_0, RULE_REF176_tree);

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:757:7: notSet
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_notSet_in_lexerAtom3409);
					notSet177=notSet();
					state._fsp--;

					adaptor.addChild(root_0, notSet177.getTree());

					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:758:7: wildcard
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_wildcard_in_lexerAtom3417);
					wildcard178=wildcard();
					state._fsp--;

					adaptor.addChild(root_0, wildcard178.getTree());

					}
					break;
				case 6 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:759:7: LEXER_CHAR_SET
					{
					root_0 = (GrammarAST)adaptor.nil();


					LEXER_CHAR_SET179=(Token)match(input,LEXER_CHAR_SET,FOLLOW_LEXER_CHAR_SET_in_lexerAtom3425); 
					LEXER_CHAR_SET179_tree = (GrammarAST)adaptor.create(LEXER_CHAR_SET179);
					adaptor.addChild(root_0, LEXER_CHAR_SET179_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerAtom"


	public static class atom_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "atom"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:762:1: atom : ( range | terminal | ruleref | notSet | wildcard );
	public final ANTLRParser.atom_return atom() throws RecognitionException {
		ANTLRParser.atom_return retval = new ANTLRParser.atom_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope range180 =null;
		ParserRuleReturnScope terminal181 =null;
		ParserRuleReturnScope ruleref182 =null;
		ParserRuleReturnScope notSet183 =null;
		ParserRuleReturnScope wildcard184 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:763:2: ( range | terminal | ruleref | notSet | wildcard )
			int alt62=5;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				switch ( input.LA(2) ) {
				case RANGE:
					{
					alt62=1;
					}
					break;
				case EOF:
				case ACTION:
				case DOT:
				case LPAREN:
				case LT:
				case NOT:
				case OR:
				case PLUS:
				case POUND:
				case QUESTION:
				case RPAREN:
				case RULE_REF:
				case SEMI:
				case SEMPRED:
				case STAR:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt62=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 62, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TOKEN_REF:
				{
				alt62=2;
				}
				break;
			case RULE_REF:
				{
				alt62=3;
				}
				break;
			case NOT:
				{
				alt62=4;
				}
				break;
			case DOT:
				{
				alt62=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 62, 0, input);
				throw nvae;
			}
			switch (alt62) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:777:9: range
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_range_in_atom3470);
					range180=range();
					state._fsp--;

					adaptor.addChild(root_0, range180.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:778:4: terminal
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_terminal_in_atom3477);
					terminal181=terminal();
					state._fsp--;

					adaptor.addChild(root_0, terminal181.getTree());

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:779:9: ruleref
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_ruleref_in_atom3487);
					ruleref182=ruleref();
					state._fsp--;

					adaptor.addChild(root_0, ruleref182.getTree());

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:780:7: notSet
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_notSet_in_atom3495);
					notSet183=notSet();
					state._fsp--;

					adaptor.addChild(root_0, notSet183.getTree());

					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:781:7: wildcard
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_wildcard_in_atom3503);
					wildcard184=wildcard();
					state._fsp--;

					adaptor.addChild(root_0, wildcard184.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			 throw re; 
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "atom"


	public static class wildcard_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "wildcard"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:785:1: wildcard : DOT ( elementOptions )? -> ^( WILDCARD[$DOT] ( elementOptions )? ) ;
	public final ANTLRParser.wildcard_return wildcard() throws RecognitionException {
		ANTLRParser.wildcard_return retval = new ANTLRParser.wildcard_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOT185=null;
		ParserRuleReturnScope elementOptions186 =null;

		GrammarAST DOT185_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_elementOptions=new RewriteRuleSubtreeStream(adaptor,"rule elementOptions");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:792:2: ( DOT ( elementOptions )? -> ^( WILDCARD[$DOT] ( elementOptions )? ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:797:6: DOT ( elementOptions )?
			{
			DOT185=(Token)match(input,DOT,FOLLOW_DOT_in_wildcard3551);  
			stream_DOT.add(DOT185);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:797:10: ( elementOptions )?
			int alt63=2;
			switch ( input.LA(1) ) {
				case LT:
					{
					alt63=1;
					}
					break;
			}
			switch (alt63) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:797:10: elementOptions
					{
					pushFollow(FOLLOW_elementOptions_in_wildcard3553);
					elementOptions186=elementOptions();
					state._fsp--;

					stream_elementOptions.add(elementOptions186.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: elementOptions
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 798:6: -> ^( WILDCARD[$DOT] ( elementOptions )? )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:798:9: ^( WILDCARD[$DOT] ( elementOptions )? )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new TerminalAST(WILDCARD, DOT185), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:798:39: ( elementOptions )?
				if ( stream_elementOptions.hasNext() ) {
					adaptor.addChild(root_1, stream_elementOptions.nextTree());
				}
				stream_elementOptions.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.ELEMENT_OPTIONS);
				if ( options!=null ) {
					Grammar.setNodeOptions(retval.tree, options);
				}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "wildcard"


	public static class notSet_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "notSet"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:806:1: notSet : ( NOT setElement -> ^( NOT[$NOT] ^( SET[$setElement.start,\"SET\"] setElement ) ) | NOT blockSet -> ^( NOT[$NOT] blockSet ) );
	public final ANTLRParser.notSet_return notSet() throws RecognitionException {
		ANTLRParser.notSet_return retval = new ANTLRParser.notSet_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token NOT187=null;
		Token NOT189=null;
		ParserRuleReturnScope setElement188 =null;
		ParserRuleReturnScope blockSet190 =null;

		GrammarAST NOT187_tree=null;
		GrammarAST NOT189_tree=null;
		RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
		RewriteRuleSubtreeStream stream_setElement=new RewriteRuleSubtreeStream(adaptor,"rule setElement");
		RewriteRuleSubtreeStream stream_blockSet=new RewriteRuleSubtreeStream(adaptor,"rule blockSet");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:807:5: ( NOT setElement -> ^( NOT[$NOT] ^( SET[$setElement.start,\"SET\"] setElement ) ) | NOT blockSet -> ^( NOT[$NOT] blockSet ) )
			int alt64=2;
			switch ( input.LA(1) ) {
			case NOT:
				{
				switch ( input.LA(2) ) {
				case LEXER_CHAR_SET:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt64=1;
					}
					break;
				case LPAREN:
					{
					alt64=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 64, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 64, 0, input);
				throw nvae;
			}
			switch (alt64) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:807:7: NOT setElement
					{
					NOT187=(Token)match(input,NOT,FOLLOW_NOT_in_notSet3591);  
					stream_NOT.add(NOT187);

					pushFollow(FOLLOW_setElement_in_notSet3593);
					setElement188=setElement();
					state._fsp--;

					stream_setElement.add(setElement188.getTree());
					// AST REWRITE
					// elements: NOT, setElement
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 807:22: -> ^( NOT[$NOT] ^( SET[$setElement.start,\"SET\"] setElement ) )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:807:25: ^( NOT[$NOT] ^( SET[$setElement.start,\"SET\"] setElement ) )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new NotAST(NOT, NOT187), root_1);
						// org\\antlr\\v4\\parse\\ANTLRParser.g:807:45: ^( SET[$setElement.start,\"SET\"] setElement )
						{
						GrammarAST root_2 = (GrammarAST)adaptor.nil();
						root_2 = (GrammarAST)adaptor.becomeRoot(new SetAST(SET, (setElement188!=null?(setElement188.start):null), "SET"), root_2);
						adaptor.addChild(root_2, stream_setElement.nextTree());
						adaptor.addChild(root_1, root_2);
						}

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:808:7: NOT blockSet
					{
					NOT189=(Token)match(input,NOT,FOLLOW_NOT_in_notSet3621);  
					stream_NOT.add(NOT189);

					pushFollow(FOLLOW_blockSet_in_notSet3623);
					blockSet190=blockSet();
					state._fsp--;

					stream_blockSet.add(blockSet190.getTree());
					// AST REWRITE
					// elements: NOT, blockSet
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 808:21: -> ^( NOT[$NOT] blockSet )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:808:24: ^( NOT[$NOT] blockSet )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new NotAST(NOT, NOT189), root_1);
						adaptor.addChild(root_1, stream_blockSet.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "notSet"


	public static class blockSet_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "blockSet"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:811:1: blockSet : LPAREN setElement ( OR setElement )* RPAREN -> ^( SET[$LPAREN,\"SET\"] ( setElement )+ ) ;
	public final ANTLRParser.blockSet_return blockSet() throws RecognitionException {
		ANTLRParser.blockSet_return retval = new ANTLRParser.blockSet_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LPAREN191=null;
		Token OR193=null;
		Token RPAREN195=null;
		ParserRuleReturnScope setElement192 =null;
		ParserRuleReturnScope setElement194 =null;

		GrammarAST LPAREN191_tree=null;
		GrammarAST OR193_tree=null;
		GrammarAST RPAREN195_tree=null;
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_setElement=new RewriteRuleSubtreeStream(adaptor,"rule setElement");


			Token t;
			boolean ebnf = false;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:816:5: ( LPAREN setElement ( OR setElement )* RPAREN -> ^( SET[$LPAREN,\"SET\"] ( setElement )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:816:7: LPAREN setElement ( OR setElement )* RPAREN
			{
			LPAREN191=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_blockSet3658);  
			stream_LPAREN.add(LPAREN191);

			pushFollow(FOLLOW_setElement_in_blockSet3660);
			setElement192=setElement();
			state._fsp--;

			stream_setElement.add(setElement192.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:816:25: ( OR setElement )*
			loop65:
			while (true) {
				int alt65=2;
				switch ( input.LA(1) ) {
				case OR:
					{
					alt65=1;
					}
					break;
				}
				switch (alt65) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:816:26: OR setElement
					{
					OR193=(Token)match(input,OR,FOLLOW_OR_in_blockSet3663);  
					stream_OR.add(OR193);

					pushFollow(FOLLOW_setElement_in_blockSet3665);
					setElement194=setElement();
					state._fsp--;

					stream_setElement.add(setElement194.getTree());
					}
					break;

				default :
					break loop65;
				}
			}

			RPAREN195=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_blockSet3669);  
			stream_RPAREN.add(RPAREN195);

			// AST REWRITE
			// elements: setElement
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 817:3: -> ^( SET[$LPAREN,\"SET\"] ( setElement )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:817:6: ^( SET[$LPAREN,\"SET\"] ( setElement )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new SetAST(SET, LPAREN191, "SET"), root_1);
				if ( !(stream_setElement.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_setElement.hasNext() ) {
					adaptor.addChild(root_1, stream_setElement.nextTree());
				}
				stream_setElement.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blockSet"


	public static class setElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "setElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:820:1: setElement : ( TOKEN_REF | STRING_LITERAL | range | LEXER_CHAR_SET );
	public final ANTLRParser.setElement_return setElement() throws RecognitionException {
		ANTLRParser.setElement_return retval = new ANTLRParser.setElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token TOKEN_REF196=null;
		Token STRING_LITERAL197=null;
		Token LEXER_CHAR_SET199=null;
		ParserRuleReturnScope range198 =null;

		GrammarAST TOKEN_REF196_tree=null;
		GrammarAST STRING_LITERAL197_tree=null;
		GrammarAST LEXER_CHAR_SET199_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:821:2: ( TOKEN_REF | STRING_LITERAL | range | LEXER_CHAR_SET )
			int alt66=4;
			switch ( input.LA(1) ) {
			case TOKEN_REF:
				{
				alt66=1;
				}
				break;
			case STRING_LITERAL:
				{
				switch ( input.LA(2) ) {
				case RANGE:
					{
					alt66=3;
					}
					break;
				case EOF:
				case ACTION:
				case DOT:
				case LEXER_CHAR_SET:
				case LPAREN:
				case NOT:
				case OR:
				case PLUS:
				case POUND:
				case QUESTION:
				case RARROW:
				case RPAREN:
				case RULE_REF:
				case SEMI:
				case SEMPRED:
				case STAR:
				case STRING_LITERAL:
				case TOKEN_REF:
					{
					alt66=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 66, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case LEXER_CHAR_SET:
				{
				alt66=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 66, 0, input);
				throw nvae;
			}
			switch (alt66) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:821:4: TOKEN_REF
					{
					root_0 = (GrammarAST)adaptor.nil();


					TOKEN_REF196=(Token)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_setElement3699); 
					TOKEN_REF196_tree = new TerminalAST(TOKEN_REF196) ;
					adaptor.addChild(root_0, TOKEN_REF196_tree);

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:822:4: STRING_LITERAL
					{
					root_0 = (GrammarAST)adaptor.nil();


					STRING_LITERAL197=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_setElement3707); 
					STRING_LITERAL197_tree = new TerminalAST(STRING_LITERAL197) ;
					adaptor.addChild(root_0, STRING_LITERAL197_tree);

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:823:4: range
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_range_in_setElement3715);
					range198=range();
					state._fsp--;

					adaptor.addChild(root_0, range198.getTree());

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:824:9: LEXER_CHAR_SET
					{
					root_0 = (GrammarAST)adaptor.nil();


					LEXER_CHAR_SET199=(Token)match(input,LEXER_CHAR_SET,FOLLOW_LEXER_CHAR_SET_in_setElement3725); 
					LEXER_CHAR_SET199_tree = (GrammarAST)adaptor.create(LEXER_CHAR_SET199);
					adaptor.addChild(root_0, LEXER_CHAR_SET199_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "setElement"


	public static class block_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "block"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:834:1: block : LPAREN ( ( optionsSpec )? (ra+= ruleAction )* COLON )? altList RPAREN -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? ( $ra)* altList ) ;
	public final ANTLRParser.block_return block() throws RecognitionException {
		ANTLRParser.block_return retval = new ANTLRParser.block_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LPAREN200=null;
		Token COLON202=null;
		Token RPAREN204=null;
		List<Object> list_ra=null;
		ParserRuleReturnScope optionsSpec201 =null;
		ParserRuleReturnScope altList203 =null;
		RuleReturnScope ra = null;
		GrammarAST LPAREN200_tree=null;
		GrammarAST COLON202_tree=null;
		GrammarAST RPAREN204_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleSubtreeStream stream_optionsSpec=new RewriteRuleSubtreeStream(adaptor,"rule optionsSpec");
		RewriteRuleSubtreeStream stream_altList=new RewriteRuleSubtreeStream(adaptor,"rule altList");
		RewriteRuleSubtreeStream stream_ruleAction=new RewriteRuleSubtreeStream(adaptor,"rule ruleAction");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:841:3: ( LPAREN ( ( optionsSpec )? (ra+= ruleAction )* COLON )? altList RPAREN -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? ( $ra)* altList ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:841:5: LPAREN ( ( optionsSpec )? (ra+= ruleAction )* COLON )? altList RPAREN
			{
			LPAREN200=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_block3749);  
			stream_LPAREN.add(LPAREN200);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:842:9: ( ( optionsSpec )? (ra+= ruleAction )* COLON )?
			int alt69=2;
			switch ( input.LA(1) ) {
				case AT:
				case COLON:
				case OPTIONS:
					{
					alt69=1;
					}
					break;
			}
			switch (alt69) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:842:11: ( optionsSpec )? (ra+= ruleAction )* COLON
					{
					// org\\antlr\\v4\\parse\\ANTLRParser.g:842:11: ( optionsSpec )?
					int alt67=2;
					switch ( input.LA(1) ) {
						case OPTIONS:
							{
							alt67=1;
							}
							break;
					}
					switch (alt67) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:842:11: optionsSpec
							{
							pushFollow(FOLLOW_optionsSpec_in_block3761);
							optionsSpec201=optionsSpec();
							state._fsp--;

							stream_optionsSpec.add(optionsSpec201.getTree());
							}
							break;

					}

					// org\\antlr\\v4\\parse\\ANTLRParser.g:842:26: (ra+= ruleAction )*
					loop68:
					while (true) {
						int alt68=2;
						switch ( input.LA(1) ) {
						case AT:
							{
							alt68=1;
							}
							break;
						}
						switch (alt68) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:842:26: ra+= ruleAction
							{
							pushFollow(FOLLOW_ruleAction_in_block3766);
							ra=ruleAction();
							state._fsp--;

							stream_ruleAction.add(ra.getTree());
							if (list_ra==null) list_ra=new ArrayList<Object>();
							list_ra.add(ra.getTree());
							}
							break;

						default :
							break loop68;
						}
					}

					COLON202=(Token)match(input,COLON,FOLLOW_COLON_in_block3769);  
					stream_COLON.add(COLON202);

					}
					break;

			}

			pushFollow(FOLLOW_altList_in_block3782);
			altList203=altList();
			state._fsp--;

			stream_altList.add(altList203.getTree());
			RPAREN204=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_block3786);  
			stream_RPAREN.add(RPAREN204);

			// AST REWRITE
			// elements: ra, optionsSpec, altList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: ra
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_ra=new RewriteRuleSubtreeStream(adaptor,"token ra",list_ra);
			root_0 = (GrammarAST)adaptor.nil();
			// 845:7: -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? ( $ra)* altList )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:845:10: ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? ( $ra)* altList )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, LPAREN200, "BLOCK"), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:845:45: ( optionsSpec )?
				if ( stream_optionsSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_optionsSpec.nextTree());
				}
				stream_optionsSpec.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:845:59: ( $ra)*
				while ( stream_ra.hasNext() ) {
					adaptor.addChild(root_1, stream_ra.nextTree());
				}
				stream_ra.reset();

				adaptor.addChild(root_1, stream_altList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.OPTIONS);
			if ( options!=null ) {
				Grammar.setNodeOptions(retval.tree, options);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "block"


	public static class ruleref_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleref"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:854:1: ruleref : RULE_REF ( ARG_ACTION )? -> ^( RULE_REF ( ARG_ACTION )? ) ;
	public final ANTLRParser.ruleref_return ruleref() throws RecognitionException {
		ANTLRParser.ruleref_return retval = new ANTLRParser.ruleref_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RULE_REF205=null;
		Token ARG_ACTION206=null;

		GrammarAST RULE_REF205_tree=null;
		GrammarAST ARG_ACTION206_tree=null;
		RewriteRuleTokenStream stream_RULE_REF=new RewriteRuleTokenStream(adaptor,"token RULE_REF");
		RewriteRuleTokenStream stream_ARG_ACTION=new RewriteRuleTokenStream(adaptor,"token ARG_ACTION");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:855:5: ( RULE_REF ( ARG_ACTION )? -> ^( RULE_REF ( ARG_ACTION )? ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:855:7: RULE_REF ( ARG_ACTION )?
			{
			RULE_REF205=(Token)match(input,RULE_REF,FOLLOW_RULE_REF_in_ruleref3835);  
			stream_RULE_REF.add(RULE_REF205);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:855:16: ( ARG_ACTION )?
			int alt70=2;
			switch ( input.LA(1) ) {
				case ARG_ACTION:
					{
					alt70=1;
					}
					break;
			}
			switch (alt70) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:855:16: ARG_ACTION
					{
					ARG_ACTION206=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_ruleref3837);  
					stream_ARG_ACTION.add(ARG_ACTION206);

					}
					break;

			}

			// AST REWRITE
			// elements: ARG_ACTION, RULE_REF
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 855:28: -> ^( RULE_REF ( ARG_ACTION )? )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:855:31: ^( RULE_REF ( ARG_ACTION )? )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new RuleRefAST(stream_RULE_REF.nextToken()), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:855:54: ( ARG_ACTION )?
				if ( stream_ARG_ACTION.hasNext() ) {
					adaptor.addChild(root_1, new ActionAST(stream_ARG_ACTION.nextToken()));
				}
				stream_ARG_ACTION.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			 throw re; 
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleref"


	public static class range_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "range"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:868:1: range : STRING_LITERAL RANGE ^ STRING_LITERAL ;
	public final ANTLRParser.range_return range() throws RecognitionException {
		ANTLRParser.range_return retval = new ANTLRParser.range_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token STRING_LITERAL207=null;
		Token RANGE208=null;
		Token STRING_LITERAL209=null;

		GrammarAST STRING_LITERAL207_tree=null;
		GrammarAST RANGE208_tree=null;
		GrammarAST STRING_LITERAL209_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:869:5: ( STRING_LITERAL RANGE ^ STRING_LITERAL )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:869:7: STRING_LITERAL RANGE ^ STRING_LITERAL
			{
			root_0 = (GrammarAST)adaptor.nil();


			STRING_LITERAL207=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_range3890); 
			STRING_LITERAL207_tree = new TerminalAST(STRING_LITERAL207) ;
			adaptor.addChild(root_0, STRING_LITERAL207_tree);

			RANGE208=(Token)match(input,RANGE,FOLLOW_RANGE_in_range3895); 
			RANGE208_tree = new RangeAST(RANGE208) ;
			root_0 = (GrammarAST)adaptor.becomeRoot(RANGE208_tree, root_0);

			STRING_LITERAL209=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_range3901); 
			STRING_LITERAL209_tree = new TerminalAST(STRING_LITERAL209) ;
			adaptor.addChild(root_0, STRING_LITERAL209_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "range"


	public static class terminal_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "terminal"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:872:1: terminal : ( TOKEN_REF ( elementOptions )? -> ^( TOKEN_REF ( elementOptions )? ) | STRING_LITERAL ( elementOptions )? -> ^( STRING_LITERAL ( elementOptions )? ) );
	public final ANTLRParser.terminal_return terminal() throws RecognitionException {
		ANTLRParser.terminal_return retval = new ANTLRParser.terminal_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token TOKEN_REF210=null;
		Token STRING_LITERAL212=null;
		ParserRuleReturnScope elementOptions211 =null;
		ParserRuleReturnScope elementOptions213 =null;

		GrammarAST TOKEN_REF210_tree=null;
		GrammarAST STRING_LITERAL212_tree=null;
		RewriteRuleTokenStream stream_STRING_LITERAL=new RewriteRuleTokenStream(adaptor,"token STRING_LITERAL");
		RewriteRuleTokenStream stream_TOKEN_REF=new RewriteRuleTokenStream(adaptor,"token TOKEN_REF");
		RewriteRuleSubtreeStream stream_elementOptions=new RewriteRuleSubtreeStream(adaptor,"rule elementOptions");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:879:2: ( TOKEN_REF ( elementOptions )? -> ^( TOKEN_REF ( elementOptions )? ) | STRING_LITERAL ( elementOptions )? -> ^( STRING_LITERAL ( elementOptions )? ) )
			int alt73=2;
			switch ( input.LA(1) ) {
			case TOKEN_REF:
				{
				alt73=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt73=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 73, 0, input);
				throw nvae;
			}
			switch (alt73) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:879:6: TOKEN_REF ( elementOptions )?
					{
					TOKEN_REF210=(Token)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_terminal3925);  
					stream_TOKEN_REF.add(TOKEN_REF210);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:879:16: ( elementOptions )?
					int alt71=2;
					switch ( input.LA(1) ) {
						case LT:
							{
							alt71=1;
							}
							break;
					}
					switch (alt71) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:879:16: elementOptions
							{
							pushFollow(FOLLOW_elementOptions_in_terminal3927);
							elementOptions211=elementOptions();
							state._fsp--;

							stream_elementOptions.add(elementOptions211.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: TOKEN_REF, elementOptions
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 879:33: -> ^( TOKEN_REF ( elementOptions )? )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:879:36: ^( TOKEN_REF ( elementOptions )? )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new TerminalAST(stream_TOKEN_REF.nextToken()), root_1);
						// org\\antlr\\v4\\parse\\ANTLRParser.g:879:61: ( elementOptions )?
						if ( stream_elementOptions.hasNext() ) {
							adaptor.addChild(root_1, stream_elementOptions.nextTree());
						}
						stream_elementOptions.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:880:6: STRING_LITERAL ( elementOptions )?
					{
					STRING_LITERAL212=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_terminal3948);  
					stream_STRING_LITERAL.add(STRING_LITERAL212);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:880:21: ( elementOptions )?
					int alt72=2;
					switch ( input.LA(1) ) {
						case LT:
							{
							alt72=1;
							}
							break;
					}
					switch (alt72) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:880:21: elementOptions
							{
							pushFollow(FOLLOW_elementOptions_in_terminal3950);
							elementOptions213=elementOptions();
							state._fsp--;

							stream_elementOptions.add(elementOptions213.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: elementOptions, STRING_LITERAL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 880:37: -> ^( STRING_LITERAL ( elementOptions )? )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:880:40: ^( STRING_LITERAL ( elementOptions )? )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new TerminalAST(stream_STRING_LITERAL.nextToken()), root_1);
						// org\\antlr\\v4\\parse\\ANTLRParser.g:880:70: ( elementOptions )?
						if ( stream_elementOptions.hasNext() ) {
							adaptor.addChild(root_1, stream_elementOptions.nextTree());
						}
						stream_elementOptions.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.ELEMENT_OPTIONS);
			if ( options!=null ) {
				Grammar.setNodeOptions(retval.tree, options);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "terminal"


	public static class elementOptions_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "elementOptions"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:885:1: elementOptions : LT elementOption ( COMMA elementOption )* GT -> ^( ELEMENT_OPTIONS[$LT,\"ELEMENT_OPTIONS\"] ( elementOption )+ ) ;
	public final ANTLRParser.elementOptions_return elementOptions() throws RecognitionException {
		ANTLRParser.elementOptions_return retval = new ANTLRParser.elementOptions_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LT214=null;
		Token COMMA216=null;
		Token GT218=null;
		ParserRuleReturnScope elementOption215 =null;
		ParserRuleReturnScope elementOption217 =null;

		GrammarAST LT214_tree=null;
		GrammarAST COMMA216_tree=null;
		GrammarAST GT218_tree=null;
		RewriteRuleTokenStream stream_GT=new RewriteRuleTokenStream(adaptor,"token GT");
		RewriteRuleTokenStream stream_LT=new RewriteRuleTokenStream(adaptor,"token LT");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_elementOption=new RewriteRuleSubtreeStream(adaptor,"rule elementOption");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:886:5: ( LT elementOption ( COMMA elementOption )* GT -> ^( ELEMENT_OPTIONS[$LT,\"ELEMENT_OPTIONS\"] ( elementOption )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:886:7: LT elementOption ( COMMA elementOption )* GT
			{
			LT214=(Token)match(input,LT,FOLLOW_LT_in_elementOptions3979);  
			stream_LT.add(LT214);

			pushFollow(FOLLOW_elementOption_in_elementOptions3981);
			elementOption215=elementOption();
			state._fsp--;

			stream_elementOption.add(elementOption215.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:886:24: ( COMMA elementOption )*
			loop74:
			while (true) {
				int alt74=2;
				switch ( input.LA(1) ) {
				case COMMA:
					{
					alt74=1;
					}
					break;
				}
				switch (alt74) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:886:25: COMMA elementOption
					{
					COMMA216=(Token)match(input,COMMA,FOLLOW_COMMA_in_elementOptions3984);  
					stream_COMMA.add(COMMA216);

					pushFollow(FOLLOW_elementOption_in_elementOptions3986);
					elementOption217=elementOption();
					state._fsp--;

					stream_elementOption.add(elementOption217.getTree());
					}
					break;

				default :
					break loop74;
				}
			}

			GT218=(Token)match(input,GT,FOLLOW_GT_in_elementOptions3990);  
			stream_GT.add(GT218);

			// AST REWRITE
			// elements: elementOption
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 886:50: -> ^( ELEMENT_OPTIONS[$LT,\"ELEMENT_OPTIONS\"] ( elementOption )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:886:53: ^( ELEMENT_OPTIONS[$LT,\"ELEMENT_OPTIONS\"] ( elementOption )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(ELEMENT_OPTIONS, LT214, "ELEMENT_OPTIONS"), root_1);
				if ( !(stream_elementOption.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_elementOption.hasNext() ) {
					adaptor.addChild(root_1, stream_elementOption.nextTree());
				}
				stream_elementOption.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elementOptions"


	public static class elementOption_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "elementOption"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:891:1: elementOption : ( qid | id ASSIGN ^ optionValue );
	public final ANTLRParser.elementOption_return elementOption() throws RecognitionException {
		ANTLRParser.elementOption_return retval = new ANTLRParser.elementOption_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ASSIGN221=null;
		ParserRuleReturnScope qid219 =null;
		ParserRuleReturnScope id220 =null;
		ParserRuleReturnScope optionValue222 =null;

		GrammarAST ASSIGN221_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:892:5: ( qid | id ASSIGN ^ optionValue )
			int alt75=2;
			switch ( input.LA(1) ) {
			case RULE_REF:
				{
				switch ( input.LA(2) ) {
				case COMMA:
				case DOT:
				case GT:
					{
					alt75=1;
					}
					break;
				case ASSIGN:
					{
					alt75=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 75, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case TOKEN_REF:
				{
				switch ( input.LA(2) ) {
				case COMMA:
				case DOT:
				case GT:
					{
					alt75=1;
					}
					break;
				case ASSIGN:
					{
					alt75=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 75, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 75, 0, input);
				throw nvae;
			}
			switch (alt75) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:893:7: qid
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_qid_in_elementOption4026);
					qid219=qid();
					state._fsp--;

					adaptor.addChild(root_0, qid219.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:894:7: id ASSIGN ^ optionValue
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_elementOption4034);
					id220=id();
					state._fsp--;

					adaptor.addChild(root_0, id220.getTree());

					ASSIGN221=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_elementOption4036); 
					ASSIGN221_tree = (GrammarAST)adaptor.create(ASSIGN221);
					root_0 = (GrammarAST)adaptor.becomeRoot(ASSIGN221_tree, root_0);

					pushFollow(FOLLOW_optionValue_in_elementOption4039);
					optionValue222=optionValue();
					state._fsp--;

					adaptor.addChild(root_0, optionValue222.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elementOption"


	public static class id_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "id"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:901:1: id : ( RULE_REF -> ID[$RULE_REF] | TOKEN_REF -> ID[$TOKEN_REF] );
	public final ANTLRParser.id_return id() throws RecognitionException {
		ANTLRParser.id_return retval = new ANTLRParser.id_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RULE_REF223=null;
		Token TOKEN_REF224=null;

		GrammarAST RULE_REF223_tree=null;
		GrammarAST TOKEN_REF224_tree=null;
		RewriteRuleTokenStream stream_RULE_REF=new RewriteRuleTokenStream(adaptor,"token RULE_REF");
		RewriteRuleTokenStream stream_TOKEN_REF=new RewriteRuleTokenStream(adaptor,"token TOKEN_REF");

		 paraphrases.push("looking for an identifier"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:904:5: ( RULE_REF -> ID[$RULE_REF] | TOKEN_REF -> ID[$TOKEN_REF] )
			int alt76=2;
			switch ( input.LA(1) ) {
			case RULE_REF:
				{
				alt76=1;
				}
				break;
			case TOKEN_REF:
				{
				alt76=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 76, 0, input);
				throw nvae;
			}
			switch (alt76) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:904:7: RULE_REF
					{
					RULE_REF223=(Token)match(input,RULE_REF,FOLLOW_RULE_REF_in_id4070);  
					stream_RULE_REF.add(RULE_REF223);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 904:17: -> ID[$RULE_REF]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, RULE_REF223));
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:905:7: TOKEN_REF
					{
					TOKEN_REF224=(Token)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_id4083);  
					stream_TOKEN_REF.add(TOKEN_REF224);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 905:17: -> ID[$TOKEN_REF]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, TOKEN_REF224));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "id"


	public static class qid_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "qid"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:908:1: qid : id ( DOT id )* -> ID[$qid.start, $text] ;
	public final ANTLRParser.qid_return qid() throws RecognitionException {
		ANTLRParser.qid_return retval = new ANTLRParser.qid_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOT226=null;
		ParserRuleReturnScope id225 =null;
		ParserRuleReturnScope id227 =null;

		GrammarAST DOT226_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");

		 paraphrases.push("looking for a qualified identifier"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:911:2: ( id ( DOT id )* -> ID[$qid.start, $text] )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:911:4: id ( DOT id )*
			{
			pushFollow(FOLLOW_id_in_qid4111);
			id225=id();
			state._fsp--;

			stream_id.add(id225.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:911:7: ( DOT id )*
			loop77:
			while (true) {
				int alt77=2;
				switch ( input.LA(1) ) {
				case DOT:
					{
					alt77=1;
					}
					break;
				}
				switch (alt77) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:911:8: DOT id
					{
					DOT226=(Token)match(input,DOT,FOLLOW_DOT_in_qid4114);  
					stream_DOT.add(DOT226);

					pushFollow(FOLLOW_id_in_qid4116);
					id227=id();
					state._fsp--;

					stream_id.add(id227.getTree());
					}
					break;

				default :
					break loop77;
				}
			}

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 911:17: -> ID[$qid.start, $text]
			{
				adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, (retval.start), input.toString(retval.start,input.LT(-1))));
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "qid"


	public static class alternativeEntry_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "alternativeEntry"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:914:1: alternativeEntry : alternative EOF ;
	public final ANTLRParser.alternativeEntry_return alternativeEntry() throws RecognitionException {
		ANTLRParser.alternativeEntry_return retval = new ANTLRParser.alternativeEntry_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token EOF229=null;
		ParserRuleReturnScope alternative228 =null;

		GrammarAST EOF229_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:914:18: ( alternative EOF )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:914:20: alternative EOF
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_alternative_in_alternativeEntry4133);
			alternative228=alternative();
			state._fsp--;

			adaptor.addChild(root_0, alternative228.getTree());

			EOF229=(Token)match(input,EOF,FOLLOW_EOF_in_alternativeEntry4135); 
			EOF229_tree = (GrammarAST)adaptor.create(EOF229);
			adaptor.addChild(root_0, EOF229_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "alternativeEntry"


	public static class elementEntry_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "elementEntry"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:915:1: elementEntry : element EOF ;
	public final ANTLRParser.elementEntry_return elementEntry() throws RecognitionException {
		ANTLRParser.elementEntry_return retval = new ANTLRParser.elementEntry_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token EOF231=null;
		ParserRuleReturnScope element230 =null;

		GrammarAST EOF231_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:915:14: ( element EOF )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:915:16: element EOF
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_element_in_elementEntry4144);
			element230=element();
			state._fsp--;

			adaptor.addChild(root_0, element230.getTree());

			EOF231=(Token)match(input,EOF,FOLLOW_EOF_in_elementEntry4146); 
			EOF231_tree = (GrammarAST)adaptor.create(EOF231);
			adaptor.addChild(root_0, EOF231_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elementEntry"


	public static class ruleEntry_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleEntry"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:916:1: ruleEntry : rule EOF ;
	public final ANTLRParser.ruleEntry_return ruleEntry() throws RecognitionException {
		ANTLRParser.ruleEntry_return retval = new ANTLRParser.ruleEntry_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token EOF233=null;
		ParserRuleReturnScope rule232 =null;

		GrammarAST EOF233_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:916:11: ( rule EOF )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:916:13: rule EOF
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_rule_in_ruleEntry4154);
			rule232=rule();
			state._fsp--;

			adaptor.addChild(root_0, rule232.getTree());

			EOF233=(Token)match(input,EOF,FOLLOW_EOF_in_ruleEntry4156); 
			EOF233_tree = (GrammarAST)adaptor.create(EOF233);
			adaptor.addChild(root_0, EOF233_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleEntry"


	public static class blockEntry_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "blockEntry"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:917:1: blockEntry : block EOF ;
	public final ANTLRParser.blockEntry_return blockEntry() throws RecognitionException {
		ANTLRParser.blockEntry_return retval = new ANTLRParser.blockEntry_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token EOF235=null;
		ParserRuleReturnScope block234 =null;

		GrammarAST EOF235_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:917:12: ( block EOF )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:917:14: block EOF
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_block_in_blockEntry4164);
			block234=block();
			state._fsp--;

			adaptor.addChild(root_0, block234.getTree());

			EOF235=(Token)match(input,EOF,FOLLOW_EOF_in_blockEntry4166); 
			EOF235_tree = (GrammarAST)adaptor.create(EOF235);
			adaptor.addChild(root_0, EOF235_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blockEntry"

	// Delegated rules



	public static final BitSet FOLLOW_DOC_COMMENT_in_grammarSpec402 = new BitSet(new long[]{0x0000080041000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_grammarType_in_grammarSpec433 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_grammarSpec435 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_grammarSpec437 = new BitSet(new long[]{0x0100020010820800L,0x0000000000000003L});
	public static final BitSet FOLLOW_sync_in_grammarSpec475 = new BitSet(new long[]{0x0100020010820800L,0x0000000000000003L});
	public static final BitSet FOLLOW_prequelConstruct_in_grammarSpec479 = new BitSet(new long[]{0x0100020010820800L,0x0000000000000003L});
	public static final BitSet FOLLOW_sync_in_grammarSpec481 = new BitSet(new long[]{0x0100020010820800L,0x0000000000000003L});
	public static final BitSet FOLLOW_rules_in_grammarSpec506 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_modeSpec_in_grammarSpec512 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_EOF_in_grammarSpec550 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_in_grammarType740 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_GRAMMAR_in_grammarType744 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PARSER_in_grammarType767 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_GRAMMAR_in_grammarType771 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAMMAR_in_grammarType792 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TREE_GRAMMAR_in_grammarType819 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_optionsSpec_in_prequelConstruct845 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delegateGrammars_in_prequelConstruct868 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tokensSpec_in_prequelConstruct912 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_action_in_prequelConstruct949 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPTIONS_in_optionsSpec964 = new BitSet(new long[]{0x0120000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_option_in_optionsSpec967 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_optionsSpec969 = new BitSet(new long[]{0x0120000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_RBRACE_in_optionsSpec973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_option1002 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_option1004 = new BitSet(new long[]{0x2100000020000010L,0x0000000000000002L});
	public static final BitSet FOLLOW_optionValue_in_option1007 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_qid_in_optionValue1050 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_optionValue1058 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_optionValue1063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INT_in_optionValue1074 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_in_delegateGrammars1090 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_delegateGrammar_in_delegateGrammars1092 = new BitSet(new long[]{0x0200000000008000L});
	public static final BitSet FOLLOW_COMMA_in_delegateGrammars1095 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_delegateGrammar_in_delegateGrammars1097 = new BitSet(new long[]{0x0200000000008000L});
	public static final BitSet FOLLOW_SEMI_in_delegateGrammars1101 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_delegateGrammar1128 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_delegateGrammar1130 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_delegateGrammar1133 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_delegateGrammar1143 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKENS_SPEC_in_tokensSpec1157 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_tokensSpec1159 = new BitSet(new long[]{0x0020000000008000L});
	public static final BitSet FOLLOW_COMMA_in_tokensSpec1162 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_tokensSpec1164 = new BitSet(new long[]{0x0020000000008000L});
	public static final BitSet FOLLOW_RBRACE_in_tokensSpec1168 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKENS_SPEC_in_tokensSpec1185 = new BitSet(new long[]{0x0020000000000000L});
	public static final BitSet FOLLOW_RBRACE_in_tokensSpec1187 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKENS_SPEC_in_tokensSpec1197 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_v3tokenSpec_in_tokensSpec1200 = new BitSet(new long[]{0x0120000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_RBRACE_in_tokensSpec1203 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_v3tokenSpec1223 = new BitSet(new long[]{0x0200000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_v3tokenSpec1229 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_v3tokenSpec1233 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_v3tokenSpec1294 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_in_action1310 = new BitSet(new long[]{0x0100080040000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_actionScopeName_in_action1313 = new BitSet(new long[]{0x0000000000004000L});
	public static final BitSet FOLLOW_COLONCOLON_in_action1315 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_action1319 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_action1321 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_actionScopeName1350 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_in_actionScopeName1355 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PARSER_in_actionScopeName1370 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MODE_in_modeSpec1389 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_modeSpec1391 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_modeSpec1393 = new BitSet(new long[]{0x0000000000820000L,0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_modeSpec1395 = new BitSet(new long[]{0x0000000000820000L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerRule_in_modeSpec1398 = new BitSet(new long[]{0x0000000000820000L,0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_modeSpec1400 = new BitSet(new long[]{0x0000000000820002L,0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_rules1431 = new BitSet(new long[]{0x0100000000820002L,0x0000000000000002L});
	public static final BitSet FOLLOW_rule_in_rules1434 = new BitSet(new long[]{0x0100000000820000L,0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_rules1436 = new BitSet(new long[]{0x0100000000820002L,0x0000000000000002L});
	public static final BitSet FOLLOW_parserRule_in_rule1498 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerRule_in_rule1503 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOC_COMMENT_in_parserRule1543 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RULE_REF_in_parserRule1566 = new BitSet(new long[]{0x8040020100000900L});
	public static final BitSet FOLLOW_ARG_ACTION_in_parserRule1596 = new BitSet(new long[]{0x8040020100000800L});
	public static final BitSet FOLLOW_ruleReturns_in_parserRule1603 = new BitSet(new long[]{0x8000020100000800L});
	public static final BitSet FOLLOW_throwsSpec_in_parserRule1610 = new BitSet(new long[]{0x0000020100000800L});
	public static final BitSet FOLLOW_localsSpec_in_parserRule1617 = new BitSet(new long[]{0x0000020000000800L});
	public static final BitSet FOLLOW_rulePrequels_in_parserRule1655 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_COLON_in_parserRule1664 = new BitSet(new long[]{0x2500404200080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_ruleBlock_in_parserRule1687 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_parserRule1696 = new BitSet(new long[]{0x0000000000401000L});
	public static final BitSet FOLLOW_exceptionGroup_in_parserRule1705 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_exceptionHandler_in_exceptionGroup1791 = new BitSet(new long[]{0x0000000000401002L});
	public static final BitSet FOLLOW_finallyClause_in_exceptionGroup1794 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CATCH_in_exceptionHandler1811 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_ARG_ACTION_in_exceptionHandler1813 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_exceptionHandler1815 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FINALLY_in_finallyClause1842 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_finallyClause1844 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_rulePrequels1876 = new BitSet(new long[]{0x0000020000000802L});
	public static final BitSet FOLLOW_rulePrequel_in_rulePrequels1879 = new BitSet(new long[]{0x0000020000000800L});
	public static final BitSet FOLLOW_sync_in_rulePrequels1881 = new BitSet(new long[]{0x0000020000000802L});
	public static final BitSet FOLLOW_optionsSpec_in_rulePrequel1905 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ruleAction_in_rulePrequel1913 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RETURNS_in_ruleReturns1933 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_ARG_ACTION_in_ruleReturns1936 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_THROWS_in_throwsSpec1964 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_qid_in_throwsSpec1966 = new BitSet(new long[]{0x0000000000008002L});
	public static final BitSet FOLLOW_COMMA_in_throwsSpec1969 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_qid_in_throwsSpec1971 = new BitSet(new long[]{0x0000000000008002L});
	public static final BitSet FOLLOW_LOCALS_in_localsSpec1996 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_ARG_ACTION_in_localsSpec1999 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_in_ruleAction2022 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_ruleAction2024 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_ruleAction2026 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ruleAltList_in_ruleBlock2064 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_labeledAlt_in_ruleAltList2100 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_OR_in_ruleAltList2103 = new BitSet(new long[]{0x2500404200080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_labeledAlt_in_ruleAltList2105 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_alternative_in_labeledAlt2123 = new BitSet(new long[]{0x0000400000000002L});
	public static final BitSet FOLLOW_POUND_in_labeledAlt2129 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_labeledAlt2132 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOC_COMMENT_in_lexerRule2164 = new BitSet(new long[]{0x0000000000800000L,0x0000000000000002L});
	public static final BitSet FOLLOW_FRAGMENT_in_lexerRule2167 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_lexerRule2173 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_COLON_in_lexerRule2175 = new BitSet(new long[]{0x2500004280080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerRuleBlock_in_lexerRule2177 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_lexerRule2179 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAltList_in_lexerRuleBlock2246 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAlt_in_lexerAltList2282 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_OR_in_lexerAltList2285 = new BitSet(new long[]{0x2500004280080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAlt_in_lexerAltList2287 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_lexerElements_in_lexerAlt2305 = new BitSet(new long[]{0x0010000000000002L});
	public static final BitSet FOLLOW_lexerCommands_in_lexerAlt2311 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerElement_in_lexerElements2354 = new BitSet(new long[]{0x2500004280080012L,0x0000000000000002L});
	public static final BitSet FOLLOW_labeledLexerElement_in_lexerElement2391 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_lexerElement2397 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAtom_in_lexerElement2443 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_lexerElement2449 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerBlock_in_lexerElement2495 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_lexerElement2501 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_actionElement_in_lexerElement2529 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_labeledLexerElement2559 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_labeledLexerElement2564 = new BitSet(new long[]{0x2100004280080000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_ASSIGN_in_labeledLexerElement2568 = new BitSet(new long[]{0x2100004280080000L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAtom_in_labeledLexerElement2575 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerBlock_in_labeledLexerElement2592 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_lexerBlock2625 = new BitSet(new long[]{0x2500024280080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_optionsSpec_in_lexerBlock2637 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_COLON_in_lexerBlock2639 = new BitSet(new long[]{0x2500004280080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAltList_in_lexerBlock2652 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_lexerBlock2662 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RARROW_in_lexerCommands2699 = new BitSet(new long[]{0x0100000800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerCommand_in_lexerCommands2701 = new BitSet(new long[]{0x0000000000008002L});
	public static final BitSet FOLLOW_COMMA_in_lexerCommands2704 = new BitSet(new long[]{0x0100000800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerCommand_in_lexerCommands2706 = new BitSet(new long[]{0x0000000000008002L});
	public static final BitSet FOLLOW_lexerCommandName_in_lexerCommand2724 = new BitSet(new long[]{0x0000000200000000L});
	public static final BitSet FOLLOW_LPAREN_in_lexerCommand2726 = new BitSet(new long[]{0x0100000020000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerCommandExpr_in_lexerCommand2728 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_lexerCommand2730 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerCommandName_in_lexerCommand2745 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_lexerCommandExpr2756 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INT_in_lexerCommandExpr2761 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_lexerCommandName2785 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MODE_in_lexerCommandName2803 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alternative_in_altList2831 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_OR_in_altList2834 = new BitSet(new long[]{0x2500044200080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_alternative_in_altList2836 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_elements_in_alternative2872 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_element_in_elements2916 = new BitSet(new long[]{0x2500004200080012L,0x0000000000000002L});
	public static final BitSet FOLLOW_labeledElement_in_element2954 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_element2960 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_atom_in_element3006 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_element3012 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ebnf_in_element3058 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_actionElement_in_element3063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_actionElement3089 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_actionElement3099 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_elementOptions_in_actionElement3101 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SEMPRED_in_actionElement3119 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SEMPRED_in_actionElement3129 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_elementOptions_in_actionElement3131 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_labeledElement3153 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_labeledElement3158 = new BitSet(new long[]{0x2100004200080000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_ASSIGN_in_labeledElement3162 = new BitSet(new long[]{0x2100004200080000L,0x0000000000000002L});
	public static final BitSet FOLLOW_atom_in_labeledElement3169 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_block_in_labeledElement3191 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_block_in_ebnf3227 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_blockSuffix_in_ebnf3251 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_blockSuffix3301 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_ebnfSuffix3316 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_ebnfSuffix3320 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_ebnfSuffix3336 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_ebnfSuffix3340 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_ebnfSuffix3358 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_ebnfSuffix3362 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_range_in_lexerAtom3383 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_terminal_in_lexerAtom3388 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RULE_REF_in_lexerAtom3398 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_notSet_in_lexerAtom3409 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_wildcard_in_lexerAtom3417 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_CHAR_SET_in_lexerAtom3425 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_range_in_atom3470 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_terminal_in_atom3477 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ruleref_in_atom3487 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_notSet_in_atom3495 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_wildcard_in_atom3503 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_wildcard3551 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_elementOptions_in_wildcard3553 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_notSet3591 = new BitSet(new long[]{0x2000000080000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_setElement_in_notSet3593 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_notSet3621 = new BitSet(new long[]{0x0000000200000000L});
	public static final BitSet FOLLOW_blockSet_in_notSet3623 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_blockSet3658 = new BitSet(new long[]{0x2000000080000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_setElement_in_blockSet3660 = new BitSet(new long[]{0x0080040000000000L});
	public static final BitSet FOLLOW_OR_in_blockSet3663 = new BitSet(new long[]{0x2000000080000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_setElement_in_blockSet3665 = new BitSet(new long[]{0x0080040000000000L});
	public static final BitSet FOLLOW_RPAREN_in_blockSet3669 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_setElement3699 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_setElement3707 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_range_in_setElement3715 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_CHAR_SET_in_setElement3725 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_block3749 = new BitSet(new long[]{0x2500064200082810L,0x0000000000000002L});
	public static final BitSet FOLLOW_optionsSpec_in_block3761 = new BitSet(new long[]{0x0000000000002800L});
	public static final BitSet FOLLOW_ruleAction_in_block3766 = new BitSet(new long[]{0x0000000000002800L});
	public static final BitSet FOLLOW_COLON_in_block3769 = new BitSet(new long[]{0x2500044200080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_altList_in_block3782 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_block3786 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RULE_REF_in_ruleref3835 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_ARG_ACTION_in_ruleref3837 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_range3890 = new BitSet(new long[]{0x0008000000000000L});
	public static final BitSet FOLLOW_RANGE_in_range3895 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_range3901 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_terminal3925 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_elementOptions_in_terminal3927 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_terminal3948 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_elementOptions_in_terminal3950 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_elementOptions3979 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_elementOption_in_elementOptions3981 = new BitSet(new long[]{0x0000000002008000L});
	public static final BitSet FOLLOW_COMMA_in_elementOptions3984 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_elementOption_in_elementOptions3986 = new BitSet(new long[]{0x0000000002008000L});
	public static final BitSet FOLLOW_GT_in_elementOptions3990 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_qid_in_elementOption4026 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_elementOption4034 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_elementOption4036 = new BitSet(new long[]{0x2100000020000010L,0x0000000000000002L});
	public static final BitSet FOLLOW_optionValue_in_elementOption4039 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RULE_REF_in_id4070 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_id4083 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_qid4111 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_DOT_in_qid4114 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_qid4116 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_alternative_in_alternativeEntry4133 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_alternativeEntry4135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_element_in_elementEntry4144 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_elementEntry4146 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rule_in_ruleEntry4154 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_ruleEntry4156 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_block_in_blockEntry4164 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_blockEntry4166 = new BitSet(new long[]{0x0000000000000002L});
}
