/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.view;

import java.util.LinkedHashSet;
import java.util.Set;
import org.androidannotations.api.view.HasViews;
import org.androidannotations.api.view.OnViewChangedListener;

public class OnViewChangedNotifier {
    private static OnViewChangedNotifier currentNotifier;
    private final Set<OnViewChangedListener> listeners = new LinkedHashSet<OnViewChangedListener>();

    public static OnViewChangedNotifier replaceNotifier(OnViewChangedNotifier notifier) {
        OnViewChangedNotifier previousNotifier = currentNotifier;
        currentNotifier = notifier;
        return previousNotifier;
    }

    public static void registerOnViewChangedListener(OnViewChangedListener listener) {
        if (currentNotifier != null) {
            OnViewChangedNotifier.currentNotifier.listeners.add(listener);
        }
    }

    public void notifyViewChanged(HasViews hasViews) {
        for (OnViewChangedListener listener : this.listeners) {
            listener.onViewChanged(hasViews);
        }
    }
}

