/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.BeaconService;
import org.altbeacon.beacon.service.MonitoringStatus;
import org.altbeacon.beacon.service.RangeState;

public class SettingsData
implements Serializable {
    private static final String TAG = SettingsData.class.getSimpleName();
    private static final String SETTINGS_DATA_KEY = "SettingsData";
    ArrayList<BeaconParser> mBeaconParsers;
    Boolean mRegionStatePersistenceEnabled;
    Boolean mAndroidLScanningDisabled;
    Long mRegionExitPeriod;
    Boolean mUseTrackingCache;
    Boolean mHardwareEqualityEnforced;

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putSerializable(SETTINGS_DATA_KEY, (Serializable)this);
        return bundle;
    }

    public static SettingsData fromBundle(@NonNull Bundle bundle) {
        bundle.setClassLoader(Region.class.getClassLoader());
        SettingsData settingsData = null;
        if (bundle.get(SETTINGS_DATA_KEY) != null) {
            settingsData = (SettingsData)bundle.getSerializable(SETTINGS_DATA_KEY);
        }
        return settingsData;
    }

    public void apply(@NonNull BeaconService scanService) {
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication((Context)scanService);
        if (beaconManager.isMainProcess()) {
            LogManager.d(TAG, "API Applying settings changes to scanner service", new Object[0]);
            scanService.reloadParsers();
        } else {
            LogManager.d(TAG, "API Applying settings changes to scanner in other process", new Object[0]);
            List<BeaconParser> beaconParsers = beaconManager.getBeaconParsers();
            boolean beaconParsersChanged = false;
            if (beaconParsers.size() == this.mBeaconParsers.size()) {
                for (int i = 0; i < beaconParsers.size(); ++i) {
                    if (beaconParsers.get(i).equals(this.mBeaconParsers.get(i))) continue;
                    LogManager.d(TAG, "Beacon parsers have changed to: " + this.mBeaconParsers.get(i).getLayout(), new Object[0]);
                    beaconParsersChanged = true;
                    break;
                }
            } else {
                beaconParsersChanged = true;
                LogManager.d(TAG, "Beacon parsers have been added or removed.", new Object[0]);
            }
            if (beaconParsersChanged) {
                LogManager.d(TAG, "Updating beacon parsers", new Object[0]);
                beaconManager.getBeaconParsers().clear();
                beaconManager.getBeaconParsers().addAll(this.mBeaconParsers);
                scanService.reloadParsers();
            } else {
                LogManager.d(TAG, "Beacon parsers unchanged.", new Object[0]);
            }
            MonitoringStatus monitoringStatus = MonitoringStatus.getInstanceForApplication((Context)scanService);
            if (monitoringStatus.isStatePreservationOn() && !this.mRegionStatePersistenceEnabled.booleanValue()) {
                monitoringStatus.stopStatusPreservation();
            } else if (!monitoringStatus.isStatePreservationOn() && this.mRegionStatePersistenceEnabled.booleanValue()) {
                monitoringStatus.startStatusPreservation();
            }
            BeaconManager.setAndroidLScanningDisabled(this.mAndroidLScanningDisabled);
            BeaconManager.setRegionExitPeriod(this.mRegionExitPeriod);
            RangeState.setUseTrackingCache(this.mUseTrackingCache);
            Beacon.setHardwareEqualityEnforced(this.mHardwareEqualityEnforced);
        }
    }

    public SettingsData collect(@NonNull Context context) {
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication(context);
        this.mBeaconParsers = new ArrayList<BeaconParser>(beaconManager.getBeaconParsers());
        this.mRegionStatePersistenceEnabled = beaconManager.isRegionStatePersistenceEnabled();
        this.mAndroidLScanningDisabled = beaconManager.isAndroidLScanningDisabled();
        this.mRegionExitPeriod = BeaconManager.getRegionExitPeriod();
        this.mUseTrackingCache = RangeState.getUseTrackingCache();
        this.mHardwareEqualityEnforced = Beacon.getHardwareEqualityEnforced();
        return this;
    }
}

