/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.app.Notification;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.distance.DistanceCalculatorFactory;
import org.altbeacon.beacon.distance.ModelSpecificDistanceCalculatorFactory;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.RunningAverageRssiFilter;
import org.altbeacon.beacon.simulator.BeaconSimulator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b9\b\u0086\b\u0018\u0000 G2\u00020\u0001:\nEFGHIJKLMNB\u00b1\u0001\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0018J\u0010\u00101\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u000f\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0016H\u00c6\u0003J\u0010\u00106\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0010\u00107\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0010\u00108\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u000b\u00109\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0010\u0010:\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010&J\u0010\u0010;\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010<\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010&J\u0010\u0010=\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u000b\u0010>\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u00ba\u0001\u0010?\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010@J\u0013\u0010A\u001a\u00020\u00032\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010C\u001a\u00020\tH\u00d6\u0001J\t\u0010D\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\"\u0010\u001cR\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b#\u0010\u001cR\u0015\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b$\u0010\u001cR\u0015\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b%\u0010&R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b(\u0010&R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b)\u0010\u001cR\u0017\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0015\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b0\u0010\u001c\u00a8\u0006O"}, d2={"Lorg/altbeacon/beacon/Settings;", "", "debug", "", "regionStatePersistenceEnabled", "hardwareEqualityEnforced", "scanPeriods", "Lorg/altbeacon/beacon/Settings$ScanPeriods;", "regionExitPeriodMillis", "", "useTrackingCache", "maxTrackingAgeMillis", "manifestCheckingDisabled", "beaconSimulator", "Lorg/altbeacon/beacon/simulator/BeaconSimulator;", "rssiFilterClass", "Ljava/lang/Class;", "distanceModelUpdateUrl", "", "distanceCalculatorFactory", "Lorg/altbeacon/beacon/distance/DistanceCalculatorFactory;", "scanStrategy", "Lorg/altbeacon/beacon/Settings$ScanStrategy;", "longScanForcingEnabled", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Lorg/altbeacon/beacon/Settings$ScanPeriods;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Boolean;Lorg/altbeacon/beacon/simulator/BeaconSimulator;Ljava/lang/Class;Ljava/lang/String;Lorg/altbeacon/beacon/distance/DistanceCalculatorFactory;Lorg/altbeacon/beacon/Settings$ScanStrategy;Ljava/lang/Boolean;)V", "getBeaconSimulator", "()Lorg/altbeacon/beacon/simulator/BeaconSimulator;", "getDebug", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getDistanceCalculatorFactory", "()Lorg/altbeacon/beacon/distance/DistanceCalculatorFactory;", "getDistanceModelUpdateUrl", "()Ljava/lang/String;", "getHardwareEqualityEnforced", "getLongScanForcingEnabled", "getManifestCheckingDisabled", "getMaxTrackingAgeMillis", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getRegionExitPeriodMillis", "getRegionStatePersistenceEnabled", "getRssiFilterClass", "()Ljava/lang/Class;", "getScanPeriods", "()Lorg/altbeacon/beacon/Settings$ScanPeriods;", "getScanStrategy", "()Lorg/altbeacon/beacon/Settings$ScanStrategy;", "getUseTrackingCache", "component1", "component10", "component11", "component12", "component13", "component14", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Lorg/altbeacon/beacon/Settings$ScanPeriods;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Boolean;Lorg/altbeacon/beacon/simulator/BeaconSimulator;Ljava/lang/Class;Ljava/lang/String;Lorg/altbeacon/beacon/distance/DistanceCalculatorFactory;Lorg/altbeacon/beacon/Settings$ScanStrategy;Ljava/lang/Boolean;)Lorg/altbeacon/beacon/Settings;", "equals", "other", "hashCode", "toString", "BackgroundServiceScanStrategy", "Builder", "Companion", "Defaults", "DisabledBeaconSimulator", "ForegroundServiceScanStrategy", "IntentScanStrategy", "JobServiceScanStrategy", "ScanPeriods", "ScanStrategy", "android-beacon-library_release"})
public final class Settings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Boolean debug;
    @Nullable
    private final Boolean regionStatePersistenceEnabled;
    @Nullable
    private final Boolean hardwareEqualityEnforced;
    @Nullable
    private final ScanPeriods scanPeriods;
    @Nullable
    private final Integer regionExitPeriodMillis;
    @Nullable
    private final Boolean useTrackingCache;
    @Nullable
    private final Integer maxTrackingAgeMillis;
    @Nullable
    private final Boolean manifestCheckingDisabled;
    @Nullable
    private final BeaconSimulator beaconSimulator;
    @Nullable
    private final Class<?> rssiFilterClass;
    @Nullable
    private final String distanceModelUpdateUrl;
    @Nullable
    private final DistanceCalculatorFactory distanceCalculatorFactory;
    @Nullable
    private final ScanStrategy scanStrategy;
    @Nullable
    private final Boolean longScanForcingEnabled;

    public Settings(@Nullable Boolean debug, @Nullable Boolean regionStatePersistenceEnabled, @Nullable Boolean hardwareEqualityEnforced, @Nullable ScanPeriods scanPeriods, @Nullable Integer regionExitPeriodMillis, @Nullable Boolean useTrackingCache, @Nullable Integer maxTrackingAgeMillis, @Nullable Boolean manifestCheckingDisabled, @Nullable BeaconSimulator beaconSimulator, @Nullable Class<?> rssiFilterClass, @Nullable String distanceModelUpdateUrl, @Nullable DistanceCalculatorFactory distanceCalculatorFactory, @Nullable ScanStrategy scanStrategy, @Nullable Boolean longScanForcingEnabled) {
        this.debug = debug;
        this.regionStatePersistenceEnabled = regionStatePersistenceEnabled;
        this.hardwareEqualityEnforced = hardwareEqualityEnforced;
        this.scanPeriods = scanPeriods;
        this.regionExitPeriodMillis = regionExitPeriodMillis;
        this.useTrackingCache = useTrackingCache;
        this.maxTrackingAgeMillis = maxTrackingAgeMillis;
        this.manifestCheckingDisabled = manifestCheckingDisabled;
        this.beaconSimulator = beaconSimulator;
        this.rssiFilterClass = rssiFilterClass;
        this.distanceModelUpdateUrl = distanceModelUpdateUrl;
        this.distanceCalculatorFactory = distanceCalculatorFactory;
        this.scanStrategy = scanStrategy;
        this.longScanForcingEnabled = longScanForcingEnabled;
    }

    public /* synthetic */ Settings(Boolean bl, Boolean bl2, Boolean bl3, ScanPeriods scanPeriods, Integer n, Boolean bl4, Integer n2, Boolean bl5, BeaconSimulator beaconSimulator, Class clazz, String string, DistanceCalculatorFactory distanceCalculatorFactory, ScanStrategy scanStrategy, Boolean bl6, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            bl = null;
        }
        if ((n3 & 2) != 0) {
            bl2 = null;
        }
        if ((n3 & 4) != 0) {
            bl3 = null;
        }
        if ((n3 & 8) != 0) {
            scanPeriods = null;
        }
        if ((n3 & 0x10) != 0) {
            n = null;
        }
        if ((n3 & 0x20) != 0) {
            bl4 = null;
        }
        if ((n3 & 0x40) != 0) {
            n2 = null;
        }
        if ((n3 & 0x80) != 0) {
            bl5 = null;
        }
        if ((n3 & 0x100) != 0) {
            beaconSimulator = null;
        }
        if ((n3 & 0x200) != 0) {
            clazz = null;
        }
        if ((n3 & 0x400) != 0) {
            string = null;
        }
        if ((n3 & 0x800) != 0) {
            distanceCalculatorFactory = null;
        }
        if ((n3 & 0x1000) != 0) {
            scanStrategy = null;
        }
        if ((n3 & 0x2000) != 0) {
            bl6 = null;
        }
        this(bl, bl2, bl3, scanPeriods, n, bl4, n2, bl5, beaconSimulator, clazz, string, distanceCalculatorFactory, scanStrategy, bl6);
    }

    @Nullable
    public final Boolean getDebug() {
        return this.debug;
    }

    @Nullable
    public final Boolean getRegionStatePersistenceEnabled() {
        return this.regionStatePersistenceEnabled;
    }

    @Nullable
    public final Boolean getHardwareEqualityEnforced() {
        return this.hardwareEqualityEnforced;
    }

    @Nullable
    public final ScanPeriods getScanPeriods() {
        return this.scanPeriods;
    }

    @Nullable
    public final Integer getRegionExitPeriodMillis() {
        return this.regionExitPeriodMillis;
    }

    @Nullable
    public final Boolean getUseTrackingCache() {
        return this.useTrackingCache;
    }

    @Nullable
    public final Integer getMaxTrackingAgeMillis() {
        return this.maxTrackingAgeMillis;
    }

    @Nullable
    public final Boolean getManifestCheckingDisabled() {
        return this.manifestCheckingDisabled;
    }

    @Nullable
    public final BeaconSimulator getBeaconSimulator() {
        return this.beaconSimulator;
    }

    @Nullable
    public final Class<?> getRssiFilterClass() {
        return this.rssiFilterClass;
    }

    @Nullable
    public final String getDistanceModelUpdateUrl() {
        return this.distanceModelUpdateUrl;
    }

    @Nullable
    public final DistanceCalculatorFactory getDistanceCalculatorFactory() {
        return this.distanceCalculatorFactory;
    }

    @Nullable
    public final ScanStrategy getScanStrategy() {
        return this.scanStrategy;
    }

    @Nullable
    public final Boolean getLongScanForcingEnabled() {
        return this.longScanForcingEnabled;
    }

    @Nullable
    public final Boolean component1() {
        return this.debug;
    }

    @Nullable
    public final Boolean component2() {
        return this.regionStatePersistenceEnabled;
    }

    @Nullable
    public final Boolean component3() {
        return this.hardwareEqualityEnforced;
    }

    @Nullable
    public final ScanPeriods component4() {
        return this.scanPeriods;
    }

    @Nullable
    public final Integer component5() {
        return this.regionExitPeriodMillis;
    }

    @Nullable
    public final Boolean component6() {
        return this.useTrackingCache;
    }

    @Nullable
    public final Integer component7() {
        return this.maxTrackingAgeMillis;
    }

    @Nullable
    public final Boolean component8() {
        return this.manifestCheckingDisabled;
    }

    @Nullable
    public final BeaconSimulator component9() {
        return this.beaconSimulator;
    }

    @Nullable
    public final Class<?> component10() {
        return this.rssiFilterClass;
    }

    @Nullable
    public final String component11() {
        return this.distanceModelUpdateUrl;
    }

    @Nullable
    public final DistanceCalculatorFactory component12() {
        return this.distanceCalculatorFactory;
    }

    @Nullable
    public final ScanStrategy component13() {
        return this.scanStrategy;
    }

    @Nullable
    public final Boolean component14() {
        return this.longScanForcingEnabled;
    }

    @NotNull
    public final Settings copy(@Nullable Boolean debug, @Nullable Boolean regionStatePersistenceEnabled, @Nullable Boolean hardwareEqualityEnforced, @Nullable ScanPeriods scanPeriods, @Nullable Integer regionExitPeriodMillis, @Nullable Boolean useTrackingCache, @Nullable Integer maxTrackingAgeMillis, @Nullable Boolean manifestCheckingDisabled, @Nullable BeaconSimulator beaconSimulator, @Nullable Class<?> rssiFilterClass, @Nullable String distanceModelUpdateUrl, @Nullable DistanceCalculatorFactory distanceCalculatorFactory, @Nullable ScanStrategy scanStrategy, @Nullable Boolean longScanForcingEnabled) {
        return new Settings(debug, regionStatePersistenceEnabled, hardwareEqualityEnforced, scanPeriods, regionExitPeriodMillis, useTrackingCache, maxTrackingAgeMillis, manifestCheckingDisabled, beaconSimulator, rssiFilterClass, distanceModelUpdateUrl, distanceCalculatorFactory, scanStrategy, longScanForcingEnabled);
    }

    public static /* synthetic */ Settings copy$default(Settings settings, Boolean bl, Boolean bl2, Boolean bl3, ScanPeriods scanPeriods, Integer n, Boolean bl4, Integer n2, Boolean bl5, BeaconSimulator beaconSimulator, Class clazz, String string, DistanceCalculatorFactory distanceCalculatorFactory, ScanStrategy scanStrategy, Boolean bl6, int n3, Object object) {
        if ((n3 & 1) != 0) {
            bl = settings.debug;
        }
        if ((n3 & 2) != 0) {
            bl2 = settings.regionStatePersistenceEnabled;
        }
        if ((n3 & 4) != 0) {
            bl3 = settings.hardwareEqualityEnforced;
        }
        if ((n3 & 8) != 0) {
            scanPeriods = settings.scanPeriods;
        }
        if ((n3 & 0x10) != 0) {
            n = settings.regionExitPeriodMillis;
        }
        if ((n3 & 0x20) != 0) {
            bl4 = settings.useTrackingCache;
        }
        if ((n3 & 0x40) != 0) {
            n2 = settings.maxTrackingAgeMillis;
        }
        if ((n3 & 0x80) != 0) {
            bl5 = settings.manifestCheckingDisabled;
        }
        if ((n3 & 0x100) != 0) {
            beaconSimulator = settings.beaconSimulator;
        }
        if ((n3 & 0x200) != 0) {
            clazz = settings.rssiFilterClass;
        }
        if ((n3 & 0x400) != 0) {
            string = settings.distanceModelUpdateUrl;
        }
        if ((n3 & 0x800) != 0) {
            distanceCalculatorFactory = settings.distanceCalculatorFactory;
        }
        if ((n3 & 0x1000) != 0) {
            scanStrategy = settings.scanStrategy;
        }
        if ((n3 & 0x2000) != 0) {
            bl6 = settings.longScanForcingEnabled;
        }
        return settings.copy(bl, bl2, bl3, scanPeriods, n, bl4, n2, bl5, beaconSimulator, clazz, string, distanceCalculatorFactory, scanStrategy, bl6);
    }

    @NotNull
    public String toString() {
        return "Settings(debug=" + this.debug + ", regionStatePersistenceEnabled=" + this.regionStatePersistenceEnabled + ", hardwareEqualityEnforced=" + this.hardwareEqualityEnforced + ", scanPeriods=" + this.scanPeriods + ", regionExitPeriodMillis=" + this.regionExitPeriodMillis + ", useTrackingCache=" + this.useTrackingCache + ", maxTrackingAgeMillis=" + this.maxTrackingAgeMillis + ", manifestCheckingDisabled=" + this.manifestCheckingDisabled + ", beaconSimulator=" + this.beaconSimulator + ", rssiFilterClass=" + this.rssiFilterClass + ", distanceModelUpdateUrl=" + this.distanceModelUpdateUrl + ", distanceCalculatorFactory=" + this.distanceCalculatorFactory + ", scanStrategy=" + this.scanStrategy + ", longScanForcingEnabled=" + this.longScanForcingEnabled + ")";
    }

    public int hashCode() {
        int result = this.debug == null ? 0 : ((Object)this.debug).hashCode();
        result = result * 31 + (this.regionStatePersistenceEnabled == null ? 0 : ((Object)this.regionStatePersistenceEnabled).hashCode());
        result = result * 31 + (this.hardwareEqualityEnforced == null ? 0 : ((Object)this.hardwareEqualityEnforced).hashCode());
        result = result * 31 + (this.scanPeriods == null ? 0 : this.scanPeriods.hashCode());
        result = result * 31 + (this.regionExitPeriodMillis == null ? 0 : ((Object)this.regionExitPeriodMillis).hashCode());
        result = result * 31 + (this.useTrackingCache == null ? 0 : ((Object)this.useTrackingCache).hashCode());
        result = result * 31 + (this.maxTrackingAgeMillis == null ? 0 : ((Object)this.maxTrackingAgeMillis).hashCode());
        result = result * 31 + (this.manifestCheckingDisabled == null ? 0 : ((Object)this.manifestCheckingDisabled).hashCode());
        result = result * 31 + (this.beaconSimulator == null ? 0 : this.beaconSimulator.hashCode());
        result = result * 31 + (this.rssiFilterClass == null ? 0 : this.rssiFilterClass.hashCode());
        result = result * 31 + (this.distanceModelUpdateUrl == null ? 0 : this.distanceModelUpdateUrl.hashCode());
        result = result * 31 + (this.distanceCalculatorFactory == null ? 0 : this.distanceCalculatorFactory.hashCode());
        result = result * 31 + (this.scanStrategy == null ? 0 : this.scanStrategy.hashCode());
        result = result * 31 + (this.longScanForcingEnabled == null ? 0 : ((Object)this.longScanForcingEnabled).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Settings)) {
            return false;
        }
        Settings settings = (Settings)other;
        if (!Intrinsics.areEqual((Object)this.debug, (Object)settings.debug)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.regionStatePersistenceEnabled, (Object)settings.regionStatePersistenceEnabled)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hardwareEqualityEnforced, (Object)settings.hardwareEqualityEnforced)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scanPeriods, (Object)settings.scanPeriods)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.regionExitPeriodMillis, (Object)settings.regionExitPeriodMillis)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.useTrackingCache, (Object)settings.useTrackingCache)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maxTrackingAgeMillis, (Object)settings.maxTrackingAgeMillis)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.manifestCheckingDisabled, (Object)settings.manifestCheckingDisabled)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.beaconSimulator, (Object)settings.beaconSimulator)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.rssiFilterClass, settings.rssiFilterClass)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.distanceModelUpdateUrl, (Object)settings.distanceModelUpdateUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.distanceCalculatorFactory, (Object)settings.distanceCalculatorFactory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scanStrategy, (Object)settings.scanStrategy)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.longScanForcingEnabled, (Object)settings.longScanForcingEnabled);
    }

    public Settings() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, 16383, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/altbeacon/beacon/Settings$ScanPeriods;", "", "foregroundScanPeriodMillis", "", "foregroundBetweenScanPeriodMillis", "backgroundScanPeriodMillis", "backgroundBetweenScanPeriodMillis", "(JJJJ)V", "getBackgroundBetweenScanPeriodMillis", "()J", "getBackgroundScanPeriodMillis", "getForegroundBetweenScanPeriodMillis", "getForegroundScanPeriodMillis", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-beacon-library_release"})
    public static final class ScanPeriods {
        private final long foregroundScanPeriodMillis;
        private final long foregroundBetweenScanPeriodMillis;
        private final long backgroundScanPeriodMillis;
        private final long backgroundBetweenScanPeriodMillis;

        public ScanPeriods(long foregroundScanPeriodMillis, long foregroundBetweenScanPeriodMillis, long backgroundScanPeriodMillis, long backgroundBetweenScanPeriodMillis) {
            this.foregroundScanPeriodMillis = foregroundScanPeriodMillis;
            this.foregroundBetweenScanPeriodMillis = foregroundBetweenScanPeriodMillis;
            this.backgroundScanPeriodMillis = backgroundScanPeriodMillis;
            this.backgroundBetweenScanPeriodMillis = backgroundBetweenScanPeriodMillis;
        }

        public /* synthetic */ ScanPeriods(long l, long l2, long l3, long l4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 1100L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 30000L;
            }
            if ((n & 8) != 0) {
                l4 = 300000L;
            }
            this(l, l2, l3, l4);
        }

        public final long getForegroundScanPeriodMillis() {
            return this.foregroundScanPeriodMillis;
        }

        public final long getForegroundBetweenScanPeriodMillis() {
            return this.foregroundBetweenScanPeriodMillis;
        }

        public final long getBackgroundScanPeriodMillis() {
            return this.backgroundScanPeriodMillis;
        }

        public final long getBackgroundBetweenScanPeriodMillis() {
            return this.backgroundBetweenScanPeriodMillis;
        }

        public final long component1() {
            return this.foregroundScanPeriodMillis;
        }

        public final long component2() {
            return this.foregroundBetweenScanPeriodMillis;
        }

        public final long component3() {
            return this.backgroundScanPeriodMillis;
        }

        public final long component4() {
            return this.backgroundBetweenScanPeriodMillis;
        }

        @NotNull
        public final ScanPeriods copy(long foregroundScanPeriodMillis, long foregroundBetweenScanPeriodMillis, long backgroundScanPeriodMillis, long backgroundBetweenScanPeriodMillis) {
            return new ScanPeriods(foregroundScanPeriodMillis, foregroundBetweenScanPeriodMillis, backgroundScanPeriodMillis, backgroundBetweenScanPeriodMillis);
        }

        public static /* synthetic */ ScanPeriods copy$default(ScanPeriods scanPeriods, long l, long l2, long l3, long l4, int n, Object object) {
            if ((n & 1) != 0) {
                l = scanPeriods.foregroundScanPeriodMillis;
            }
            if ((n & 2) != 0) {
                l2 = scanPeriods.foregroundBetweenScanPeriodMillis;
            }
            if ((n & 4) != 0) {
                l3 = scanPeriods.backgroundScanPeriodMillis;
            }
            if ((n & 8) != 0) {
                l4 = scanPeriods.backgroundBetweenScanPeriodMillis;
            }
            return scanPeriods.copy(l, l2, l3, l4);
        }

        @NotNull
        public String toString() {
            return "ScanPeriods(foregroundScanPeriodMillis=" + this.foregroundScanPeriodMillis + ", foregroundBetweenScanPeriodMillis=" + this.foregroundBetweenScanPeriodMillis + ", backgroundScanPeriodMillis=" + this.backgroundScanPeriodMillis + ", backgroundBetweenScanPeriodMillis=" + this.backgroundBetweenScanPeriodMillis + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.foregroundScanPeriodMillis);
            result = result * 31 + Long.hashCode(this.foregroundBetweenScanPeriodMillis);
            result = result * 31 + Long.hashCode(this.backgroundScanPeriodMillis);
            result = result * 31 + Long.hashCode(this.backgroundBetweenScanPeriodMillis);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScanPeriods)) {
                return false;
            }
            ScanPeriods scanPeriods = (ScanPeriods)other;
            if (this.foregroundScanPeriodMillis != scanPeriods.foregroundScanPeriodMillis) {
                return false;
            }
            if (this.foregroundBetweenScanPeriodMillis != scanPeriods.foregroundBetweenScanPeriodMillis) {
                return false;
            }
            if (this.backgroundScanPeriodMillis != scanPeriods.backgroundScanPeriodMillis) {
                return false;
            }
            return this.backgroundBetweenScanPeriodMillis == scanPeriods.backgroundBetweenScanPeriodMillis;
        }

        public ScanPeriods() {
            this(0L, 0L, 0L, 0L, 15, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001J\b\u0010\u0002\u001a\u00020\u0000H&J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lorg/altbeacon/beacon/Settings$ScanStrategy;", "", "clone", "configure", "", "beaconManager", "Lorg/altbeacon/beacon/BeaconManager;", "android-beacon-library_release"})
    public static interface ScanStrategy
    extends Comparable<ScanStrategy> {
        @NotNull
        public ScanStrategy clone();

        public void configure(@NotNull BeaconManager var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lorg/altbeacon/beacon/Settings$Companion;", "", "()V", "fromBuilder", "Lorg/altbeacon/beacon/Settings;", "builder", "Lorg/altbeacon/beacon/Settings$Builder;", "fromSettings", "other", "android-beacon-library_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Settings fromSettings(@NotNull Settings other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            ScanPeriods scanPeriods = other.getScanPeriods();
            Boolean bl = other.getDebug();
            Boolean bl2 = other.getRegionStatePersistenceEnabled();
            Boolean bl3 = other.getUseTrackingCache();
            Boolean bl4 = other.getHardwareEqualityEnforced();
            Integer n = other.getRegionExitPeriodMillis();
            Integer n2 = other.getMaxTrackingAgeMillis();
            Boolean bl5 = other.getManifestCheckingDisabled();
            BeaconSimulator beaconSimulator = other.getBeaconSimulator();
            Class<?> clazz = other.getRssiFilterClass();
            ScanStrategy scanStrategy = other.getScanStrategy();
            ScanStrategy scanStrategy2 = scanStrategy != null ? scanStrategy.clone() : null;
            Boolean bl6 = other.getLongScanForcingEnabled();
            String string = other.getDistanceModelUpdateUrl();
            DistanceCalculatorFactory distanceCalculatorFactory = other.getDistanceCalculatorFactory();
            return new Settings(bl, bl2, bl4, scanPeriods, n, bl3, n2, bl5, beaconSimulator, clazz, string, distanceCalculatorFactory, scanStrategy2, bl6);
        }

        @NotNull
        public final Settings fromBuilder(@NotNull Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            ScanPeriods scanPeriods = builder.get_scanPeriods$android_beacon_library_release();
            Boolean bl = builder.get_debug$android_beacon_library_release();
            Boolean bl2 = builder.get_regionStatePeristenceEnabled$android_beacon_library_release();
            Boolean bl3 = builder.get_useTrackingCache$android_beacon_library_release();
            Boolean bl4 = builder.get_hardwareEqualityEnforced$android_beacon_library_release();
            Integer n = builder.get_regionExitPeriodMillis$android_beacon_library_release();
            Integer n2 = builder.get_maxTrackingAgeMillis$android_beacon_library_release();
            Boolean bl5 = builder.get_manifestCheckingDisabled$android_beacon_library_release();
            BeaconSimulator beaconSimulator = builder.get_beaconSimulator$android_beacon_library_release();
            Class<?> clazz = builder.get_rssiFilterClass$android_beacon_library_release();
            ScanStrategy scanStrategy = builder.get_scanStrategy$android_beacon_library_release();
            ScanStrategy scanStrategy2 = scanStrategy != null ? scanStrategy.clone() : null;
            Boolean bl6 = builder.get_longScanForcingEnabled$android_beacon_library_release();
            String string = builder.get_distanceModelUpdateUrl$android_beacon_library_release();
            DistanceCalculatorFactory distanceCalculatorFactory = builder.get_distanceCalculatorFactory$android_beacon_library_release();
            return new Settings(bl, bl2, bl4, scanPeriods, n, bl3, n2, bl5, beaconSimulator, clazz, string, distanceCalculatorFactory, scanStrategy2, bl6);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/altbeacon/beacon/Settings$Defaults;", "", "()V", "beaconSimulator", "Lorg/altbeacon/beacon/Settings$DisabledBeaconSimulator;", "getBeaconSimulator", "()Lorg/altbeacon/beacon/Settings$DisabledBeaconSimulator;", "debug", "", "distanceCalculatorFactory", "Lorg/altbeacon/beacon/distance/ModelSpecificDistanceCalculatorFactory;", "getDistanceCalculatorFactory", "()Lorg/altbeacon/beacon/distance/ModelSpecificDistanceCalculatorFactory;", "distanceModelUpdateUrl", "", "hardwareEqualityEnforced", "longScanForcingEnabled", "manifestCheckingDisabled", "maxTrackingAgeMillis", "", "regionExitPeriodMillis", "regionStatePeristenceEnabled", "rssiFilterImplClass", "Ljava/lang/Class;", "getRssiFilterImplClass", "()Ljava/lang/Class;", "scanPeriods", "Lorg/altbeacon/beacon/Settings$ScanPeriods;", "getScanPeriods", "()Lorg/altbeacon/beacon/Settings$ScanPeriods;", "scanStrategy", "Lorg/altbeacon/beacon/Settings$ScanStrategy;", "getScanStrategy", "()Lorg/altbeacon/beacon/Settings$ScanStrategy;", "useTrackingCache", "android-beacon-library_release"})
    public static final class Defaults {
        @NotNull
        public static final Defaults INSTANCE = new Defaults();
        public static final boolean debug = false;
        @NotNull
        private static final ScanStrategy scanStrategy;
        public static final boolean longScanForcingEnabled = false;
        @NotNull
        private static final ScanPeriods scanPeriods;
        public static final int regionExitPeriodMillis = 30000;
        public static final boolean useTrackingCache = true;
        public static final int maxTrackingAgeMillis = 10000;
        public static final boolean manifestCheckingDisabled = false;
        @NotNull
        private static final DisabledBeaconSimulator beaconSimulator;
        @NotNull
        private static final Class<?> rssiFilterImplClass;
        public static final boolean regionStatePeristenceEnabled = true;
        public static final boolean hardwareEqualityEnforced = false;
        @NotNull
        public static final String distanceModelUpdateUrl = "";
        @NotNull
        private static final ModelSpecificDistanceCalculatorFactory distanceCalculatorFactory;

        private Defaults() {
        }

        @NotNull
        public final ScanStrategy getScanStrategy() {
            return scanStrategy;
        }

        @NotNull
        public final ScanPeriods getScanPeriods() {
            return scanPeriods;
        }

        @NotNull
        public final DisabledBeaconSimulator getBeaconSimulator() {
            return beaconSimulator;
        }

        @NotNull
        public final Class<?> getRssiFilterImplClass() {
            return rssiFilterImplClass;
        }

        @NotNull
        public final ModelSpecificDistanceCalculatorFactory getDistanceCalculatorFactory() {
            return distanceCalculatorFactory;
        }

        static {
            scanPeriods = new ScanPeriods(0L, 0L, 0L, 0L, 15, null);
            beaconSimulator = new DisabledBeaconSimulator();
            rssiFilterImplClass = RunningAverageRssiFilter.class;
            distanceCalculatorFactory = new ModelSpecificDistanceCalculatorFactory();
            scanStrategy = Build.VERSION.SDK_INT >= 26 ? (ScanStrategy)new JobServiceScanStrategy(0L, 0L, false, 7, null) : (ScanStrategy)new BackgroundServiceScanStrategy();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u0004J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\nJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0011J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u0017J\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010R\u001a\u00020\nJ\u0012\u0010S\u001a\u00020\u00002\n\u0010T\u001a\u0006\u0012\u0002\b\u000303J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010V\u001a\u000209J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020?R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR\u001e\u0010\u001f\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b \u0010\f\"\u0004\b!\u0010\u000eR\u001e\u0010\"\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b#\u0010\f\"\u0004\b$\u0010\u000eR\u001e\u0010%\u001a\u0004\u0018\u00010&X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010,\u001a\u0004\u0018\u00010&X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b-\u0010(\"\u0004\b.\u0010*R\u001e\u0010/\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b0\u0010\f\"\u0004\b1\u0010\u000eR \u00102\u001a\b\u0012\u0002\b\u0003\u0018\u000103X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001c\u00108\u001a\u0004\u0018\u000109X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001e\u0010D\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\bE\u0010\f\"\u0004\bF\u0010\u000e\u00a8\u0006Y"}, d2={"Lorg/altbeacon/beacon/Settings$Builder;", "", "()V", "_beaconSimulator", "Lorg/altbeacon/beacon/simulator/BeaconSimulator;", "get_beaconSimulator$android_beacon_library_release", "()Lorg/altbeacon/beacon/simulator/BeaconSimulator;", "set_beaconSimulator$android_beacon_library_release", "(Lorg/altbeacon/beacon/simulator/BeaconSimulator;)V", "_debug", "", "get_debug$android_beacon_library_release", "()Ljava/lang/Boolean;", "set_debug$android_beacon_library_release", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "_distanceCalculatorFactory", "Lorg/altbeacon/beacon/distance/DistanceCalculatorFactory;", "get_distanceCalculatorFactory$android_beacon_library_release", "()Lorg/altbeacon/beacon/distance/DistanceCalculatorFactory;", "set_distanceCalculatorFactory$android_beacon_library_release", "(Lorg/altbeacon/beacon/distance/DistanceCalculatorFactory;)V", "_distanceModelUpdateUrl", "", "get_distanceModelUpdateUrl$android_beacon_library_release", "()Ljava/lang/String;", "set_distanceModelUpdateUrl$android_beacon_library_release", "(Ljava/lang/String;)V", "_hardwareEqualityEnforced", "get_hardwareEqualityEnforced$android_beacon_library_release", "set_hardwareEqualityEnforced$android_beacon_library_release", "_longScanForcingEnabled", "get_longScanForcingEnabled$android_beacon_library_release", "set_longScanForcingEnabled$android_beacon_library_release", "_manifestCheckingDisabled", "get_manifestCheckingDisabled$android_beacon_library_release", "set_manifestCheckingDisabled$android_beacon_library_release", "_maxTrackingAgeMillis", "", "get_maxTrackingAgeMillis$android_beacon_library_release", "()Ljava/lang/Integer;", "set_maxTrackingAgeMillis$android_beacon_library_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "_regionExitPeriodMillis", "get_regionExitPeriodMillis$android_beacon_library_release", "set_regionExitPeriodMillis$android_beacon_library_release", "_regionStatePeristenceEnabled", "get_regionStatePeristenceEnabled$android_beacon_library_release", "set_regionStatePeristenceEnabled$android_beacon_library_release", "_rssiFilterClass", "Ljava/lang/Class;", "get_rssiFilterClass$android_beacon_library_release", "()Ljava/lang/Class;", "set_rssiFilterClass$android_beacon_library_release", "(Ljava/lang/Class;)V", "_scanPeriods", "Lorg/altbeacon/beacon/Settings$ScanPeriods;", "get_scanPeriods$android_beacon_library_release", "()Lorg/altbeacon/beacon/Settings$ScanPeriods;", "set_scanPeriods$android_beacon_library_release", "(Lorg/altbeacon/beacon/Settings$ScanPeriods;)V", "_scanStrategy", "Lorg/altbeacon/beacon/Settings$ScanStrategy;", "get_scanStrategy$android_beacon_library_release", "()Lorg/altbeacon/beacon/Settings$ScanStrategy;", "set_scanStrategy$android_beacon_library_release", "(Lorg/altbeacon/beacon/Settings$ScanStrategy;)V", "_useTrackingCache", "get_useTrackingCache$android_beacon_library_release", "set_useTrackingCache$android_beacon_library_release", "build", "Lorg/altbeacon/beacon/Settings;", "setBeaconSimulator", "beaconSimulator", "setDebug", "debug", "setDistanceCalculatorFactory", "factory", "setDistanceModelUpdateUrl", "url", "setLongScanForcingEnabled", "longScanForcingEnabled", "setRssiFilterClass", "rssiFilterClass", "setScanPeriods", "scanPeriods", "setScanStrategy", "scanStrategy", "android-beacon-library_release"})
    public static final class Builder {
        @Nullable
        private ScanPeriods _scanPeriods;
        @Nullable
        private Boolean _debug;
        @Nullable
        private Boolean _regionStatePeristenceEnabled;
        @Nullable
        private Boolean _useTrackingCache;
        @Nullable
        private Boolean _hardwareEqualityEnforced;
        @Nullable
        private Integer _regionExitPeriodMillis;
        @Nullable
        private Integer _maxTrackingAgeMillis;
        @Nullable
        private Boolean _manifestCheckingDisabled;
        @Nullable
        private BeaconSimulator _beaconSimulator;
        @Nullable
        private Class<?> _rssiFilterClass;
        @Nullable
        private String _distanceModelUpdateUrl;
        @Nullable
        private DistanceCalculatorFactory _distanceCalculatorFactory;
        @Nullable
        private ScanStrategy _scanStrategy;
        @Nullable
        private Boolean _longScanForcingEnabled;

        @Nullable
        public final ScanPeriods get_scanPeriods$android_beacon_library_release() {
            return this._scanPeriods;
        }

        public final void set_scanPeriods$android_beacon_library_release(@Nullable ScanPeriods scanPeriods) {
            this._scanPeriods = scanPeriods;
        }

        @Nullable
        public final Boolean get_debug$android_beacon_library_release() {
            return this._debug;
        }

        public final void set_debug$android_beacon_library_release(@Nullable Boolean bl) {
            this._debug = bl;
        }

        @Nullable
        public final Boolean get_regionStatePeristenceEnabled$android_beacon_library_release() {
            return this._regionStatePeristenceEnabled;
        }

        public final void set_regionStatePeristenceEnabled$android_beacon_library_release(@Nullable Boolean bl) {
            this._regionStatePeristenceEnabled = bl;
        }

        @Nullable
        public final Boolean get_useTrackingCache$android_beacon_library_release() {
            return this._useTrackingCache;
        }

        public final void set_useTrackingCache$android_beacon_library_release(@Nullable Boolean bl) {
            this._useTrackingCache = bl;
        }

        @Nullable
        public final Boolean get_hardwareEqualityEnforced$android_beacon_library_release() {
            return this._hardwareEqualityEnforced;
        }

        public final void set_hardwareEqualityEnforced$android_beacon_library_release(@Nullable Boolean bl) {
            this._hardwareEqualityEnforced = bl;
        }

        @Nullable
        public final Integer get_regionExitPeriodMillis$android_beacon_library_release() {
            return this._regionExitPeriodMillis;
        }

        public final void set_regionExitPeriodMillis$android_beacon_library_release(@Nullable Integer n) {
            this._regionExitPeriodMillis = n;
        }

        @Nullable
        public final Integer get_maxTrackingAgeMillis$android_beacon_library_release() {
            return this._maxTrackingAgeMillis;
        }

        public final void set_maxTrackingAgeMillis$android_beacon_library_release(@Nullable Integer n) {
            this._maxTrackingAgeMillis = n;
        }

        @Nullable
        public final Boolean get_manifestCheckingDisabled$android_beacon_library_release() {
            return this._manifestCheckingDisabled;
        }

        public final void set_manifestCheckingDisabled$android_beacon_library_release(@Nullable Boolean bl) {
            this._manifestCheckingDisabled = bl;
        }

        @Nullable
        public final BeaconSimulator get_beaconSimulator$android_beacon_library_release() {
            return this._beaconSimulator;
        }

        public final void set_beaconSimulator$android_beacon_library_release(@Nullable BeaconSimulator beaconSimulator) {
            this._beaconSimulator = beaconSimulator;
        }

        @Nullable
        public final Class<?> get_rssiFilterClass$android_beacon_library_release() {
            return this._rssiFilterClass;
        }

        public final void set_rssiFilterClass$android_beacon_library_release(@Nullable Class<?> clazz) {
            this._rssiFilterClass = clazz;
        }

        @Nullable
        public final String get_distanceModelUpdateUrl$android_beacon_library_release() {
            return this._distanceModelUpdateUrl;
        }

        public final void set_distanceModelUpdateUrl$android_beacon_library_release(@Nullable String string) {
            this._distanceModelUpdateUrl = string;
        }

        @Nullable
        public final DistanceCalculatorFactory get_distanceCalculatorFactory$android_beacon_library_release() {
            return this._distanceCalculatorFactory;
        }

        public final void set_distanceCalculatorFactory$android_beacon_library_release(@Nullable DistanceCalculatorFactory distanceCalculatorFactory) {
            this._distanceCalculatorFactory = distanceCalculatorFactory;
        }

        @Nullable
        public final ScanStrategy get_scanStrategy$android_beacon_library_release() {
            return this._scanStrategy;
        }

        public final void set_scanStrategy$android_beacon_library_release(@Nullable ScanStrategy scanStrategy) {
            this._scanStrategy = scanStrategy;
        }

        @Nullable
        public final Boolean get_longScanForcingEnabled$android_beacon_library_release() {
            return this._longScanForcingEnabled;
        }

        public final void set_longScanForcingEnabled$android_beacon_library_release(@Nullable Boolean bl) {
            this._longScanForcingEnabled = bl;
        }

        @NotNull
        public final Builder setDebug(boolean debug) {
            this._debug = debug;
            return this;
        }

        @NotNull
        public final Builder setScanPeriods(@NotNull ScanPeriods scanPeriods) {
            Intrinsics.checkNotNullParameter((Object)scanPeriods, (String)"scanPeriods");
            this._scanPeriods = scanPeriods;
            return this;
        }

        @NotNull
        public final Builder setDistanceModelUpdateUrl(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this._distanceModelUpdateUrl = url;
            return this;
        }

        @NotNull
        public final Builder setDistanceCalculatorFactory(@NotNull DistanceCalculatorFactory factory) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            this._distanceCalculatorFactory = factory;
            return this;
        }

        @NotNull
        public final Builder setBeaconSimulator(@NotNull BeaconSimulator beaconSimulator) {
            Intrinsics.checkNotNullParameter((Object)beaconSimulator, (String)"beaconSimulator");
            this._beaconSimulator = beaconSimulator;
            return this;
        }

        @NotNull
        public final Builder setScanStrategy(@NotNull ScanStrategy scanStrategy) {
            Intrinsics.checkNotNullParameter((Object)scanStrategy, (String)"scanStrategy");
            this._scanStrategy = scanStrategy;
            return this;
        }

        @NotNull
        public final Builder setLongScanForcingEnabled(boolean longScanForcingEnabled) {
            this._longScanForcingEnabled = longScanForcingEnabled;
            return this;
        }

        @NotNull
        public final Builder setRssiFilterClass(@NotNull Class<?> rssiFilterClass) {
            Intrinsics.checkNotNullParameter(rssiFilterClass, (String)"rssiFilterClass");
            this._rssiFilterClass = rssiFilterClass;
            return this;
        }

        @NotNull
        public final Settings build() {
            return Companion.fromBuilder(this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u0000H\u0016J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/altbeacon/beacon/Settings$JobServiceScanStrategy;", "Lorg/altbeacon/beacon/Settings$ScanStrategy;", "immediateJobId", "", "periodicJobId", "jobPersistenceEnabled", "", "(JJZ)V", "getImmediateJobId", "()J", "getJobPersistenceEnabled", "()Z", "getPeriodicJobId", "clone", "compareTo", "", "other", "configure", "", "beaconManager", "Lorg/altbeacon/beacon/BeaconManager;", "equals", "", "hashCode", "android-beacon-library_release"})
    public static final class JobServiceScanStrategy
    implements ScanStrategy {
        private final long immediateJobId;
        private final long periodicJobId;
        private final boolean jobPersistenceEnabled;

        public JobServiceScanStrategy(long immediateJobId, long periodicJobId, boolean jobPersistenceEnabled) {
            this.immediateJobId = immediateJobId;
            this.periodicJobId = periodicJobId;
            this.jobPersistenceEnabled = jobPersistenceEnabled;
        }

        public /* synthetic */ JobServiceScanStrategy(long l, long l2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 208352939L;
            }
            if ((n & 2) != 0) {
                l2 = 208352940L;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            this(l, l2, bl);
        }

        public final long getImmediateJobId() {
            return this.immediateJobId;
        }

        public final long getPeriodicJobId() {
            return this.periodicJobId;
        }

        public final boolean getJobPersistenceEnabled() {
            return this.jobPersistenceEnabled;
        }

        @Override
        @NotNull
        public JobServiceScanStrategy clone() {
            return new JobServiceScanStrategy(this.immediateJobId, this.periodicJobId, this.jobPersistenceEnabled);
        }

        public boolean equals(@Nullable Object other) {
            JobServiceScanStrategy otherJobServiceScanStrategy;
            JobServiceScanStrategy jobServiceScanStrategy = otherJobServiceScanStrategy = other instanceof JobServiceScanStrategy ? (JobServiceScanStrategy)other : null;
            if (otherJobServiceScanStrategy != null) {
                return this.immediateJobId == otherJobServiceScanStrategy.immediateJobId && this.periodicJobId == otherJobServiceScanStrategy.periodicJobId && this.jobPersistenceEnabled == otherJobServiceScanStrategy.jobPersistenceEnabled;
            }
            return false;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public void configure(@NotNull BeaconManager beaconManager) {
            Intrinsics.checkNotNullParameter((Object)beaconManager, (String)"beaconManager");
            beaconManager.setEnableScheduledScanJobs(true);
            beaconManager.setIntentScanningStrategyEnabled(false);
        }

        @Override
        public int compareTo(@NotNull ScanStrategy other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other instanceof JobServiceScanStrategy ? (this.immediateJobId == ((JobServiceScanStrategy)other).immediateJobId && this.periodicJobId == ((JobServiceScanStrategy)other).periodicJobId && this.jobPersistenceEnabled == ((JobServiceScanStrategy)other).jobPersistenceEnabled ? 0 : -1) : -1;
        }

        public JobServiceScanStrategy() {
            this(0L, 0L, false, 7, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0000H\u0016J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/altbeacon/beacon/Settings$BackgroundServiceScanStrategy;", "Lorg/altbeacon/beacon/Settings$ScanStrategy;", "()V", "clone", "compareTo", "", "other", "configure", "", "beaconManager", "Lorg/altbeacon/beacon/BeaconManager;", "equals", "", "", "hashCode", "android-beacon-library_release"})
    public static final class BackgroundServiceScanStrategy
    implements ScanStrategy {
        @Override
        @NotNull
        public BackgroundServiceScanStrategy clone() {
            return new BackgroundServiceScanStrategy();
        }

        public boolean equals(@Nullable Object other) {
            return (other instanceof BackgroundServiceScanStrategy ? (BackgroundServiceScanStrategy)other : null) != null;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public void configure(@NotNull BeaconManager beaconManager) {
            Intrinsics.checkNotNullParameter((Object)beaconManager, (String)"beaconManager");
            beaconManager.setEnableScheduledScanJobs(false);
            beaconManager.setIntentScanningStrategyEnabled(false);
            if (Build.VERSION.SDK_INT >= 26) {
                LogManager.w("BackgroundServiceScanStrategy", "Using the BackgroundService  scan strategy on Android 8+ may disable delivery of beacon callbacks in the background.", new Object[0]);
            }
        }

        @Override
        public int compareTo(@NotNull ScanStrategy other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other instanceof BackgroundServiceScanStrategy ? 0 : -1;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u0011\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/altbeacon/beacon/Settings$ForegroundServiceScanStrategy;", "Lorg/altbeacon/beacon/Settings$ScanStrategy;", "notification", "Landroid/app/Notification;", "notificationId", "", "(Landroid/app/Notification;I)V", "androidLScanningDisabled", "", "getAndroidLScanningDisabled", "()Z", "setAndroidLScanningDisabled", "(Z)V", "getNotification", "()Landroid/app/Notification;", "getNotificationId", "()I", "clone", "compareTo", "other", "configure", "", "beaconManager", "Lorg/altbeacon/beacon/BeaconManager;", "equals", "", "hashCode", "android-beacon-library_release"})
    public static final class ForegroundServiceScanStrategy
    implements ScanStrategy {
        @NotNull
        private final Notification notification;
        private final int notificationId;
        private boolean androidLScanningDisabled;

        public ForegroundServiceScanStrategy(@NotNull Notification notification, int notificationId) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            this.notification = notification;
            this.notificationId = notificationId;
            this.androidLScanningDisabled = true;
        }

        @NotNull
        public final Notification getNotification() {
            return this.notification;
        }

        public final int getNotificationId() {
            return this.notificationId;
        }

        public final boolean getAndroidLScanningDisabled() {
            return this.androidLScanningDisabled;
        }

        public final void setAndroidLScanningDisabled(boolean bl) {
            this.androidLScanningDisabled = bl;
        }

        @Override
        @NotNull
        public ForegroundServiceScanStrategy clone() {
            return new ForegroundServiceScanStrategy(this.notification, this.notificationId);
        }

        public boolean equals(@Nullable Object other) {
            ForegroundServiceScanStrategy otherForegroundServiceScanStrategy;
            ForegroundServiceScanStrategy foregroundServiceScanStrategy = otherForegroundServiceScanStrategy = other instanceof ForegroundServiceScanStrategy ? (ForegroundServiceScanStrategy)other : null;
            if (otherForegroundServiceScanStrategy != null) {
                return this.notificationId == otherForegroundServiceScanStrategy.notificationId && this.androidLScanningDisabled == otherForegroundServiceScanStrategy.androidLScanningDisabled;
            }
            return false;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public void configure(@NotNull BeaconManager beaconManager) {
            Intrinsics.checkNotNullParameter((Object)beaconManager, (String)"beaconManager");
            beaconManager.setEnableScheduledScanJobs(false);
            beaconManager.setIntentScanningStrategyEnabled(false);
            beaconManager.enableForegroundServiceScanning(this.notification, this.notificationId);
        }

        @Override
        public int compareTo(@NotNull ScanStrategy other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other instanceof ForegroundServiceScanStrategy ? (this.notificationId == ((ForegroundServiceScanStrategy)other).notificationId && this.androidLScanningDisabled == ((ForegroundServiceScanStrategy)other).androidLScanningDisabled ? 0 : -1) : -1;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0000H\u0016J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/altbeacon/beacon/Settings$IntentScanStrategy;", "Lorg/altbeacon/beacon/Settings$ScanStrategy;", "()V", "clone", "compareTo", "", "other", "configure", "", "beaconManager", "Lorg/altbeacon/beacon/BeaconManager;", "equals", "", "", "hashCode", "android-beacon-library_release"})
    public static final class IntentScanStrategy
    implements ScanStrategy {
        @Override
        @NotNull
        public IntentScanStrategy clone() {
            return new IntentScanStrategy();
        }

        public boolean equals(@Nullable Object other) {
            return (other instanceof IntentScanStrategy ? (IntentScanStrategy)other : null) != null;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public void configure(@NotNull BeaconManager beaconManager) {
            Intrinsics.checkNotNullParameter((Object)beaconManager, (String)"beaconManager");
            beaconManager.setEnableScheduledScanJobs(false);
            beaconManager.setIntentScanningStrategyEnabled(true);
        }

        @Override
        public int compareTo(@NotNull ScanStrategy other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other instanceof IntentScanStrategy ? 0 : -1;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/altbeacon/beacon/Settings$DisabledBeaconSimulator;", "Lorg/altbeacon/beacon/simulator/BeaconSimulator;", "()V", "getBeacons", "", "Lorg/altbeacon/beacon/Beacon;", "android-beacon-library_release"})
    public static final class DisabledBeaconSimulator
    implements BeaconSimulator {
        @Override
        @NotNull
        public List<Beacon> getBeacons() {
            return new ArrayList();
        }
    }
}

