/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.utils;

import android.annotation.TargetApi;
import android.util.Base64;
import android.util.Log;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconParser;

public class EddystoneTelemetryAccessor {
    private static final String TAG = "EddystoneTLMAccessor";

    public byte[] getTelemetryBytes(Beacon beacon) {
        if (beacon.getExtraDataFields().size() >= 5) {
            Beacon telemetryBeacon = new Beacon.Builder().setDataFields(beacon.getExtraDataFields()).build();
            BeaconParser telemetryParser = new BeaconParser().setBeaconLayout("x,s:0-1=feaa,m:2-2=20,d:3-3,d:4-5,d:6-7,d:8-11,d:12-15");
            byte[] telemetryBytes = telemetryParser.getBeaconAdvertisementData(telemetryBeacon);
            Log.d((String)TAG, (String)("Rehydrated telemetry bytes are :" + this.byteArrayToString(telemetryBytes)));
            return telemetryBytes;
        }
        return null;
    }

    @TargetApi(value=8)
    public String getBase64EncodedTelemetry(Beacon beacon) {
        byte[] bytes = this.getTelemetryBytes(beacon);
        if (bytes != null) {
            String base64EncodedTelemetry = Base64.encodeToString((byte[])bytes, (int)0);
            Log.d((String)TAG, (String)("Base64 telemetry bytes are :" + base64EncodedTelemetry));
            return base64EncodedTelemetry;
        }
        return null;
    }

    private String byteArrayToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(String.format("%02x", bytes[i]));
            sb.append(" ");
        }
        return sb.toString().trim();
    }
}

