/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.grgit.gradle;

import java.io.File;
import javax.inject.Inject;
import org.ajoberstar.grgit.Grgit;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class GrgitService
implements BuildService<Params>,
AutoCloseable {
    private static final Logger logger = Logging.getLogger(GrgitService.class);
    private final Grgit grgit;

    @Inject
    public GrgitService() {
        if (((Params)this.getParameters()).getCurrentDirectory().isPresent()) {
            this.grgit = Grgit.open(op -> op.setCurrentDir((Object)((Directory)((Params)this.getParameters()).getCurrentDirectory().get()).getAsFile()));
            return;
        }
        File dir = ((Directory)((Params)this.getParameters()).getDirectory().get()).getAsFile();
        if (dir.exists()) {
            this.grgit = Grgit.open(op -> op.setDir((Object)dir));
        } else if (((Boolean)((Params)this.getParameters()).getInitIfNotExists().get()).booleanValue()) {
            this.grgit = Grgit.init(op -> op.setDir((Object)dir));
        } else {
            throw new IllegalStateException("No Git repo exists at " + dir + " and initIfNotExists is false. Cannot proceed.");
        }
    }

    public Grgit getGrgit() {
        return this.grgit;
    }

    @Override
    public void close() throws Exception {
        logger.info("Closing Git repo: {}", (Object)this.grgit.getRepository().getRootDir());
        this.grgit.close();
    }

    public static interface Params
    extends BuildServiceParameters {
        public DirectoryProperty getCurrentDirectory();

        public DirectoryProperty getDirectory();

        public Property<Boolean> getInitIfNotExists();
    }
}

