/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.RequiredResourcesProperty;
import org.jenkins.plugins.lockableresources.util.SerializableSecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class LockableResourcesStruct
implements Serializable {
    public List<LockableResource> required;
    public String label;
    public String requiredVar;
    public String requiredNumber;
    public long queuedAt = new Date().getTime();
    @CheckForNull
    private final SerializableSecureGroovyScript serializableResourceMatchScript;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    @CheckForNull
    private transient SecureGroovyScript resourceMatchScript;
    private static final long serialVersionUID = 1L;

    public LockableResourcesStruct(RequiredResourcesProperty property, EnvVars env) {
        this.required = new ArrayList<LockableResource>();
        ArrayList<String> names = new ArrayList<String>();
        for (String name : property.getResources()) {
            String resourceName = env.expand(name);
            if (resourceName == null) continue;
            names.add(resourceName);
        }
        LockableResourcesManager lrm = LockableResourcesManager.get();
        this.required = lrm.fromNames(names, true);
        this.label = env.expand(property.getLabelName());
        if (this.label == null) {
            this.label = "";
        }
        this.resourceMatchScript = property.getResourceMatchScript();
        this.serializableResourceMatchScript = new SerializableSecureGroovyScript(this.resourceMatchScript);
        this.requiredVar = property.getResourceNamesVar();
        this.requiredNumber = property.getResourceNumber();
        if (this.requiredNumber != null && this.requiredNumber.equals("0")) {
            this.requiredNumber = null;
        }
    }

    public LockableResourcesStruct(@Nullable List<String> resources) {
        this(resources, null, 0);
    }

    public LockableResourcesStruct(@Nullable List<String> resources, @Nullable String label, int quantity, String variable) {
        this(resources, label, quantity);
        this.requiredVar = variable;
    }

    public LockableResourcesStruct(@Nullable List<String> resources, @Nullable String label, int quantity) {
        this.required = new ArrayList<LockableResource>();
        if (resources != null) {
            for (String resource : resources) {
                LockableResource r = LockableResourcesManager.get().fromName(resource);
                if (r == null) continue;
                this.required.add(r);
            }
        }
        this.label = label;
        if (this.label == null) {
            this.label = "";
        }
        this.requiredNumber = null;
        if (quantity > 0) {
            this.requiredNumber = String.valueOf(quantity);
        }
        this.serializableResourceMatchScript = null;
        this.resourceMatchScript = null;
    }

    @CheckForNull
    public SecureGroovyScript getResourceMatchScript() {
        if (this.resourceMatchScript == null && this.serializableResourceMatchScript != null) {
            this.resourceMatchScript = this.serializableResourceMatchScript.rehydrate();
        }
        return this.resourceMatchScript;
    }

    public String toString() {
        Object str = "";
        if (this.required != null && !this.required.isEmpty()) {
            str = (String)str + "Required resources: " + this.required;
        }
        if (this.label != null && !this.label.isEmpty()) {
            str = (String)str + "Required label: " + this.label;
        }
        if (this.resourceMatchScript != null) {
            str = (String)str + "Required label script: " + this.resourceMatchScript.getScript();
        }
        if (this.requiredVar != null) {
            str = (String)str + ", Variable name: " + this.requiredVar;
        }
        if (this.requiredNumber != null) {
            str = (String)str + ", Number of resources: " + this.requiredNumber;
        }
        return str;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isResourceRequired(LockableResource resource) {
        if (resource == null) {
            return false;
        }
        return LockableResourcesManager.getResourcesNames(this.required).contains(resource.getName());
    }
}

